/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import hydra.TestConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sql.SQLPrms;

public class SQLStmt {
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\?\\?");
    private static boolean logDML = TestConfig.tab().booleanAt(SQLPrms.logDML, false);
    private String orig_sql;
    private String sql;
    private final int[] substitutions;

    public SQLStmt(String sql, int ... substitutions) {
        this.substitutions = substitutions;
        this.setSQL(sql);
    }

    protected final void setSQL(String sql) {
        this.orig_sql = sql;
        for (int ctr : this.substitutions) {
            assert (ctr > 0);
            String replace = "";
            for (int i = 0; i < ctr; ++i) {
                replace = replace + (i > 0 ? ", " : "") + "?";
            }
            Matcher m = SUBSTITUTION_PATTERN.matcher(sql);
            sql = m.replaceFirst(replace);
        }
        this.sql = sql;
    }

    public final String getSQL() {
        return this.sql;
    }

    protected final String getOriginalSQL() {
        return this.orig_sql;
    }

    public String toString() {
        return "SQLStmt{" + this.sql + "}";
    }
}

