/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.EventCallback;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import hydra.Log;
import java.sql.SQLException;
import util.TestException;
import util.TestHelper;

public class SqlLogListener
implements EventCallback {
    public void onEvent(Event event) throws SQLException {
        StringBuilder aStr = new StringBuilder();
        aStr.append("Invoked " + this.getClass().getName() + ".onEvent " + event + "\n");
        aStr.append(this.eventToString(event));
        Log.getLogWriter().info(aStr.toString());
    }

    private String eventToString(Event event) {
        StringBuilder aStr = new StringBuilder();
        aStr.append("  getNewRowsAsResultSet(): " + event.getNewRowsAsResultSet() + "\n");
        aStr.append("  getOldRowAsResultSet(): " + event.getOldRowAsResultSet() + "\n");
        aStr.append("  getSchemaName(): " + event.getSchemaName() + "\n");
        aStr.append("  getTableName(): " + event.getTableName() + "\n");
        return aStr.toString();
    }

    private String metaDataToString(TableMetaData metaData) {
        StringBuilder aStr = new StringBuilder();
        try {
            int numColumns = metaData.getColumnCount();
            for (int column = 1; column <= numColumns; ++column) {
                String columnName = metaData.getColumnName(column);
                aStr.append("    Column name " + columnName + ", column index " + column + "\n");
                aStr.append("      getCatalogName(" + column + "): " + metaData.getCatalogName(column) + "\n");
                aStr.append("      getColumnClassName(" + column + "): " + metaData.getColumnClassName(column) + "\n");
                aStr.append("      getColumnDisplaySize(" + column + "): " + metaData.getColumnDisplaySize(column) + "\n");
                aStr.append("      getColumnLabel(" + column + "): " + metaData.getColumnLabel(column) + "\n");
                aStr.append("      getColumnName(" + column + "): " + columnName + "\n");
                aStr.append("      getColumnPosition(" + columnName + "): " + metaData.getColumnPosition(columnName) + "\n");
                aStr.append("      getColumnType(" + column + ") " + metaData.getColumnType(column) + "\n");
                aStr.append("      getColumnTypeName(" + column + "): " + metaData.getColumnTypeName(column) + "\n");
                aStr.append("      getDeclaredColumnWidth(" + column + "): " + metaData.getDeclaredColumnWidth(column) + "\n");
                aStr.append("      getPrecision(" + column + "): " + metaData.getPrecision(column) + "\n");
                aStr.append("      getScale(" + column + "): " + metaData.getScale(column) + "\n");
                aStr.append("      getSchemaName(" + column + "): " + metaData.getSchemaName(column) + "\n");
                aStr.append("      getSchemaVersion(): " + metaData.getSchemaVersion() + "\n");
                aStr.append("      getTableColumnPosition(" + column + "): " + metaData.getTableColumnPosition(column) + "\n");
                aStr.append("      getTableName(" + column + "): " + metaData.getTableName(column) + "\n");
                aStr.append("      isAutoIncrement(" + column + "): " + metaData.isAutoIncrement(column) + "\n");
                aStr.append("      isCaseSensitive(" + column + "): " + metaData.isCaseSensitive(column) + "\n");
                aStr.append("      isCurrency(" + column + "): " + metaData.isCurrency(column) + "\n");
                aStr.append("      isDefinitielyWriteable(" + column + "): " + metaData.isDefinitelyWritable(column) + "\n");
                aStr.append("      isNullable(" + column + "): " + metaData.isNullable(column) + "\n");
                aStr.append("      isReadOnly(" + column + "): " + metaData.isReadOnly(column) + "\n");
                aStr.append("      isSearchable(" + column + "): " + metaData.isSearchable(column) + "\n");
                aStr.append("      isSigned(" + column + "): " + metaData.isSigned(column) + "\n");
                aStr.append("      isWritable(" + column + "):  " + metaData.isWritable(column) + "\n");
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        return aStr.toString();
    }

    public void close() throws SQLException {
        Log.getLogWriter().info("Invoked " + this.getClass().getName() + ".close()");
    }

    public void init(String initStr) throws SQLException {
        Log.getLogWriter().info("Invoked " + this.getClass().getName() + ".init() with " + initStr);
    }
}

