/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerPrms;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import memscale.OffHeapHelper;
import util.TestException;

public class SqlOffHeapHelper {
    public static List<SimpleMemoryAllocatorImpl.Chunk> getLobChunks(SimpleMemoryAllocatorImpl.Chunk aChunk, String regionName, Object key) {
        ArrayList<SimpleMemoryAllocatorImpl.Chunk> aList = new ArrayList<SimpleMemoryAllocatorImpl.Chunk>();
        if (aChunk instanceof OffHeapRowWithLobs) {
            OffHeapRowWithLobs ohbs = (OffHeapRowWithLobs)aChunk;
            int numLobs = ohbs.readNumLobsColumns(false);
            if (numLobs <= 0) {
                throw new TestException("For key " + key + " + in region " + regionName + " the off-heap memory byte source " + ohbs + " has lobs " + true + ", but the number of lobs is " + numLobs);
            }
            for (int i = 1; i <= numLobs; ++i) {
                Object byteSrc = ohbs.getGfxdByteSource(i);
                if (!(byteSrc instanceof SimpleMemoryAllocatorImpl.Chunk)) continue;
                SimpleMemoryAllocatorImpl.Chunk lobChunk = (SimpleMemoryAllocatorImpl.Chunk)byteSrc;
                aList.add(lobChunk);
            }
        }
        return aList;
    }

    public static String getOffHeapMemorySize() {
        String offHeapMemorySize = TestConfig.tab().stringAt(FabricServerPrms.offHeapMemorySize, null);
        return offHeapMemorySize;
    }

    private static boolean isGlobalIndexTable(Region aRegion) {
        Object attr = aRegion.getUserAttribute();
        if (attr != null && attr instanceof GemFireContainer) {
            GemFireContainer container = (GemFireContainer)attr;
            return container.isGlobalIndex();
        }
        return false;
    }

    public static void verifyUserTablesEnabledWithOffHeap() {
        Set allRegions = OffHeapHelper.getAllRegions();
        if (allRegions == null) {
            return;
        }
        ArrayList<String> userTablesList = new ArrayList<String>();
        for (Region aRegion : allRegions) {
            boolean isGlobalIndexTable;
            boolean isSchema;
            if (!aRegion.getAttributes().getDataPolicy().withStorage() || aRegion.getAttributes().getDataPolicy().withPartitioning() && aRegion.getAttributes().getPartitionAttributes().getLocalMaxMemory() == 0) continue;
            String regionName = aRegion.getFullPath();
            boolean isSystemTable = regionName.startsWith("/SYS");
            boolean expectOffHeapEnabled = !isSystemTable & !(isSchema = regionName.indexOf("/") == regionName.lastIndexOf("/")) & !(isGlobalIndexTable = SqlOffHeapHelper.isGlobalIndexTable(aRegion));
            if (!expectOffHeapEnabled) continue;
            userTablesList.add(regionName);
        }
        OffHeapHelper.verifyRegionsEnabledWithOffHeap(userTablesList);
    }
}

