/*
 * Decompiled with CFR 0.152.
 */
package sql.subquery;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanBB;
import sql.wan.WanTest;
import util.TestException;
import util.TestHelper;

public class Subquery {
    protected static String[] uniqSelect = new String[]{"select * from trade.customers c where tid = ? and c.cid IN (select cid from trade.portfolio where tid =? and sid >? )", "select * from trade.customers where tid=? and cid IN (select avg(cid) from trade.portfolio where tid =? and sid >? group by sid )"};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.customers c where c.cid IN (select cid from trade.portfolio where sid >?)"};
    protected static String[] uniqDelete = new String[]{"delete from trade.networth n where tid = ? and n.cid IN (select cid from trade.portfolio where tid =? and sid >? and sid < ? )"};
    protected static String[] uniqUpdate = new String[]{"update trade.sellorders s set qty= qty+?  where tid = ? and s.cid IN (select cid from trade.portfolio where sid >? and sid < ? )"};
    protected static ArrayList<String> partitionKeys = null;
    static SharedMap partitionMap = SQLBB.getBB().getSharedMap();
    static SharedMap wanPartitionMap = SQLWanBB.getBB().getSharedMap();
    boolean isWanTest = AbstractDMLStmt.isWanTest;
    public static final Random rand = SQLTest.random;
    protected static boolean testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
    protected static boolean isHATest = SQLTest.isHATest;
    protected static int maxNumOfTries = 2;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();

    public void query(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                this.getUniqQuery(dConn, gConn, whichQuery);
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                this.getNonUniqQuery(dConn, gConn, whichQuery);
            }
        } else {
            int whichQuery = rand.nextInt(nonUniqSelect.length);
            this.getNonUniqQuery(gConn, whichQuery);
        }
    }

    public void subqueryDelete(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichDelete = rand.nextInt(uniqDelete.length);
                this.deleteUniqQuery(dConn, gConn, whichDelete);
            } else {
                int whichDelete = rand.nextInt(uniqDelete.length);
                this.deleteNonUniqQuery(dConn, gConn, whichDelete);
            }
        } else {
            int whichDelete = rand.nextInt(uniqDelete.length);
            this.deleteNonUniqQuery(gConn, whichDelete);
        }
    }

    public void subqueryUpdate(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichUpdate = rand.nextInt(uniqUpdate.length);
                this.updateUniqQuery(dConn, gConn, whichUpdate);
            } else {
                int whichUpdate = rand.nextInt(uniqUpdate.length);
                this.updateNonUniqQuery(dConn, gConn, whichUpdate);
            }
        } else {
            int whichUpdate = rand.nextInt(uniqUpdate.length);
            this.updateNonUniqQuery(gConn, whichUpdate);
        }
    }

    protected int getMyTid() {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        return myTid;
    }

    protected void getUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet gfeRS;
        ResultSet derbyRS;
        int tid = this.getMyTid();
        int[] sid = new int[1];
        switch (whichQuery) {
            case 0: 
            case 1: {
                this.getDataForQuery0(sid);
                Log.getLogWriter().info("getting result from derby");
                derbyRS = this.getUniqQuery0(dConn, whichQuery, sid[0], tid);
                Log.getLogWriter().info("getting result from gfxd");
                gfeRS = this.getUniqQuery0(gConn, whichQuery, sid[0], tid);
                break;
            }
            default: {
                throw new TestException("invalid uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        Log.getLogWriter().info("converting derby result to list of Struct");
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        Log.getLogWriter().info("converting gfxd result to list of Struct");
        List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
        if (gfeList == null) {
            if (isHATest) {
                Log.getLogWriter().info("could not get results after a few retries");
                return;
            }
            throw new TestException("non HA test and gemfirexd query result is " + gfeList);
        }
        ResultSetHelper.compareResultSets(derbyList, gfeList);
    }

    private void getDataForQuery0(int[] sid) {
        sid[0] = this.getSid();
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int sid, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery0(conn, whichQuery, sid, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery0(conn, whichQuery, sid, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int sid, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- sid: " + sid + ", tid: " + tid);
            stmt.setInt(1, tid);
            stmt.setInt(2, sid);
            stmt.setInt(3, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet gfeRS;
        ResultSet derbyRS;
        int[] sid = new int[1];
        switch (whichQuery) {
            case 0: 
            case 1: {
                this.getDataForQuery0(sid);
                derbyRS = this.getNonUniqQuery0(dConn, whichQuery, sid[0]);
                gfeRS = this.getNonUniqQuery0(gConn, whichQuery, sid[0]);
                break;
            }
            default: {
                throw new TestException("invalid non uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        if (gfeRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
        ResultSetHelper.compareResultSets(derbyList, gfeList);
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery, int sid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery0(conn, whichQuery, sid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery0(conn, whichQuery, sid, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery, int sid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- sid: " + sid);
            stmt.setInt(1, sid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection gConn, int whichQuery) {
        ResultSet gfeRS;
        int[] sid = new int[1];
        switch (whichQuery) {
            case 0: 
            case 1: {
                this.getDataForQuery0(sid);
                gfeRS = this.getNonUniqQuery0(gConn, whichQuery, sid[0]);
                break;
            }
            default: {
                throw new TestException("invalid non uinque quey selection");
            }
        }
        if (gfeRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        ResultSetHelper.asList(gfeRS, false);
    }

    protected int getSid() {
        return rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary)) + 1;
    }

    protected void deleteUniqQuery(Connection dConn, Connection gConn, int whichDelete) {
        int tid = this.getMyTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, sid2, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, sid2, exList);
            }
            this.deleteFromGfxdTable(gConn, whichDelete, tid, sid, sid2, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    private boolean deleteFromDerbyTable(Connection conn, int whichDelete, int tid, int sid, int sid2, List<SQLException> exList) {
        PreparedStatement stmt = this.getStmt(conn, uniqDelete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int count = -1;
        Log.getLogWriter().info("delete from derby, myTid is " + tid);
        try {
            verifyRowCount.put(tid + "_delete", 0);
            count = this.deleteFromTable(stmt, whichDelete, tid, sid, sid2);
            verifyRowCount.put(tid + "_delete", count);
            Log.getLogWriter().info("Derby deletes " + count + " rows");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    private void deleteFromGfxdTable(Connection conn, int whichDelete, int tid, int sid, int sid2, List<SQLException> exList) {
        PreparedStatement stmt = this.getStmt(conn, uniqDelete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        int count = -1;
        Log.getLogWriter().info("delete from gemfirexd, myTid is " + tid);
        try {
            count = this.deleteFromTable(stmt, whichDelete, tid, sid, sid2);
            if (!isHATest && count != verifyRowCount.get(tid + "_delete")) {
                throw new TestException("Gfxd delete has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete") + " but gfxd deleted " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    private int deleteFromTable(PreparedStatement stmt, int whichDelete, int tid, int sid, int sid2) throws SQLException {
        Log.getLogWriter().info("delete statement is " + uniqDelete[whichDelete]);
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("deleting record where sid between " + sid + " and " + sid2 + " and tid is " + tid);
                stmt.setInt(1, tid);
                stmt.setInt(2, tid);
                stmt.setInt(3, sid);
                stmt.setInt(4, sid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void deleteNonUniqQuery(Connection dConn, Connection gConn, int whichDelete) {
        int tid = this.getOtherTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, sid2, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, sid2, exList);
            }
            this.deleteFromGfxdTable(gConn, whichDelete, tid, sid, sid2, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    protected int getOtherTid() {
        int myTid = this.getMyTid();
        int offset = rand.nextInt(3);
        return rand.nextBoolean() ? myTid + offset : myTid - offset;
    }

    protected void deleteNonUniqQuery(Connection gConn, int whichDelete) {
        int tid = this.getOtherTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        this.deleteFromGfxdTable(gConn, whichDelete, tid, sid, sid2);
    }

    private void deleteFromGfxdTable(Connection conn, int whichDelete, int tid, int sid, int sid2) {
        PreparedStatement stmt = this.getStmt(conn, uniqDelete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        try {
            this.deleteFromTable(stmt, whichDelete, tid, sid, sid2);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
            }
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && SQLTest.testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected PreparedStatement getStmt(Connection conn, String sql) {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            if (SQLTest.testSecurity && (se.getSQLState().equals("42500") || se.getSQLState().equals("42502"))) {
                Log.getLogWriter().info("sql is " + sql);
                SQLHelper.printSQLException(se);
                SQLSecurityTest.prepareStmtException.set((Object)se);
            }
            if (!SQLHelper.checkDerbyException(conn, se)) {
                if (SQLTest.hasTx) {
                    SQLDistTxTest.rollbackGfxdTx.set((Object)true);
                    Log.getLogWriter().info("force gfxd to rollback operations as well");
                }
            }
            SQLHelper.handleSQLException(se);
        }
        return stmt;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("qty")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, uniqUpdate[whichUpdate]);
                    break;
                }
                stmt = this.getStmt(conn, uniqUpdate[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected PreparedStatement getUnsupportedStmt(Connection conn, String sql) {
        try {
            conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            if (SQLTest.testSecurity && (se.getSQLState().equals("42500") || se.getSQLState().equals("42502"))) {
                SQLHelper.printSQLException(se);
                SQLSecurityTest.prepareStmtException.set((Object)se);
            }
            if (se.getSQLState().equals("0A000")) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("Got the expected Exception, continuing test");
                return null;
            }
            throw new TestException("Not the expected  Feature not implemented \n" + TestHelper.getStackTrace((Throwable)se));
        }
        throw new TestException("Did not get the expected  'Feature not implemented' exception\n");
    }

    protected void setPartitionKeys() {
        if (!this.isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"sellordersPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_sellordersPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected int getMyWanSite() {
        if (this.isWanTest) {
            return WanTest.myWanSite;
        }
        return -1;
    }

    protected void updateUniqQuery(Connection dConn, Connection gConn, int whichUpdate) {
        int qty = rand.nextInt(30);
        int tid = this.getMyTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            }
            this.updateFromGfxdTable(gConn, whichUpdate, qty, tid, sid, sid2, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    private boolean updateFromDerbyTable(Connection conn, int whichUpdate, int qty, int tid, int sid, int sid2, List<SQLException> exList) {
        PreparedStatement stmt = null;
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate) : this.getStmt(conn, uniqUpdate[whichUpdate]);
        if (stmt == null) {
            return false;
        }
        int count = -1;
        Log.getLogWriter().info("update from derby, myTid is " + tid);
        try {
            verifyRowCount.put(tid + "_update", 0);
            count = this.updateFromTable(stmt, whichUpdate, qty, tid, sid, sid2);
            verifyRowCount.put(tid + "_update", count);
            Log.getLogWriter().info("Derby updates " + count + " rows");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    private void updateFromGfxdTable(Connection conn, int whichUpdate, int qty, int tid, int sid, int sid2, List<SQLException> exList) {
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate) : this.getStmt(conn, uniqUpdate[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        int count = -1;
        Log.getLogWriter().info("update from gemfirexd, myTid is " + tid);
        try {
            count = this.updateFromTable(stmt, whichUpdate, qty, tid, sid, sid2);
            if (!isHATest && count != verifyRowCount.get(tid + "_update")) {
                throw new TestException("Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update") + " but gfxd updated " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    private int updateFromTable(PreparedStatement stmt, int whichUpdate, int qty, int tid, int sid, int sid2) throws SQLException {
        Log.getLogWriter().info("update statement is " + uniqUpdate[whichUpdate]);
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating record where sid between " + sid + " and " + sid2 + " and tid is " + tid);
                stmt.setInt(1, qty);
                stmt.setInt(2, tid);
                stmt.setInt(3, sid);
                stmt.setInt(4, sid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("incorrect update statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void updateNonUniqQuery(Connection dConn, Connection gConn, int whichUpdate) {
        int qty = rand.nextInt(30);
        int tid = this.getOtherTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            }
            this.updateFromGfxdTable(gConn, whichUpdate, qty, tid, sid, sid2, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    protected void updateNonUniqQuery(Connection gConn, int whichUpdate) {
        int qty = rand.nextInt(30);
        int tid = this.getOtherTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        this.updateFromGfxdTable(gConn, whichUpdate, qty, tid, sid, sid2);
    }

    private void updateFromGfxdTable(Connection conn, int whichUpdate, int qty, int tid, int sid, int sid2) {
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate) : this.getStmt(conn, uniqUpdate[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (stmt == null) {
            return;
        }
        try {
            this.updateFromTable(stmt, whichUpdate, qty, tid, sid, sid2);
        }
        catch (SQLException se) {
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && SQLTest.testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }
}

