/*
 * Decompiled with CFR 0.152.
 */
package sql.subquery;

import hydra.TestConfig;
import java.sql.Connection;
import sql.SQLPrms;
import sql.SQLTest;
import sql.subquery.ColocatedSubquery;
import sql.subquery.Subquery;

public class SubqueryTest
extends SQLTest {
    protected static SubqueryTest sbt = new SubqueryTest();
    protected static boolean independentSubqueryOnly = TestConfig.tab().booleanAt(SQLPrms.independentSubqueryOnly, true);
    protected boolean limitedSubquery = TestConfig.tab().booleanAt(SQLPrms.limitNumberOfSubquery, false);

    public static void HydraTask_doSubquery() {
        sbt.doSubquery();
    }

    protected void doSubquery() {
        if (this.limitedSubquery && this.getMyTid() % 37 != 0) {
            return;
        }
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        this.doSubquery(dConn, gConn);
        this.commit(gConn);
        this.commit(dConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void doSubquery(Connection dConn, Connection gConn) {
        if (independentSubqueryOnly) {
            int num = random.nextInt(numOfWorkers);
            if (num == 0 && !isHATest) {
                new Subquery().subqueryUpdate(dConn, gConn);
            } else if (num == 1) {
                new Subquery().subqueryDelete(dConn, gConn);
            } else {
                new Subquery().query(dConn, gConn);
            }
        } else if (random.nextInt(numOfWorkers) != 1) {
            new ColocatedSubquery().query(dConn, gConn);
        } else {
            new ColocatedSubquery().subqueryDelete(dConn, gConn);
        }
    }
}

