/*
 * Decompiled with CFR 0.152.
 */
package sql.subqueryStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.joinStatements.CustPortfSoJoinStmt;
import sql.security.SQLSecurityTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import sql.subqueryStatements.SubqueryStmtIF;
import sql.wan.SQLWanBB;
import sql.wan.WanTest;
import util.TestException;
import util.TestHelper;

public class CustPortfSoSubqueryStmt
extends CustPortfSoJoinStmt
implements SubqueryStmtIF {
    protected static String[] uniqSelect = new String[]{"select * from trade.customers c where exists (select * from trade.portfolio f where c.cid = f.cid and qty > 297) and tid =?", "select * from trade.customers c where EXISTS (select * from trade.portfolio f where c.cid = f.cid and tid =?) and NOT EXISTS (select * from trade.sellorders s where c.cid = s.cid and status IN ('open','filled'))", "select * from trade.portfolio f , trade.sellorders s where f.cid = s.cid and f.tid=s.tid and ask > 49.9 and s.cid IN (select cid from trade.customers where cust_name LIKE 'name1%' and tid = ?)", "select f.cid, f.sid, f.tid, s.oid, s.tid from trade.portfolio f, trade.sellorders s where (f.cid = s.cid and f.tid=s.tid) and f.cid IN (select cid from trade.customers c where tid = ? and since > ?)", "select * from trade.sellorders s where exists (select * from trade.portfolio f where f.cid = s.cid and f.sid < ? and tid =? and f.cid IN (select cid from trade.customers c where since <? ))", "select c.cid from trade.customers c where exists (select * from trade.portfolio f where f.cid = c.cid and tid =? and f.qty >927) UNION select s.cid from trade.sellorders s where (select sum(qty) from trade.portfolio f where f.cid = s.cid GROUP BY f.cid) > 1277 and tid =? "};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.customers c where exists (select * from trade.portfolio f where c.cid = f.cid and qty > 297) ", "select * from trade.customers c where EXISTS (select * from trade.portfolio f where c.cid = f.cid) and NOT EXISTS (select * from trade.sellorders s where c.cid = s.cid and status IN ('open','filled'))", "select s.cid, s.sid, s.qty, s.tid as soTID, ask from trade.portfolio f , trade.sellorders s where f.cid = s.cid and f.tid=s.tid and ask > 49.9 and s.cid IN (select cid from trade.customers where cust_name LIKE 'name1%')", "select f.cid, f.sid, f.tid, s.oid, s.tid from trade.portfolio f, trade.sellorders s where (f.cid = s.cid and f.tid=s.tid) and f.cid IN (select cid from trade.customers c where since > ?)", "select * from trade.sellorders s where exists (select * from trade.portfolio f where f.cid = s.cid and f.sid < ? and f.cid IN (select cid from trade.customers c where since <? ))", "select c.cid from trade.customers c where exists (select * from trade.portfolio f where f.cid = c.cid and f.qty >927) UNION select s.cid from trade.sellorders s where (select sum(qty) from trade.portfolio f where f.cid = s.cid GROUP BY f.cid) > 1231 "};
    protected static String[] uniqDelete = new String[]{"delete from trade.sellorders s where exists (select * from trade.portfolio f where f.cid = s.cid and f.sid < ? and tid =? and f.cid IN (select cid from trade.customers c where since <? ))"};
    protected static String[] uniqUpdate = new String[]{"update trade.sellorders s set qty= qty+?  where tid = ? and s.cid IN (select cid from trade.portfolio where sid >? and sid < ? )"};
    protected static String[] nonUniqUpdate = new String[]{"update trade.sellorders s set qty= qty+?  where s.cid IN (select cid from trade.portfolio where sid >? and sid < ? )"};
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static ArrayList<String> partitionKeys = null;
    static SharedMap partitionMap = SQLBB.getBB().getSharedMap();
    static SharedMap wanPartitionMap = SQLWanBB.getBB().getSharedMap();
    boolean isWanTest = AbstractDMLStmt.isWanTest;
    boolean isTicket42422Fixed = false;

    @Override
    public void subquery(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                this.getUniqQuery(dConn, gConn, whichQuery);
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                this.getNonUniqQuery(dConn, gConn, whichQuery);
            }
        } else {
            int whichQuery = rand.nextInt(nonUniqSelect.length);
            this.getNonUniqQuery(gConn, whichQuery);
        }
    }

    @Override
    public void subqueryDelete(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichDelete = rand.nextInt(uniqDelete.length);
                this.deleteUniqQuery(dConn, gConn, whichDelete);
            } else {
                int whichDelete = rand.nextInt(uniqDelete.length);
                this.deleteNonUniqQuery(dConn, gConn, whichDelete);
            }
        } else {
            int whichDelete = rand.nextInt(uniqDelete.length);
            this.deleteNonUniqQuery(gConn, whichDelete);
        }
    }

    protected void getUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet derbyRS = null;
        ResultSet gfxdRS = null;
        int tid = this.getMyTid();
        int sid = this.getSid();
        Date since = this.getSince();
        switch (whichQuery) {
            case 0: {
                derbyRS = this.getUniqQuery0(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery0(gConn, whichQuery, tid);
                break;
            }
            case 1: {
                derbyRS = this.getUniqQuery0(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery0(gConn, whichQuery, tid);
                break;
            }
            case 2: {
                derbyRS = this.getUniqQuery0(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery0(gConn, whichQuery, tid);
                break;
            }
            case 3: {
                derbyRS = this.getUniqQuery3(dConn, whichQuery, since, tid);
                gfxdRS = this.getUniqQuery3(gConn, whichQuery, since, tid);
                break;
            }
            case 4: {
                derbyRS = this.getUniqQuery4(dConn, whichQuery, sid, since, tid);
                gfxdRS = this.getUniqQuery4(gConn, whichQuery, sid, since, tid);
                break;
            }
            case 5: {
                derbyRS = this.getUniqQuery5(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery5(gConn, whichQuery, tid);
                break;
            }
            default: {
                throw new TestException("invalid uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        if (gfxdRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        ResultSetHelper.compareResultSets(derbyList, gfxdList);
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery0(conn, whichQuery, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery0(conn, whichQuery, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid);
            stmt.setInt(1, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getUniqQuery3(Connection conn, int whichQuery, Date since, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery3(conn, whichQuery, since, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery3(conn, whichQuery, since, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery3(Connection conn, int whichQuery, Date since, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid + " since: " + since);
            stmt.setInt(1, tid);
            stmt.setDate(2, since);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getUniqQuery4(Connection conn, int whichQuery, int sid, Date since, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery4(conn, whichQuery, sid, since, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery4(conn, whichQuery, sid, since, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery4(Connection conn, int whichQuery, int sid, Date since, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query tid: " + tid + " and sid: " + sid + " since: " + since);
            stmt.setInt(1, sid);
            stmt.setInt(2, tid);
            stmt.setDate(3, since);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getUniqQuery5(Connection conn, int whichQuery, int tid) {
        if (!this.isTicket42422Fixed && SQLHelper.isDerbyConn(conn)) {
            return null;
        }
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery5(conn, whichQuery, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery5(conn, whichQuery, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery5(Connection conn, int whichQuery, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid);
            stmt.setInt(1, tid);
            stmt.setInt(2, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!this.isTicket42422Fixed && se.getSQLState().equalsIgnoreCase("0A000")) {
                Log.getLogWriter().info("get unsupported exception for union query, continue testing");
                success[0] = true;
                return null;
            }
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet derbyRS = null;
        ResultSet gfxdRS = null;
        int sid = this.getSid();
        Date since = this.getSince();
        switch (whichQuery) {
            case 0: {
                derbyRS = this.getNonUniqQuery0(dConn, whichQuery);
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 1: {
                derbyRS = this.getNonUniqQuery0(dConn, whichQuery);
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 2: {
                derbyRS = this.getNonUniqQuery0(dConn, whichQuery);
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 3: {
                derbyRS = this.getNonUniqQuery3(dConn, whichQuery, since);
                gfxdRS = this.getNonUniqQuery3(gConn, whichQuery, since);
                break;
            }
            case 4: {
                derbyRS = this.getNonUniqQuery4(dConn, whichQuery, sid, since);
                gfxdRS = this.getNonUniqQuery4(gConn, whichQuery, sid, since);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new TestException("invalid non uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        if (gfxdRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        ResultSetHelper.compareResultSets(derbyList, gfxdList);
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery0(conn, whichQuery, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery0(conn, whichQuery, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- none ");
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery3(Connection conn, int whichQuery, Date since) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery3(conn, whichQuery, since, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery3(conn, whichQuery, since, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery3(Connection conn, int whichQuery, Date since, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- since: " + since);
            stmt.setDate(1, since);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery4(Connection conn, int whichQuery, int sid, Date since) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery4(conn, whichQuery, sid, since, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery4(conn, whichQuery, sid, since, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery4(Connection conn, int whichQuery, int sid, Date since, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query sid: " + sid + " since: " + since);
            stmt.setInt(1, sid);
            stmt.setDate(2, since);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection gConn, int whichQuery) {
        ResultSet gfxdRS = null;
        int sid = this.getSid();
        Date since = this.getSince();
        switch (whichQuery) {
            case 0: {
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 1: {
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 2: {
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 3: {
                gfxdRS = this.getNonUniqQuery3(gConn, whichQuery, since);
                break;
            }
            case 4: {
                gfxdRS = this.getNonUniqQuery4(gConn, whichQuery, sid, since);
                break;
            }
            case 5: {
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            default: {
                throw new TestException("invalid uinque quey selection");
            }
        }
        if (gfxdRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        ResultSetHelper.asList(gfxdRS, false);
    }

    protected void deleteUniqQuery(Connection dConn, Connection gConn, int whichDelete) {
        int tid = this.getMyTid();
        int sid = this.getSid();
        Date since = this.getSince();
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, since, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, since, exList);
            }
            this.deleteFromGfxdTable(gConn, whichDelete, tid, sid, since, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    private boolean deleteFromDerbyTable(Connection conn, int whichDelete, int tid, int sid, Date since, List<SQLException> exList) {
        PreparedStatement stmt = this.getStmt(conn, uniqDelete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int count = -1;
        Log.getLogWriter().info("delete from derby, myTid is " + tid);
        try {
            verifyRowCount.put(tid + "_delete", 0);
            count = this.deleteFromTable(stmt, whichDelete, tid, sid, since);
            verifyRowCount.put(tid + "_delete", count);
            Log.getLogWriter().info("Derby deletes " + count + " rows");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    private void deleteFromGfxdTable(Connection conn, int whichDelete, int tid, int sid, Date since, List<SQLException> exList) {
        PreparedStatement stmt = this.getStmt(conn, uniqDelete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        int count = -1;
        Log.getLogWriter().info("delete from gemfirexd, myTid is " + tid);
        try {
            count = this.deleteFromTable(stmt, whichDelete, tid, sid, since);
            if (!isHATest && count != verifyRowCount.get(tid + "_delete")) {
                throw new TestException("Gfxd delete has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete") + " but gfxd deleted " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    private int deleteFromTable(PreparedStatement stmt, int whichDelete, int tid, int sid, Date since) throws SQLException {
        Log.getLogWriter().info("delete statement is " + uniqDelete[whichDelete]);
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("deleting record where sid is " + sid + " and tid is " + tid + " and since is " + since);
                stmt.setInt(1, sid);
                stmt.setInt(2, tid);
                stmt.setDate(3, since);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void deleteNonUniqQuery(Connection dConn, Connection gConn, int whichDelete) {
        int tid = this.getOtherTid();
        int sid = this.getSid();
        Date since = this.getSince();
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, since, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, tid, sid, since, exList);
            }
            this.deleteFromGfxdTable(gConn, whichDelete, tid, sid, since, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    protected int getOtherTid() {
        int myTid = this.getMyTid();
        int offset = rand.nextInt(3);
        return rand.nextBoolean() ? myTid + offset : myTid - offset;
    }

    protected void deleteNonUniqQuery(Connection gConn, int whichDelete) {
        int tid = this.getOtherTid();
        int sid = this.getSid();
        Date since = this.getSince();
        this.deleteFromGfxdTable(gConn, whichDelete, tid, sid, since);
    }

    private void deleteFromGfxdTable(Connection conn, int whichDelete, int tid, int sid, Date since) {
        PreparedStatement stmt = this.getStmt(conn, uniqDelete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        try {
            this.deleteFromTable(stmt, whichDelete, tid, sid, since);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
            }
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && SQLTest.testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected PreparedStatement getStmt(Connection conn, String sql) {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            if (SQLTest.testSecurity && (se.getSQLState().equals("42500") || se.getSQLState().equals("42502"))) {
                Log.getLogWriter().info("sql is " + sql);
                SQLHelper.printSQLException(se);
                SQLSecurityTest.prepareStmtException.set((Object)se);
            }
            if (!SQLHelper.checkDerbyException(conn, se)) {
                if (SQLTest.hasTx) {
                    SQLDistTxTest.rollbackGfxdTx.set((Object)true);
                    Log.getLogWriter().info("force gfxd to rollback operations as well");
                }
            }
            SQLHelper.handleSQLException(se);
        }
        return stmt;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("qty")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, uniqUpdate[whichUpdate]);
                    break;
                }
                stmt = this.getStmt(conn, uniqUpdate[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected PreparedStatement getUnsupportedStmt(Connection conn, String sql) {
        try {
            conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            if (SQLTest.testSecurity && (se.getSQLState().equals("42500") || se.getSQLState().equals("42502"))) {
                SQLHelper.printSQLException(se);
                SQLSecurityTest.prepareStmtException.set((Object)se);
            }
            if (se.getSQLState().equals("0A000")) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("Got the expected Exception, continuing test");
                return null;
            }
            throw new TestException("Not the expected  Feature not implemented \n" + TestHelper.getStackTrace((Throwable)se));
        }
        throw new TestException("Did not get the expected  'Feature not implemented' exception\n");
    }

    protected void setPartitionKeys() {
        if (!this.isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"sellordersPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_sellordersPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected int getMyWanSite() {
        if (this.isWanTest) {
            return WanTest.myWanSite;
        }
        return -1;
    }

    protected void updateUniqQuery(Connection dConn, Connection gConn, int whichUpdate) {
        int qty = rand.nextInt(30);
        int tid = this.getMyTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            }
            this.updateFromGfxdTable(gConn, whichUpdate, qty, tid, sid, sid2, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    private boolean updateFromDerbyTable(Connection conn, int whichUpdate, int qty, int tid, int sid, int sid2, List<SQLException> exList) {
        PreparedStatement stmt = null;
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate) : this.getStmt(conn, uniqUpdate[whichUpdate]);
        if (stmt == null) {
            return false;
        }
        int count = -1;
        Log.getLogWriter().info("update from derby, myTid is " + tid);
        try {
            verifyRowCount.put(tid + "_update", 0);
            count = this.updateFromTable(stmt, whichUpdate, qty, tid, sid, sid2);
            verifyRowCount.put(tid + "_update", count);
            Log.getLogWriter().info("Derby updates " + count + " rows");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    private void updateFromGfxdTable(Connection conn, int whichUpdate, int qty, int tid, int sid, int sid2, List<SQLException> exList) {
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate) : this.getStmt(conn, uniqUpdate[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        int count = -1;
        Log.getLogWriter().info("update from gemfirexd, myTid is " + tid);
        try {
            count = this.updateFromTable(stmt, whichUpdate, qty, tid, sid, sid2);
            if (!isHATest && count != verifyRowCount.get(tid + "_update")) {
                throw new TestException("Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update") + " but gfxd updated " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    private int updateFromTable(PreparedStatement stmt, int whichUpdate, int qty, int tid, int sid, int sid2) throws SQLException {
        Log.getLogWriter().info("update statement is " + uniqUpdate[whichUpdate]);
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating record where sid between " + sid + " and " + sid2 + " and tid is " + tid);
                stmt.setInt(1, qty);
                stmt.setInt(2, tid);
                stmt.setInt(3, sid);
                stmt.setInt(4, sid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("incorrect update statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void updateNonUniqQuery(Connection dConn, Connection gConn, int whichUpdate) {
        int qty = rand.nextInt(30);
        int tid = this.getOtherTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        int retrySleepMs = 100;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.updateFromDerbyTable(dConn, whichUpdate, qty, tid, sid, sid2, exList);
            }
            this.updateFromGfxdTable(gConn, whichUpdate, qty, tid, sid, sid2, exList);
            SQLHelper.handleMissedSQLException(exList);
        }
    }

    protected void updateNonUniqQuery(Connection gConn, int whichUpdate) {
        int qty = rand.nextInt(30);
        int tid = this.getOtherTid();
        int sid = this.getSid();
        int sid2 = sid + 10;
        this.updateFromGfxdTable(gConn, whichUpdate, qty, tid, sid, sid2);
    }

    private void updateFromGfxdTable(Connection conn, int whichUpdate, int qty, int tid, int sid, int sid2) {
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate) : this.getStmt(conn, uniqUpdate[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        try {
            this.updateFromTable(stmt, whichUpdate, qty, tid, sid, sid2);
        }
        catch (SQLException se) {
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && SQLTest.testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }
}

