/*
 * Decompiled with CFR 0.152.
 */
package sql.subqueryStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import sql.SQLHelper;
import sql.joinStatements.CustomersNetworthJoinStmt;
import sql.sqlutil.ResultSetHelper;
import sql.subqueryStatements.SubqueryStmtIF;
import util.TestException;

public class CustomersNetworthSubqueryStmt
extends CustomersNetworthJoinStmt
implements SubqueryStmtIF {
    protected static String[] uniqSelect = new String[]{"select * from trade.customers c where c.tid = ? and c.cid IN (select cid from trade.networth n where tid =? and (cash + securities - (loanLimit - availloan)) > 5000 )", "select cid, cust_name, since from trade.customers c where (select (cash + securities) from trade.networth n where c.cid = n.cid and n.tid =?) > 5000 ", "select cid, cash, securities from trade.networth n where (select (cust_name) from trade.customers c where c.cid = n.cid and c.tid =?) like ? ", "select cid, cash, securities from trade.networth n where (select (cust_name) from trade.customers c where c.cid = n.cid and c.tid = n.tid and c.tid =?) like ? "};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.customers c where c.cid IN (select cid from trade.networth n where (cash + securities - (loanLimit - availloan)) > 5000 )", "select cid, cust_name, since from trade.customers c where (select (cash + securities) from trade.networth n where c.cid = n.cid) > 5000 ", "select cid, cash, securities from trade.networth n where (select (cust_name) from trade.customers c where c.cid = n.cid) like ? ", "select cid, cash, securities from trade.networth n where (select (cust_name) from trade.customers c where c.cid = n.cid and c.tid = n.tid) like ? "};

    @Override
    public void subquery(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                this.getUniqQuery(dConn, gConn, whichQuery);
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                this.getNonUniqQuery(dConn, gConn, whichQuery);
            }
        } else {
            int whichQuery = rand.nextInt(nonUniqSelect.length);
            this.getNonUniqQuery(gConn, whichQuery);
        }
    }

    @Override
    public void subqueryDelete(Connection dConn, Connection gConn) {
    }

    protected void getUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet gfxdRS;
        ResultSet derbyRS;
        int tid = this.getMyTid();
        StringBuilder custName = new StringBuilder();
        switch (whichQuery) {
            case 0: {
                derbyRS = this.getUniqQuery0(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery0(gConn, whichQuery, tid);
                break;
            }
            case 1: {
                derbyRS = this.getUniqQuery1(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery1(gConn, whichQuery, tid);
                break;
            }
            case 2: {
                this.getDataForQuery2(custName);
                derbyRS = this.getUniqQuery2(dConn, whichQuery, custName.toString(), tid);
                gfxdRS = this.getUniqQuery2(gConn, whichQuery, custName.toString(), tid);
                break;
            }
            case 3: {
                this.getDataForQuery2(custName);
                derbyRS = this.getUniqQuery2(dConn, whichQuery, custName.toString(), tid);
                gfxdRS = this.getUniqQuery2(gConn, whichQuery, custName.toString(), tid);
                break;
            }
            default: {
                throw new TestException("invalid uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        if (gfxdRS == null) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        ResultSetHelper.compareResultSets(derbyList, gfxdList);
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery0(conn, whichQuery, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery0(conn, whichQuery, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid);
            stmt.setInt(1, tid);
            stmt.setInt(2, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getUniqQuery1(Connection conn, int whichQuery, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery1(conn, whichQuery, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery1(conn, whichQuery, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery1(Connection conn, int whichQuery, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid);
            stmt.setInt(1, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private void getDataForQuery2(StringBuilder custName) {
        int length = 2;
        custName.append('%' + this.getRandVarChar(length) + '%');
    }

    private ResultSet getUniqQuery2(Connection conn, int whichQuery, String custName, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery2(conn, whichQuery, custName, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery2(conn, whichQuery, custName, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery2(Connection conn, int whichQuery, String custName, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query cust_name " + custName + " and tid: " + tid);
            stmt.setInt(1, tid);
            stmt.setString(2, custName);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equalsIgnoreCase("0A000") && whichQuery == 3) {
                success[0] = true;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet gfxdRS;
        ResultSet derbyRS;
        StringBuilder custName = new StringBuilder();
        switch (whichQuery) {
            case 0: {
                derbyRS = this.getNonUniqQuery0(dConn, whichQuery);
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 1: {
                derbyRS = this.getNonUniqQuery0(dConn, whichQuery);
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 2: {
                this.getDataForQuery2(custName);
                derbyRS = this.getNonUniqQuery2(dConn, whichQuery, custName.toString());
                gfxdRS = this.getNonUniqQuery2(gConn, whichQuery, custName.toString());
                break;
            }
            case 3: {
                this.getDataForQuery2(custName);
                derbyRS = this.getNonUniqQuery2(dConn, whichQuery, custName.toString());
                gfxdRS = this.getNonUniqQuery2(gConn, whichQuery, custName.toString());
                break;
            }
            default: {
                throw new TestException("invalid uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        if (gfxdRS == null) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        ResultSetHelper.compareResultSets(derbyList, gfxdList);
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery0(conn, whichQuery, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery0(conn, whichQuery, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("no bound data used in query");
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery2(Connection conn, int whichQuery, String custName) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery2(conn, whichQuery, custName, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery2(conn, whichQuery, custName, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery2(Connection conn, int whichQuery, String custName, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query cust_name " + custName);
            stmt.setString(1, custName);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equalsIgnoreCase("0A000") && whichQuery == 3) {
                success[0] = true;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection gConn, int whichQuery) {
        ResultSet gfxdRS;
        StringBuilder custName = new StringBuilder();
        switch (whichQuery) {
            case 0: {
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 1: {
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery);
                break;
            }
            case 2: {
                this.getDataForQuery2(custName);
                gfxdRS = this.getNonUniqQuery2(gConn, whichQuery, custName.toString());
                break;
            }
            case 3: {
                this.getDataForQuery2(custName);
                gfxdRS = this.getNonUniqQuery2(gConn, whichQuery, custName.toString());
                break;
            }
            default: {
                throw new TestException("invalid uinque quey selection");
            }
        }
        if (gfxdRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        ResultSetHelper.asList(gfxdRS, false);
    }
}

