/*
 * Decompiled with CFR 0.152.
 */
package sql.subqueryStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.AbstractDMLStmt;
import sql.joinStatements.SecuritiesPortfolioJoinStmt;
import sql.sqlutil.ResultSetHelper;
import sql.subqueryStatements.SubqueryStmtIF;
import util.TestException;
import util.TestHelper;

public class SecuritiesPortfolioSubqueryStmt
extends SecuritiesPortfolioJoinStmt
implements SubqueryStmtIF {
    protected static String[] uniqSelect = new String[]{"select * from trade.securities where sec_id IN (select sid from trade.portfolio where tid = ? and cid >?) ", "select sec_id, symbol, price, tid from trade.securities s where price >(select (Avg(subTotal/qty)) from trade.portfolio f where sec_id = f.sid and f.tid =? and qty <> 0) and tid =? ", "select sec_id, symbol, price, exchange from trade.securities s where sec_id IN (select sid from trade.portfolio f where tid =? GROUP BY sid Having count(*) > 2) ", "select cid,  sid, qty from trade.portfolio f where (select price from trade.securities s where sec_id = f.sid and cid >? and f.tid = ? ) <? and tid = ?", "select cid,  sid, availQty, tid, subTotal from trade.portfolio f where (select symbol from trade.securities s where sec_id = f.sid and f.tid = ? ) like ? and cid >? and tid =?"};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.securities trade where sec_id IN (select sid from trade.portfolio where cid >?)", "select sec_id, symbol, price, tid from trade.securities s where price >(select (Avg(subTotal/qty)) from trade.portfolio f where sec_id = f.sid and qty <> 0) ", "select sec_id, symbol, price, exchange from trade.securities s where sec_id IN (select sid from trade.portfolio f GROUP BY sid Having count(*) > 2) ", "select cid,  sid, qty from trade.portfolio f where (select price from trade.securities s where sec_id = f.sid and cid >?) <?", "select cid,  sid, availQty, tid, subTotal from trade.portfolio f where (select symbol from trade.securities s where sec_id = f.sid ) like ? and cid >? "};
    protected static boolean isTableSecuritiesReplicated = TestConfig.tab().booleanAt(SQLPrms.isTableSecuritiesReplicated, false);

    @Override
    public void subquery(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                this.getUniqQuery(dConn, gConn, whichQuery);
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                this.getNonUniqQuery(dConn, gConn, whichQuery);
            }
        } else {
            int whichQuery = rand.nextInt(nonUniqSelect.length);
            this.getNonUniqQuery(gConn, whichQuery);
        }
    }

    @Override
    public void subqueryDelete(Connection dConn, Connection gConn) {
    }

    protected void getUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet derbyRS = null;
        ResultSet gfxdRS = null;
        int tid = this.getMyTid();
        int cid = AbstractDMLStmt.getCid();
        BigDecimal price = this.getPrice();
        StringBuilder symbol = new StringBuilder();
        switch (whichQuery) {
            case 0: {
                derbyRS = this.getUniqQuery0(dConn, whichQuery, cid, tid);
                gfxdRS = this.getUniqQuery0(gConn, whichQuery, cid, tid);
                break;
            }
            case 1: {
                derbyRS = this.getUniqQuery1(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery1(gConn, whichQuery, tid);
                break;
            }
            case 2: {
                derbyRS = this.getUniqQuery2(dConn, whichQuery, tid);
                gfxdRS = this.getUniqQuery2(gConn, whichQuery, tid);
                break;
            }
            case 3: {
                derbyRS = this.getUniqQuery3(dConn, whichQuery, cid, price, tid);
                gfxdRS = this.getUniqQuery3(gConn, whichQuery, cid, price, tid);
                break;
            }
            case 4: {
                this.getDataForQuery4(symbol);
                derbyRS = this.getUniqQuery4(dConn, whichQuery, cid, symbol.toString(), tid);
                gfxdRS = this.getUniqQuery4(gConn, whichQuery, cid, symbol.toString(), tid);
                break;
            }
            default: {
                throw new TestException("invalid uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        if (gfxdRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        ResultSetHelper.compareResultSets(derbyList, gfxdList);
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int cid, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery0(conn, whichQuery, cid, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery0(conn, whichQuery, cid, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery0(Connection conn, int whichQuery, int cid, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid + " cid: " + cid);
            stmt.setInt(1, tid);
            stmt.setInt(2, cid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getUniqQuery1(Connection conn, int whichQuery, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery1(conn, whichQuery, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery1(conn, whichQuery, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery1(Connection conn, int whichQuery, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid);
            stmt.setInt(1, tid);
            stmt.setInt(2, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && se.getMessage().contains("Correlated query with outer query on replicated table and inner on partitioned table is unsupported")) {
                ArrayList securitiesPartition = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"securitiesPartition");
                if (securitiesPartition != null && securitiesPartition.size() == 0 || isTableSecuritiesReplicated) {
                    Log.getLogWriter().info("Correlated query with outer query on replicated table and inner on partitioned table is unsupported");
                    success[0] = false;
                }
                throw new TestException("get unexpected 0A000 as outer table is not replicate table " + TestHelper.getStackTrace((Throwable)se));
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getUniqQuery2(Connection conn, int whichQuery, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery2(conn, whichQuery, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery2(conn, whichQuery, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery2(Connection conn, int whichQuery, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- tid: " + tid);
            stmt.setInt(1, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private void getDataForQuery4(StringBuilder symbol) {
        int length = 1;
        symbol.append('_' + this.getRandVarChar(length) + '%');
    }

    private ResultSet getUniqQuery3(Connection conn, int whichQuery, int cid, BigDecimal price, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery3(conn, whichQuery, cid, price, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery3(conn, whichQuery, cid, price, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery3(Connection conn, int whichQuery, int cid, BigDecimal price, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query price " + price + " and tid: " + tid + " and cid: " + cid);
            stmt.setInt(1, cid);
            stmt.setBigDecimal(3, price);
            stmt.setInt(2, tid);
            stmt.setInt(4, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equalsIgnoreCase("0A000") && whichQuery == 3) {
                success[0] = true;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getUniqQuery4(Connection conn, int whichQuery, int cid, String symbol, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getUniqQuery4(conn, whichQuery, cid, symbol, tid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getUniqQuery4(conn, whichQuery, cid, symbol, tid, success);
        }
        return rs;
    }

    private ResultSet getUniqQuery4(Connection conn, int whichQuery, int cid, String symbol, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query symbol " + symbol + " and tid: " + tid + " and cid: " + cid);
            stmt.setInt(1, tid);
            stmt.setString(2, symbol);
            stmt.setInt(3, cid);
            stmt.setInt(4, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection dConn, Connection gConn, int whichQuery) {
        ResultSet derbyRS = null;
        ResultSet gfxdRS = null;
        int cid = AbstractDMLStmt.getCid();
        BigDecimal price = this.getPrice();
        StringBuilder symbol = new StringBuilder();
        switch (whichQuery) {
            case 0: {
                derbyRS = this.getNonUniqQuery0(dConn, whichQuery, cid);
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery, cid);
                break;
            }
            case 1: {
                derbyRS = this.getNonUniqQuery1(dConn, whichQuery);
                gfxdRS = this.getNonUniqQuery1(gConn, whichQuery);
                break;
            }
            case 2: {
                derbyRS = this.getNonUniqQuery1(dConn, whichQuery);
                gfxdRS = this.getNonUniqQuery1(gConn, whichQuery);
                break;
            }
            case 3: {
                derbyRS = this.getNonUniqQuery3(dConn, whichQuery, cid, price);
                gfxdRS = this.getNonUniqQuery3(gConn, whichQuery, cid, price);
                break;
            }
            case 4: {
                this.getDataForQuery4(symbol);
                derbyRS = this.getNonUniqQuery4(dConn, whichQuery, cid, symbol.toString());
                gfxdRS = this.getNonUniqQuery4(gConn, whichQuery, cid, symbol.toString());
                break;
            }
            default: {
                throw new TestException("invalid non uinque quey selection");
            }
        }
        if (derbyRS == null) {
            Log.getLogWriter().info("Could not get query results from derby.");
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            Log.getLogWriter().info("Not able to convert derby resultSet to a list");
            return;
        }
        if (gfxdRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        ResultSetHelper.compareResultSets(derbyList, gfxdList);
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery, int cid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery0(conn, whichQuery, cid, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery0(conn, whichQuery, cid, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery0(Connection conn, int whichQuery, int cid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- cid: " + cid);
            stmt.setInt(1, cid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery1(Connection conn, int whichQuery) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery1(conn, whichQuery, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery1(conn, whichQuery, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery1(Connection conn, int whichQuery, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query -- none");
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && se.getMessage().contains("Correlated query with outer query on replicated table and inner on partitioned table is unsupported")) {
                ArrayList securitiesPartition = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"securitiesPartition");
                if (securitiesPartition != null && securitiesPartition.size() == 0 || isTableSecuritiesReplicated) {
                    Log.getLogWriter().info("Correlated query with outer query on replicated table and inner on partitioned table is unsupported");
                    success[0] = false;
                }
                throw new TestException("get unexpected 0A000 as outer table is not replicate table " + TestHelper.getStackTrace((Throwable)se));
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery3(Connection conn, int whichQuery, int cid, BigDecimal price) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery3(conn, whichQuery, cid, price, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery3(conn, whichQuery, cid, price, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery3(Connection conn, int whichQuery, int cid, BigDecimal price, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query price " + price + " and cid: " + cid);
            stmt.setInt(1, cid);
            stmt.setBigDecimal(2, price);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery4(Connection conn, int whichQuery, int cid, String symbol) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = this.getNonUniqQuery4(conn, whichQuery, cid, symbol, success);
        int count = 0;
        while (!success[0]) {
            if (SQLHelper.isDerbyConn(conn) || count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the resultSet abort this operation");
                return rs;
            }
            ++count;
            rs = this.getNonUniqQuery4(conn, whichQuery, cid, symbol, success);
        }
        return rs;
    }

    private ResultSet getNonUniqQuery4(Connection conn, int whichQuery, int cid, String symbol, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Log.getLogWriter().info("which query is -- " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            Log.getLogWriter().info("data used in query symbol " + symbol + " and cid: " + cid);
            stmt.setString(1, symbol);
            stmt.setInt(2, cid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equalsIgnoreCase("0A000") && whichQuery == 3) {
                success[0] = true;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getNonUniqQuery(Connection gConn, int whichQuery) {
        ResultSet gfxdRS;
        int cid = AbstractDMLStmt.getCid();
        BigDecimal price = this.getPrice();
        StringBuilder symbol = new StringBuilder();
        switch (whichQuery) {
            case 0: {
                gfxdRS = this.getNonUniqQuery0(gConn, whichQuery, cid);
                break;
            }
            case 1: {
                gfxdRS = this.getNonUniqQuery1(gConn, whichQuery);
                break;
            }
            case 2: {
                gfxdRS = this.getNonUniqQuery1(gConn, whichQuery);
                break;
            }
            case 3: {
                gfxdRS = this.getNonUniqQuery3(gConn, whichQuery, cid, price);
                break;
            }
            case 4: {
                this.getDataForQuery4(symbol);
                gfxdRS = this.getNonUniqQuery4(gConn, whichQuery, cid, symbol.toString());
                break;
            }
            default: {
                throw new TestException("invalid non uinque quey selection");
            }
        }
        if (gfxdRS == null && !isHATest) {
            Log.getLogWriter().info("could not get results after a few retries");
            return;
        }
        ResultSetHelper.asList(gfxdRS, false);
    }
}

