/*
 * Decompiled with CFR 0.152.
 */
package sql.testDBs;

import hydra.Log;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import sql.SQLHelper;
import util.TestException;

public class MusicPopulator {
    static final String[] VERSION_STRINGS = new String[]{"studio", "live", "unplugged", "funky remix", "rap mix", "disco mix"};
    static final int MAX_RATING = 5;

    public static Integer getColMaxInt(Connection conn, String tableName, String colName) throws SQLException {
        Integer retVal = null;
        ResultSet rs = conn.createStatement().executeQuery("select max(" + colName + ") from " + tableName);
        if (rs != null) {
            rs.next();
            retVal = new Integer(rs.getInt(1));
        }
        rs.close();
        return retVal;
    }

    public static HashSet<String> getStringVals(Connection conn, String tableName, String colName) throws SQLException {
        HashSet<String> retSet = null;
        ResultSet rs = conn.createStatement().executeQuery("select " + colName + " from " + tableName);
        if (rs != null) {
            retSet = new HashSet<String>();
            while (rs.next()) {
                retSet.add(rs.getString(1));
            }
        }
        return retSet;
    }

    public static void addToTables(Connection conn, int artistCount, int albumCount, int copyrightOwnerCount, int songCount, int genreCount, int tagCount, int tracksCount) {
        Log.getLogWriter().info("Entered addToTables with artistCount=" + artistCount + ", albumCount=" + albumCount + ", copyrightOwnerCount=" + copyrightOwnerCount + ", songCount=" + songCount + ", genreCount=" + genreCount + ", tagCount=" + tagCount + ", tracksCount=" + tracksCount);
        try {
            int trackNumOnDisk;
            int albumID;
            int i;
            int artistExistingMax = MusicPopulator.getColMaxInt(conn, "music.artist", "artist_id");
            int albumExistingMax = MusicPopulator.getColMaxInt(conn, "music.album", "album_id");
            int copyrightOwnerExistingMax = MusicPopulator.getColMaxInt(conn, "music.copyright_owner", "owner_id");
            int songExistingMax = MusicPopulator.getColMaxInt(conn, "music.song", "song_id");
            int copyrightExistingMax = MusicPopulator.getColMaxInt(conn, "music.copyright", "copyright_id");
            int genreMax = MusicPopulator.getColMaxInt(conn, "music.genre", "genre_id");
            HashSet<String> existingTags = MusicPopulator.getStringVals(conn, "music.tag", "tag_name");
            Log.getLogWriter().info("addToTables found artistExistingMax=" + artistExistingMax + ", albumExistingMax=" + albumExistingMax + ", copyrightOwnerExistingMax=" + copyrightOwnerExistingMax + ", songExistingMax=" + songExistingMax + ", genreMax=" + genreMax);
            PreparedStatement ps = conn.prepareStatement("insert into music.artist(artist_id, artist_name) values(?,?)");
            for (i = artistExistingMax + 1; i <= artistExistingMax + artistCount; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "artist" + i);
                ps.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            ps = conn.prepareStatement("insert into music.album(album_id, album_name, primary_artist_id, publish_date) values(?,?,?,?)");
            for (i = 1; i <= albumCount; ++i) {
                ps.setInt(1, albumExistingMax + i);
                ps.setString(2, "album" + (albumExistingMax + i));
                ps.setInt(3, artistExistingMax + 1 + i % artistCount);
                try {
                    ps.setDate(4, new Date(new SimpleDateFormat("yyyy/MM/dd").parse("1999/12/12").getTime()));
                }
                catch (ParseException e) {
                    throw new TestException("Invalid date in MusicPopulator");
                }
                ps.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            ps = conn.prepareStatement("insert into music.copyright_owner(owner_id, owner_name) values(?,?)");
            for (i = 1; i <= copyrightOwnerCount; ++i) {
                ps.setInt(1, copyrightOwnerExistingMax + i);
                ps.setString(2, "copyrightOwner" + (copyrightOwnerExistingMax + i));
                ps.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            ps = conn.prepareStatement("insert into music.song(song_id, artist_id,song_name,version,copyright_owner_id,rating) values(?,?,?,?,?,?)");
            for (i = songExistingMax + 1; i <= songExistingMax + songCount; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i % artistCount + artistExistingMax + 1);
                ps.setString(3, "song" + i);
                ps.setString(4, VERSION_STRINGS[i % VERSION_STRINGS.length]);
                ps.setInt(5, i % copyrightOwnerCount + copyrightOwnerExistingMax + 1);
                ps.setInt(6, i % 5);
                ps.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            ps = conn.prepareStatement("insert into music.copyright(copyright_id,song_id,owner_id,copyright_fee,copyright_notes) values (?,?,?,?,?)");
            for (i = 1; i <= songCount; ++i) {
                ps.setInt(1, copyrightExistingMax + i);
                ps.setInt(2, songExistingMax + i);
                ps.setInt(3, i % copyrightOwnerCount + copyrightOwnerExistingMax + 1);
                ps.setInt(4, 10 + i % 10);
                ps.setString(5, "note for cw " + copyrightExistingMax + i);
                ps.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            ps = conn.prepareStatement("insert into music.genre(genre_id,genre_name) values(?,?)");
            for (i = genreMax + 1; i <= genreMax + genreCount; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "genre" + i);
                ps.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            ps = conn.prepareStatement("insert into music.tag(tag_name) values(?)");
            for (i = existingTags.size() + 1; i <= existingTags.size() + tagCount; ++i) {
                ps.setString(1, "tag" + i);
                ps.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            ps = conn.prepareStatement("insert into music.tracks(album_id,disk_number,track_number,duration_secs,song_id,genre_id,track_price_cents, track_price_to_copyright_owner_cents, track_price_to_artist_cents) values (?,?,?,?,?,?,?,?,?)");
            int tracksPerAlbum = tracksCount / albumCount;
            int totalTrackCtr = 0;
            for (albumID = albumExistingMax + 1; albumID <= albumCount + albumExistingMax; ++albumID) {
                for (trackNumOnDisk = 1; trackNumOnDisk <= tracksPerAlbum && totalTrackCtr < tracksCount; ++trackNumOnDisk) {
                    ps.setInt(1, albumID);
                    ps.setInt(2, 1);
                    ps.setInt(3, trackNumOnDisk);
                    ps.setInt(4, 240);
                    ps.setInt(5, ++totalTrackCtr % songCount + songExistingMax + 1);
                    ps.setInt(6, totalTrackCtr % genreCount + genreMax + 1);
                    ps.setInt(7, 99);
                    ps.setInt(8, 10);
                    ps.setInt(9, 25);
                    ps.executeUpdate();
                }
            }
            if (totalTrackCtr < tracksCount) {
                for (albumID = albumExistingMax + 1; albumID <= albumCount + albumExistingMax; ++albumID) {
                    for (trackNumOnDisk = 1; trackNumOnDisk <= tracksPerAlbum && totalTrackCtr < tracksCount; ++trackNumOnDisk) {
                        Log.getLogWriter().info("generating track album=" + albumID + ", disk=2, track=" + trackNumOnDisk + " for " + ++totalTrackCtr);
                        ps.setInt(1, albumID);
                        ps.setInt(2, 2);
                        ps.setInt(3, trackNumOnDisk);
                        ps.setInt(4, 240);
                        ps.setInt(5, totalTrackCtr % songCount + songExistingMax + 1);
                        ps.setInt(6, totalTrackCtr % genreCount + genreMax + 1);
                        ps.setInt(7, 99);
                        ps.setInt(8, 10);
                        ps.setInt(9, 25);
                        ps.executeUpdate();
                    }
                }
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException sqle) {
            SQLHelper.handleSQLException(sqle);
        }
    }
}

