/*
 * Decompiled with CFR 0.152.
 */
package sql.tpce;

import cacheperf.comparisons.gemfirexd.QueryPerfException;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class TPCEStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    protected static final String TRADEORDERTXN = "tradeordertxn";
    protected static final String TRADE_ORDER_TXN_TIME = "tradeOrderTxnTime";
    protected static final String TRADERESULTTXN = "traderesulttxn";
    protected static final String TRADE_RESULT_TXN_TIME = "tradeResultTxnTime";
    protected static final String MARKETFEEDTXN = "marketfeedtxn";
    protected static final String MARKET_FEED_TXN_TIME = "marketFeedTxnTime";
    protected static final String MARKET_FEED_TXN_IN_PROGRESS = "marketFeedTxnInProgress";
    protected static final String TRADE_ORDER_TXN_IN_PROGRESS = "tradeOrderTxnInProgress";
    protected static final String TRADE_RESULT_TXN_IN_PROGRESS = "tradeResultTxnInProgress";
    protected static final String MARKET_FEED_TXN_COMPLETED = "marketFeedTxnCompleted";
    protected static final String TRADE_ORDER_TXN_COMPLETED = "tradeOrderTxnCompleted";
    protected static final String TRADE_RESULT_TXN_COMPLETED = "tradeResultTxnCompleted";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{TPCEStats.factory().createIntCounter(TRADE_ORDER_TXN_COMPLETED, "Number of trade_order txn completed.", "operations", largerIsBetter), TPCEStats.factory().createLongCounter(TRADE_ORDER_TXN_TIME, "Total time spent performing trade_order txn.", "nanoseconds", !largerIsBetter), TPCEStats.factory().createIntGauge(TRADE_ORDER_TXN_IN_PROGRESS, "The number of trade_order txn in progress.", "operations"), TPCEStats.factory().createIntCounter(TRADE_RESULT_TXN_COMPLETED, "Number of trade_result txn completed.", "operations", largerIsBetter), TPCEStats.factory().createLongCounter(TRADE_RESULT_TXN_TIME, "Total time spent performing trade_result txn.", "nanoseconds", !largerIsBetter), TPCEStats.factory().createIntGauge(TRADE_RESULT_TXN_IN_PROGRESS, "The number of trade_result txn in progress.", "operations"), TPCEStats.factory().createIntCounter(MARKET_FEED_TXN_COMPLETED, "Number of market_feed txn completed.", "operations", largerIsBetter), TPCEStats.factory().createLongCounter(MARKET_FEED_TXN_TIME, "Total time spent performing market_feed txn.", "nanoseconds", !largerIsBetter), TPCEStats.factory().createIntGauge(MARKET_FEED_TXN_IN_PROGRESS, "The number of market_feed txn in progress.", "operations")};
    }

    public static TPCEStats getInstance() {
        return (TPCEStats)TPCEStats.getInstance(TPCEStats.class, (int)0);
    }

    public static TPCEStats getInstance(String name) {
        return (TPCEStats)TPCEStats.getInstance(TPCEStats.class, (int)0, (String)name);
    }

    public static TPCEStats getInstance(String name, String trimspecName) {
        return (TPCEStats)TPCEStats.getInstance(TPCEStats.class, (int)0, (String)name, (String)trimspecName);
    }

    public TPCEStats(Class<?> cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getTradeOrder() {
        return this.statistics().getInt(TRADEORDERTXN);
    }

    public long getTradeOrderTime() {
        return this.statistics().getLong(TRADE_ORDER_TXN_TIME);
    }

    public int getTradeResultQueries() {
        return this.statistics().getInt(TRADERESULTTXN);
    }

    public long getTradeResultTime() {
        return this.statistics().getLong(TRADE_RESULT_TXN_TIME);
    }

    public int getMarketFeedQueries() {
        return this.statistics().getInt(MARKETFEEDTXN);
    }

    public long getMarketFeedTime() {
        return this.statistics().getLong(MARKET_FEED_TXN_TIME);
    }

    public void incTradeOrder() {
        this.incTradeOrder(1);
    }

    public void incTradeOrder(int amount) {
        this.statistics().incInt(TRADEORDERTXN, amount);
    }

    public void incTradeOrderTime(long amount) {
        this.statistics().incLong(TRADE_ORDER_TXN_TIME, amount);
    }

    public long startTradeOrder() {
        return NanoTimer.getTime();
    }

    public void endTradeOrder(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(TRADEORDERTXN, 1);
        long elapsed = ts - start;
        this.statistics().incLong(TRADE_ORDER_TXN_TIME, elapsed);
    }

    public void incTradeResult() {
        this.incTradeResult(1);
    }

    public void incTradeResult(int amount) {
        this.statistics().incInt(TRADERESULTTXN, amount);
    }

    public void incTradeResultTime(long amount) {
        this.statistics().incLong(TRADE_RESULT_TXN_TIME, amount);
    }

    public long startTradeResult() {
        return NanoTimer.getTime();
    }

    public void endTradeResult(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(TRADERESULTTXN, 1);
        long elapsed = ts - start;
        this.statistics().incLong(TRADE_RESULT_TXN_TIME, elapsed);
    }

    public void incMarketFeed() {
        this.incMarketFeed(1);
    }

    public void incMarketFeed(int amount) {
        this.statistics().incInt(MARKETFEEDTXN, amount);
    }

    public void incMarketFeedTime(long amount) {
        this.statistics().incLong(MARKET_FEED_TXN_TIME, amount);
    }

    public long startMarketFeed() {
        return NanoTimer.getTime();
    }

    public void endMarketFeed(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(MARKETFEEDTXN, 1);
        long elapsed = ts - start;
        this.statistics().incLong(MARKET_FEED_TXN_TIME, elapsed);
    }

    public long startTransaction(int txnType) {
        switch (txnType) {
            case 1: {
                this.statistics().incInt(TRADE_ORDER_TXN_IN_PROGRESS, 1);
                break;
            }
            case 2: {
                this.statistics().incInt(TRADE_RESULT_TXN_IN_PROGRESS, 1);
                break;
            }
            case 3: {
                this.statistics().incInt(MARKET_FEED_TXN_IN_PROGRESS, 1);
                break;
            }
            default: {
                String s = "Should not happen";
                throw new QueryPerfException(s);
            }
        }
        return NanoTimer.getTime();
    }

    public void endTransaction(int txType, long start) {
        long end = NanoTimer.getTime();
        long elapsed = end - start;
        switch (txType) {
            case 1: {
                this.statistics().incInt(TRADE_ORDER_TXN_IN_PROGRESS, -1);
                this.statistics().incInt(TRADE_ORDER_TXN_COMPLETED, 1);
                this.statistics().incLong(TRADE_ORDER_TXN_TIME, elapsed);
                break;
            }
            case 2: {
                this.statistics().incInt(TRADE_RESULT_TXN_IN_PROGRESS, -1);
                this.statistics().incInt(TRADE_RESULT_TXN_COMPLETED, 1);
                this.statistics().incLong(TRADE_RESULT_TXN_TIME, elapsed);
                break;
            }
            case 3: {
                this.statistics().incInt(MARKET_FEED_TXN_IN_PROGRESS, -1);
                this.statistics().incInt(MARKET_FEED_TXN_COMPLETED, 1);
                this.statistics().incLong(MARKET_FEED_TXN_TIME, elapsed);
                break;
            }
            default: {
                String s = "Should not happen";
                throw new QueryPerfException(s);
            }
        }
    }
}

