/*
 * Decompiled with CFR 0.152.
 */
package sql.tpce;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.QueryPerfException;
import cacheperf.comparisons.gemfirexd.QueryUtil;
import com.gemstone.gemfire.cache.query.Struct;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.HDFSStoreDescription;
import hydra.gemfirexd.HDFSStoreHelper;
import hydra.gemfirexd.ThinClientHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.hdfs.HDFSSqlTest;
import sql.sqlutil.ResultSetHelper;
import sql.tpce.TPCEBB;
import sql.tpce.TPCEStats;
import sql.tpce.tpcedef.TPCETxnInput;
import sql.tpce.tpcedef.generator.CE;
import sql.tpce.tpcedef.generator.MEE;
import sql.tpce.tpcedef.input.MarketFeedTxnInput;
import sql.tpce.tpcedef.input.TradeOrderTxnInput;
import sql.tpce.tpcedef.input.TradeResultTxnInput;
import sql.tpce.tpcedef.output.MarketFeedTxnOutput;
import sql.tpce.tpcedef.output.TradeOrderTxnOutput;
import sql.tpce.tpcedef.output.TradeResultTxnOutput;
import sql.tpce.tpcetxn.TPCEMarketFeed;
import sql.tpce.tpcetxn.TPCETradeOrder;
import sql.tpce.tpcetxn.TPCETradeResult;
import util.TestException;
import util.TestHelper;

public class TPCETest
extends QueryPerfClient {
    public static TPCETest tpceTest;
    public static boolean isClient;
    public static boolean isFunctionalTest;
    public static boolean tradeToMarketWithDefaultId;
    public static boolean logDML;
    public static final Random rand;
    public static final int TRADE_ORDER = 1;
    public static final int TRADE_RESULT = 2;
    public static final int MARKET_FEED = 3;
    protected static final int TPCETXN = 18800000;
    protected static final int TRADEORDER = 1880001;
    protected static final int TRADERESULT = 1880002;
    protected static final String TPCETXN_NAME = "tpcetxn";
    protected static final String TRADEORDER_NAME = "tradeorder";
    protected static final String TRADERESULT_NAME = "traderesult";
    protected static final String SCHEMA_NAME = "TPCEGFXD";
    protected static boolean reproduce48557;
    protected static int initSellQty;
    protected static int initBuyQty;
    protected static int acct_id;
    protected static String symbol;
    public static final String type_limit_buy = "TLB";
    public static final String type_limit_sell = "TLS";
    public static final String type_market_buy = "TMB";
    public static final String type_market_sell = "TMS";
    public static final String type_stop_loss = "TSL";
    public static final String status_submitted = "SBMT";
    public static final String status_completed = "CMPT";
    public static final String[] trade_types;
    private static int totalSellQtyInInit;
    private static final String CONFLICTEXCEPTION = "X0Z02";
    private static final String OFFHEAPCLAUSE = " offheap ";
    private static boolean isOffHeapTest;
    private static boolean isHDFSTest;
    private static String hdfsStoreName;
    private static HydraThreadLocal queryHDFSConn;
    private static boolean reproduce49166OOME;
    private static boolean isTicket49452Fixed;
    public static boolean useSyncCommit;
    private static String createTradeToMarketTable;
    private static String createTradeToMarketTableWithoutDefaultId;
    protected static HydraThreadLocal localtpcestats;
    public TPCEStats tpcestats;

    public static void HydraTask_initailizeClient() {
        isClient = true;
    }

    public static void HydraTask_initializeParameters() {
        if (tpceTest == null) {
            tpceTest = new TPCETest();
        }
        tpceTest.initLocalVariables(-1);
        tpceTest.initLocalParameters();
    }

    @Override
    protected void initLocalParameters() {
        super.initLocalParameters();
        Log.getLogWriter().info("in HydraTask_initializeParameters, this.connection = " + this.connection);
    }

    public static void openStatisticsTask() {
        TPCETest eTest = new TPCETest();
        eTest.openStatistics();
    }

    private void openStatistics() {
        this.tpcestats = this.getTPCEStats();
        if (this.tpcestats == null) {
            this.tpcestats = TPCEStats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
        this.setTPCEStats(this.tpcestats);
    }

    public static void closeStatisticsTask() {
        TPCETest eTest = new TPCETest();
        eTest.initHydraThreadLocals();
        eTest.closeStatistics();
        eTest.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.tpcestats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.tpcestats.close();
        }
    }

    protected TPCEStats getTPCEStats() {
        TPCEStats tpcestats = (TPCEStats)((Object)localtpcestats.get());
        return tpcestats;
    }

    protected void setTPCEStats(TPCEStats tpcestats) {
        localtpcestats.set((Object)tpcestats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPartitionedTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection conn = this.getGfxdNonTxConnection();
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT tableschemaname, tablename, datapolicy FROM sys.systables WHERE tabletype = 'T' and tableschemaname != 'SYSSTAT'");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String schema = rs.getString("tableschemaname");
                String tablename = rs.getString("tablename");
                String datapolicy = rs.getString("datapolicy");
                if (!datapolicy.contains("PARTITION")) continue;
                tableNames.add(schema + "." + tablename);
            }
            rs.close();
            rs = null;
            ps.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
        return tableNames;
    }

    public static void HydraTask_createBucketsTask() throws InterruptedException, SQLException {
        tpceTest.createBuckets();
    }

    protected void createBuckets() throws SQLException {
        if (this.queryAPI == 1) {
            this.assignBucketsForTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignBucketsForTables() throws SQLException {
        try (Connection conn = this.getGfxdNonTxConnection();){
            String sql = "call SYS.CREATE_ALL_BUCKETS( ? )";
            CallableStatement cs = conn.prepareCall(sql);
            List<String> tableNames = this.getPartitionedTables();
            for (String tableName : tableNames) {
                Log.getLogWriter().info("Creating buckets for table " + tableName + ": " + sql);
                cs.setString(1, tableName);
                cs.execute();
                Log.getLogWriter().info("Created buckets for table " + tableName + ": " + sql);
            }
            cs.close();
        }
    }

    protected Connection getConnection(int db) throws SQLException {
        Connection conn = null;
        switch (db) {
            case 1: {
                if (isClient) {
                    conn = QueryUtil.gfxdClientSetup(this);
                    break;
                }
                conn = QueryUtil.gfxdEmbeddedSetup(this);
                break;
            }
            default: {
                throw new TestException("Test issue, other db should not use this method");
            }
        }
        return conn;
    }

    protected Connection getGfxdNonTxConnection() throws SQLException {
        Connection conn;
        if (isClient) {
            conn = QueryUtil.gfxdClientSetup(this);
            conn.setTransactionIsolation(0);
        } else {
            conn = QueryUtil.gfxdEmbeddedSetup(this);
            conn.setTransactionIsolation(0);
        }
        Log.getLogWriter().info("Using transaction isolation level: none");
        return conn;
    }

    protected Connection getQueryHDFSConnectionWithSchema() throws SQLException {
        Connection conn;
        if (isClient) {
            Properties p = ThinClientHelper.getConnectionProperties();
            p.setProperty("query-HDFS", "true");
            Log.getLogWriter().info("setting query-HDFS to true");
            conn = QueryUtil.gfxdClientSetup(this, p);
        } else {
            Properties p = new Properties();
            p.setProperty("query-HDFS", "true");
            Log.getLogWriter().info("setting query-HDFS to true");
            conn = QueryUtil.gfxdEmbeddedSetup(this, p);
        }
        return this.getConnectionWithSchema(conn);
    }

    protected Connection getSkipConstraintsConnectionWithSchema() throws SQLException {
        Connection conn;
        if (isClient) {
            Properties p = ThinClientHelper.getConnectionProperties();
            p.setProperty("skip-constraint-checks", "true");
            Log.getLogWriter().info("setting skip-constraint-checks to true");
            conn = QueryUtil.gfxdClientSetup(this, p);
        } else {
            Properties p = new Properties();
            p.setProperty("skip-constraint-checks", "true");
            Log.getLogWriter().info("setting skip-constraint-checks to true");
            conn = QueryUtil.gfxdEmbeddedSetup(this, p);
        }
        if (!reproduce49166OOME) {
            conn.setTransactionIsolation(0);
            Log.getLogWriter().info("Using transaction isolation level: none");
        }
        return this.getConnectionWithSchema(conn);
    }

    public static void HydraTask_runSQLScript() throws SQLException {
        tpceTest.runSQLScript(true);
    }

    public static void HydraTask_runSQLScriptContinueOnError() throws SQLException {
        tpceTest.runSQLScript(false);
    }

    public static void HydraTask_runImportTable() throws SQLException {
        tpceTest.runImportTable();
    }

    protected void runImportTable() throws SQLException {
        boolean skipConstraints = TestConfig.tab().booleanAt(SQLPrms.skipConstraints, true);
        if (skipConstraints) {
            this.runImportTableSkipConstraints();
        } else {
            this.runImportTableWithConstraints();
        }
    }

    protected void runImportTableWithConstraints() throws SQLException {
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("import table starts from " + start);
        Connection conn = this.getGfxdNonTxConnection();
        this.importTable(conn);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("import table finishes at " + end);
        long time = end - start;
        long seconds = time / 1000L;
        long minutes = seconds / 60L;
        Log.getLogWriter().info("import_table takes " + (minutes > 0L ? minutes + " minutes" : seconds + " seconds"));
        TPCEBB.getBB().getSharedCounters().add(TPCEBB.importTableTime, time);
    }

    public static void HydraTask_runImportTableSkipConstraints() throws SQLException {
        tpceTest.runImportTableSkipConstraints();
    }

    protected void runImportTableSkipConstraints() throws SQLException {
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("import table starts from " + start);
        Connection conn = this.getSkipConstraintsConnectionWithSchema();
        this.importTable(conn);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("import table finishes at " + end);
        long time = end - start;
        Log.getLogWriter().info("import_table takes " + time / 1000L + " seconds");
        TPCEBB.getBB().getSharedCounters().add(TPCEBB.importTableTime, time);
    }

    protected void importTable(Connection conn) throws SQLException {
        StringBuilder sb = this.getSqlScript();
        String[] inst = sb.toString().split(";");
        Statement st = conn.createStatement();
        for (int i = 0; i < inst.length; ++i) {
            try {
                if (inst[i].trim().equals("") || inst[i].contains("exit")) continue;
                TPCETest.log().info(">>" + inst[i]);
                long start = System.currentTimeMillis();
                st.executeUpdate(inst[i]);
                long end = System.currentTimeMillis();
                Log.getLogWriter().info("executing " + inst[i] + " takes " + ((double)(end - start) / 1000.0 < 30.0 ? (double)(end - start) / 1000.0 + " seconds." : (double)(end - start) / 60000.0 + " minutes."));
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public StringBuilder getSqlScript() {
        String jtests = System.getProperty("JTESTS");
        String sqlFilePath = SQLPrms.getSqlFilePath();
        String s = new String();
        StringBuilder sb = new StringBuilder();
        try {
            FileReader fr = new FileReader(new File(jtests + "/" + sqlFilePath));
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                int indexOfCommentSign = s.indexOf("--");
                if (indexOfCommentSign != -1) {
                    s = s.startsWith("--") ? new String("") : new String(s.substring(0, indexOfCommentSign - 1));
                }
                sb.append(s);
            }
            br.close();
            return sb;
        }
        catch (Exception e) {
            throw new TestException("could not get sql script " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static void HydraTask_createOffheapTables() throws SQLException {
        tpceTest.createOffheapTables();
    }

    protected void createOffheapTables() throws SQLException {
        isOffHeapTest = true;
        this.createTables();
    }

    protected void createTables() throws SQLException {
        if (isHDFSTest) {
            HDFSStoreDescription hdfsStoreDesc = HDFSStoreHelper.getHDFSStoreDescription(GfxdConfigPrms.getHDFSStoreConfig());
            hdfsStoreName = hdfsStoreDesc.getName();
        }
        StringBuilder sb = this.getSqlScript();
        String[] inst = sb.toString().split(";");
        Connection c = this.getGfxdNonTxConnection();
        Statement st = c.createStatement();
        for (int i = 0; i < inst.length; ++i) {
            try {
                if (inst[i].trim().equals("") || inst[i].contains("exit")) continue;
                if (isOffHeapTest && inst[i].contains("CREATE TABLE")) {
                    int n = i;
                    inst[n] = inst[n] + OFFHEAPCLAUSE;
                }
                if (isHDFSTest && isTicket49452Fixed) {
                    if (inst[i].contains("CREATE TABLE trade ")) {
                        int n = i;
                        inst[n] = inst[n] + this.getTradeHDFSClause();
                    }
                    if (inst[i].contains("CREATE TABLE trade_history ")) {
                        int n = i;
                        inst[n] = inst[n] + this.getTradeHistoryHDFSClause();
                    }
                    if (inst[i].contains("CREATE TABLE holding_history ")) {
                        int n = i;
                        inst[n] = inst[n] + this.getHoldingHistoryHDFSClause();
                    }
                    if (inst[i].contains("CREATE TABLE cash_transaction ")) {
                        int n = i;
                        inst[n] = inst[n] + this.getCashTransactionHDFSClause();
                    }
                }
                TPCETest.log().info(">>" + inst[i]);
                st.executeUpdate(inst[i]);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    private String getTradeHDFSClause() {
        return " EVICTION BY CRITERIA ( t_st_id = 'CMPT') EVICTION FREQUENCY 30 SECONDS  HDFSSTORE (" + hdfsStoreName + ")";
    }

    private String getHoldingHistoryHDFSClause() {
        return " EVICTION BY CRITERIA ( hh_t_id > 0 or hh_h_t_id > 0) EVICT INCOMING HDFSSTORE (" + hdfsStoreName + ")";
    }

    private String getTradeHistoryHDFSClause() {
        return " EVICTION BY CRITERIA ( th_t_id > 0 ) EVICT INCOMING HDFSSTORE (" + hdfsStoreName + ")";
    }

    private String getCashTransactionHDFSClause() {
        return " EVICTION BY CRITERIA (DATE(ct_dts) < CURRENT_DATE OR HOUR(ct_dts) < HOUR(CURRENT_TIMESTAMP) - 1 ) EVICTION FREQUENCY 30 MINUTES HDFSSTORE (" + hdfsStoreName + ")";
    }

    public static void HydraTask_setHDFSFlag() throws SQLException {
        isHDFSTest = true;
        tpceTest.setHDFSConnection();
    }

    protected void setHDFSConnection() throws SQLException {
        queryHDFSConn.set((Object)this.getQueryHDFSConnectionWithSchema());
        Log.getLogWriter().info("set the threadlocal for connection with query-HDFS to true");
    }

    public static void HydraTask_createHDFSTables() throws SQLException {
        isHDFSTest = true;
        tpceTest.createHDFSTables();
    }

    protected void createHDFSTables() throws SQLException {
        this.createTables();
    }

    public static void HydraTask_createHdfsStore() throws SQLException {
        tpceTest.createHdfsStore();
    }

    protected void createHdfsStore() throws SQLException {
        Connection conn = this.getGfxdNonTxConnection();
        new HDFSSqlTest().createHdfsStore(conn);
        conn.close();
    }

    public static void HydraTask_createDiskStore() throws SQLException {
        tpceTest.createDiskStores();
    }

    protected void createDiskStores() throws SQLException {
        Connection conn = this.getGfxdNonTxConnection();
        this.createDiskStores(conn);
        conn.close();
    }

    protected void createDiskStores(Connection conn) {
        String maxlogsize = " maxlogsize 2";
        String createDiskStore = "create diskstore tpceHdfsDiskStore 'tpceHdfsDiskStore'" + maxlogsize;
        try {
            conn.createStatement().execute(createDiskStore);
            Log.getLogWriter().info("successfuly exectued " + createDiskStore);
        }
        catch (SQLException sqle) {
            SQLHelper.handleSQLException(sqle);
        }
    }

    protected void runSQLScript(boolean failOnError) throws SQLException {
        Connection conn = null;
        switch (this.queryAPI) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 1: {
                conn = this.getGfxdNonTxConnection();
                break;
            }
            default: {
                this.unsupported();
            }
        }
        if (conn == null) {
            throw new TestException("Test issue, connection are not set for other db");
        }
        this.runSQLScript(conn, failOnError);
    }

    protected void runSQLScript(Connection conn, boolean failOnError) throws SQLException {
        String sqlFilePath = SQLPrms.getSqlFilePath();
        Log.getLogWriter().info("running sql script " + sqlFilePath + " on gfxd");
        SQLHelper.runSQLScript(conn, sqlFilePath, failOnError);
    }

    public static void HydraTask_runTradeOrderInInitForSell() {
        TPCETest tTest = new TPCETest();
        tTest.initialize(1880001);
        tTest.runTradeOrderInInit(true);
    }

    public static void HydraTask_runTradeOrderInInitForBuy() {
        TPCETest tTest = new TPCETest();
        tTest.initialize(1880001);
        tTest.runTradeOrderInInit(false);
    }

    protected void runTradeOrderInInit(Boolean isSell) {
        Connection conn = this.getConnectionWithSchema();
        try {
            this.runTradeOrderInInit(conn, isSell);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void runTradeOrderInInit(Connection conn, boolean isSell) throws SQLException {
        TradeOrderTxnInput toInput = (TradeOrderTxnInput)this.getTradeOrderTxnInputInInit(isSell);
        TPCETradeOrder to = new TPCETradeOrder();
        TradeOrderTxnOutput toOutput = (TradeOrderTxnOutput)to.runTxn(toInput, conn);
        if (toInput.getRollItBack() != 1L && (toInput.getTradeTypeId().equals(type_market_sell) || toInput.getTradeTypeId().equals(type_market_buy))) {
            TPCEBB.getBB().addTradeId(toOutput.getTradeId());
            TPCEBB.getBB().getSharedCounters().increment(TPCEBB.TradeIdsInsertedInInitTask);
            Log.getLogWriter().info("TPCEBB adds " + toOutput.getTradeId());
        }
        if (logDML) {
            Log.getLogWriter().info("TradeOrderTxn output: " + toOutput.toString());
        }
    }

    protected TPCETxnInput getTradeOrderTxnInputInInit(Boolean isSell) {
        TradeOrderTxnInput toInput = new TradeOrderTxnInput();
        toInput.setAcctId(acct_id);
        if (rand.nextBoolean()) {
            toInput.setExecFirstName("Christopher");
            toInput.setExecLastName("Worton");
            toInput.setExecTaxId("006WF1412RP228");
        } else {
            toInput.setExecFirstName("Yelena");
            toInput.setExecLastName("Engelhardt");
            toInput.setExecTaxId("206LC5809NM565");
        }
        toInput.setSymbol(symbol);
        toInput.setIssue("COMMON");
        int total = 10;
        if (rand.nextInt(total) == 1) {
            toInput.setRollItBack(1L);
        } else {
            toInput.setRollItBack(0L);
        }
        toInput.setIsLifo(1L);
        if (isSell.booleanValue()) {
            toInput.setTradeQty(initSellQty);
        } else {
            toInput.setTradeQty(initBuyQty);
        }
        if (rand.nextBoolean()) {
            if (isSell.booleanValue()) {
                toInput.setTradeTypeId(type_market_sell);
            } else {
                toInput.setTradeTypeId(type_market_buy);
                toInput.setRollItBack(0L);
            }
            toInput.setStSubmittedId(status_submitted);
        } else {
            if (isSell.booleanValue()) {
                toInput.setTradeTypeId(type_limit_sell);
            } else {
                toInput.setTradeTypeId(type_limit_buy);
            }
            toInput.setRequestedPrice(new BigDecimal("25.97"));
            toInput.setStPendingId("PNDG");
        }
        return toInput;
    }

    public static void HydraTask_runTradeResultInInit() {
        TPCETest tTest = new TPCETest();
        tTest.initialize(1880001);
        tTest.runTradeResultInInit();
    }

    protected void runTradeResultInInit() {
        Connection conn = this.getConnectionWithSchema();
        boolean singleThreadExe = true;
        int maxRun = singleThreadExe ? 80 : 2;
        try {
            for (int i = 0; i < maxRun; ++i) {
                this.runTradeResultInInit(conn);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void runTradeResultInInit(Connection conn) throws SQLException {
        long trade_id = TPCEBB.getBB().getNextTradeId();
        if (trade_id == -1L) {
            if (logDML) {
                Log.getLogWriter().info("no new trade_id available to process");
            }
            return;
        }
        if (logDML) {
            Log.getLogWriter().info("processing trade_id: " + trade_id);
        }
        TradeResultTxnInput trInput = (TradeResultTxnInput)this.getTradeResultTxnInputInInit(trade_id);
        TPCETradeResult tr = new TPCETradeResult();
        TradeResultTxnOutput trOutput = null;
        boolean retry = true;
        while (retry) {
            try {
                trOutput = (TradeResultTxnOutput)tr.runTxn(trInput, conn);
                retry = false;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals(CONFLICTEXCEPTION)) {
                    if (!logDML) continue;
                    Log.getLogWriter().info("Got conflict exception: " + TestHelper.getStackTrace((Throwable)se));
                    continue;
                }
                if (se.getSQLState().equals("08003")) {
                    if (logDML) {
                        Log.getLogWriter().info("Got connection closed exception: " + TestHelper.getStackTrace((Throwable)se));
                    }
                    if (reproduce48557) continue;
                    this.connection = this.getConnection(1);
                    this.setConnection(this.connection);
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (logDML) {
            Log.getLogWriter().info("TradeResultTxn output: " + trOutput.toString());
        }
    }

    protected TPCETxnInput getTradeResultTxnInputInInit(long trade_id) throws SQLException {
        TradeResultTxnInput trInput = new TradeResultTxnInput();
        trInput.setTradeID(trade_id);
        Connection conn = this.getGfxdNonTxConnection();
        conn.createStatement().execute("set schema TPCEGFXD");
        String sql = "select t_bid_price from trade where t_id = " + trade_id;
        ResultSet rs = conn.createStatement().executeQuery(sql);
        if (!rs.next()) {
            throw new TestException(sql + " does not get results for t_id = " + trade_id);
        }
        trInput.setTradePrice(rs.getBigDecimal("t_bid_price"));
        return trInput;
    }

    protected static int intFor(String name) {
        if (name.equalsIgnoreCase(TRADEORDER_NAME)) {
            return 1880001;
        }
        if (name.equalsIgnoreCase(TRADERESULT_NAME)) {
            return 1880002;
        }
        if (name.equalsIgnoreCase(TPCETXN_NAME)) {
            return 18800000;
        }
        String s = "Unexpected trim interval: " + name;
        throw new QueryPerfException(s);
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 1880001: {
                return TRADEORDER_NAME;
            }
            case 1880002: {
                return TRADERESULT_NAME;
            }
            case 18800000: {
                return TPCETXN_NAME;
            }
        }
        return super.nameFor(name);
    }

    @Override
    protected void initHydraThreadLocals() {
        Log.getLogWriter().info("TPCETest initHydraThreadLocals");
        super.initHydraThreadLocals();
        this.tpcestats = this.getTPCEStats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setTPCEStats(this.tpcestats);
    }

    protected Connection getConnectionWithSchema(Connection conn) {
        String sql = "set schema TPCEGFXD";
        try {
            conn.createStatement().execute(sql);
            if (logDML) {
                Log.getLogWriter().info(sql);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return conn;
    }

    protected Connection getConnectionWithSchema() {
        Connection conn = super.getConnection();
        return this.getConnectionWithSchema(conn);
    }

    public static void HydraTask_alterTableSetTradeId() throws SQLException {
        tpceTest.alterTableSetTradeId();
    }

    protected void alterTableSetTradeId() throws SQLException {
        boolean performAlterTableRestart = rand.nextBoolean();
        if (!performAlterTableRestart) {
            Log.getLogWriter().info("not use alter table with restart");
            return;
        }
        Connection conn = this.getGfxdNonTxConnection();
        conn.createStatement().execute("set schema TPCEGFXD");
        String getMaxTradeId = "select max(T_ID) from trade";
        PreparedStatement ps = conn.prepareStatement(getMaxTradeId);
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            throw new TestException(getMaxTradeId + " failed to get result");
        }
        long maxT_ID = rs.getLong(1);
        Log.getLogWriter().info(getMaxTradeId + " returns " + maxT_ID);
        if (rs.next()) {
            Log.getLogWriter().info(getMaxTradeId + " returns " + rs.getLong(1));
        } else {
            Log.getLogWriter().info(getMaxTradeId + " does not get any result ");
        }
        ps.close();
        String alterTableWithRestart = "alter table trade alter column id restart with " + ++maxT_ID;
        conn.createStatement().execute(alterTableWithRestart);
        Log.getLogWriter().info(alterTableWithRestart + " is executed");
        conn.close();
    }

    public static void HydraTask_verifyTradeResultAfterInit() throws SQLException {
        TPCETest tpceTest = new TPCETest();
        tpceTest.initLocalVariables(-1);
        tpceTest.verifyTradeResultAfterInit();
    }

    protected void verifyTradeResultAfterInit() throws SQLException {
        int hs_qty;
        Connection conn = this.getGfxdNonTxConnection();
        conn.createStatement().execute("set schema TPCEGFXD");
        String selectHoldingSummaryTBL = "select HS_QTY from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? ";
        PreparedStatement ps = conn.prepareStatement(selectHoldingSummaryTBL);
        ps.setLong(1, acct_id);
        ps.setString(2, symbol);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            hs_qty = rs.getInt("HS_QTY");
            if (logDML) {
                Log.getLogWriter().info(selectHoldingSummaryTBL + " get HS_QTY: " + hs_qty + " for HS_CA_ID = " + acct_id + " and HS_S_SYMB = " + symbol);
            }
        } else {
            throw new TestException(selectHoldingSummaryTBL + " expected to get result after trade result txns " + "for HS_CA_ID = " + acct_id + " and HS_S_SYMB = " + symbol);
        }
        totalSellQtyInInit = -1 * initSellQty * (int)TPCEBB.getBB().getSharedCounters().read(TPCEBB.TradeIdsInsertedInInitTask);
        if (hs_qty != totalSellQtyInInit) {
            throw new TestException("Total expected hs_qty after processing trade results is " + totalSellQtyInInit + " but acutal hs_qty from holding_summary_table is " + hs_qty);
        }
        rs.close();
        String selectHolding = "select * from HOLDING where H_CA_ID = ? and H_S_SYMB = ? ";
        ps = conn.prepareStatement(selectHolding);
        ps.setLong(1, acct_id);
        ps.setString(2, symbol);
        rs = ps.executeQuery();
        if (logDML) {
            Log.getLogWriter().info("holding table info: " + ResultSetHelper.listToString(ResultSetHelper.asList(rs, false)));
        }
        rs.close();
    }

    public static void HydraTask_stopFabricServer() {
        FabricServerHelper.stopFabricServer();
    }

    public static void HydraTask_restartFabricServer() throws SQLException {
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("recovery from persistent table starts from " + start);
        TPCETest.startFabricServerTask();
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("recovery from persistent table finishes at " + end);
        long time = end - start;
        Log.getLogWriter().info("recovery takes " + time + " ms");
        TPCEBB.getBB().getSharedCounters().add(TPCEBB.totalServerRecoveryTime, time);
    }

    public static void HydraTask_reportRecoveryTestResults() {
        Log.getLogWriter().info("import table takes " + TPCEBB.getBB().getSharedCounters().read(TPCEBB.importTableTime) + " ms");
        Log.getLogWriter().info("total aggregated recovery time for all data nodes is " + TPCEBB.getBB().getSharedCounters().read(TPCEBB.totalServerRecoveryTime) + " ms");
    }

    public static void HydraTask_runMarketFeedInInit() {
        TPCETest tTest = new TPCETest();
        tTest.initialize(1880001);
        tTest.runMarketFeedInInit();
    }

    protected void runMarketFeedInInit() {
        Connection conn = this.getConnectionWithSchema();
        try {
            this.runMarketFeedInInit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void runMarketFeedInInit(Connection conn) throws SQLException {
        MarketFeedTxnInput mfInput = (MarketFeedTxnInput)this.getMarketFeedTxnInputInInit();
        TPCEMarketFeed mf = new TPCEMarketFeed();
        MarketFeedTxnOutput mfOutput = (MarketFeedTxnOutput)mf.runTxn(mfInput, conn);
        if (logDML) {
            Log.getLogWriter().info("MarketFeedTxn output: " + mfOutput.toString());
        }
    }

    protected TPCETxnInput getMarketFeedTxnInputInInit() {
        MarketFeedTxnInput mfInput = new MarketFeedTxnInput();
        int num = 1;
        mfInput.setLimitBuy(type_limit_buy);
        mfInput.setLimitSell(type_limit_sell);
        mfInput.setStopLoss(type_stop_loss);
        mfInput.setStatusSubmitted(status_submitted);
        BigDecimal[] price_quotes = new BigDecimal[num];
        int[] trade_qty = new int[num];
        String[] symbols = new String[num];
        price_quotes[0] = new BigDecimal("25.97");
        trade_qty[0] = 500;
        symbols[0] = symbol;
        mfInput.setPriceQuotes(price_quotes);
        mfInput.setSymbol(symbols);
        mfInput.setTradeQty(trade_qty);
        return mfInput;
    }

    public static void HydraTask_runTradeOrder() {
        TPCETest tTest = new TPCETest();
        tTest.initialize(1880001);
        CE ce = new CE();
        tTest.runTradeOrder(ce);
    }

    protected void runTradeOrder(CE ce) {
        Connection conn = this.getConnectionWithSchema();
        try {
            if (logDML) {
                Log.getLogWriter().info("execute TradeOrderTxn");
            }
            this.runTradeOrder(conn, ce);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void runTradeOrder(Connection conn, CE ce) throws SQLException {
        TradeOrderTxnInput toInput = (TradeOrderTxnInput)ce.getTradeOrderTxn();
        TPCETradeOrder to = new TPCETradeOrder();
        TradeOrderTxnOutput toOutput = null;
        long start = this.tpcestats.startTransaction(1);
        boolean retry = true;
        while (retry) {
            try {
                toOutput = (TradeOrderTxnOutput)to.runTxn(toInput, conn);
                retry = false;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals(CONFLICTEXCEPTION)) {
                    if (!logDML) continue;
                    Log.getLogWriter().info("Will retry after getting expected conflict exception: " + TestHelper.getStackTrace((Throwable)se));
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        this.tpcestats.endTransaction(1, start);
        if (logDML) {
            Log.getLogWriter().info("TradeOrderTxn output: " + toOutput.toString());
        }
    }

    public static void HydraTask_runMarketFeed() throws InterruptedException {
        TPCETest tTest = new TPCETest();
        tTest.initialize(1880001);
        MEE mee = new MEE();
        tTest.runMarketFeed(mee);
    }

    protected void runMarketFeed(MEE mee) throws InterruptedException {
        Connection conn = this.getConnectionWithSchema();
        try {
            if (logDML) {
                Log.getLogWriter().info("execute MarketFeedTxn");
            }
            this.runMarketFeed(conn, mee);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void runMarketFeed(Connection conn, MEE mee) throws SQLException, InterruptedException {
        MarketFeedTxnInput mfInput = (MarketFeedTxnInput)this.getMarketFeedTxnInput(conn, mee);
        TPCEMarketFeed mf = new TPCEMarketFeed();
        long start = this.tpcestats.startTransaction(3);
        MarketFeedTxnOutput mfOutput = (MarketFeedTxnOutput)mf.runTxn(mfInput, conn);
        this.tpcestats.endTransaction(3, start);
        if (logDML) {
            Log.getLogWriter().info("MarketFeedTxn output: " + mfOutput.toString());
        }
    }

    protected TPCETxnInput getMarketFeedTxnInput(Connection conn, MEE mee) throws SQLException, InterruptedException {
        int minMfTxnInputsQueueSize = 10;
        if (mee.getMfTxnInputQueueSize() < minMfTxnInputsQueueSize) {
            mee.processTradesSubmitted(conn);
        }
        return mee.getMfTxnInput();
    }

    public static void HydraTask_runTradeResult() throws InterruptedException {
        TPCETest tTest = new TPCETest();
        tTest.initialize(1880001);
        MEE mee = new MEE();
        tTest.runTradeResult(mee);
    }

    protected void runTradeResult(MEE mee) throws InterruptedException {
        Connection conn = this.getConnectionWithSchema();
        try {
            if (logDML) {
                Log.getLogWriter().info("execute TradeResultTxn");
            }
            this.runTradeResult(conn, mee);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void runTradeResult(Connection conn, MEE mee) throws SQLException, InterruptedException {
        TradeResultTxnInput trInput = (TradeResultTxnInput)this.getTradeResultTxnInput(conn, mee);
        TPCETradeResult tr = new TPCETradeResult();
        TradeResultTxnOutput trOutput = null;
        long start = this.tpcestats.startTransaction(2);
        boolean retry = true;
        while (retry) {
            try {
                trOutput = (TradeResultTxnOutput)tr.runTxn(trInput, conn);
                retry = false;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals(CONFLICTEXCEPTION)) {
                    if (!logDML) continue;
                    Log.getLogWriter().info("Will retry after getting expected conflict exception: " + TestHelper.getStackTrace((Throwable)se));
                    continue;
                }
                if (se.getSQLState().equals("08003")) {
                    if (logDML) {
                        Log.getLogWriter().info("Got connection closed exception: " + TestHelper.getStackTrace((Throwable)se));
                    }
                    if (reproduce48557) continue;
                    this.connection = this.getConnection(1);
                    this.setConnection(this.connection);
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        this.tpcestats.endTransaction(2, start);
        if (logDML) {
            Log.getLogWriter().info("TradeResultTxn output: " + trOutput.toString());
        }
    }

    protected TPCETxnInput getTradeResultTxnInput(Connection conn, MEE mee) throws SQLException, InterruptedException {
        int minTrTxnInputsQueueSize = 100;
        if (mee.getTrTxnInputQueueSize() < minTrTxnInputsQueueSize) {
            mee.processTradesSubmitted(conn);
        }
        return mee.getTrTxnInput();
    }

    public static void HydraTask_verifyTradeResultAfterBuyInit() throws SQLException {
        tpceTest.verifyTradeResultAfterBuyInit();
    }

    protected void verifyTradeResultAfterBuyInit() throws SQLException {
        int hs_qty;
        Connection conn = this.getGfxdNonTxConnection();
        conn.createStatement().execute("set schema TPCEGFXD");
        String selectHoldingSummaryTBL = "select HS_QTY from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? ";
        PreparedStatement ps = conn.prepareStatement(selectHoldingSummaryTBL);
        ps.setLong(1, acct_id);
        ps.setString(2, symbol);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            hs_qty = rs.getInt("HS_QTY");
            if (logDML) {
                Log.getLogWriter().info(selectHoldingSummaryTBL + " get HS_QTY: " + hs_qty + " for HS_CA_ID = " + acct_id + " and HS_S_SYMB = " + symbol);
            }
        } else {
            throw new TestException(selectHoldingSummaryTBL + " expected to get result after trade result txns " + "for HS_CA_ID = " + acct_id + " and HS_S_SYMB = " + symbol);
        }
        rs.close();
        int expectedHSQty = totalSellQtyInInit + initBuyQty;
        if (hs_qty != expectedHSQty) {
            throw new TestException("Total expected hs_qty after processing trade results is " + expectedHSQty + " but acutal hs_qty from holding_summary_table is " + hs_qty);
        }
        String selectHolding = "select * from HOLDING where H_CA_ID = ? and H_S_SYMB = ? ";
        ps = conn.prepareStatement(selectHolding);
        ps.setLong(1, acct_id);
        ps.setString(2, symbol);
        rs = ps.executeQuery();
        if (logDML) {
            Log.getLogWriter().info("holding table info: " + ResultSetHelper.listToString(ResultSetHelper.asList(rs, false)));
        }
        rs.close();
    }

    public static void HydraTask_createTradeToMEETable() throws SQLException {
        tpceTest.createTradeToMEETable();
    }

    protected void createTradeToMEETable() throws SQLException {
        Connection conn = this.getGfxdNonTxConnection();
        conn.createStatement().execute("set schema TPCEGFXD");
        String sql = tradeToMarketWithDefaultId ? createTradeToMarketTable : createTradeToMarketTableWithoutDefaultId;
        conn.createStatement().execute(sql);
        Log.getLogWriter().info(sql + " is created");
        conn.close();
    }

    public static void HydraTask_initCE() {
        tpceTest.initCE();
    }

    protected void initCE() {
        Log.getLogWriter().info("this connection is " + this.connection);
        Connection conn = this.getConnectionWithSchema();
        Log.getLogWriter().info("conn is " + conn);
        CE ce = new CE();
        try {
            ce.setCaInfo(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_runTPCETxns() throws InterruptedException, SQLException {
        TPCETest tTest = new TPCETest();
        tTest.initialize(18800000);
        tTest.runTPCETxns();
    }

    protected void runTPCETxns() throws InterruptedException, SQLException {
        CE ce = new CE();
        MEE mee = new MEE();
        int throttleMs = 0;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            if (!this.queryPlanGenerationEnabled) {
                int whichTxn = this.runWhichTxn();
                for (int i = 0; i < 5; ++i) {
                    this.runTPCETransaction(whichTxn, ce, mee);
                    if (throttleMs == 0) continue;
                    Thread.sleep(throttleMs);
                }
            }
            this.disableQueryPlanGeneration();
            this.updateLastTradeInCE(ce);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private int runWhichTxn() throws SQLException {
        int minTradeToBeProcessed;
        long tradeProcessed;
        long tradeSendToMarket = TPCEBB.getBB().getSharedCounters().read(TPCEBB.tradeSentToMarket);
        if (tradeSendToMarket - (tradeProcessed = TPCEBB.getBB().getSharedCounters().read(TPCEBB.tradeProcessedByMarket)) < (long)(minTradeToBeProcessed = 1000)) {
            return 1;
        }
        if (rand.nextInt(10) == 0) {
            return 3;
        }
        return 2;
    }

    protected void runTPCETransaction(int whichTxn, CE ce, MEE mee) throws InterruptedException {
        switch (whichTxn) {
            case 1: {
                this.runTradeOrder(ce);
                break;
            }
            case 2: {
                this.runTradeResult(mee);
                break;
            }
            case 3: {
                this.runMarketFeed(mee);
                break;
            }
            default: {
                throw new TestException("should not happen with other txn");
            }
        }
    }

    protected void updateLastTradeInCE(CE ce) throws SQLException {
        long currTime = System.currentTimeMillis();
        if (currTime - ce.getLastTradeUpdatedTime() > 30000L) {
            ce.setLastTradeInfo(this.getConnectionWithSchema());
        }
    }

    public static void HydraTask_validateResults() throws SQLException {
        tpceTest.validateResults();
    }

    private void validateResults() throws SQLException {
        Connection conn = this.getGfxdNonTxConnection();
        conn.createStatement().execute("set schema TPCEGFXD");
        this.validateCompletedOrders(conn);
        this.validateBrokerCommissions(conn);
        this.validateHoldingSummary(conn);
        conn.close();
    }

    private void validateCompletedOrders(Connection conn) throws SQLException {
        String sql = "select b_id, b_num_trades as num_trades from broker order by b_id";
        Log.getLogWriter().info("exectuing numOfTradesFromBroker qeury: " + sql);
        ResultSet bRs = conn.createStatement().executeQuery(sql);
        List<Struct> numOfTradesFromBroker = ResultSetHelper.asList(bRs, false);
        bRs.close();
        boolean useQueryHint = isHDFSTest && rand.nextBoolean();
        sql = "select b_id, count (*) as num_trades from broker, customer_account, trade where b_id = ca_b_id and ca_id = t_ca_id and t_st_id = 'CMPT' group by b_id order by b_id";
        String sqlHdfsQueryHint = "select b_id, count (*) as num_trades from broker, customer_account, trade -- GEMFIREXD-PROPERTIES queryHDFS=true \n where b_id = ca_b_id and ca_id = t_ca_id and t_st_id = 'CMPT' group by b_id order by b_id";
        Statement stmt = null;
        ResultSet joinRs = null;
        if (isHDFSTest && !useQueryHint) {
            Log.getLogWriter().info("using query-HDFS connection");
            Log.getLogWriter().info("exectuing numOfTradesFromJoin query: " + sql);
            stmt = ((Connection)queryHDFSConn.get()).createStatement();
            joinRs = stmt.executeQuery(sql);
        } else {
            stmt = conn.createStatement();
            if (useQueryHint) {
                Log.getLogWriter().info("exectuing numOfTradesFromJoin query using query hint: " + sqlHdfsQueryHint);
                joinRs = stmt.executeQuery(sqlHdfsQueryHint);
            } else {
                Log.getLogWriter().info("exectuing numOfTradesFromJoin query: " + sql);
                joinRs = stmt.executeQuery(sql);
            }
        }
        List<Struct> numOfTradesFromJoin = ResultSetHelper.asList(joinRs, false);
        joinRs.close();
        Log.getLogWriter().info("number of trades for each broker is " + ResultSetHelper.listToString(numOfTradesFromBroker));
        ResultSetHelper.compareSortedResultSets(numOfTradesFromBroker, numOfTradesFromJoin, "numOfTradesFromBroker", "numOfTradesFromJoin");
    }

    private void validateBrokerCommissions(Connection conn) throws SQLException {
        String sql = "select b_id, b_comm_total as commission from broker order by b_id";
        Log.getLogWriter().info("exectuing commissionFromBroker qeury: " + sql);
        ResultSet bRs = conn.createStatement().executeQuery(sql);
        List<Struct> commissionFromBroker = ResultSetHelper.asList(bRs, false);
        bRs.close();
        sql = "select b_id, sum (t_comm) as commission from broker, customer_account, trade where b_id = ca_b_id and ca_id = t_ca_id and t_st_id = 'CMPT' group by b_id order by b_id";
        String sqlHdfsQueryHint = "select b_id, sum (t_comm) as commission from broker, customer_account, trade -- GEMFIREXD-PROPERTIES queryHDFS=true \nwhere b_id = ca_b_id and ca_id = t_ca_id and t_st_id = 'CMPT' group by b_id order by b_id";
        boolean useQueryHint = isHDFSTest && rand.nextBoolean();
        Statement stmt = null;
        ResultSet joinRs = null;
        if (isHDFSTest && !useQueryHint) {
            Log.getLogWriter().info("using query-HDFS connection");
            Log.getLogWriter().info("exectuing commissionFromJoin query: " + sql);
            stmt = ((Connection)queryHDFSConn.get()).createStatement();
            joinRs = stmt.executeQuery(sql);
        } else {
            stmt = conn.createStatement();
            if (useQueryHint) {
                Log.getLogWriter().info("exectuing commissionFromJoin query using query hint: " + sqlHdfsQueryHint);
                joinRs = stmt.executeQuery(sqlHdfsQueryHint);
            } else {
                Log.getLogWriter().info("exectuing commissionFromJoin query: " + sql);
                joinRs = stmt.executeQuery(sql);
            }
        }
        List<Struct> commissionFromJoin = ResultSetHelper.asList(joinRs, false);
        joinRs.close();
        Log.getLogWriter().info("number of trades for each broker is " + ResultSetHelper.listToString(commissionFromBroker));
        ResultSetHelper.compareSortedResultSets(commissionFromBroker, commissionFromJoin, "commissionFromBroker", "commissionFromJoin");
    }

    private void validateHoldingSummary(Connection conn) throws SQLException {
        boolean withQtyCondition = rand.nextBoolean();
        String sql = "select hs_ca_id, hs_s_symb, hs_qty from holding_summary_tbl " + (withQtyCondition ? " where hs_qty > 0 " : "") + " order by hs_ca_id, hs_s_symb";
        Log.getLogWriter().info("exectuing holingSummaryTable qeury: " + sql);
        ResultSet bRs = conn.createStatement().executeQuery(sql);
        List<Struct> holingSummaryTable = ResultSetHelper.asList(bRs, false);
        bRs.close();
        sql = "select hs_ca_id, hs_s_symb, hs_qty from holding_summary " + (withQtyCondition ? "where hs_qty > 0" : "") + " order by hs_ca_id, hs_s_symb";
        Log.getLogWriter().info("exectuing holingSummaryView query: " + sql);
        ResultSet viewRs = conn.createStatement().executeQuery(sql);
        List<Struct> holingSummaryView = ResultSetHelper.asList(viewRs, false);
        viewRs.close();
        ResultSetHelper.compareSortedResultSets(holingSummaryTable, holingSummaryView, "holingSummaryTable", "holingSummaryView");
    }

    static {
        isClient = false;
        isFunctionalTest = TestConfig.tab().booleanAt(SQLPrms.isFunctionalTest, false);
        tradeToMarketWithDefaultId = TestConfig.tab().booleanAt(SQLPrms.tradeToMarketWithDefaultId, false);
        logDML = TestConfig.tab().booleanAt(SQLPrms.logDML, false);
        rand = new Random(SQLPrms.getRandSeed());
        reproduce48557 = true;
        initSellQty = 50;
        initBuyQty = 2598;
        acct_id = 9936;
        symbol = "ADPT";
        trade_types = new String[]{type_limit_buy, type_limit_sell, type_market_buy, type_market_sell, type_stop_loss};
        isOffHeapTest = false;
        isHDFSTest = false;
        hdfsStoreName = "tpcehdfsStore";
        queryHDFSConn = new HydraThreadLocal();
        reproduce49166OOME = false;
        isTicket49452Fixed = false;
        useSyncCommit = false;
        createTradeToMarketTable = "CREATE TABLE trade_market (tm_id BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, tm_s_symb CHAR(15) NOT NULL, tm_t_qty INTEGER NOT NULL CHECK (tm_t_qty > 0), tm_t_bid_price DECIMAL(8,2) NOT NULL CHECK (tm_t_bid_price > 0), tm_tt_id CHAR(3) NOT NULL, tm_t_id BIGINT NOT NULL, tm_status SMALLINT NOT NULL CHECK (tm_status in (0, 1)), PRIMARY KEY (tm_id)) PARTITION BY PRIMARY KEY SERVER GROUPS(MarketGroup)";
        createTradeToMarketTableWithoutDefaultId = "CREATE TABLE trade_market (tm_id BIGINT NOT NULL, tm_s_symb CHAR(15) NOT NULL, tm_t_qty INTEGER NOT NULL CHECK (tm_t_qty > 0), tm_t_bid_price DECIMAL(8,2) NOT NULL CHECK (tm_t_bid_price > 0), tm_tt_id CHAR(3) NOT NULL, tm_t_id BIGINT NOT NULL, tm_status SMALLINT NOT NULL CHECK (tm_status in (0, 1)), PRIMARY KEY (tm_id)) PARTITION BY PRIMARY KEY SERVER GROUPS(MarketGroup)";
        localtpcestats = new HydraThreadLocal();
    }
}

