/*
 * Decompiled with CFR 0.152.
 */
package sql.tpce.tpcedef;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TPCEConstants {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int FREQUENCY_BROKER_VOLUME = 5;
    public static final int FREQUENCY_DATA_MAINTENANCE = -1;
    public static final int FREQUENCY_CUSTOMER_POSITION = 13;
    public static final int FREQUENCY_MARKET_FEED = 1;
    public static final int FREQUENCY_MARKET_WATCH = 18;
    public static final int FREQUENCY_SECURITY_DETAIL = 14;
    public static final int FREQUENCY_TRADE_CLEANUP = -1;
    public static final int FREQUENCY_TRADE_LOOKUP = 8;
    public static final int FREQUENCY_TRADE_ORDER = 10;
    public static final int FREQUENCY_TRADE_RESULT = 10;
    public static final int FREQUENCY_TRADE_STATUS = 19;
    public static final int FREQUENCY_TRADE_UPDATE = 2;
    public static String[] szDriverTypeNames = new String[]{"EGenLoader", "EGenDriverAll", "EGenDriverCE", "EGenDriverMEE", "EGenDriverDM"};
    public static final int DEFAULT_NUM_CUSTOMERS = 5000;
    public static final int DEFAULT_SCALE_FACTOR = 500;
    public static final int DEFAULT_INITIAL_DAYS = 300;
    public static final int DEFAULT_LOAD_UNIT = 1000;
    public static final long IDENT_SHIFT = 4300000000L;
    public static final long TRADE_SHIFT = 200000000000000L;
    public static final long DEFAULT_START_CUSTOMER_ID = 1L;
    public static final long ACTIVECUSTOMERCOUNT = 5000L;
    public static final long DEFAULT_COMPANIES_PER_UNIT = 500L;
    public static final long DEFAULT_COMPANY_COMPETITORS_PER_UNIT = 1500L;
    public static final long DEFAULT_SECURITIES_PER_UNIT = 685L;
    public static final int BROKERS_DIV = 100;
    public static final long STARTING_BROKER_ID = 1L;
    public static final int AbortTrade = 101;
    public static final int MAXHOSTNAME = 64;
    public static final int MAXDBNAME = 64;
    public static final int MAXPATH = 512;
    public static final int dailyMarketBaseYear = 2000;
    public static final int dailyMarketBaseMonth = 0;
    public static final int dailyMarketBaseDay = 3;
    public static final int dailyMarketBaseHour = 0;
    public static final int dailyMarketBaseMinute = 0;
    public static final int dailyMarketBaseSecond = 0;
    public static final int dailyMarketBaseMsec = 0;
    public static final int dailyMarketYears = 5;
    public static final int initialTradePopulationBaseYear = 2005;
    public static final int initialTradePopulationBaseMonth = 0;
    public static final int initialTradePopulationBaseDay = 3;
    public static final int initialTradePopulationBaseHour = 9;
    public static final int initialTradePopulationBaseMinute = 0;
    public static final int initialTradePopulationBaseSecond = 0;
    public static final int initialTradePopulationBaseFraction = 0;
    public static final int daysPerWorkWeek = 5;
    public static final int newsItemsPerCompany = 2;
    public static final int iSecurityDetailMinRows = 5;
    public static final int iSecurityDetailMaxRows = 20;
    public static final int TradeLookupMaxTradeHistoryRowsReturned = 3;
    public static final int TradeLookupMaxRows = 20;
    public static final int TradeLookupFrame1MaxRows = 20;
    public static final int TradeLookupFrame2MaxRows = 20;
    public static final int TradeLookupFrame3MaxRows = 20;
    public static final int TradeLookupFrame4MaxRows = 20;
    public static final int TradeUpdateMaxTradeHistoryRowsReturned = 3;
    public static final int TradeUpdateMaxRows = 20;
    public static final int TradeUpdateFrame1MaxRows = 20;
    public static final int TradeUpdateFrame2MaxRows = 20;
    public static final int TradeUpdateFrame3MaxRows = 20;
    public static final char[] UpperCaseLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] LowerCaseLetters = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] Numerals = "0123456789".toCharArray();
    public static final int MaxLowerCaseLetters = LowerCaseLetters.toString().length() - 1;
    public static final int TradeLookupAValueForTradeIDGenFrame1 = 65535;
    public static final int TradeLookupSValueForTradeIDGenFrame1 = 7;
    public static final int TradeLookupAValueForTimeGenFrame2 = 4095;
    public static final int TradeLookupSValueForTimeGenFrame2 = 16;
    public static final int TradeLookupAValueForSymbolFrame3 = 0;
    public static final int TradeLookupSValueForSymbolFrame3 = 0;
    public static final int TradeLookupAValueForTimeGenFrame3 = 4095;
    public static final int TradeLookupSValueForTimeGenFrame3 = 16;
    public static final int TradeLookupAValueForTimeGenFrame4 = 4095;
    public static final int TradeLookupSValueForTimeGenFrame4 = 16;
    public static final int TradeUpdateAValueForTradeIDGenFrame1 = 65535;
    public static final int TradeUpdateSValueForTradeIDGenFrame1 = 7;
    public static final int TradeUpdateAValueForTimeGenFrame2 = 4095;
    public static final int TradeUpdateSValueForTimeGenFrame2 = 16;
    public static final int TradeUpdateAValueForSymbolFrame3 = 0;
    public static final int TradeUpdateSValueForSymbolFrame3 = 0;
    public static final int TradeUpdateAValueForTimeGenFrame3 = 4095;
    public static final int TradeUpdateSValueForTimeGenFrame3 = 16;
    public static final double minSecPrice = 20.0;
    public static final double maxSecPrice = 30.0;
    public static final int eMEEProcessOrder = 0;
    public static final int eMEESetLimitOrderTrigger = 1;
    public static final String TABLENAME_ZIP_CODE = "ZIP_CODE";
    public static final String TABLENAME_ADDRESS = "ADDRESS";
    public static final String TABLENAME_STATUS_TYPE = "STATUS_TYPE";
    public static final String TABLENAME_TAXRATE = "TAXRATE";
    public static final String TABLENAME_ACCOUNT_PERMISSION = "ACCOUNT_PERMISSION";
    public static final String TABLENAME_CUSTOMER = "CUSTOMER";
    public static final String TABLENAME_EXCHANGE = "EXCHANGE";
    public static final String TABLENAME_SECTOR = "SECTOR";
    public static final String TABLENAME_INDUSTRY = "INDUSTRY";
    public static final String TABLENAME_COMPANY = "COMPANY";
    public static final String TABLENAME_COMPANY_COMPETITOR = "COMPANY_COMPETITOR";
    public static final String TABLENAME_SECURITY = "SECURITY";
    public static final String TABLENAME_DAILY_MARKET = "DAILY_MARKET";
    public static final String TABLENAME_FINANCIAL = "FINANCIAL";
    public static final String TABLENAME_LAST_TRADE = "LAST_TRADE";
    public static final String TABLENAME_NEWS_ITEM = "NEWS_ITEM";
    public static final String TABLENAME_NEWS_XREF = "NEWS_XREF";
    public static final String TABLENAME_BROKER = "BROKER";
    public static final String TABLENAME_CUSTOMER_ACCOUNT = "CUSTOMER_ACCOUNT";
    public static final String TABLENAME_CUSTOMER_TAXRATE = "CUSTOMER_TAXRATE";
    public static final String TABLENAME_TRADE_TYPE = "TRADE_TYPE";
    public static final String TABLENAME_TRADE = "TRADE";
    public static final String TABLENAME_SETTLEMENT = "SETTLEMENT";
    public static final String TABLENAME_TRADE_HISTORY = "TRADE_HISTORY";
    public static final String TABLENAME_HOLDING_SUMMARY = "HOLDING_SUMMARY";
    public static final String TABLENAME_HOLDING = "HOLDING";
    public static final String TABLENAME_HOLDING_HISTORY = "HOLDING_HISTORY";
    public static final String TABLENAME_WATCH_LIST = "WATCH_LIST";
    public static final String TABLENAME_WATCH_ITEM = "WATCH_ITEM";
    public static final String TABLENAME_CASH_TRANSACTION = "CASH_TRANSACTION";
    public static final String TABLENAME_CHARGE = "CHARGE";
    public static final String TABLENAME_COMMISSION_RATE = "COMMISSION_RATE";
    public static final String TABLENAME_TRADE_REQUEST = "TRADE_REQUEST";
    public static final Set<String> FIXED_TABLES = new HashSet<String>();
    public static final Set<String> SCALING_TABLES;
    public static final Set<String> GROWING_TABLES;
    public static final Map<String, TableType> TABLE_TYPES;
    public static final Map<String, String> MIXED_TABLES;

    public static TableType getTableType(String table_name) {
        return TABLE_TYPES.get(table_name);
    }

    static {
        FIXED_TABLES.add(TABLENAME_CHARGE);
        FIXED_TABLES.add(TABLENAME_COMMISSION_RATE);
        FIXED_TABLES.add(TABLENAME_EXCHANGE);
        FIXED_TABLES.add(TABLENAME_INDUSTRY);
        FIXED_TABLES.add(TABLENAME_SECTOR);
        FIXED_TABLES.add(TABLENAME_STATUS_TYPE);
        FIXED_TABLES.add(TABLENAME_TAXRATE);
        FIXED_TABLES.add(TABLENAME_TRADE_TYPE);
        FIXED_TABLES.add(TABLENAME_ZIP_CODE);
        SCALING_TABLES = new HashSet<String>();
        SCALING_TABLES.add(TABLENAME_ACCOUNT_PERMISSION);
        SCALING_TABLES.add(TABLENAME_ADDRESS);
        SCALING_TABLES.add(TABLENAME_COMPANY_COMPETITOR);
        SCALING_TABLES.add(TABLENAME_COMPANY);
        SCALING_TABLES.add(TABLENAME_CUSTOMER_ACCOUNT);
        SCALING_TABLES.add(TABLENAME_CUSTOMER_TAXRATE);
        SCALING_TABLES.add(TABLENAME_CUSTOMER);
        SCALING_TABLES.add(TABLENAME_DAILY_MARKET);
        SCALING_TABLES.add(TABLENAME_FINANCIAL);
        SCALING_TABLES.add(TABLENAME_LAST_TRADE);
        SCALING_TABLES.add(TABLENAME_NEWS_ITEM);
        SCALING_TABLES.add(TABLENAME_NEWS_XREF);
        SCALING_TABLES.add(TABLENAME_SECURITY);
        SCALING_TABLES.add(TABLENAME_WATCH_ITEM);
        SCALING_TABLES.add(TABLENAME_WATCH_LIST);
        GROWING_TABLES = new HashSet<String>();
        GROWING_TABLES.add(TABLENAME_BROKER);
        GROWING_TABLES.add(TABLENAME_CASH_TRANSACTION);
        GROWING_TABLES.add(TABLENAME_HOLDING_HISTORY);
        GROWING_TABLES.add(TABLENAME_HOLDING_SUMMARY);
        GROWING_TABLES.add(TABLENAME_HOLDING);
        GROWING_TABLES.add(TABLENAME_SETTLEMENT);
        GROWING_TABLES.add(TABLENAME_TRADE_HISTORY);
        GROWING_TABLES.add(TABLENAME_TRADE);
        TABLE_TYPES = new HashMap<String, TableType>();
        for (String table_name : FIXED_TABLES) {
            TABLE_TYPES.put(table_name, TableType.FIXED);
        }
        for (String table_name : SCALING_TABLES) {
            TABLE_TYPES.put(table_name, TableType.SCALING);
        }
        for (String table_name : GROWING_TABLES) {
            TABLE_TYPES.put(table_name, TableType.GROWING);
        }
        MIXED_TABLES = new HashMap<String, String>();
        MIXED_TABLES.put(TABLENAME_ACCOUNT_PERMISSION, TABLENAME_CUSTOMER_ACCOUNT);
    }

    public static enum eStatusTypeID {
        eCompleted(0),
        eActive(1),
        eSubmitted(2),
        ePending(3),
        eCanceled(4),
        eMaxStatusTypeID(5);

        private int index;

        private eStatusTypeID(int index) {
            this.index = index;
        }

        public int getVal() {
            return this.index;
        }
    }

    public static enum DriverType {
        eDriverEGenLoader(0),
        eDriverAll(1),
        eDriverCE(2),
        eDriverMEE(3),
        eDriverDM(4),
        eDriverMax(5);

        private int index;

        private DriverType(int index) {
            this.index = index;
        }

        public int getVal() {
            return this.index;
        }
    }

    public static enum eMEETradeRequestAction {
        eMEEProcessOrder(0),
        eMEESetLimitOrderTrigger(1);

        private int index;

        private eMEETradeRequestAction(int index) {
            this.index = index;
        }

        public int getVal() {
            return this.index;
        }
    }

    public static enum TableType {
        FIXED,
        SCALING,
        GROWING;

    }
}

