/*
 * Decompiled with CFR 0.152.
 */
package sql.tpce.tpcedef.generator;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import sql.tpce.TPCETest;
import sql.tpce.tpcedef.TPCETxnInput;
import sql.tpce.tpcedef.input.TradeOrderTxnInput;

public class CE {
    private static ArrayList<List<Struct>> caInfo = new ArrayList();
    private static List<Struct> companyInfo;
    private static HashMap<String, BigDecimal> lastTradeInfo;
    private static String selectCAInfoJoin;
    private static String selectSymbolInfo;
    private static String selectCompanyInfoJoin;
    private static String selectLastTradeInfo;
    private static Boolean infoSet;
    private static final String status_pending = "PNDG";
    private static Long lastTradeUpdatedTime;
    private static final BigDecimal zero;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaInfo(Connection conn) throws SQLException {
        ResultSet rs;
        Boolean bl = infoSet;
        synchronized (bl) {
            if (infoSet.booleanValue()) {
                return;
            }
            infoSet = true;
        }
        if (conn == null) {
            Log.getLogWriter().info("in ce, conn is " + conn);
        }
        PreparedStatement ps = conn.prepareStatement(selectCAInfoJoin);
        for (int i = 0; i < 3; ++i) {
            ps.setShort(1, (short)(i + 1));
            rs = ps.executeQuery();
            caInfo.add(ResultSetHelper.asList(rs, false));
            rs.close();
        }
        ps = conn.prepareStatement(selectCompanyInfoJoin);
        rs = ps.executeQuery();
        companyInfo = ResultSetHelper.asList(rs, false);
        rs.close();
        this.setLastTradeInfo(conn);
    }

    public long getLastTradeUpdatedTime() {
        return lastTradeUpdatedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastTradeInfo(Connection conn) throws SQLException {
        Long l = lastTradeUpdatedTime;
        synchronized (l) {
            Log.getLogWriter().info("in setLastTradeInfo, conn is " + conn);
            PreparedStatement ps = conn.prepareStatement(selectLastTradeInfo);
            ResultSet rs = ps.executeQuery();
            List<Struct> lastTrade = ResultSetHelper.asList(rs, false);
            rs.close();
            for (Struct ltStruct : lastTrade) {
                lastTradeInfo.put((String)ltStruct.get("lt_s_symb".toUpperCase()), (BigDecimal)ltStruct.get("lt_price".toUpperCase()));
            }
            lastTradeUpdatedTime = System.currentTimeMillis();
            Log.getLogWriter().info("lastTradeUpdatedTime is " + lastTradeUpdatedTime);
        }
    }

    private static int getTier() {
        int max = 10;
        int num = TPCETest.rand.nextInt(max);
        if (num < 1) {
            return 0;
        }
        if (num < 4) {
            return 1;
        }
        return 2;
    }

    public TPCETxnInput getTradeOrderTxn() {
        TradeOrderTxnInput toInput = new TradeOrderTxnInput();
        int tier = CE.getTier();
        int index = TPCETest.rand.nextInt(caInfo.get(tier).size());
        GFXDStructImpl caInfoStruct = (GFXDStructImpl)caInfo.get(tier).get(index);
        toInput.setAcctId((Long)caInfoStruct.get("ca_id".toUpperCase()));
        toInput.setExecFirstName((String)caInfoStruct.get("ap_f_name".toUpperCase()));
        toInput.setExecLastName((String)caInfoStruct.get("ap_l_name".toUpperCase()));
        toInput.setExecTaxId((String)caInfoStruct.get("ap_tax_id".toUpperCase()));
        int symbolIndex = TPCETest.rand.nextInt(companyInfo.size());
        GFXDStructImpl companyStruct = (GFXDStructImpl)companyInfo.get(symbolIndex);
        String symbol = (String)companyStruct.get("s_symb".toUpperCase());
        String issue = (String)companyStruct.get("s_issue".toUpperCase());
        String co_name = (String)companyStruct.get("co_name".toUpperCase());
        if (TPCETest.rand.nextBoolean()) {
            toInput.setSymbol(symbol);
        } else {
            toInput.setIssue(issue);
            toInput.setCoName(co_name);
            toInput.setSymbol(" ");
        }
        int total = 30;
        if (TPCETest.rand.nextInt(total) == 1) {
            toInput.setRollItBack(1L);
        } else {
            toInput.setRollItBack(0L);
        }
        total = 5;
        if (TPCETest.rand.nextInt(total) == 1) {
            toInput.setIsLifo(1L);
        } else {
            toInput.setIsLifo(0L);
        }
        total = 20;
        int hand = 100;
        int qty = (TPCETest.rand.nextInt(total) + 1) * hand;
        if (TPCETest.rand.nextInt(total) == 1) {
            qty += TPCETest.rand.nextInt(hand);
        }
        toInput.setTradeQty(qty);
        int hundred = 100;
        int whichOne = TPCETest.rand.nextInt(hundred);
        BigDecimal curPrice = lastTradeInfo.get(symbol);
        if (whichOne % 2 == 0) {
            if (whichOne < hundred / 2) {
                toInput.setTradeTypeId("TMS");
            } else {
                toInput.setTradeTypeId("TMB");
            }
            toInput.setStSubmittedId("SBMT");
        } else {
            if (whichOne < 6) {
                toInput.setTradeTypeId("TSL");
                toInput.setRequestedPrice(this.getLowerOrEqualPrice(curPrice));
            } else if (whichOne < hundred / 2) {
                toInput.setTradeTypeId("TLS");
                toInput.setRequestedPrice(this.getHigherOrEqualPrice(curPrice));
            } else {
                toInput.setTradeTypeId("TLB");
                toInput.setRequestedPrice(this.getLowerOrEqualPrice(curPrice));
            }
            toInput.setStPendingId(status_pending);
        }
        if (TPCETest.logDML) {
            Log.getLogWriter().info("gets toInput as: " + toInput.toString());
        }
        return toInput;
    }

    private BigDecimal getLowerOrEqualPrice(BigDecimal price) {
        price.subtract(this.getRandomChange());
        if (price.compareTo(zero) == -1) {
            return new BigDecimal("0.01");
        }
        return price;
    }

    private BigDecimal getHigherOrEqualPrice(BigDecimal price) {
        return price.add(this.getRandomChange());
    }

    private BigDecimal getRandomChange() {
        int max = 100;
        double change = (double)TPCETest.rand.nextInt(max) * 0.01;
        return new BigDecimal(Double.toString(change));
    }

    static {
        lastTradeInfo = new HashMap();
        selectCAInfoJoin = "select ca_id, ca_c_id, ap_ca_id, ap_l_name, ap_f_name, ap_tax_id, c_id, c_tier from customer_account, account_permission, customer where ca_id = ap_ca_id and ca_c_id = c_id and c_tier = ?";
        selectSymbolInfo = "select s_symb, s_issue from security";
        selectCompanyInfoJoin = "select s_symb, s_issue, co_name from security, company where s_co_id = co_id";
        selectLastTradeInfo = "select lt_s_symb, lt_price from last_trade";
        infoSet = false;
        lastTradeUpdatedTime = System.currentTimeMillis();
        zero = new BigDecimal("0.00");
    }
}

