/*
 * Decompiled with CFR 0.152.
 */
package sql.tpce.tpcedef.generator;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import sql.SQLHelper;
import sql.tpce.TPCEBB;
import sql.tpce.TPCETest;
import sql.tpce.entity.TradeInfo;
import sql.tpce.tpcedef.TPCETxnInput;
import sql.tpce.tpcedef.generator.ProcessedOrderQty;
import sql.tpce.tpcedef.input.MarketFeedTxnInput;
import sql.tpce.tpcedef.input.TradeResultTxnInput;
import util.TestException;

public class MEE {
    private static boolean tradeToMarketWithDefaultId = TPCETest.tradeToMarketWithDefaultId;
    private static String insertTradeMarket = "insert into TRADE_Market ( TM_S_SYMB, TM_T_ID, TM_T_QTY, TM_T_BID_PRICE, TM_TT_ID, TM_STATUS, TM_ID) values (?, ?, ?, ?, ?, 0, default)";
    private static String insertTradeMarketWithoutDefaultId = "insert into TRADE_Market (TM_S_SYMB, TM_T_ID, TM_T_QTY, TM_T_BID_PRICE, TM_TT_ID, TM_STATUS, TM_ID) values (?, ?, ?, ?, ?, 0, ?)";
    private static String selectTradeMarket = " select * from Trade_market where TM_status = 1 fetch first 10 rows only order by TM_ID for update";
    private static String selectTradeMarketWithHDFS = "select * from Trade_market order by TM_ID fetch first 10 rows only for update";
    private static String selectTradeMarketWithoutDefaultId = " select * from TRADE_Market where tm_id = ?";
    private static BigDecimal[] randomChange = new BigDecimal[]{new BigDecimal("0.01"), new BigDecimal("0.02"), new BigDecimal("0.03"), new BigDecimal("0.04"), new BigDecimal("0.05")};
    public static final int mfCapacity = 10000;
    public static final int trCapacity = 100000;
    private static ArrayBlockingQueue<MarketFeedTxnInput> mfTxnInputsQueue = new ArrayBlockingQueue(10000);
    private static ArrayBlockingQueue<TradeResultTxnInput> trTxnInputsQueue = new ArrayBlockingQueue(100000);
    private static HashMap<String, ProcessedOrderQty> trackQtyForSymbol = new HashMap();

    public void submitTradeToMarket(Connection conn, ArrayList<TradeInfo> tradeRequest) throws SQLException {
        ArrayList<Long> tm_ids = new ArrayList<Long>();
        this.getTMIdsToInsert(tm_ids, tradeRequest.size());
        boolean retry = true;
        while (retry) {
            try {
                this.submitTradeToMarket(conn, tradeRequest, tm_ids);
                conn.commit();
                if (TPCETest.logDML) {
                    Log.getLogWriter().info("committed insert to trade_market");
                }
                retry = false;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public void submitTradeToMarket(Connection conn, ArrayList<TradeInfo> tradeRequest, ArrayList<Long> tm_ids) throws SQLException {
        int[] counts;
        String insert = tradeToMarketWithDefaultId ? insertTradeMarket : insertTradeMarketWithoutDefaultId;
        PreparedStatement ps = conn.prepareStatement(insert);
        for (int i = 0; i < tradeRequest.size(); ++i) {
            ps.setString(1, tradeRequest.get(i).getSymbol());
            ps.setLong(2, tradeRequest.get(i).getTradeId());
            ps.setInt(3, tradeRequest.get(i).getTradeQty());
            ps.setBigDecimal(4, tradeRequest.get(i).getPriceQuote());
            ps.setString(5, tradeRequest.get(i).getTradeType());
            if (!tradeToMarketWithDefaultId) {
                ps.setLong(6, tm_ids.get(i));
            }
            if (TPCETest.logDML) {
                Log.getLogWriter().info(insert + " in batch TM_S_SYMB: " + tradeRequest.get(i).getSymbol() + " TM_T_ID:" + tradeRequest.get(i).getTradeId() + " TM_T_QTY: " + tradeRequest.get(i).getTradeQty() + " TM_T_BID_PRICE: " + tradeRequest.get(i).getPriceQuote() + " T_TT_ID: " + tradeRequest.get(i).getTradeType() + (tradeToMarketWithDefaultId ? "" : " and TM_ID: " + tm_ids.get(i)));
            }
            ps.addBatch();
        }
        for (int count : counts = ps.executeBatch()) {
            if (count == 1) continue;
            throw new TestException(insert + " failed insert all rows");
        }
    }

    protected void getTMIdsToInsert(ArrayList<Long> list, int size) {
        long lastId = TPCEBB.getBB().getSharedCounters().add(TPCEBB.tradeSentToMarket, (long)size);
        for (int i = 1; i <= size; ++i) {
            list.add(lastId - (long)(size - i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTradesSubmitted(Connection conn) throws SQLException {
        ArrayList<Long> tm_ids = new ArrayList<Long>();
        int size = 10;
        if (!tradeToMarketWithDefaultId) {
            this.getTMIdsToProcess(tm_ids, size);
        }
        boolean retry = true;
        HashMap<String, ArrayList<TradeInfo>> processedTrades = null;
        ArrayList<TradeResultTxnInput> trTxnInputs = null;
        ArrayList<String> processedSymbols = null;
        while (retry) {
            try {
                processedTrades = new HashMap<String, ArrayList<TradeInfo>>();
                trTxnInputs = new ArrayList<TradeResultTxnInput>();
                processedSymbols = new ArrayList<String>();
                this.generateTrTxnInputs(conn, tm_ids, processedTrades, trTxnInputs, processedSymbols);
                retry = false;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        MarketFeedTxnInput mfTxnInput = this.getMfTxnInputs(processedTrades, processedSymbols);
        if (mfTxnInput == null || trTxnInputs == null || processedSymbols == null) {
            throw new TestException("TxnInputs should not be null at this time");
        }
        ArrayBlockingQueue<TPCETxnInput> arrayBlockingQueue = mfTxnInputsQueue;
        synchronized (arrayBlockingQueue) {
            mfTxnInputsQueue.add(mfTxnInput);
        }
        arrayBlockingQueue = trTxnInputsQueue;
        synchronized (arrayBlockingQueue) {
            trTxnInputsQueue.addAll(trTxnInputs);
        }
    }

    protected void getTMIdsToProcess(ArrayList<Long> list, int size) {
        long lastIdToProcess = TPCEBB.getBB().getSharedCounters().add(TPCEBB.tradeProcessedByMarket, (long)size);
        long lastIdAvail = TPCEBB.getBB().getSharedCounters().read(TPCEBB.tradeSentToMarket);
        while (lastIdAvail < lastIdToProcess) {
            lastIdAvail = TPCEBB.getBB().getSharedCounters().read(TPCEBB.tradeSentToMarket);
        }
        for (int i = 1; i <= size; ++i) {
            list.add(lastIdToProcess - (long)(size - i));
        }
    }

    public void generateTrTxnInputs(Connection conn, ArrayList<Long> tm_ids, HashMap<String, ArrayList<TradeInfo>> processedTrades, ArrayList<TradeResultTxnInput> trTxnInputs, ArrayList<String> processedSymbols) throws SQLException {
        if (tradeToMarketWithDefaultId) {
            this.generateTrTxnInputsWithDefaultId(conn);
            return;
        }
        this.generateTrTxnInputs(conn, trTxnInputs, tm_ids, processedTrades, processedSymbols);
    }

    protected void generateTrTxnInputsWithDefaultId(Connection conn) throws SQLException {
        throw new TestException("Not ready for testing default id in Trade_Market table as order by with for update is not supported in gfxd yet");
    }

    protected void generateTrTxnInputs(Connection conn, ArrayList<TradeResultTxnInput> trTxnInputs, ArrayList<Long> ids, HashMap<String, ArrayList<TradeInfo>> processedTrades, ArrayList<String> processedSymbols) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(selectTradeMarketWithoutDefaultId);
        for (long id : ids) {
            TradeResultTxnInput trTxnInput = this.getTrTxnInput(ps, id, processedTrades, processedSymbols);
            trTxnInputs.add(trTxnInput);
        }
    }

    protected TradeResultTxnInput getTrTxnInput(PreparedStatement ps, long id, HashMap<String, ArrayList<TradeInfo>> processedTrades, ArrayList<String> processedSymbols) throws SQLException {
        String trade_type;
        BigDecimal price;
        int trade_qty;
        String symbol;
        long trade_id;
        TradeResultTxnInput trTxnInput = new TradeResultTxnInput();
        ps.setLong(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            trade_id = rs.getLong("TM_T_ID");
            symbol = rs.getString("TM_S_SYMB");
            trade_qty = rs.getInt("TM_T_QTY");
            price = rs.getBigDecimal("TM_T_BID_PRICE");
            trade_type = rs.getString("TM_TT_ID");
            short tm_status = rs.getShort("TM_STATUS");
            if (tm_status != 0) {
                throw new TestException(selectTradeMarketWithoutDefaultId + " returns the row with " + "TM_STATUS: " + tm_status);
            }
        } else {
            throw new TestException(selectTradeMarketWithoutDefaultId + " does not get result for " + "TM_ID: " + id);
        }
        rs.close();
        TradeInfo trade = new TradeInfo();
        BigDecimal price_quote = this.getPrice(trade_type, price, symbol);
        trTxnInput.setTradeID(trade_id);
        trTxnInput.setTradePrice(price_quote);
        trade.setPriceQuotes(price_quote);
        trade.setSymbol(symbol);
        trade.setTradeId(trade_id);
        trade.setTradeQty(trade_qty);
        trade.setTradeType(trade_type);
        ArrayList<TradeInfo> trades = processedTrades.get(symbol);
        if (trades == null) {
            trades = new ArrayList();
            processedSymbols.add(symbol);
        }
        trades.add(trade);
        processedTrades.put(symbol, trades);
        return trTxnInput;
    }

    protected MarketFeedTxnInput getMfTxnInputs(HashMap<String, ArrayList<TradeInfo>> processedTrades, ArrayList<String> processedSymbols) {
        MarketFeedTxnInput mfTxnInput = new MarketFeedTxnInput();
        mfTxnInput.setLimitBuy("TLB");
        mfTxnInput.setLimitSell("TLS");
        mfTxnInput.setStatusSubmitted("SBMT");
        mfTxnInput.setStopLoss("TSL");
        int size = processedTrades.size();
        String[] symbols = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        int[] qty = new int[size];
        for (int i = 0; i < size; ++i) {
            String symbol = processedSymbols.get(i);
            ArrayList<TradeInfo> trades = processedTrades.get(symbol);
            symbols[i] = symbol;
            this.getInfo(i, symbol, trades, price, qty);
        }
        mfTxnInput.setPriceQuotes(price);
        mfTxnInput.setSymbol(symbols);
        mfTxnInput.setTradeQty(qty);
        return mfTxnInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInfo(int i, String symbol, ArrayList<TradeInfo> trades, BigDecimal[] price, int[] qty) {
        int buy_qty = 0;
        int sell_qty = 0;
        int other_buy_qty = 0;
        int other_sell_qty = 0;
        BigDecimal trade_price = null;
        for (TradeInfo trade : trades) {
            String trade_type = trade.getTradeType();
            if (trade_type.equals("TLB") || trade_type.equals("TMB")) {
                buy_qty += trade.getTradeQty();
            } else {
                sell_qty += trade.getTradeQty();
            }
            trade_price = this.getPrice(trade_type, trade.getPriceQuote(), symbol);
        }
        int max = 20;
        if (TPCETest.rand.nextBoolean()) {
            other_buy_qty = TPCETest.rand.nextInt(max) * 100;
        } else {
            other_sell_qty = TPCETest.rand.nextInt(max) * 100;
        }
        price[i] = trade_price;
        qty[i] = buy_qty + sell_qty + other_buy_qty + other_sell_qty;
        HashMap<String, ProcessedOrderQty> hashMap = trackQtyForSymbol;
        synchronized (hashMap) {
            ProcessedOrderQty poq = trackQtyForSymbol.get(symbol);
            if (poq == null) {
                poq = new ProcessedOrderQty();
            }
            poq.addBuyQty(buy_qty);
            poq.addSellQty(sell_qty);
            poq.addOtherBuyQty(other_buy_qty);
            poq.addOtherSellQty(other_sell_qty);
            trackQtyForSymbol.put(symbol, poq);
        }
    }

    private BigDecimal getPrice(String trade_type, BigDecimal price, String symbol) {
        boolean isUp;
        long buy_qty = trackQtyForSymbol.get(symbol) != null ? trackQtyForSymbol.get(symbol).getBuyQty() + trackQtyForSymbol.get(symbol).getOtherBuyQty() : 0L;
        long sell_qty = trackQtyForSymbol.get(symbol) != null ? trackQtyForSymbol.get(symbol).getSellQty() + trackQtyForSymbol.get(symbol).getOtherSellQty() : 0L;
        boolean bl = isUp = buy_qty > sell_qty;
        if (trade_type.equals("TLB") || trade_type.equals("TSL")) {
            if (isUp) {
                return price;
            }
            return this.getLowerOrEqualPrice(price);
        }
        if (trade_type.equals("TLS")) {
            if (isUp) {
                return this.getHigherOrEqualPrice(price);
            }
            return price;
        }
        if (trade_type.equals("TMB") || trade_type.equals("TMS")) {
            if (isUp) {
                return this.getHigherOrEqualPrice(price);
            }
            return this.getLowerOrEqualPrice(price);
        }
        throw new TestException("Got unknown trade type " + trade_type);
    }

    private BigDecimal getLowerOrEqualPrice(BigDecimal price) {
        if (TPCETest.rand.nextBoolean()) {
            return price;
        }
        BigDecimal change = this.getChange(price);
        if (price.compareTo(change) == -1) {
            return price;
        }
        return price.subtract(change);
    }

    private BigDecimal getHigherOrEqualPrice(BigDecimal price) {
        if (TPCETest.rand.nextBoolean()) {
            return price;
        }
        BigDecimal change = this.getChange(price);
        return price.add(change);
    }

    private BigDecimal getChange(BigDecimal price) {
        if (price.compareTo(new BigDecimal("1.00")) == -1) {
            return this.getRandomChange(1);
        }
        if (price.compareTo(new BigDecimal("10.00")) == -1) {
            return this.getRandomChange(2);
        }
        if (price.compareTo(new BigDecimal("25.00")) == -1) {
            return this.getRandomChange(3);
        }
        if (price.compareTo(new BigDecimal("50.00")) == -1) {
            return this.getRandomChange(4);
        }
        return this.getRandomChange(5);
    }

    private BigDecimal getRandomChange(int num) {
        return randomChange[TPCETest.rand.nextInt(num)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarketFeedTxnInput getMfTxnInput() throws InterruptedException {
        MarketFeedTxnInput mfTxnInput = null;
        ArrayBlockingQueue<MarketFeedTxnInput> arrayBlockingQueue = mfTxnInputsQueue;
        synchronized (arrayBlockingQueue) {
            mfTxnInput = mfTxnInputsQueue.take();
        }
        return mfTxnInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradeResultTxnInput getTrTxnInput() throws InterruptedException {
        TradeResultTxnInput trTxnInput = null;
        ArrayBlockingQueue<TradeResultTxnInput> arrayBlockingQueue = trTxnInputsQueue;
        synchronized (arrayBlockingQueue) {
            trTxnInput = trTxnInputsQueue.take();
        }
        return trTxnInput;
    }

    public int getMfTxnInputQueueSize() {
        return mfTxnInputsQueue.size();
    }

    public int getTrTxnInputQueueSize() {
        return trTxnInputsQueue.size();
    }
}

