/*
 * Decompiled with CFR 0.152.
 */
package sql.tpce.tpcetxn;

import hydra.Log;
import hydra.RemoteTestModule;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import sql.SQLHelper;
import sql.tpce.entity.Broker;
import sql.tpce.entity.Customer;
import sql.tpce.entity.CustomerAccount;
import sql.tpce.entity.TradeInfo;
import sql.tpce.tpcedef.TPCETxnInput;
import sql.tpce.tpcedef.TPCETxnOutput;
import sql.tpce.tpcedef.generator.MEE;
import sql.tpce.tpcedef.input.TradeOrderTxnInput;
import sql.tpce.tpcedef.output.TradeOrderTxnOutput;
import sql.tpce.tpcetxn.TPCETransaction;
import util.TestException;

public class TPCETradeOrder
extends TPCETransaction {
    protected TradeOrderTxnInput toTxnInput = null;
    protected TradeOrderTxnOutput toTxnOutput = null;
    protected Customer customer = null;
    protected CustomerAccount customerAccount = null;
    protected Broker broker = null;
    protected Connection conn = null;
    BigDecimal commissionRate = null;
    BigDecimal chargeAmount = null;
    String statusId = null;
    String securitySymbol = null;
    BigDecimal requestedPrice = new BigDecimal("0.00");
    short ttIsMrkt = (short)-1;
    long tradeId = 0L;
    private static final String selectCustomerAccount = "select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ?";
    private static final String selectCustomer = " select C_F_NAME, C_L_NAME, C_TIER, C_TAX_ID from CUSTOMER where C_ID = ?";
    private static final String selectBroker = "select B_NAME from BROKER where B_ID = ?";
    private static final String selectAccountPermission = "select AP_ACL from ACCOUNT_PERMISSION where AP_CA_ID = ? and AP_F_NAME = ? and AP_L_NAME = ? and AP_TAX_ID = ?";
    private static final String selectCoId = "select CO_ID from COMPANY where CO_NAME = ?";
    private static final String selectSecurity = "select S_EX_ID, S_NAME, S_SYMB from SECURITY where S_CO_ID = ? and S_ISSUE = ?";
    private static final String selectCoIdWithSymb = "select s_co_id, s_ex_id, s_name from security where s_symb = ?";
    private static final String selectCoName = "select CO_NAME from COMPANY where CO_ID = ?";
    private static final String selectLTPrice = "select lt_price from last_trade where lt_s_symb = ?";
    private static final String selectTType = "select tt_is_mrkt, tt_is_sell from trade_type where tt_id = ?";
    private static final String selectHoldingSummary = "select hs_qty from holding_summary where hs_ca_id = ? and hs_s_symb =?";
    private static final String selectHoldingDesc = "select H_QTY, H_PRICE from HOLDING where H_CA_ID = ? and H_S_SYMB = ? order by H_DTS desc";
    private static final String selectHoldingAsc = "select H_QTY, H_PRICE from HOLDING where H_CA_ID = ? and H_S_SYMB = ? order by H_DTS asc";
    private static final String selectTaxRate = "select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?)";
    private static final String selectCommRate = "select cr_rate from commission_rate where cr_c_tier = ? and cr_tt_id = ? and cr_ex_id = ? and cr_from_qty <= ? and cr_to_qty >= ?";
    private static final String selectCharge = "select ch_chrg from charge where ch_c_tier = ? and ch_tt_id = ?";
    private static final String selectAccountBal = "select CA_BAL from CUSTOMER_ACCOUNT where CA_ID = ?";
    private static final String selectHoldingAsset = "select sum(hs_qty * lt_price) from holding_summary, last_trade where hs_ca_id = ? and lt_s_symb = hs_s_symb";
    private static final String insertTrade = "insert into TRADE (T_ID, T_CA_ID, T_S_SYMB, T_ST_ID, T_BID_PRICE, T_CHRG, T_COMM, T_DTS, T_EXEC_NAME, T_IS_CASH, T_LIFO, T_QTY, T_TAX, T_TRADE_PRICE, T_TT_ID) values (default, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String insertTradeRequest = "insert into TRADE_REQUEST (TR_T_ID, TR_TT_ID, TR_S_SYMB, TR_QTY, TR_BID_PRICE, TR_CA_ID, TR_B_ID) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String insertTradeHistory = "insert into TRADE_HISTORY(TH_T_ID, TH_DTS, TH_ST_ID) values (?, ?, ?)";
    private static final String CONFLICTEXCEPTION = "X0Z02";

    @Override
    public TPCETxnOutput runTxn(TPCETxnInput txnInput, Connection conn) throws SQLException {
        this.toTxnInput = (TradeOrderTxnInput)txnInput;
        this.toTxnOutput = new TradeOrderTxnOutput();
        this.conn = conn;
        MEE mee = new MEE();
        try {
            this.invokeFrame1();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (!(this.toTxnInput.getExecLastName().equalsIgnoreCase(this.customer.getCLName()) && this.toTxnInput.getExecFirstName().equalsIgnoreCase(this.customer.getCFName()) && this.toTxnInput.getExecTaxId().equalsIgnoreCase(this.customer.getCTaxId()))) {
            try {
                this.invokeFrame2();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        try {
            this.invokeFrame3();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        try {
            this.invokeFrame4();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals(CONFLICTEXCEPTION)) {
                throw se;
            }
            SQLHelper.handleSQLException(se);
        }
        try {
            this.invokeFrame5();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        try {
            this.invokeFrame6(mee);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return this.toTxnOutput;
    }

    protected void invokeFrame1() throws SQLException {
        long ca_c_id;
        long ca_b_id;
        PreparedStatement ps = this.conn.prepareStatement(selectCustomerAccount);
        ps.setLong(1, this.toTxnInput.getAcctId());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            this.customerAccount = new CustomerAccount();
            this.customerAccount.setCaName(rs.getString("CA_NAME"));
            ca_b_id = rs.getInt("CA_B_ID");
            ca_c_id = rs.getInt("CA_C_ID");
            this.customerAccount.setCaTaxSt(rs.getShort("CA_TAX_ST"));
            this.customerAccount.setCaId(this.toTxnInput.getAcctId());
            if (logDML) {
                Log.getLogWriter().info("select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ? gets CA_NAME: " + this.customerAccount.getCaName() + " CA_B_ID:" + ca_b_id + " CA_C_ID: " + ca_c_id + " CA_TAX_ST: " + this.customerAccount.getCaTaxSt() + " for CA_ID = " + this.toTxnInput.getAcctId());
            }
            if (rs.next()) {
                this.toTxnOutput.setStatus(-711);
                if (logDML) {
                    Log.getLogWriter().info("select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ? gets CA_NAME: " + this.customerAccount.getCaName() + " CA_B_ID:" + ca_b_id + " CA_C_ID: " + ca_c_id + " CA_TAX_ST: " + this.customerAccount.getCaTaxSt() + " for CA_ID = " + this.toTxnInput.getAcctId());
                }
                throw new TestException("select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ? has more than 1 row in result set for CA_ID = " + this.toTxnInput.getAcctId());
            }
        } else {
            this.toTxnOutput.setStatus(-711);
            throw new TestException("select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ? does not get single row in result set for CA_ID = " + this.toTxnInput.getAcctId());
        }
        rs.close();
        this.getBroker(ca_b_id);
        this.customerAccount.setBroker(this.broker);
        this.getCustomer(ca_c_id);
        this.customerAccount.setCustomer(this.customer);
    }

    protected void getBroker(long b_id) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(selectBroker);
        ps.setLong(1, b_id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            this.broker = new Broker();
            this.broker.setBName(rs.getString("B_NAME"));
            this.broker.setBId(b_id);
            if (logDML) {
                Log.getLogWriter().info("select B_NAME from BROKER where B_ID = ? gets B_NAME: " + this.broker.getBName() + " for B_ID = " + b_id);
            }
            if (rs.next()) {
                if (logDML) {
                    Log.getLogWriter().info("select B_NAME from BROKER where B_ID = ? gets B_NAME: " + this.broker.getBName() + " for B_ID = " + b_id);
                }
                throw new TestException("select B_NAME from BROKER where B_ID = ? has more than 1 row in result set for B_ID = " + b_id);
            }
        } else {
            throw new TestException("select B_NAME from BROKER where B_ID = ? does not get single row in result set for B_ID = " + b_id);
        }
        rs.close();
    }

    protected void getCustomer(long c_id) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(selectCustomer);
        ps.setLong(1, c_id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            this.customer = new Customer();
            this.customer.setCFName(rs.getString("C_F_NAME"));
            this.customer.setCLName(rs.getString("C_L_NAME"));
            this.customer.setCTier(rs.getShort("C_TIER"));
            this.customer.setCTaxId(rs.getString("C_TAX_ID"));
            this.customer.setCId(c_id);
            if (logDML) {
                Log.getLogWriter().info(" select C_F_NAME, C_L_NAME, C_TIER, C_TAX_ID from CUSTOMER where C_ID = ? gets C_F_NAME: " + this.customer.getCFName() + " C_L_NAME:" + this.customer.getCLName() + " C_TIER: " + this.customer.getCTier() + " C_TAX_ID: " + this.customer.getCTaxId() + " for C_ID = " + c_id);
            }
            if (rs.next()) {
                if (logDML) {
                    Log.getLogWriter().info(" select C_F_NAME, C_L_NAME, C_TIER, C_TAX_ID from CUSTOMER where C_ID = ? gets C_F_NAME: " + this.customer.getCFName() + " C_L_NAME:" + this.customer.getCLName() + " C_TIER: " + this.customer.getCTier() + " C_TAX_ID: " + this.customer.getCTaxId() + " for C_ID = " + c_id);
                }
                throw new TestException(" select C_F_NAME, C_L_NAME, C_TIER, C_TAX_ID from CUSTOMER where C_ID = ? has more than 1 row in result set for C_ID = " + c_id);
            }
        } else {
            throw new TestException(" select C_F_NAME, C_L_NAME, C_TIER, C_TAX_ID from CUSTOMER where C_ID = ? does not get single row in result set for C_ID = " + c_id);
        }
        rs.close();
    }

    protected void invokeFrame2() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(selectAccountPermission);
        ps.setLong(1, this.toTxnInput.getAcctId());
        ps.setString(2, this.toTxnInput.getExecFirstName());
        ps.setString(3, this.toTxnInput.getExecLastName());
        ps.setString(4, this.toTxnInput.getExecTaxId());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            if (logDML) {
                Log.getLogWriter().info("select AP_ACL from ACCOUNT_PERMISSION where AP_CA_ID = ? and AP_F_NAME = ? and AP_L_NAME = ? and AP_TAX_ID = ?got account permission for  AP_CA_ID = " + this.toTxnInput.getAcctId() + " AP_F_NAME = " + this.toTxnInput.getExecFirstName() + " AP_L_NAME = " + this.toTxnInput.getExecLastName() + " AP_TAX_ID = " + this.toTxnInput.getExecTaxId());
            }
        } else {
            this.toTxnOutput.setStatus(-721);
            throw new TestException(" No account permission was found: select AP_ACL from ACCOUNT_PERMISSION where AP_CA_ID = ? and AP_F_NAME = ? and AP_L_NAME = ? and AP_TAX_ID = ? does not get single row in result set for AP_CA_ID = " + this.toTxnInput.getAcctId() + " and AP_F_NAME = " + this.toTxnInput.getExecFirstName() + " and AP_L_NAME = " + this.toTxnInput.getExecLastName() + " and AP_TAX_ID = " + this.toTxnInput.getExecTaxId());
        }
        rs.close();
    }

    protected void invokeFrame3() throws SQLException {
        long companyId = -1L;
        String companyName = this.toTxnInput.getCoName();
        this.securitySymbol = this.toTxnInput.getSymbol().trim();
        String exchangeId = null;
        String securityName = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        BigDecimal marketPrice = null;
        if (this.securitySymbol.isEmpty()) {
            ps = this.conn.prepareStatement(selectCoId);
            ps.setString(1, companyName);
            rs = ps.executeQuery();
            if (rs.next()) {
                companyId = rs.getLong("CO_ID");
                if (rs.next()) {
                    throw new TestException("select CO_ID from COMPANY where CO_NAME = ? has more than 1 row in result set for CO_NAME = " + companyName);
                }
            } else {
                throw new TestException("select CO_ID from COMPANY where CO_NAME = ? does not get single row in result set for CO_NAME = " + companyName);
            }
            rs.close();
            ps = this.conn.prepareStatement(selectSecurity);
            ps.setLong(1, companyId);
            ps.setString(2, this.toTxnInput.getIssue());
            rs = ps.executeQuery();
            if (rs.next()) {
                exchangeId = rs.getString("S_EX_ID");
                securityName = rs.getString("S_NAME");
                this.securitySymbol = rs.getString("S_SYMB");
                if (rs.next()) {
                    throw new TestException("select S_EX_ID, S_NAME, S_SYMB from SECURITY where S_CO_ID = ? and S_ISSUE = ? has more than 1 row in result set for CO_ID = " + companyId + " and S_ISSUE " + this.toTxnInput.getIssue());
                }
            } else {
                throw new TestException("select S_EX_ID, S_NAME, S_SYMB from SECURITY where S_CO_ID = ? and S_ISSUE = ? does not get single row in result set for CO_ID = " + companyId + " and S_ISSUE " + this.toTxnInput.getIssue());
            }
            rs.close();
        } else {
            ps = this.conn.prepareStatement(selectCoIdWithSymb);
            ps.setString(1, this.securitySymbol);
            rs = ps.executeQuery();
            if (rs.next()) {
                companyId = rs.getLong("s_co_id");
                exchangeId = rs.getString("S_EX_ID");
                securityName = rs.getString("S_NAME");
                if (rs.next()) {
                    throw new TestException("select s_co_id, s_ex_id, s_name from security where s_symb = ? has more than 1 row in result set for symb = " + this.securitySymbol);
                }
            } else {
                throw new TestException("select s_co_id, s_ex_id, s_name from security where s_symb = ? does not get single row in result set for symb = " + this.securitySymbol);
            }
            rs.close();
            ps = this.conn.prepareStatement(selectCoName);
            ps.setLong(1, companyId);
            rs = ps.executeQuery();
            if (rs.next()) {
                companyName = rs.getString("CO_NAME");
                if (rs.next()) {
                    throw new TestException("select CO_NAME from COMPANY where CO_ID = ? has more than 1 row in result set for CO_ID = " + companyId);
                }
            } else {
                throw new TestException("select CO_NAME from COMPANY where CO_ID = ? does not get single row in result set for CO_ID = " + companyId);
            }
            rs.close();
        }
        ps = this.conn.prepareStatement(selectLTPrice);
        ps.setString(1, this.securitySymbol);
        rs = ps.executeQuery();
        if (rs.next()) {
            marketPrice = rs.getBigDecimal("LT_PRICE");
            if (rs.next()) {
                throw new TestException("select lt_price from last_trade where lt_s_symb = ? has more than 1 row in result set for symb = " + this.securitySymbol);
            }
        } else {
            throw new TestException("select lt_price from last_trade where lt_s_symb = ? does not get single row in result set for symb = " + this.securitySymbol);
        }
        rs.close();
        ps = this.conn.prepareStatement(selectTType);
        ps.setString(1, this.toTxnInput.getTradeTypeId());
        rs = ps.executeQuery();
        int ttIsSell = -1;
        if (rs.next()) {
            this.ttIsMrkt = rs.getShort("tt_is_mrkt");
            ttIsSell = rs.getShort("tt_is_sell");
            if (rs.next()) {
                throw new TestException("select tt_is_mrkt, tt_is_sell from trade_type where tt_id = ? has more than 1 row in result set for TT_ID = " + this.toTxnInput.getTradeTypeId());
            }
        } else {
            throw new TestException("select tt_is_mrkt, tt_is_sell from trade_type where tt_id = ? does not get single row in result set for TT_ID = " + this.toTxnInput.getTradeTypeId());
        }
        rs.close();
        this.requestedPrice = this.ttIsMrkt == 1 ? marketPrice : this.toTxnInput.getRequestedPrice();
        int hsQty = 0;
        ps = this.conn.prepareStatement(selectHoldingSummary);
        ps.setLong(1, this.customerAccount.getCaId());
        ps.setString(2, this.securitySymbol);
        rs = ps.executeQuery();
        if (rs.next()) {
            hsQty = rs.getInt("hs_qty");
            if (rs.next()) {
                throw new TestException("select hs_qty from holding_summary where hs_ca_id = ? and hs_s_symb =? has more than 1 row in result set for hs_ca_id = " + this.customerAccount.getCaId() + " and hs_s_symb = " + this.securitySymbol);
            }
        } else {
            hsQty = 0;
            if (logDML) {
                Log.getLogWriter().info("select hs_qty from holding_summary where hs_ca_id = ? and hs_s_symb =? does not get any row for hs_ca_id = " + this.customerAccount.getCaId() + " and hs_s_symb = " + this.securitySymbol);
            }
        }
        rs.close();
        BigDecimal buyValue = new BigDecimal("0.00");
        BigDecimal sellValue = new BigDecimal("0.00");
        long neededQty = this.toTxnInput.getTradeQty();
        int holdQty = 0;
        BigDecimal holdPrice = null;
        String select = null;
        select = this.toTxnInput.getIsLifo() == 1L ? selectHoldingDesc : selectHoldingAsc;
        ps = this.conn.prepareStatement(select);
        ps.setLong(1, this.customerAccount.getCaId());
        ps.setString(2, this.securitySymbol);
        rs = ps.executeQuery();
        if (ttIsSell == 1) {
            if (hsQty > 0) {
                while (rs.next() && neededQty == 0L) {
                    holdQty = rs.getInt("H_QTY");
                    holdPrice = rs.getBigDecimal("H_PRICE");
                    if ((long)holdQty > neededQty) {
                        buyValue = buyValue.add(holdPrice.multiply(new BigDecimal(String.valueOf(neededQty))));
                        sellValue = sellValue.add(this.requestedPrice.multiply(new BigDecimal(String.valueOf(neededQty))));
                        neededQty = 0L;
                        continue;
                    }
                    buyValue = buyValue.add(holdPrice.multiply(new BigDecimal(String.valueOf(holdQty))));
                    sellValue = sellValue.add(this.requestedPrice.multiply(new BigDecimal(String.valueOf(holdQty))));
                    neededQty -= (long)holdQty;
                }
                rs.close();
            }
        } else if (hsQty < 0) {
            while (rs.next() && neededQty == 0L) {
                holdQty = rs.getInt("H_QTY");
                holdPrice = rs.getBigDecimal("H_PRICE");
                if ((long)holdQty + neededQty < 0L) {
                    sellValue = sellValue.add(holdPrice.multiply(new BigDecimal(String.valueOf(neededQty))));
                    buyValue = buyValue.add(this.requestedPrice.multiply(new BigDecimal(String.valueOf(neededQty))));
                    neededQty = 0L;
                    continue;
                }
                holdQty = -holdQty;
                sellValue = sellValue.add(holdPrice.multiply(new BigDecimal(String.valueOf(holdQty))));
                buyValue = buyValue.add(this.requestedPrice.multiply(new BigDecimal(String.valueOf(holdQty))));
                neededQty -= (long)holdQty;
            }
            rs.close();
        }
        BigDecimal taxAmount = null;
        BigDecimal taxRates = null;
        if (sellValue.compareTo(buyValue) == 1 && (this.customerAccount.getCaTaxSt() == 1 || this.customerAccount.getCaTaxSt() == 2)) {
            ps = this.conn.prepareStatement(selectTaxRate);
            ps.setLong(1, this.customer.getCId());
            rs = ps.executeQuery();
            if (rs.next()) {
                taxRates = rs.getBigDecimal(1);
                if (rs.next()) {
                    throw new TestException("select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?) has more than 1 row in result set for cx_c_id = " + this.customer.getCId());
                }
            } else {
                throw new TestException("select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?) does not get single row in result set for cx_c_id = " + this.customer.getCId());
            }
            rs.close();
            taxAmount = taxRates.multiply(sellValue.subtract(buyValue));
        }
        ps = this.conn.prepareStatement(selectCommRate);
        ps.setShort(1, this.customer.getCTier());
        ps.setString(2, this.toTxnInput.getTradeTypeId());
        ps.setString(3, exchangeId);
        ps.setLong(4, this.toTxnInput.getTradeQty());
        ps.setLong(5, this.toTxnInput.getTradeQty());
        rs = ps.executeQuery();
        if (rs.next()) {
            this.commissionRate = rs.getBigDecimal("cr_rate");
            if (rs.next()) {
                throw new TestException("select cr_rate from commission_rate where cr_c_tier = ? and cr_tt_id = ? and cr_ex_id = ? and cr_from_qty <= ? and cr_to_qty >= ? has more than 1 row in result set for cr_c_tier  = " + this.customer.getCTier() + " and cr_tt_id = " + this.toTxnInput.getTradeTypeId() + " and cr_ex_id = " + exchangeId + " and cr_from_qty & cr_to_qty = " + this.toTxnInput.getTradeQty());
            }
        } else {
            throw new TestException("select cr_rate from commission_rate where cr_c_tier = ? and cr_tt_id = ? and cr_ex_id = ? and cr_from_qty <= ? and cr_to_qty >= ? does not get single row in result set for cr_c_tier  = " + this.customer.getCTier() + " and cr_tt_id = " + this.toTxnInput.getTradeTypeId() + " and cr_ex_id = " + exchangeId + " and cr_from_qty & cr_to_qty = " + this.toTxnInput.getTradeQty());
        }
        rs.close();
        ps = this.conn.prepareStatement(selectCharge);
        ps.setShort(1, this.customer.getCTier());
        ps.setString(2, this.toTxnInput.getTradeTypeId());
        rs = ps.executeQuery();
        if (rs.next()) {
            this.chargeAmount = new BigDecimal(String.valueOf(rs.getFloat("ch_chrg")));
            if (rs.next()) {
                throw new TestException("select ch_chrg from charge where ch_c_tier = ? and ch_tt_id = ? has more than 1 row in result set for cr_c_tier  = " + this.customer.getCTier() + " and cr_tt_id = " + this.toTxnInput.getTradeTypeId());
            }
        } else {
            throw new TestException("select ch_chrg from charge where ch_c_tier = ? and ch_tt_id = ? does not get single row in result set for cr_c_tier  = " + this.customer.getCTier() + " and cr_tt_id = " + this.toTxnInput.getTradeTypeId());
        }
        rs.close();
        if (this.toTxnInput.getTypeIsMargin() == 1L) {
            BigDecimal customerAssets = null;
            ps = this.conn.prepareStatement(selectAccountBal);
            ps.setLong(1, this.toTxnInput.getAcctId());
            rs = ps.executeQuery();
            if (rs.next()) {
                customerAssets = rs.getBigDecimal("CA_BAL");
                if (rs.next()) {
                    throw new TestException("select CA_BAL from CUSTOMER_ACCOUNT where CA_ID = ? has more than 1 row in result set for CA_ID  = " + this.toTxnInput.getAcctId());
                }
            } else {
                throw new TestException("select CA_BAL from CUSTOMER_ACCOUNT where CA_ID = ? does not get single row in result set for CA_ID  = " + this.toTxnInput.getAcctId());
            }
            rs.close();
            ps = this.conn.prepareStatement(selectHoldingAsset);
            ps.setLong(1, this.toTxnInput.getAcctId());
            rs = ps.executeQuery();
            if (rs.next()) {
                customerAssets = customerAssets.add(rs.getBigDecimal(1));
                if (rs.next()) {
                    throw new TestException("select sum(hs_qty * lt_price) from holding_summary, last_trade where hs_ca_id = ? and lt_s_symb = hs_s_symb has more than 1 row in result set for CA_ID  = " + this.toTxnInput.getAcctId());
                }
            }
            rs.close();
        }
        String string = this.statusId = this.ttIsMrkt == 1 ? this.toTxnInput.getStSubmittedId() : this.toTxnInput.getStPendingId();
        if (sellValue.compareTo(buyValue) == 1 && (this.customerAccount.getCaTaxSt() == 1 || this.customerAccount.getCaTaxSt() == 2) && taxAmount.compareTo(new BigDecimal("0.00")) == 0) {
            this.toTxnOutput.setStatus(-731);
        } else if (this.commissionRate.compareTo(new BigDecimal("0.0000")) == 0) {
            this.toTxnOutput.setStatus(-732);
        } else if (this.chargeAmount.compareTo(new BigDecimal("0.00")) == 0) {
            this.toTxnOutput.setStatus(-733);
        }
        if (this.toTxnInput.getRollItBack() == 0L) {
            this.toTxnOutput.setBuyValue(buyValue);
            this.toTxnOutput.setSellValue(sellValue);
            this.toTxnOutput.setTaxAmount(taxAmount);
        }
    }

    protected void invokeFrame4() throws SQLException {
        Timestamp orderTime = new Timestamp(System.currentTimeMillis());
        BigDecimal commission = this.commissionRate.multiply(this.requestedPrice).multiply(new BigDecimal(String.valueOf(this.toTxnInput.getTradeQty()))).divide(new BigDecimal("100"));
        String execName = this.toTxnInput.getExecFirstName() + " " + this.toTxnInput.getExecLastName();
        short isCash = this.toTxnInput.getTypeIsMargin() == 1L ? (short)0 : 1;
        PreparedStatement ps = this.conn.prepareStatement(insertTrade, new String[]{"T_ID"});
        ResultSet rs = null;
        ps.setLong(1, this.toTxnInput.getAcctId());
        ps.setString(2, this.securitySymbol);
        ps.setString(3, this.statusId);
        ps.setBigDecimal(4, this.requestedPrice);
        ps.setBigDecimal(5, this.chargeAmount);
        ps.setBigDecimal(6, commission);
        ps.setTimestamp(7, orderTime);
        ps.setString(8, execName);
        ps.setShort(9, isCash);
        ps.setShort(10, (short)this.toTxnInput.getIsLifo());
        ps.setInt(11, (int)this.toTxnInput.getTradeQty());
        ps.setBigDecimal(12, new BigDecimal("0.00"));
        ps.setBigDecimal(13, null);
        ps.setString(14, this.toTxnInput.getTradeTypeId());
        int count = ps.executeUpdate();
        rs = ps.getGeneratedKeys();
        if (!rs.next()) {
            throw new TestException("jdbc call getGeneratedKeys fail to returns the generated id ");
        }
        this.tradeId = rs.getLong(1);
        if (this.tradeId == 0L) {
            throw new TestException("jdbc call getGeneratedKeys returns wrong result " + this.tradeId);
        }
        if (logDML) {
            Log.getLogWriter().info("insert into TRADE (T_ID, T_CA_ID, T_S_SYMB, T_ST_ID, T_BID_PRICE, T_CHRG, T_COMM, T_DTS, T_EXEC_NAME, T_IS_CASH, T_LIFO, T_QTY, T_TAX, T_TRADE_PRICE, T_TT_ID) values (default, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) with T_CA_ID = " + this.toTxnInput.getAcctId() + " T_S_SYMB = " + this.securitySymbol + " T_ST_ID = " + this.statusId + " T_BID_PRICE " + this.requestedPrice + " T_CHRG = " + this.chargeAmount + " T_COMM = " + commission + " T_DTS = " + orderTime + " T_EXEC_NAME = " + execName + " T_IS_CASH = " + isCash + " T_LIFO = " + (short)this.toTxnInput.getIsLifo() + " T_QTY = " + this.toTxnInput.getTradeQty() + " T_TAX = 0.00 T_TRADE_PRICE = null and " + " auto generated T_TT_ID = " + this.tradeId);
        }
        if (count != 1) {
            throw new TestException("insert into trade table failed ");
        }
        ps.close();
        if (this.ttIsMrkt != 1) {
            ps = this.conn.prepareStatement(insertTradeRequest);
            ps.setLong(1, this.tradeId);
            ps.setString(2, this.toTxnInput.getTradeTypeId());
            ps.setString(3, this.securitySymbol);
            ps.setInt(4, (int)this.toTxnInput.getTradeQty());
            ps.setBigDecimal(5, this.requestedPrice);
            ps.setLong(6, this.toTxnInput.getAcctId());
            ps.setLong(7, this.broker.getBId());
            count = ps.executeUpdate();
            if (logDML) {
                Log.getLogWriter().info("insert into TRADE_REQUEST (TR_T_ID, TR_TT_ID, TR_S_SYMB, TR_QTY, TR_BID_PRICE, TR_CA_ID, TR_B_ID) values (?, ?, ?, ?, ?, ?, ?) with TR_T_ID = " + this.tradeId + " TR_TT_ID = " + this.toTxnInput.getTradeTypeId() + " TR_S_SYMB = " + this.securitySymbol + " TR_QTY " + this.toTxnInput.getTradeQty() + " TR_BID_PRICE = " + this.requestedPrice + " TR_CA_ID = " + this.toTxnInput.getAcctId() + " TR_B_ID = " + this.broker.getBId());
            }
            if (count != 1) {
                throw new TestException("insert into trade_request table failed ");
            }
            ps.close();
        }
        ps = this.conn.prepareStatement(insertTradeHistory);
        ps.setLong(1, this.tradeId);
        ps.setTimestamp(2, orderTime);
        ps.setString(3, this.statusId);
        count = ps.executeUpdate();
        if (logDML) {
            Log.getLogWriter().info("insert into TRADE_HISTORY(TH_T_ID, TH_DTS, TH_ST_ID) values (?, ?, ?) with TH_T_ID = " + this.tradeId + " TH_DTS = " + orderTime + " TH_ST_ID = " + this.statusId);
        }
        if (count != 1) {
            throw new TestException("insert into TRADE_HISTORY(TH_T_ID, TH_DTS, TH_ST_ID) values (?, ?, ?) should inserts 1 row but inserted " + count + " row(s)");
        }
        ps.close();
        if (this.toTxnInput.getRollItBack() == 0L) {
            this.toTxnOutput.setTradeId(this.tradeId);
            if (logDML) {
                Log.getLogWriter().info(this.tradeId + " will be committed.");
            }
        }
    }

    protected void invokeFrame5() throws SQLException {
        if (this.toTxnInput.getRollItBack() == 1L) {
            this.conn.rollback();
            if (logDML) {
                Log.getLogWriter().info("This transaction is rolled back.");
            }
        }
    }

    protected void invokeFrame6(MEE mee) throws SQLException {
        if (this.toTxnInput.getRollItBack() != 1L) {
            this.conn.commit();
            if (logDML) {
                Log.getLogWriter().info("committed trade_order_txn");
            }
            if (RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK")) {
                return;
            }
            if (this.ttIsMrkt == 1) {
                TradeInfo ti = new TradeInfo();
                ti.setPriceQuotes(this.requestedPrice);
                ti.setSymbol(this.securitySymbol);
                ti.setTradeId(this.tradeId);
                ti.setTradeQty((int)this.toTxnInput.getTradeQty());
                ti.setTradeType(this.toTxnInput.getTradeTypeId());
                if (logDML) {
                    Log.getLogWriter().info("send trade info to market" + ti.toString());
                }
                ArrayList<TradeInfo> tradeToMarket = new ArrayList<TradeInfo>();
                tradeToMarket.add(ti);
                mee.submitTradeToMarket(this.conn, tradeToMarket);
            }
        }
    }
}

