/*
 * Decompiled with CFR 0.152.
 */
package sql.tpce.tpcetxn;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import sql.tpce.tpcedef.TPCETxnInput;
import sql.tpce.tpcedef.TPCETxnOutput;
import sql.tpce.tpcedef.input.TradeResultTxnInput;
import sql.tpce.tpcedef.output.TradeResultTxnOutput;
import sql.tpce.tpcetxn.TPCETransaction;
import util.TestException;

public class TPCETradeResult
extends TPCETransaction {
    protected TradeResultTxnInput trTxnInput = null;
    protected TradeResultTxnOutput trTxnOutput = null;
    protected Connection conn = null;
    protected static boolean isTicket41738Fixed = false;
    long trade_id;
    BigDecimal trade_price;
    private long acct_id;
    private String type_id;
    private String symbol;
    private int trade_qty;
    private BigDecimal charge;
    private short is_lifo;
    private short trade_is_cash;
    private String type_name;
    private short type_is_sell;
    private short type_is_market;
    private int hs_qty;
    private long broker_id;
    private long cust_id;
    private short tax_status;
    private Timestamp trade_dts;
    BigDecimal buy_value = new BigDecimal("0.00");
    BigDecimal sell_value = new BigDecimal("0.00");
    BigDecimal tax_amount = new BigDecimal("0.00");
    BigDecimal comm_rate = new BigDecimal("0.00");
    private String s_name;
    private BigDecimal comm_amount = new BigDecimal("0.00");
    private String st_completed_id = "CMPT";
    private Date due_date;
    private BigDecimal se_amount;
    private BigDecimal acct_bal;
    private static final String selectTrade = "select T_CA_ID, T_TT_ID, T_S_SYMB, T_QTY, T_CHRG, T_LIFO, T_IS_CASH from TRADE where T_ID = ?";
    private static final String selectTradeType = "select TT_NAME, TT_IS_SELL, TT_IS_MRKT from TRADE_TYPE where TT_ID = ?";
    private static final String selectHoldingSummary = "select HS_QTY from HOLDING_SUMMARY where HS_CA_ID = ? and HS_S_SYMB = ?";
    private static final String selectHoldingSummaryTBLForLock = "select HS_QTY from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? for update";
    private static final String selectCustomerAccount = "select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ?";
    private static final String insertHSTable = " insert into HOLDING_SUMMARY_TBL( HS_CA_ID, HS_S_SYMB, HS_QTY) values (?, ?, ?)";
    private static final String updateHSForSell = "update HOLDING_SUMMARY_TBL set HS_QTY = hs_qty - ? where HS_CA_ID = ? and HS_S_SYMB = ?";
    private static final String updateHSHoldLock = "update HOLDING_SUMMARY_TBL set HS_QTY = ? where HS_CA_ID = ? and HS_S_SYMB = ?";
    private static final String deleteHS = "delete from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ?";
    private static final String updateHSForBuy = "update HOLDING_SUMMARY_TBL set HS_QTY = hs_qty + ? where HS_CA_ID = ? and HS_S_SYMB = ?";
    private static final String selectHoldingForUpdateDesc = "select H_T_ID, H_QTY, H_PRICE from HOLDING where H_CA_ID = ? and H_S_SYMB = ? order by H_DTS desc ";
    private static final String selectHoldingForUpdateAsc = "select H_T_ID, H_QTY, H_PRICE from HOLDING where H_CA_ID = ? and H_S_SYMB = ? order by H_DTS asc ";
    private static final String insertHoldingHistory = " insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?)";
    private static final String updateHoldingCurrentOf = "update HOLDING set H_QTY = ? where current of updateCursor";
    private static final String updateHoldingPK = "update HOLDING set H_QTY = ? where H_T_ID = ?";
    private static final String deleteHoldingCurrentOf = "delete from HOLDING where current of updateCursor";
    private static final String deleteHoldingPK = "delete from HOLDING where H_T_ID = ?";
    private static final String insertHolding = "insert into HOLDING (H_T_ID, H_CA_ID, H_S_SYMB, H_DTS, H_PRICE, H_QTY) values (? ,? ,? ,? ,? ,?)";
    private static final String selectTaxRate = "select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?)";
    private static final String updateTaxAmount = "update TRADE set T_TAX = ? where T_ID = ?";
    private static final String selectSecurity = "select  S_EX_ID, S_NAME from SECURITY where S_SYMB = ?";
    private static final String selectCustomer = "select C_TIER from CUSTOMER where C_ID = ?";
    private static final String selectCommRate = "select CR_RATE from COMMISSION_RATE where CR_C_TIER = ? and CR_TT_ID = ? and CR_EX_ID = ? and CR_FROM_QTY <= ? and CR_TO_QTY >= ? Fetch first row only";
    private static final String updateTrade = "update TRADE set T_COMM = ?, T_DTS = ?, T_ST_ID = ?, T_TRADE_PRICE = ? where T_ID = ?";
    private static final String insertTradeHistory = "insert into TRADE_HISTORY(TH_T_ID, TH_DTS, TH_ST_ID) values (?, ?, ?)";
    private static final String updateBroker = "update BROKER set B_COMM_TOTAL = B_COMM_TOTAL + ?, B_NUM_TRADES = B_NUM_TRADES + 1 where B_ID = ?";
    private static final String insertSettlement = "insert into SETTLEMENT ( SE_T_ID, SE_CASH_TYPE, SE_CASH_DUE_DATE, SE_AMT) values ( ?, ?, ?, ?)";
    private static final String updateCustomerAccount = "update CUSTOMER_ACCOUNT set CA_BAL = CA_BAL + ? where CA_ID = ?";
    private static final String insertCashTransaction = "insert into CASH_TRANSACTION ( CT_DTS, CT_T_ID, CT_AMT, CT_NAME ) values ( ?, ?, ?, ?)";
    private static final String selectCABalance = "select CA_BAL from CUSTOMER_ACCOUNT where CA_ID = ?";

    @Override
    public TPCETxnOutput runTxn(TPCETxnInput txnInput, Connection conn) throws SQLException {
        this.trTxnInput = (TradeResultTxnInput)txnInput;
        this.trTxnOutput = new TradeResultTxnOutput();
        this.conn = conn;
        this.invokeFrame1();
        this.invokeFrame2();
        if ((this.tax_status == 1 || this.tax_status == 2) && this.sell_value.compareTo(this.buy_value) == 1) {
            this.invokeFrame3();
            if (this.tax_amount.compareTo(new BigDecimal("0.00")) != 1) {
                this.trTxnOutput.setStatus(-831);
            }
        }
        this.invokeFrame4();
        if (this.comm_rate.compareTo(new BigDecimal("0.00")) != 1) {
            this.trTxnOutput.setStatus(-841);
        }
        this.comm_amount = this.comm_rate.divide(new BigDecimal("100.0")).multiply(this.trade_price.multiply(new BigDecimal(String.valueOf(this.trade_qty))));
        this.invokeFrame5();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(this.trade_dts.getTime()));
        c.add(5, 2);
        this.due_date = new Date(c.getTimeInMillis());
        this.se_amount = this.type_is_sell == 1 ? this.trade_price.multiply(new BigDecimal(String.valueOf(this.trade_qty))).subtract(this.charge).subtract(this.comm_amount) : new BigDecimal("-1").multiply(this.trade_price.multiply(new BigDecimal(String.valueOf(this.trade_qty))).add(this.charge).add(this.comm_amount));
        if (this.tax_status == 1) {
            this.se_amount = this.se_amount.subtract(this.tax_amount);
        }
        this.invokeFrame6();
        this.trTxnOutput.setAcctId(this.acct_id);
        this.trTxnOutput.setAcctBal(this.acct_bal);
        return this.trTxnOutput;
    }

    protected void invokeFrame1() throws SQLException {
        ResultSet rsLock;
        PreparedStatement psLock;
        block23: {
            this.trade_id = this.trTxnInput.getTradeID();
            PreparedStatement ps = this.conn.prepareStatement(selectTrade);
            ps.setLong(1, this.trade_id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                this.acct_id = rs.getLong("T_CA_ID");
                this.type_id = rs.getString("T_TT_ID");
                this.symbol = rs.getString("T_S_SYMB");
                this.trade_qty = rs.getInt("T_QTY");
                this.charge = rs.getBigDecimal("T_CHRG");
                this.is_lifo = rs.getShort("T_IS_CASH");
                this.trade_is_cash = rs.getShort("T_IS_CASH");
                if (rs.next()) {
                    this.trTxnOutput.setStatus(-811);
                    throw new TestException("select T_CA_ID, T_TT_ID, T_S_SYMB, T_QTY, T_CHRG, T_LIFO, T_IS_CASH from TRADE where T_ID = ? has more than 1 row in result set for T_ID = " + this.trade_id);
                }
            } else {
                this.trTxnOutput.setStatus(-811);
                throw new TestException("select T_CA_ID, T_TT_ID, T_S_SYMB, T_QTY, T_CHRG, T_LIFO, T_IS_CASH from TRADE where T_ID = ? does not get single row in result set for T_ID = " + this.trade_id);
            }
            rs.close();
            ps = this.conn.prepareStatement(selectTradeType);
            ps.setString(1, this.type_id);
            rs = ps.executeQuery();
            if (rs.next()) {
                this.type_name = rs.getString("TT_NAME");
                this.type_is_sell = rs.getShort("TT_IS_SELL");
                this.type_is_market = rs.getShort("TT_IS_MRKT");
                if (logDML) {
                    Log.getLogWriter().info("select TT_NAME, TT_IS_SELL, TT_IS_MRKT from TRADE_TYPE where TT_ID = ? gets TT_NAME: " + this.type_name + " TT_IS_SELL: " + this.type_is_sell + " TT_IS_MRKT: " + this.type_is_market);
                }
                if (rs.next()) {
                    this.trTxnOutput.setStatus(-811);
                    throw new TestException("select TT_NAME, TT_IS_SELL, TT_IS_MRKT from TRADE_TYPE where TT_ID = ? has more than 1 row in result set for TT_ID = " + this.type_id);
                }
            } else {
                this.trTxnOutput.setStatus(-811);
                throw new TestException("select TT_NAME, TT_IS_SELL, TT_IS_MRKT from TRADE_TYPE where TT_ID = ? does not get single row in result set for TT_ID = " + this.type_id);
            }
            rs.close();
            psLock = null;
            rsLock = null;
            try {
                psLock = this.conn.prepareStatement(selectHoldingSummaryTBLForLock);
                psLock.setLong(1, this.acct_id);
                psLock.setString(2, this.symbol);
                rsLock = psLock.executeQuery();
            }
            catch (SQLException se) {
                if (logDML && se.getSQLState().equals("X0Z02")) {
                    Log.getLogWriter().info("select HS_QTY from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? for update gets expected conflict exception");
                }
                throw se;
            }
            if (rsLock.next()) {
                this.hs_qty = rsLock.getInt("HS_QTY");
                if (logDML) {
                    Log.getLogWriter().info("select HS_QTY from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? for update get HS_QTY: " + this.hs_qty + " for HS_CA_ID = " + this.acct_id + " and HS_S_SYMB = " + this.symbol);
                }
                if (rsLock.next()) {
                    this.trTxnOutput.setStatus(-811);
                    throw new TestException("select HS_QTY from HOLDING_SUMMARY where HS_CA_ID = ? and HS_S_SYMB = ? has more than 1 row in result set for HS_CA_ID = " + this.acct_id + " and HS_S_SYMB = " + this.symbol);
                }
            } else {
                this.hs_qty = 0;
            }
            if (logDML) {
                Log.getLogWriter().info("select HS_QTY from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? for update gets hs_qty " + this.hs_qty);
            }
            if (this.hs_qty == 0) {
                try {
                    ps = this.conn.prepareStatement(insertHSTable);
                    ps.setLong(1, this.acct_id);
                    ps.setString(2, this.symbol);
                    ps.setInt(3, this.hs_qty);
                    int count = ps.executeUpdate();
                    if (logDML) {
                        Log.getLogWriter().info(" insert into HOLDING_SUMMARY_TBL( HS_CA_ID, HS_S_SYMB, HS_QTY) values (?, ?, ?) inserts hs_qty as 0 to be updated in frame2 -- with HS_CA_ID = " + this.acct_id + " HS_S_SYMB = " + this.symbol + " HS_QTY = " + this.hs_qty);
                    }
                    if (count != 1) {
                        throw new TestException(" insert into HOLDING_SUMMARY_TBL( HS_CA_ID, HS_S_SYMB, HS_QTY) values (?, ?, ?) should insert 1 row but inserted " + count + " row(s)");
                    }
                    break block23;
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("23505")) {
                        Log.getLogWriter().info("should occur rarely -- the window is another insert occurs just after the select for update, test will allow this");
                        throw new SQLException("throw conflict exception instead for retry as gemfirexd does not support isolation Serializable", "X0Z02");
                    }
                    throw se;
                }
            }
            ps = this.conn.prepareStatement(updateHSHoldLock);
            ps.setLong(2, this.acct_id);
            ps.setString(3, this.symbol);
            ps.setInt(1, this.hs_qty);
            int count = ps.executeUpdate();
            if (logDML) {
                Log.getLogWriter().info("update HOLDING_SUMMARY_TBL set HS_QTY = ? where HS_CA_ID = ? and HS_S_SYMB = ? does not change any hs_qty but to hold the row lock to prevent other concrrent update -- with HS_CA_ID = " + this.acct_id + " HS_S_SYMB = " + this.symbol + " HS_QTY = " + this.hs_qty);
            }
            if (count != 1) {
                throw new TestException("update HOLDING_SUMMARY_TBL set HS_QTY = ? where HS_CA_ID = ? and HS_S_SYMB = ? should update 1 row but updated " + count + " row(s)");
            }
        }
        rsLock.close();
        psLock.close();
    }

    protected void invokeFrame2() throws SQLException {
        this.trade_price = this.trTxnInput.getTradePrice();
        this.trade_dts = new Timestamp(System.currentTimeMillis());
        int needed_qty = this.trade_qty;
        int hold_qty = 0;
        ResultSet updatableRs = null;
        boolean useBatchInsert = true;
        boolean useBatchDelete = true;
        PreparedStatement ps = this.conn.prepareStatement(selectCustomerAccount);
        ps.setLong(1, this.acct_id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            this.broker_id = rs.getInt("CA_B_ID");
            this.cust_id = rs.getInt("CA_C_ID");
            this.tax_status = rs.getShort("CA_TAX_ST");
            if (rs.next()) {
                this.trTxnOutput.setStatus(-821);
                throw new TestException("select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ? has more than 1 row in result set for CA_ID = " + this.acct_id);
            }
        } else {
            this.trTxnOutput.setStatus(-821);
            throw new TestException("select CA_NAME, CA_B_ID, CA_C_ID, CA_TAX_ST from CUSTOMER_ACCOUNT where CA_ID = ? does not get single row in result set for CA_ID = " + this.acct_id);
        }
        rs.close();
        ps.close();
        if (this.type_is_sell == 1) {
            int count;
            if (this.hs_qty != this.trade_qty) {
                ps = this.conn.prepareStatement(updateHSForSell);
                ps.setLong(2, this.acct_id);
                ps.setString(3, this.symbol);
                ps.setInt(1, this.trade_qty);
                count = ps.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info("update HOLDING_SUMMARY_TBL set HS_QTY = hs_qty - ? where HS_CA_ID = ? and HS_S_SYMB = ? with HS_CA_ID = " + this.acct_id + " HS_S_SYMB = " + this.symbol + " HS_QTY = HS_QTY - " + this.trade_qty);
                }
                if (count != 1) {
                    throw new TestException("update HOLDING_SUMMARY_TBL set HS_QTY = hs_qty - ? where HS_CA_ID = ? and HS_S_SYMB = ? should update 1 row but updated " + count + " row(s)");
                }
                ps.close();
            } else {
                ps = this.conn.prepareStatement(deleteHS);
                ps.setLong(1, this.acct_id);
                ps.setString(2, this.symbol);
                count = ps.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info("delete from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? for HS_CA_ID = " + this.acct_id + " HS_S_SYMB = " + this.symbol);
                }
                if (count != 1) {
                    throw new TestException("delete from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? should delete 1 row but deleteed " + count + " row(s)");
                }
                ps.close();
            }
            if (this.hs_qty > 0) {
                PreparedStatement ps_deleteHolding;
                PreparedStatement ps_updateHolding;
                ps = this.is_lifo == 1 ? this.conn.prepareStatement(selectHoldingForUpdateDesc) : this.conn.prepareStatement(selectHoldingForUpdateAsc);
                ps.setLong(1, this.acct_id);
                ps.setString(2, this.symbol);
                updatableRs = ps.executeQuery();
                int numOfInsertHH = 0;
                int numOfDeleteHolding = 0;
                PreparedStatement ps_insertHH = this.conn.prepareStatement(insertHoldingHistory);
                String updateHolding = isTicket41738Fixed ? updateHoldingCurrentOf : updateHoldingPK;
                PreparedStatement preparedStatement = ps_updateHolding = isTicket41738Fixed ? this.conn.prepareStatement(updateHolding, 1003, 1008) : this.conn.prepareStatement(updateHolding);
                if (isTicket41738Fixed) {
                    ps_updateHolding.setCursorName("updateCursor");
                }
                String deleteHolding = isTicket41738Fixed ? deleteHoldingCurrentOf : deleteHoldingPK;
                PreparedStatement preparedStatement2 = ps_deleteHolding = isTicket41738Fixed ? this.conn.prepareStatement(deleteHolding, 1003, 1008) : this.conn.prepareStatement(deleteHolding);
                if (isTicket41738Fixed) {
                    ps_deleteHolding.setCursorName("updateCursor");
                }
                while (updatableRs.next() && needed_qty != 0) {
                    int count2;
                    long hold_id = updatableRs.getLong("H_T_ID");
                    hold_qty = updatableRs.getInt("H_QTY");
                    BigDecimal hold_price = updatableRs.getBigDecimal("H_PRICE");
                    if (hold_qty > needed_qty) {
                        ps_insertHH.setLong(1, hold_id);
                        ps_insertHH.setLong(2, this.trade_id);
                        ps_insertHH.setInt(3, hold_qty);
                        ps_insertHH.setInt(4, hold_qty - needed_qty);
                        if (logDML) {
                            Log.getLogWriter().info(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) with HH_H_T_ID = " + hold_id + " HH_T_ID = " + this.trade_id + " HH_BEFORE_QTY = " + hold_qty + " HH_AFTER_QTY = " + (hold_qty - needed_qty));
                        }
                        if (useBatchInsert) {
                            ps_insertHH.addBatch();
                            if (logDML) {
                                Log.getLogWriter().info("add to batch insert");
                            }
                        } else {
                            count2 = ps_insertHH.executeUpdate();
                            if (count2 != 1) {
                                throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row but inserted " + count2 + " row(s)");
                            }
                        }
                        ++numOfInsertHH;
                        ps_updateHolding.setInt(1, hold_qty - needed_qty);
                        if (!isTicket41738Fixed) {
                            ps_updateHolding.setLong(2, hold_id);
                        }
                        count2 = ps_updateHolding.executeUpdate();
                        if (logDML) {
                            Log.getLogWriter().info(updateHolding + " with H_QTY  = " + hold_id + " - " + needed_qty + " for H_T_ID  = " + hold_id);
                        }
                        if (count2 != 1) {
                            throw new TestException(updateHolding + " should update 1 row " + "but updated " + count2 + " row(s)");
                        }
                        this.buy_value = this.buy_value.add(hold_price.multiply(new BigDecimal(String.valueOf(needed_qty))));
                        this.sell_value = this.sell_value.add(this.trade_price.multiply(new BigDecimal(String.valueOf(needed_qty))));
                        needed_qty = 0;
                        continue;
                    }
                    ps_insertHH.setLong(1, hold_id);
                    ps_insertHH.setLong(2, this.trade_id);
                    ps_insertHH.setInt(3, hold_qty);
                    ps_insertHH.setInt(4, 0);
                    if (logDML) {
                        Log.getLogWriter().info(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) with HH_H_T_ID = " + hold_id + " HH_T_ID = " + this.trade_id + " HH_BEFORE_QTY = " + hold_qty + " HH_AFTER_QTY = " + 0);
                    }
                    if (useBatchInsert) {
                        ps_insertHH.addBatch();
                        if (logDML) {
                            Log.getLogWriter().info("add to batch insert");
                        }
                    } else {
                        count2 = ps_insertHH.executeUpdate();
                        if (count2 != 1) {
                            throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row but inserted " + count2 + " row(s)");
                        }
                    }
                    ++numOfInsertHH;
                    if (!isTicket41738Fixed) {
                        ps_deleteHolding.setLong(1, hold_id);
                    }
                    ++numOfDeleteHolding;
                    if (logDML) {
                        Log.getLogWriter().info(deleteHolding + " with H_T_ID = " + hold_id);
                    }
                    if (useBatchDelete) {
                        ps_deleteHolding.addBatch();
                        if (logDML) {
                            Log.getLogWriter().info("add to batch insert");
                        }
                    } else {
                        count2 = ps_deleteHolding.executeUpdate();
                        if (count2 != 1) {
                            throw new TestException(deleteHolding + " should delete 1 row " + "but inserted " + count2 + " row(s)");
                        }
                    }
                    this.buy_value = this.buy_value.add(hold_price.multiply(new BigDecimal(String.valueOf(hold_qty))));
                    this.sell_value = this.sell_value.add(this.trade_price.multiply(new BigDecimal(String.valueOf(hold_qty))));
                    needed_qty -= hold_qty;
                }
                if (useBatchInsert) {
                    int[] counts = ps_insertHH.executeBatch();
                    if (counts.length != numOfInsertHH) {
                        throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) does not return correct number of statement executed, should execute " + numOfInsertHH + " of statements but " + counts.length + " statements are executed");
                    }
                    for (int count3 : counts) {
                        if (count3 == 1) continue;
                        throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row for each statement in a batch but one of the statmement inserted " + count3 + " row(s)");
                    }
                }
                if (useBatchDelete) {
                    int[] counts = ps_deleteHolding.executeBatch();
                    if (counts.length != numOfDeleteHolding) {
                        throw new TestException(deleteHolding + " does not return correct number of" + " statement executed, should execute " + numOfDeleteHolding + " of statements but " + counts.length + " statements are executed");
                    }
                    for (int count3 : counts) {
                        if (count3 == 1) continue;
                        throw new TestException(deleteHolding + " should delete 1 row " + "for each statement in a batch but one of the statmement deleted " + count3 + " row(s)");
                    }
                }
                updatableRs.close();
                ps.close();
            }
            if (needed_qty > 0) {
                PreparedStatement ps_insertHH = this.conn.prepareStatement(insertHoldingHistory);
                ps_insertHH.setLong(1, this.trade_id);
                ps_insertHH.setLong(2, this.trade_id);
                ps_insertHH.setInt(3, 0);
                ps_insertHH.setInt(4, -1 * needed_qty);
                int count4 = ps_insertHH.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) selling short with HH_H_T_ID = " + this.trade_id + " HH_T_ID = " + this.trade_id + " HH_BEFORE_QTY = " + 0 + " HH_AFTER_QTY = " + -1 * needed_qty);
                }
                if (count4 != 1) {
                    throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row but inserted " + count4 + " row(s)");
                }
                ps = this.conn.prepareStatement(insertHolding);
                ps.setLong(1, this.trade_id);
                ps.setLong(2, this.acct_id);
                ps.setString(3, this.symbol);
                ps.setTimestamp(4, this.trade_dts);
                ps.setBigDecimal(5, this.trade_price);
                ps.setInt(6, -1 * needed_qty);
                count4 = ps.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info("insert into HOLDING (H_T_ID, H_CA_ID, H_S_SYMB, H_DTS, H_PRICE, H_QTY) values (? ,? ,? ,? ,? ,?) with H_T_ID = " + this.trade_id + " H_CA_ID = " + this.acct_id + " H_S_SYMB = " + this.symbol + " H_DTS = " + this.trade_dts + " H_PRICE = " + this.trade_price + " H_QTY = " + -1 * needed_qty);
                }
                if (count4 != 1) {
                    throw new TestException("insert into HOLDING (H_T_ID, H_CA_ID, H_S_SYMB, H_DTS, H_PRICE, H_QTY) values (? ,? ,? ,? ,? ,?) should insert 1 row but inserted " + count4 + " row(s)");
                }
            }
        } else {
            int count;
            if (-this.hs_qty != this.trade_qty) {
                ps = this.conn.prepareStatement(updateHSForBuy);
                ps.setInt(1, this.trade_qty);
                ps.setLong(2, this.acct_id);
                ps.setString(3, this.symbol);
                count = ps.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info("update HOLDING_SUMMARY_TBL set HS_QTY = hs_qty + ? where HS_CA_ID = ? and HS_S_SYMB = ? with HS_CA_ID = " + this.acct_id + " HS_S_SYMB = " + this.symbol + " HS_QTY = HS_QTY + " + this.trade_qty);
                }
                if (count != 1) {
                    throw new TestException("update HOLDING_SUMMARY_TBL set HS_QTY = hs_qty - ? where HS_CA_ID = ? and HS_S_SYMB = ? should update 1 row but updated " + count + " row(s)");
                }
                ps.close();
            } else {
                ps = this.conn.prepareStatement(deleteHS);
                ps.setLong(1, this.acct_id);
                ps.setString(2, this.symbol);
                count = ps.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info("delete from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? for HS_CA_ID = " + this.acct_id + " HS_S_SYMB = " + this.symbol);
                }
                if (count != 1) {
                    throw new TestException("delete from HOLDING_SUMMARY_TBL where HS_CA_ID = ? and HS_S_SYMB = ? should delete 1 row but deleteed " + count + " row(s)");
                }
                ps.close();
            }
            if (this.hs_qty < 0) {
                PreparedStatement ps_deleteHolding;
                PreparedStatement ps_updateHolding;
                ps = this.is_lifo == 1 ? this.conn.prepareStatement(selectHoldingForUpdateDesc) : this.conn.prepareStatement(selectHoldingForUpdateAsc);
                ps.setLong(1, this.acct_id);
                ps.setString(2, this.symbol);
                updatableRs = ps.executeQuery();
                int numOfInsertHH = 0;
                int numOfDeleteHolding = 0;
                PreparedStatement ps_insertHH = this.conn.prepareStatement(insertHoldingHistory);
                String updateHolding = isTicket41738Fixed ? updateHoldingCurrentOf : updateHoldingPK;
                PreparedStatement preparedStatement = ps_updateHolding = isTicket41738Fixed ? this.conn.prepareStatement(updateHolding, 1003, 1008) : this.conn.prepareStatement(updateHolding);
                if (isTicket41738Fixed) {
                    ps_updateHolding.setCursorName("updateCursor");
                }
                String deleteHolding = isTicket41738Fixed ? deleteHoldingCurrentOf : deleteHoldingPK;
                PreparedStatement preparedStatement3 = ps_deleteHolding = isTicket41738Fixed ? this.conn.prepareStatement(deleteHolding, 1003, 1008) : this.conn.prepareStatement(deleteHolding);
                if (isTicket41738Fixed) {
                    ps_deleteHolding.setCursorName("updateCursor");
                }
                while (updatableRs.next() && needed_qty != 0) {
                    int count5;
                    long hold_id = updatableRs.getLong("H_T_ID");
                    hold_qty = updatableRs.getInt("H_QTY");
                    BigDecimal hold_price = updatableRs.getBigDecimal("H_PRICE");
                    if (hold_qty + needed_qty < 0) {
                        ps_insertHH.setLong(1, hold_id);
                        ps_insertHH.setLong(2, this.trade_id);
                        ps_insertHH.setInt(3, hold_qty);
                        ps_insertHH.setInt(4, hold_qty + needed_qty);
                        if (logDML) {
                            Log.getLogWriter().info(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) with HH_H_T_ID = " + hold_id + " HH_T_ID = " + this.trade_id + " HH_BEFORE_QTY = " + hold_qty + " HH_AFTER_QTY = " + (hold_qty + needed_qty));
                        }
                        if (useBatchInsert) {
                            ps_insertHH.addBatch();
                            if (logDML) {
                                Log.getLogWriter().info("add to batch insert");
                            }
                        } else {
                            count5 = ps_insertHH.executeUpdate();
                            if (count5 != 1) {
                                throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row but inserted " + count5 + " row(s)");
                            }
                        }
                        ++numOfInsertHH;
                        ps_updateHolding.setInt(1, hold_qty + needed_qty);
                        if (!isTicket41738Fixed) {
                            ps_updateHolding.setLong(2, hold_id);
                        }
                        count5 = ps_updateHolding.executeUpdate();
                        if (logDML) {
                            Log.getLogWriter().info(updateHolding + " with H_QTY  = " + hold_id + " - " + needed_qty + " for H_T_ID  = " + hold_id);
                        }
                        if (count5 != 1) {
                            throw new TestException(updateHolding + " should update 1 row " + "but updated " + count5 + " row(s)");
                        }
                        this.buy_value = this.buy_value.add(this.trade_price.multiply(new BigDecimal(String.valueOf(needed_qty))));
                        this.sell_value = this.sell_value.add(hold_price.multiply(new BigDecimal(String.valueOf(needed_qty))));
                        needed_qty = 0;
                        continue;
                    }
                    ps_insertHH.setLong(1, hold_id);
                    ps_insertHH.setLong(2, this.trade_id);
                    ps_insertHH.setInt(3, hold_qty);
                    ps_insertHH.setInt(4, 0);
                    if (logDML) {
                        Log.getLogWriter().info(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) with HH_H_T_ID = " + hold_id + " HH_T_ID = " + this.trade_id + " HH_BEFORE_QTY = " + hold_qty + " HH_AFTER_QTY = " + 0);
                    }
                    if (useBatchInsert) {
                        ps_insertHH.addBatch();
                        if (logDML) {
                            Log.getLogWriter().info("add to batch insert");
                        }
                    } else {
                        count5 = ps_insertHH.executeUpdate();
                        if (count5 != 1) {
                            throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row but inserted " + count5 + " row(s)");
                        }
                    }
                    ++numOfInsertHH;
                    if (!isTicket41738Fixed) {
                        ps_deleteHolding.setLong(1, hold_id);
                    }
                    ++numOfDeleteHolding;
                    if (logDML) {
                        Log.getLogWriter().info(deleteHolding + " with H_T_ID = " + hold_id);
                    }
                    if (useBatchDelete) {
                        ps_deleteHolding.addBatch();
                        if (logDML) {
                            Log.getLogWriter().info("add to batch insert");
                        }
                    } else {
                        count5 = ps_deleteHolding.executeUpdate();
                        if (count5 != 1) {
                            throw new TestException(deleteHolding + " should delete 1 row " + "but inserted " + count5 + " row(s)");
                        }
                    }
                    hold_qty = -hold_qty;
                    this.buy_value = this.buy_value.add(this.trade_price.multiply(new BigDecimal(String.valueOf(hold_qty))));
                    this.sell_value = this.sell_value.add(hold_price.multiply(new BigDecimal(String.valueOf(hold_qty))));
                    needed_qty -= hold_qty;
                }
                if (useBatchInsert) {
                    int[] counts = ps_insertHH.executeBatch();
                    if (counts.length != numOfInsertHH) {
                        throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) does not return correct number of statement executed, should execute " + numOfInsertHH + " of statements but " + counts.length + " statements are executed");
                    }
                    for (int count6 : counts) {
                        if (count6 == 1) continue;
                        throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row for each statement in a batch but one of the statmement inserted " + count6 + " row(s)");
                    }
                }
                if (useBatchDelete) {
                    int[] counts = ps_deleteHolding.executeBatch();
                    if (counts.length != numOfDeleteHolding) {
                        throw new TestException(deleteHolding + " does not return correct number of" + " statement executed, should execute " + numOfDeleteHolding + " of statements but " + counts.length + " statements are executed");
                    }
                    for (int count6 : counts) {
                        if (count6 == 1) continue;
                        throw new TestException(deleteHolding + " should delete 1 row " + "for each statement in a batch but one of the statmement deleted " + count6 + " row(s)");
                    }
                }
                updatableRs.close();
                ps.close();
            }
            if (needed_qty > 0) {
                PreparedStatement ps_insertHH = this.conn.prepareStatement(insertHoldingHistory);
                ps_insertHH.setLong(1, this.trade_id);
                ps_insertHH.setLong(2, this.trade_id);
                ps_insertHH.setInt(3, 0);
                ps_insertHH.setInt(4, needed_qty);
                int count7 = ps_insertHH.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) buying long with HH_H_T_ID = " + this.trade_id + " HH_T_ID = " + this.trade_id + " HH_BEFORE_QTY = " + 0 + " HH_AFTER_QTY = " + needed_qty);
                }
                if (count7 != 1) {
                    throw new TestException(" insert into HOLDING_HISTORY (HH_H_T_ID, HH_T_ID, HH_BEFORE_QTY, HH_AFTER_QTY) values (?, ?, ?, ?) should insert 1 row but inserted " + count7 + " row(s)");
                }
                ps = this.conn.prepareStatement(insertHolding);
                ps.setLong(1, this.trade_id);
                ps.setLong(2, this.acct_id);
                ps.setString(3, this.symbol);
                ps.setTimestamp(4, this.trade_dts);
                ps.setBigDecimal(5, this.trade_price);
                ps.setInt(6, needed_qty);
                count7 = ps.executeUpdate();
                if (logDML) {
                    Log.getLogWriter().info("insert into HOLDING (H_T_ID, H_CA_ID, H_S_SYMB, H_DTS, H_PRICE, H_QTY) values (? ,? ,? ,? ,? ,?) with H_T_ID = " + this.trade_id + " H_CA_ID = " + this.acct_id + " H_S_SYMB = " + this.symbol + " H_DTS = " + this.trade_dts + " H_PRICE = " + this.trade_price + " H_QTY = " + needed_qty);
                }
                if (count7 != 1) {
                    throw new TestException("insert into HOLDING (H_T_ID, H_CA_ID, H_S_SYMB, H_DTS, H_PRICE, H_QTY) values (? ,? ,? ,? ,? ,?) should insert 1 row but inserted " + count7 + " row(s)");
                }
            }
        }
    }

    protected void invokeFrame3() throws SQLException {
        BigDecimal tax_rates;
        PreparedStatement ps = this.conn.prepareStatement(selectTaxRate);
        ps.setLong(1, this.cust_id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            tax_rates = rs.getBigDecimal(1);
            if (logDML) {
                Log.getLogWriter().info("tax rate is " + tax_rates);
            }
            if (rs.next()) {
                throw new TestException("select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?) has more than 1 row in result set for cx_c_id = " + this.cust_id);
            }
        } else {
            throw new TestException("select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?) does not get single row in result set for cx_c_id = " + this.cust_id);
        }
        rs.close();
        this.tax_amount = tax_rates.multiply(this.sell_value.subtract(this.buy_value));
        ps = this.conn.prepareStatement(updateTaxAmount);
        ps.setBigDecimal(1, this.tax_amount);
        ps.setLong(2, this.trade_id);
        int count = ps.executeUpdate();
        if (logDML) {
            Log.getLogWriter().info("update TRADE set T_TAX = ? where T_ID = ? updates T_TAX = " + this.tax_amount + " for T_ID = " + this.trade_id);
        }
        if (count != 1) {
            throw new TestException("update TRADE set T_TAX = ? where T_ID = ? should updates only 1 row but updated " + count + " row(s)");
        }
    }

    protected void invokeFrame4() throws SQLException {
        short c_tier;
        String s_ex_id;
        PreparedStatement ps = this.conn.prepareStatement(selectSecurity);
        ps.setString(1, this.symbol);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            s_ex_id = rs.getString("S_EX_ID");
            this.s_name = rs.getString(2);
            if (logDML) {
                Log.getLogWriter().info("select  S_EX_ID, S_NAME from SECURITY where S_SYMB = ? gets S_EX_ID: " + s_ex_id + " S_NAME: " + this.s_name + " for S_SYMB = " + this.symbol);
            }
            if (rs.next()) {
                throw new TestException("select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?) has more than 1 row in result set for S_SYMB = " + this.symbol);
            }
        } else {
            throw new TestException("select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?) does not get single row in result set for S_SYMB = " + this.symbol);
        }
        rs.close();
        ps.close();
        ps = this.conn.prepareStatement(selectCustomer);
        ps.setLong(1, this.cust_id);
        rs = ps.executeQuery();
        if (rs.next()) {
            c_tier = rs.getShort("C_TIER");
            if (logDML) {
                Log.getLogWriter().info("select C_TIER from CUSTOMER where C_ID = ? gets C_TIER: " + c_tier + " S_NAME: " + this.s_name + " for C_ID = " + this.cust_id);
            }
            if (rs.next()) {
                throw new TestException("select C_TIER from CUSTOMER where C_ID = ? has more than 1 row in result set for C_ID = " + this.cust_id);
            }
        } else {
            throw new TestException("select C_TIER from CUSTOMER where C_ID = ? does not get single row in result set for C_ID = " + this.cust_id);
        }
        rs.close();
        ps.close();
        ps = this.conn.prepareStatement(selectCommRate);
        ps.setShort(1, c_tier);
        ps.setString(2, this.type_id);
        ps.setString(3, s_ex_id);
        ps.setInt(4, this.trade_qty);
        ps.setInt(5, this.trade_qty);
        rs = ps.executeQuery();
        if (rs.next()) {
            this.comm_rate = rs.getBigDecimal("CR_RATE");
            if (logDML) {
                Log.getLogWriter().info("select CR_RATE from COMMISSION_RATE where CR_C_TIER = ? and CR_TT_ID = ? and CR_EX_ID = ? and CR_FROM_QTY <= ? and CR_TO_QTY >= ? Fetch first row only gets CR_RATE: " + this.comm_rate + " for CR_C_TIER = " + c_tier + " CR_TT_ID = " + this.type_id + " CR_EX_ID = " + s_ex_id + " CR_FROM_QTY <= " + this.trade_qty + " CR_TO_QTY >= " + this.trade_qty);
            }
            if (rs.next()) {
                throw new TestException("select CR_RATE from COMMISSION_RATE where CR_C_TIER = ? and CR_TT_ID = ? and CR_EX_ID = ? and CR_FROM_QTY <= ? and CR_TO_QTY >= ? Fetch first row only has more than 1 row in result set for CR_C_TIER = " + c_tier + " CR_TT_ID = " + this.type_id + " CR_EX_ID = " + s_ex_id + " CR_FROM_QTY <= " + this.trade_qty + " CR_TO_QTY >= " + this.trade_qty);
            }
        } else {
            throw new TestException("select CR_RATE from COMMISSION_RATE where CR_C_TIER = ? and CR_TT_ID = ? and CR_EX_ID = ? and CR_FROM_QTY <= ? and CR_TO_QTY >= ? Fetch first row only does not get single row in result set for CR_C_TIER = " + c_tier + " CR_TT_ID = " + this.type_id + " CR_EX_ID = " + s_ex_id + " CR_FROM_QTY <= " + this.trade_qty + " CR_TO_QTY >= " + this.trade_qty);
        }
        rs.close();
        ps.close();
    }

    protected void invokeFrame5() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(updateTrade);
        ps.setBigDecimal(1, this.comm_amount);
        ps.setTimestamp(2, this.trade_dts);
        ps.setString(3, this.st_completed_id);
        ps.setBigDecimal(4, this.trade_price);
        ps.setLong(5, this.trade_id);
        int count = ps.executeUpdate();
        if (logDML) {
            Log.getLogWriter().info("update TRADE set T_COMM = ?, T_DTS = ?, T_ST_ID = ?, T_TRADE_PRICE = ? where T_ID = ? updates T_COMM = " + this.comm_amount + " T_DTS = " + this.trade_dts + " T_ST_ID = " + this.st_completed_id + " T_TRADE_PRICE = " + this.trade_price + " for T_ID = " + this.trade_id);
        }
        if (count != 1) {
            throw new TestException("update TRADE set T_COMM = ?, T_DTS = ?, T_ST_ID = ?, T_TRADE_PRICE = ? where T_ID = ? should updates only 1 row but updated " + count + " row(s) for T_ID = " + this.trade_id);
        }
        ps.close();
        ps = this.conn.prepareStatement(insertTradeHistory);
        ps.setLong(1, this.trade_id);
        ps.setTimestamp(2, this.trade_dts);
        ps.setString(3, this.st_completed_id);
        count = ps.executeUpdate();
        if (logDML) {
            Log.getLogWriter().info("insert into TRADE_HISTORY(TH_T_ID, TH_DTS, TH_ST_ID) values (?, ?, ?) with TH_T_ID = " + this.trade_id + " TH_DTS = " + this.trade_dts + " TH_ST_ID = " + this.st_completed_id);
        }
        if (count != 1) {
            throw new TestException("insert into TRADE_HISTORY(TH_T_ID, TH_DTS, TH_ST_ID) values (?, ?, ?) should inserts 1 row but inserted " + count + " row(s)");
        }
        ps.close();
        ps = this.conn.prepareStatement(updateBroker);
        ps.setBigDecimal(1, this.comm_amount);
        ps.setLong(2, this.broker_id);
        count = ps.executeUpdate();
        if (logDML) {
            Log.getLogWriter().info("update BROKER set B_COMM_TOTAL = B_COMM_TOTAL + ?, B_NUM_TRADES = B_NUM_TRADES + 1 where B_ID = ? set B_COMM_TOTAL = B_COMM_TOTAL + " + this.comm_amount + " B_NUM_TRADES = B_NUM_TRADES + 1 for B_ID = " + this.broker_id);
        }
        if (count != 1) {
            throw new TestException("update BROKER set B_COMM_TOTAL = B_COMM_TOTAL + ?, B_NUM_TRADES = B_NUM_TRADES + 1 where B_ID = ? should updates 1 row but updated " + count + " row(s) for B_ID = " + this.broker_id);
        }
        ps.close();
    }

    protected void invokeFrame6() throws SQLException {
        String cash_type = this.trade_is_cash == 1 ? "Cash Account" : "Margin";
        PreparedStatement ps = this.conn.prepareStatement(insertSettlement);
        ps.setLong(1, this.trade_id);
        ps.setString(2, cash_type);
        ps.setDate(3, this.due_date);
        ps.setBigDecimal(4, this.se_amount);
        int count = ps.executeUpdate();
        if (logDML) {
            Log.getLogWriter().info("insert into SETTLEMENT ( SE_T_ID, SE_CASH_TYPE, SE_CASH_DUE_DATE, SE_AMT) values ( ?, ?, ?, ?) with SE_T_ID = " + this.trade_id + " SE_CASH_TYPE = " + cash_type + " SE_CASH_DUE_DATE = " + this.due_date + " SE_AMT = " + this.se_amount);
        }
        if (count != 1) {
            throw new TestException("insert into SETTLEMENT ( SE_T_ID, SE_CASH_TYPE, SE_CASH_DUE_DATE, SE_AMT) values ( ?, ?, ?, ?) with SE_T_ID = " + this.trade_id + " SE_CASH_TYPE = " + cash_type + " SE_CASH_DUE_DATE = " + this.due_date + " SE_AMT = " + this.se_amount + " should inserts 1 row " + "but inserted " + count + " row(s)");
        }
        ps.close();
        if (this.trade_is_cash == 1) {
            ps = this.conn.prepareStatement(updateCustomerAccount);
            ps.setBigDecimal(1, this.se_amount);
            ps.setLong(2, this.acct_id);
            if (logDML) {
                Log.getLogWriter().info("update CUSTOMER_ACCOUNT set CA_BAL = CA_BAL + ? where CA_ID = ? with CA_BAL = CA_BAL + " + this.se_amount + " for CA_ID = " + this.acct_id);
            }
            if ((count = ps.executeUpdate()) != 1) {
                throw new TestException("update CUSTOMER_ACCOUNT set CA_BAL = CA_BAL + ? where CA_ID = ? for CA_ID = " + this.acct_id + " should inserts 1 row but inserted " + count + " row(s)");
            }
            ps.close();
            ps = this.conn.prepareStatement(insertCashTransaction);
            ps.setTimestamp(1, this.trade_dts);
            ps.setLong(2, this.trade_id);
            ps.setBigDecimal(3, this.se_amount);
            ps.setString(4, this.type_name + " " + this.trade_qty + " shares of " + this.s_name);
            count = ps.executeUpdate();
            if (logDML) {
                Log.getLogWriter().info("insert into CASH_TRANSACTION ( CT_DTS, CT_T_ID, CT_AMT, CT_NAME ) values ( ?, ?, ?, ?) with CT_DTS = " + this.trade_dts + " CT_T_ID = " + this.trade_id + " CT_AMT = " + this.se_amount + " CT_NAME = " + this.type_name + " " + this.trade_qty + " shares of " + this.s_name);
            }
            if (count != 1) {
                throw new TestException("insert into CASH_TRANSACTION ( CT_DTS, CT_T_ID, CT_AMT, CT_NAME ) values ( ?, ?, ?, ?) with CT_DTS = " + this.trade_dts + " CT_T_ID = " + this.trade_id + " CT_AMT = " + this.se_amount + " CT_NAME = " + this.type_name + " " + this.trade_qty + " shares of " + this.s_name + " should inserts 1 row but inserted " + count + " row(s)");
            }
            ps.close();
        }
        ps = this.conn.prepareStatement(selectCABalance);
        ps.setLong(1, this.acct_id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            this.acct_bal = rs.getBigDecimal("CA_BAL");
            if (logDML) {
                Log.getLogWriter().info("select CA_BAL from CUSTOMER_ACCOUNT where CA_ID = ? gets CA_BAL: " + this.acct_bal + " for SCA_ID = " + this.acct_id);
            }
            if (rs.next()) {
                throw new TestException("select CA_BAL from CUSTOMER_ACCOUNT where CA_ID = ? for SCA_ID = " + this.acct_id + " has more than 1 row " + "in result set for S_SYMB = " + this.symbol);
            }
        } else {
            throw new TestException("select CA_BAL from CUSTOMER_ACCOUNT where CA_ID = ? for SCA_ID = " + this.acct_id + " does not get single row " + "in result set for S_SYMB = " + this.symbol);
        }
        rs.close();
        ps.close();
        this.conn.commit();
        if (logDML) {
            Log.getLogWriter().info("committed the trade_result_txn");
        }
    }
}

