/*
 * Decompiled with CFR 0.152.
 */
package sql.tpch;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.QueryUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.ThinClientHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import objects.query.QueryPrms;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.tpch.TPCHStats;
import util.TestException;
import util.TestHelper;

public class TPCHTest
extends QueryPerfClient {
    public static TPCHTest tpchTest;
    public TPCHStats tpchstats;
    public static boolean isClient;
    private static boolean reproduce49166OOME;
    protected static final String SCHEMA_NAME = "TPCHGFXD";
    public static boolean logDML;
    protected static HydraThreadLocal localtpchstats;
    private static String query1;
    private static String query2;
    private static String query3;
    private static String query4;
    private static String query5;

    public static void HydraTask_initailizeClient() {
        isClient = true;
    }

    public static void HydraTask_initializeParameters() {
        if (tpchTest == null) {
            tpchTest = new TPCHTest();
        }
        tpchTest.initLocalVariables(-1);
        tpchTest.initLocalParameters();
    }

    public static void openStatisticsTask() {
        tpchTest.openStatistics();
    }

    private void openStatistics() {
        this.tpchstats = this.getTPCHStats();
        if (this.tpchstats == null) {
            this.tpchstats = TPCHStats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
        this.setTPCHStats(this.tpchstats);
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.tpchstats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.tpchstats.close();
        }
    }

    protected TPCHStats getTPCHStats() {
        TPCHStats tpchstats = (TPCHStats)((Object)localtpchstats.get());
        return tpchstats;
    }

    protected void setTPCHStats(TPCHStats tpchstats) {
        localtpchstats.set((Object)tpchstats);
    }

    @Override
    protected void initLocalParameters() {
        super.initLocalParameters();
        Log.getLogWriter().info("in HydraTask_initializeParameters, this.connection = " + this.connection);
    }

    public static void HydraTask_runSQLScript() throws SQLException {
        if (tpchTest == null) {
            tpchTest = new TPCHTest();
            TPCHTest.tpchTest.queryAPI = QueryPrms.getAPI();
        }
        tpchTest.runSQLScript(true);
    }

    public static void HydraTask_runSQLScriptContinueOnError() throws SQLException {
        tpchTest.runSQLScript(false);
    }

    protected void runSQLScript(boolean failOnError) throws SQLException {
        Connection conn = null;
        switch (this.queryAPI) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 1: {
                conn = this.getSqlfNonTxConnection();
                break;
            }
            default: {
                this.unsupported();
            }
        }
        if (conn == null) {
            throw new TestException("Test issue, connection are not set for other db");
        }
        this.runSQLScript(conn, failOnError);
    }

    protected void runSQLScript(Connection conn, boolean failOnError) throws SQLException {
        String sqlFilePath = SQLPrms.getSqlFilePath();
        Log.getLogWriter().info("running sql script " + sqlFilePath + " on gfxd");
        SQLHelper.runSQLScript(conn, sqlFilePath, failOnError);
    }

    public static void HydraTask_createBucketsTask() throws InterruptedException, SQLException {
        tpchTest.createBuckets();
    }

    protected void createBuckets() throws SQLException {
        if (this.queryAPI == 1) {
            this.assignBucketsForTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignBucketsForTables() throws SQLException {
        try (Connection conn = this.getSqlfNonTxConnection();){
            String sql = "call SYS.CREATE_ALL_BUCKETS( ? )";
            CallableStatement cs = conn.prepareCall(sql);
            List<String> tableNames = this.getPartitionedTables();
            for (String tableName : tableNames) {
                Log.getLogWriter().info("Creating buckets for table " + tableName + ": " + sql);
                cs.setString(1, tableName);
                cs.execute();
                Log.getLogWriter().info("Created buckets for table " + tableName + ": " + sql);
            }
            cs.close();
        }
    }

    public static void closeStatisticsTask() {
        TPCHTest hTest = new TPCHTest();
        hTest.initHydraThreadLocals();
        hTest.closeStatistics();
        hTest.updateHydraThreadLocals();
    }

    protected Connection getConnection(int db) throws SQLException {
        Connection conn = null;
        switch (db) {
            case 1: {
                if (isClient) {
                    conn = QueryUtil.gfxdClientSetup(this);
                    break;
                }
                conn = QueryUtil.gfxdEmbeddedSetup(this);
                break;
            }
            default: {
                throw new TestException("Test issue, other db should not use this method");
            }
        }
        return conn;
    }

    protected Connection getSqlfNonTxConnection() throws SQLException {
        Connection conn;
        if (isClient) {
            conn = QueryUtil.gfxdClientSetup(this);
            conn.setTransactionIsolation(0);
        } else {
            conn = QueryUtil.gfxdEmbeddedSetup(this);
            conn.setTransactionIsolation(0);
        }
        Log.getLogWriter().info("Using transaction isolation level: none");
        return conn;
    }

    public static void HydraTask_runImportTable() throws SQLException {
        if (tpchTest == null) {
            tpchTest = new TPCHTest();
        }
        tpchTest.runImportTable();
    }

    protected void runImportTable() throws SQLException {
        boolean skipConstraints = TestConfig.tab().booleanAt(SQLPrms.skipConstraints, true);
        if (skipConstraints) {
            this.runImportTableSkipConstraints();
        } else {
            this.runImportTableWithConstraints();
        }
    }

    protected void runImportTableWithConstraints() throws SQLException {
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("import table starts from " + start);
        Connection conn = this.getSqlfNonTxConnection();
        this.importTable(conn);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("import table finishes at " + end);
        long time = end - start;
        Log.getLogWriter().info("import_table takes " + time / 1000L + " seconds");
    }

    public static void HydraTask_runImportTableSkipConstraints() throws SQLException {
        tpchTest.runImportTableSkipConstraints();
    }

    protected void runImportTableSkipConstraints() throws SQLException {
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("import table starts from " + start);
        Connection conn = this.getSkipConstraintsConnectionWithSchema();
        this.importTable(conn);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("import table finishes at " + end);
        long time = end - start;
        Log.getLogWriter().info("import_table takes " + time / 1000L + " seconds");
    }

    protected void importTable(Connection conn) throws SQLException {
        StringBuilder sb = this.getSqlScript();
        String[] inst = sb.toString().split(";");
        Statement st = conn.createStatement();
        for (int i = 0; i < inst.length; ++i) {
            try {
                if (inst[i].trim().equals("") || inst[i].contains("exit")) continue;
                TPCHTest.log().info(">>" + inst[i]);
                long start = System.currentTimeMillis();
                st.executeUpdate(inst[i]);
                long end = System.currentTimeMillis();
                Log.getLogWriter().info("executing " + inst[i] + " takes " + ((double)(end - start) / 1000.0 < 30.0 ? (double)(end - start) / 1000.0 + " seconds." : (double)(end - start) / 60000.0 + " minutes."));
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public StringBuilder getSqlScript() {
        String jtests = System.getProperty("JTESTS");
        String sqlFilePath = SQLPrms.getSqlFilePath();
        String s = new String();
        StringBuilder sb = new StringBuilder();
        try {
            FileReader fr = new FileReader(new File(jtests + "/" + sqlFilePath));
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                int indexOfCommentSign = s.indexOf("--");
                if (indexOfCommentSign != -1) {
                    s = s.startsWith("--") ? new String("") : new String(s.substring(0, indexOfCommentSign - 1));
                }
                sb.append(s);
            }
            br.close();
            return sb;
        }
        catch (Exception e) {
            throw new TestException("could not get sql script " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    protected Connection getSkipConstraintsConnectionWithSchema() throws SQLException {
        Connection conn;
        if (isClient) {
            Properties p = ThinClientHelper.getConnectionProperties();
            p.setProperty("skip-constraint-checks", "true");
            Log.getLogWriter().info("setting skip-constraint-checks to true");
            conn = QueryUtil.gfxdClientSetup(this, p);
        } else {
            Properties p = new Properties();
            p.setProperty("skip-constraint-checks", "true");
            Log.getLogWriter().info("setting skip-constraint-checks to true");
            conn = QueryUtil.gfxdEmbeddedSetup(this, p);
        }
        if (!reproduce49166OOME) {
            conn.setTransactionIsolation(0);
            Log.getLogWriter().info("Using transaction isolation level: none");
        }
        return this.getConnectionWithSchema(conn);
    }

    protected Connection getConnectionWithSchema(Connection conn) {
        String sql = "set schema TPCHGFXD";
        try {
            conn.createStatement().execute(sql);
            if (logDML) {
                Log.getLogWriter().info(sql);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return conn;
    }

    protected Connection getConnectionWithSchema() {
        Connection conn = super.getConnection();
        return this.getConnectionWithSchema(conn);
    }

    public static void HydraTask_runTPCHQueries() throws SQLException {
        tpchTest.initialize(6230814);
        tpchTest.runQueries();
    }

    protected void runQueries() throws SQLException {
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.executeQueries();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    protected void executeQueries() throws SQLException {
        List<String> queryList = Arrays.asList(query1, query2, query3, query4, query5);
        int queryNo = 0;
        for (int i = 0; i < queryList.size(); ++i) {
            String query = queryList.get(i);
            Log.getLogWriter().info("Query" + String.valueOf(++queryNo) + " String:  " + query);
            Connection conn = this.getSkipConstraintsConnectionWithSchema();
            this.executeQuery(conn, query, queryNo);
        }
    }

    protected void executeQuery(Connection conn, String query, int queryNo) throws SQLException {
        boolean exception = false;
        Exception ex = null;
        try {
            PreparedStatement stmt = conn.prepareStatement(query);
            long start = System.currentTimeMillis();
            ResultSet set = stmt.executeQuery();
            long end = System.currentTimeMillis();
            this.tpchstats.incQuery(queryNo, 1);
            this.tpchstats.incQueryExecutionTime(queryNo, end - start);
            Log.getLogWriter().info("Query" + String.valueOf(queryNo) + " execution starts from " + start);
            Log.getLogWriter().info("Query" + String.valueOf(queryNo) + " execution finishes at " + end);
            long time = end - start;
            Log.getLogWriter().info("Query" + String.valueOf(queryNo) + " execution time " + time / 1000L + " seconds");
            while (set.next()) {
                Log.getLogWriter().info("executing query" + String.valueOf(queryNo) + " = " + set.getString(1));
            }
        }
        catch (Exception e) {
            exception = true;
            ex = e;
            Log.getLogWriter().info("Encountered exception while running query" + String.valueOf(queryNo) + " :" + e.toString());
        }
        if (exception) {
            throw new TestException("Exception encountered" + ex);
        }
    }

    static {
        isClient = false;
        reproduce49166OOME = false;
        logDML = TestConfig.tab().booleanAt(SQLPrms.logDML, false);
        localtpchstats = new HydraThreadLocal();
        query1 = "select l_returnflag, l_linestatus, sum(l_quantity) as sum_qty, sum(l_extendedprice) as sum_base_price, sum(l_extendedprice*(1-l_discount)) as sum_disc_price, sum(l_extendedprice*(1-l_discount)*(1+l_tax)) as sum_charge, avg(l_quantity) as avg_qty, avg(l_extendedprice) as avg_price, avg(l_discount) as avg_disc,  count(*) as count_order from lineitem where l_shipdate <= cast({fn timestampadd(SQL_TSI_DAY, -90, timestamp('1998-12-01 23:59:59'))} as DATE) group by l_returnflag, l_linestatus order by l_returnflag, l_linestatus";
        query2 = "select s_acctbal, s_name, n_name, p_partkey, p_mfgr, s_address, s_phone, s_comment from   part , supplier, partsupp, nation, region  where   p_partkey = ps_partkey and s_suppkey = ps_suppkey and p_size = 15 and p_type like '%BRASS'   and  s_nationkey = n_nationkey and n_regionkey = r_regionkey and r_name = 'EUROPE'   and  ps_supplycost = ( select min(ps_supplycost) from  part, partsupp, supplier, nation, region where p_partkey = ps_partkey and s_suppkey = ps_suppkey and  s_nationkey = n_nationkey and n_regionkey = r_regionkey  and r_name = 'EUROPE' ) order by s_acctbal desc, n_name, s_name, p_partkey";
        query3 = "select l_orderkey, sum(l_extendedprice*(1-l_discount)) as revenue, o_orderdate, o_shippriority from   customer, orders, lineitem where  c_mktsegment = 'BUILDING' and c_custkey = o_custkey and l_orderkey = o_orderkey   and o_orderdate < '1995-03-15' and l_shipdate > '1995-03-15'  group by   l_orderkey, o_orderdate, o_shippriority order by   revenue desc, o_orderdate";
        query4 = "select o_orderpriority, count(*) as order_count from orders where  o_orderdate >= '1993-07-01'   and o_orderdate < cast({fn timestampadd(SQL_TSI_MONTH, 3, timestamp('1993-07-01 23:59:59'))} as DATE) and  exists (select * from lineitem where l_orderkey = o_orderkey and l_commitdate < l_receiptdate   ) group by   o_orderpriority order by   o_orderpriority";
        query5 = "select n_name, sum(l_extendedprice * (1 - l_discount)) as revenue from   customer, orders, lineitem, supplier, nation, region  where c_custkey = o_custkey and l_orderkey = o_orderkey and l_suppkey = s_suppkey and c_nationkey = s_nationkey  and s_nationkey = n_nationkey and n_regionkey = r_regionkey and r_name = 'ASIA'   and o_orderdate >= '1994-01-01'  and o_orderdate < cast({fn timestampadd(SQL_TSI_YEAR, 1, timestamp('1994-01-01 23:59:59'))} as DATE) group by   n_name order by   revenue desc";
    }
}

