/*
 * Decompiled with CFR 0.152.
 */
package sql.trigger;

import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import sql.DBType;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.DMLStmtIF;
import sql.dmlStatements.TradeCustomersInsertStmt;
import sql.sqlutil.ResultSetHelper;
import sql.trigger.TriggerPrms;
import sql.trigger.TriggerTestBB;
import util.TestException;

public class TriggerTest
extends SQLTest {
    protected static TriggerTest triggerTest;
    DMLStmtIF dmlStmt;
    long pauseSec = TestConfig.tab().longAt(TriggerPrms.pauseSec, 10L);
    boolean audit = TestConfig.tab().booleanAt(TriggerPrms.audit, true);
    boolean manageDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, true);
    boolean createRecursiveTrigger = TestConfig.tab().booleanAt(SQLPrms.createRecursiveTrigger, false);

    public static synchronized void HydraTask_initialize() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
            triggerTest.initialize();
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    public static void HydraTask_createTriggers() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.createProcedures();
        triggerTest.createTriggers();
    }

    @Override
    protected void createProcedures() {
        this.createProcedure(DBType.DERBY);
        this.createProcedure(DBType.GFXD);
    }

    protected void createProcedure(DBType dbType) {
        Connection conn = this.getConnection(dbType);
        String[] procedureStmts = TriggerPrms.getProcedureStmts();
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        try {
            Log.getLogWriter().info("Creating Procedures on " + (Object)((Object)dbType));
            Statement stmt = conn.createStatement();
            for (String procedureStmt : procedureStmts) {
                try {
                    stmt.execute(procedureStmt);
                    Log.getLogWriter().info("Created Java Procedure: " + procedureStmt);
                    this.commit(conn);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(dbType, se, exList);
                }
            }
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(dbType, se, exList);
            throw new TestException("Create Procedure on " + (Object)((Object)dbType) + " Failed");
        }
        this.closeConnection(conn, dbType);
    }

    @Override
    protected void createTriggers() {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (!hasDerbyServer) {
            this.createTrigger(DBType.GFXD, exList);
            return;
        }
        this.createTrigger(DBType.DERBY, exList);
        this.createTrigger(DBType.GFXD, exList);
    }

    protected void createTrigger(DBType dbType, List<SQLException> exList) {
        Connection conn = this.getConnection(dbType);
        String[] triggerStmts = TriggerPrms.getTriggerStmts();
        try {
            Log.getLogWriter().info("Creating Triggers on " + (Object)((Object)dbType));
            Statement stmt = conn.createStatement();
            for (String triggerStmt : triggerStmts) {
                if (dbType == DBType.DERBY && triggerStmt.contains("CALL readProc")) {
                    Log.getLogWriter().info("do not create this trigger in derby as the procedure should not be run on derby");
                    continue;
                }
                try {
                    Log.getLogWriter().info("Executing: " + triggerStmt + " on " + (Object)((Object)dbType));
                    stmt.execute(triggerStmt);
                    Log.getLogWriter().info("Created Trigger: " + triggerStmt + " on " + (Object)((Object)dbType));
                    this.commit(conn);
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("0A000") && this.createRecursiveTrigger) {
                        Log.getLogWriter().info("got expected unsupported exception when creating recursive trigger");
                        continue;
                    }
                    SQLHelper.handleSQLException(dbType, se, exList);
                }
            }
            stmt.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(dbType, se, exList);
        }
        this.closeConnection(conn, dbType);
    }

    public static void HydraTask_dropTriggers() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.dropTriggers();
    }

    @Override
    protected void dropTriggers() {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (!hasDerbyServer) {
            this.dropTrigger(DBType.GFXD, exList);
            return;
        }
        this.dropTrigger(DBType.DERBY, exList);
        this.dropTrigger(DBType.GFXD, exList);
    }

    protected void dropTrigger(DBType dbType, List<SQLException> exList) {
        Connection conn = this.getConnection(dbType);
        String[] dropTriggerStmts = TriggerPrms.getDropTriggerStmts();
        try {
            Log.getLogWriter().info("Dropping Triggers on " + (Object)((Object)dbType));
            Statement stmt = conn.createStatement();
            for (String dropTriggerStmt : dropTriggerStmts) {
                try {
                    stmt.execute(dropTriggerStmt);
                    Log.getLogWriter().info("Dropped Trigger: " + dropTriggerStmt + " on " + (Object)((Object)dbType));
                    this.commit(conn);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(dbType, se, exList);
                }
            }
            stmt.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(dbType, se, exList);
        }
        this.closeConnection(conn, dbType);
    }

    public static void HydraTask_createAndDropTriggers() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.dropTriggers();
        triggerTest.pause();
        triggerTest.createTriggers();
        triggerTest.pause();
    }

    protected void pause() {
        try {
            Thread.sleep(this.pauseSec * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void HydraTask_testInsertActions() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testInsertActions();
    }

    protected void testInsertActions() {
        Connection gConn = this.getGFEConnection();
        if (!hasDerbyServer) {
            this.testInsertActions(null, gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
        } else {
            Connection dConn = this.getDiscConnection();
            this.testInsertActions(dConn, gConn);
            this.commit(dConn);
            this.commit(gConn);
            this.closeDiscConnection(dConn);
            this.closeGFEConnection(gConn);
        }
    }

    protected void testInsertActions(Connection dConn, Connection gConn) {
        this.dmlStmt = new TradeCustomersInsertStmt();
        this.dmlStmt.insert(dConn, gConn, 2);
    }

    public static void HydraTask_testDeleteActions() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testDeleteActions();
    }

    protected void testDeleteActions() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.testDeleteActions(dConn, gConn);
    }

    protected void testDeleteActions(Connection dConn, Connection gConn) {
        try {
            String sql = "delete from trade.customers where cid = 1";
            int dRow = dConn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("Deleted " + dRow + " row from Derby");
            int gRow = gConn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("Deleted " + gRow + " row from GFXD");
            this.commit(dConn);
            this.commit(gConn);
            this.closeDiscConnection(dConn);
            this.closeGFEConnection(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_testUpdateActions() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testUpdateActions();
    }

    protected void testUpdateActions() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.testUpdateActions(dConn, gConn);
    }

    protected void testUpdateActions(Connection dConn, Connection gConn) {
        try {
            String sql = "update trade.customers set addr = 'NEWADDR2' where cid = 2";
            int dRow = dConn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("Updated " + dRow + " row on DERBY");
            int gRow = gConn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("Updated " + gRow + " row on GFXD");
            this.commit(dConn);
            this.commit(gConn);
            this.closeDiscConnection(dConn);
            this.closeGFEConnection(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_testDeleteAll() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testDeleteAll();
    }

    protected void testDeleteAll() {
        this.testDeleteAll(DBType.DERBY);
        this.testDeleteAll(DBType.GFXD);
    }

    protected void testDeleteAll(DBType dbType) {
        try {
            Connection conn = this.getConnection(dbType);
            String sql = "DELETE FROM trade.customers";
            int row = conn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("Deleted " + row + " row on " + (Object)((Object)dbType));
            this.commit(conn);
            String query = "SELECT COUNT(*) FROM trade.customers_audit";
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int num_row = rs.getInt(1);
            Log.getLogWriter().info("Number of rows inserted in audit table : " + num_row);
            rs.close();
            stmt.close();
            this.commit(conn);
            this.closeConnection(conn, dbType);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_testReadProc() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testReadProc();
    }

    protected void testReadProc() {
        Connection gConn = this.getGFEConnection();
        this.testReadProc(gConn);
    }

    protected void testReadProc(Connection gConn) {
        this.dmlStmt = new TradeCustomersInsertStmt();
        this.dmlStmt.insert(null, gConn, 1);
        long num_insert = TriggerTestBB.getBB().getSharedCounters().incrementAndRead(TriggerTestBB.NUM_INSERT);
        Log.getLogWriter().info("Num of before insert called :  " + num_insert);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_testInsertWriter() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testInsertWriter();
    }

    protected void testInsertWriter() {
        this.addWriter("trade", "customers", "sql.trigger.TriggerWriter", "insert writer", "");
        this.dmlStmt = new TradeCustomersInsertStmt();
        Connection conn = this.getGFEConnection();
        this.dmlStmt.insert(null, conn, 1);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_testDeleteWriter() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testDeleteWriter();
    }

    protected void testDeleteWriter() {
        this.addWriter("trade", "customers", "sql.trigger.TriggerWriter", "delete writer", "");
        Connection conn = this.getGFEConnection();
        String sql = "delete from trade.customers where cid = 1";
        try {
            int row = conn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("Deleted " + row + " row from customers table");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_testUpdateWriter() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.testUpdateWriter();
    }

    protected void testUpdateWriter() {
        this.addWriter("trade", "customers", "sql.trigger.TriggerWriter", "update writer", "");
        Connection conn = this.getGFEConnection();
        String sql = "update trade.customers set addr = 'NEWADDR1' where cid = 1";
        try {
            int row = conn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("Updated " + row + " row on customers table");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    private void addWriter(String schemaName, String tableName, String functionStr, String initInfoStr, String serverGroups) {
        Connection conn = this.getGFEConnection();
        try {
            CallableStatement cs = conn.prepareCall("CALL SYS.ATTACH_WRITER(?,?,?,?,?)");
            cs.setString(1, schemaName);
            cs.setString(2, tableName);
            cs.setString(3, functionStr);
            cs.setString(4, initInfoStr);
            cs.setString(5, serverGroups);
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_verifyTriggerResults() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.verifyTriggerResults();
    }

    protected void verifyTriggerResults() {
        if (!this.manageDerbyServer) {
            Connection conn = this.getGFEConnection();
            Log.getLogWriter().info("Comparing tables on GFXD ...");
            this.verifyResultSets(conn, "trade", "customers", "customers_audit");
        } else {
            Connection dConn = this.getDiscConnection();
            Connection gConn = this.getGFEConnection();
            Log.getLogWriter().info("Verifying customers tables on both DBs ...");
            this.verifyResultSets(dConn, gConn, "trade", "customers");
            if (this.audit) {
                Log.getLogWriter().info("Verifying customers_audit tables on both DBs ...");
                this.verifyResultSets(dConn, gConn, "trade", "customers_audit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyResultSets(Connection conn, String schema, String table1, String table2) {
        try {
            String select1 = "select * from " + schema + "." + table1;
            String select2 = "select * from " + schema + "." + table2;
            ResultSet RS1 = conn.createStatement().executeQuery(select1);
            ResultSet RS2 = conn.createStatement().executeQuery(select2);
            ResultSetHelper.compareResultSets(RS1, RS2);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            this.commit(conn);
        }
    }

    public static void HydraTask_verifyProcTriggerResults() {
        if (triggerTest == null) {
            triggerTest = new TriggerTest();
        }
        triggerTest.verifyProcTriggerResults();
    }

    protected void verifyProcTriggerResults() {
        long procCounter;
        long insertCounter = TriggerTestBB.getBB().getSharedCounters().read(TriggerTestBB.NUM_INSERT);
        if (insertCounter != (procCounter = TriggerTestBB.getBB().getSharedCounters().read(TriggerTestBB.NUM_PROC))) {
            Log.getLogWriter().error("Test Failed : Number of procedure calls " + procCounter + "  does not equal to number of insert actions - " + insertCounter);
            throw new TestException("verify results Failed");
        }
    }

    public static void readProc() {
        triggerTest.getInsertCount();
        long num_proc = TriggerTestBB.getBB().getSharedCounters().incrementAndRead(TriggerTestBB.NUM_PROC);
        Log.getLogWriter().info("JAVA Stored Procedure is called " + num_proc + "times");
    }

    protected void getInsertCount() {
        Connection gConn = this.getGFEConnection();
        String query = "SELECT COUNT(*) FROM trade.customers";
        try {
            PreparedStatement stmt = gConn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int num_row = rs.getInt(1);
            Log.getLogWriter().info("Number of rows inserted : " + num_row);
            rs.close();
            stmt.close();
            this.closeGFEConnection(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            throw new TestException("Read SQL Data Failed");
        }
    }
}

