/*
 * Decompiled with CFR 0.152.
 */
package sql.trigger;

import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.EventCallback;
import hydra.Log;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import sql.SQLHelper;
import sql.SQLTest;

public class TriggerWriter
extends SQLTest
implements EventCallback {
    public static TriggerWriter getTriggerCallback() {
        return new TriggerWriter();
    }

    public void close() throws SQLException {
        Log.getLogWriter().info("close writer");
    }

    public void init(String initStr) throws SQLException {
        Log.getLogWriter().info("init writer : " + initStr);
    }

    public void onEvent(Event event) throws SQLException {
        Log.getLogWriter().info("onEvent , Event Type : " + event.getType());
        Connection conn = this.getGFEConnection();
        String sql = null;
        try {
            PreparedStatement stmt;
            if (event.getType().equals((Object)Event.Type.BEFORE_INSERT)) {
                List row = event.getNewRow();
                sql = "insert into trade.customers_audit values(?,?,?,?,?)";
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, (Integer)row.get(0));
                stmt.setString(2, (String)row.get(1));
                stmt.setDate(3, (Date)row.get(2));
                stmt.setString(4, (String)row.get(3));
                stmt.setInt(5, (Integer)row.get(4));
            } else if (event.getType().equals((Object)Event.Type.BEFORE_DELETE)) {
                List row = event.getOldRow();
                sql = "delete from trade.customers_audit where cid = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, (Integer)row.get(0));
            } else if (event.getType().equals((Object)Event.Type.BEFORE_UPDATE)) {
                List row = event.getNewRow();
                sql = "update trade.customers_audit set addr = ? where cid = 1";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, (String)row.get(3));
            } else {
                throw new IllegalArgumentException("Unknown Event Type " + event.getType());
            }
            int numRow = stmt.executeUpdate();
            Log.getLogWriter().info("SZHU modified " + numRow + " row to audit table");
            stmt.close();
            this.commit(conn);
            conn.commit();
            this.closeGFEConnection(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }
}

