/*
 * Decompiled with CFR 0.152.
 */
package sql.view;

import hydra.HydraVector;
import hydra.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.SQLHelper;
import sql.SQLThinClientTest;
import sql.sqlutil.ResultSetHelper;
import sql.view.ViewPrms;

public class ViewTest
extends SQLThinClientTest {
    public static ViewTest viewTest = new ViewTest();

    public static void HydraTask_createDiscViews() {
        viewTest.createDiscViews();
    }

    public static void HydraTask_createGfxdViewsByClients() {
        viewTest.createGfxdViews(true);
    }

    public static void HydraTask_populateViewBaseTablesByClients() {
        viewTest.populateViewBaseTables(true);
    }

    public static void HydraTask_queryViewByClients() {
        viewTest.queryView(true);
    }

    public static void HydraTask_queryAndVerifyViewByClients() {
        viewTest.queryAndVerifyView(true);
    }

    public static void HydraTask_verifyViewResultsByClients() {
        viewTest.verifyViewResults(true);
    }

    public static void HydraTask_createGfxdViewsByPeers() {
        viewTest.createGfxdViews(false);
    }

    public static void HydraTask_populateViewBaseTablesByPeers() {
        viewTest.populateViewBaseTables(false);
    }

    public static void HydraTask_queryViewByPeers() {
        viewTest.queryView(false);
    }

    public static void HydraTask_queryAndVerifyViewByPeers() {
        viewTest.queryAndVerifyView(false);
    }

    public static void HydraTask_verifyViewResultsByPeers() {
        viewTest.verifyViewResults(false);
    }

    protected void queryView(boolean gfxdclient) {
        HydraVector queryVec = ViewPrms.getQueryViewsStatements();
        String viewQuery = (String)queryVec.get(random.nextInt(queryVec.size()));
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.queryResultSets(dConn, gConn, viewQuery, false);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void queryAndVerifyView(boolean gfxdclient) {
        HydraVector queryVec = ViewPrms.getQueryViewsStatements();
        String viewQuery = (String)queryVec.get(random.nextInt(queryVec.size()));
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.queryResultSets(dConn, gConn, viewQuery, true);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyViewResults(boolean gfxdclient) {
        HydraVector queryVec = ViewPrms.getQueryViewsStatements();
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        for (int i = 0; i < queryVec.size(); ++i) {
            String viewQuery = (String)queryVec.get(i);
            this.queryResultSets(dConn, gConn, viewQuery, true);
        }
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void queryResultSets(Connection dConn, Connection gConn, String queryStr, boolean verify) {
        try {
            Log.getLogWriter().info("Query view: " + queryStr);
            ResultSet dRS = dConn.createStatement().executeQuery(queryStr);
            ResultSet gRS = gConn.createStatement().executeQuery(queryStr);
            if (verify) {
                ResultSetHelper.compareResultSets(dRS, gRS);
            }
            this.commit(dConn);
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void populateViewBaseTables(boolean gfxdclient) {
        Connection conn;
        String viewDataPath = ViewPrms.getViewDataFilePath();
        if (hasDerbyServer) {
            conn = this.getDiscConnection();
            Log.getLogWriter().info("Populating view base tables in disc using sql script: " + viewDataPath);
            SQLHelper.runDerbySQLScript(conn, viewDataPath, true);
            Log.getLogWriter().info("done populating view base tables in disc.");
            this.closeDiscConnection(conn);
        }
        conn = this.getGFEConnection();
        Log.getLogWriter().info("Populating view base tables in gfxd using sql script: " + viewDataPath);
        SQLHelper.runSQLScript(conn, viewDataPath, true);
        Log.getLogWriter().info("done populating view base tables in gfxd.");
        this.closeGFEConnection(conn);
    }

    protected void createDiscViews() {
        if (!hasDerbyServer) {
            return;
        }
        Connection conn = this.getDiscConnection();
        String viewDDLPath = ViewPrms.getViewDDLFilePath();
        Log.getLogWriter().info("creating views on disc using sql script: " + viewDDLPath);
        SQLHelper.runDerbySQLScript(conn, viewDDLPath, true);
        Log.getLogWriter().info("done creating views on disc.");
        this.closeDiscConnection(conn);
    }

    protected void createGfxdViews(boolean gfxdclient) {
        Connection conn = this.getGFEConnection();
        String viewDDLPath = ViewPrms.getViewDDLFilePath();
        Log.getLogWriter().info("creating views in gfxd using sql script: " + viewDDLPath);
        SQLHelper.runSQLScript(conn, viewDDLPath, true);
        Log.getLogWriter().info("done creating views in gfxd.");
        this.closeGFEConnection(conn);
    }
}

