/*
 * Decompiled with CFR 0.152.
 */
package sql.wan;

import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import hydra.ClientVmInfo;
import hydra.ConfigHashtable;
import hydra.HostHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GatewayReceiverHelper;
import hydra.gemfirexd.GatewaySenderPrms;
import hydra.gemfirexd.GfxdConfigPrms;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import sql.ClientDiscDBManager;
import sql.DiscDBManager;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.FunctionDDLStmt;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanBB;
import sql.wan.SQLWanPrms;
import sql.wan.SQLWanSenderBB;
import util.PRObserver;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class WanTest
extends SQLTest {
    protected static WanTest wanTest = new WanTest();
    static final String diskStore = "WanDiskStore";
    protected static String sgSender = "sgSender";
    protected static String sgReceiver = "sgReceiver";
    private static final String SPACE = " ";
    public static ConfigHashtable conftab = TestConfig.tab();
    public static int myVMid = RemoteTestModule.getMyVmid();
    public static int numOfPeersPerSite = conftab.intAt(SQLWanPrms.numOfPeersPerSite, 0);
    public static int numOfDataStoresPerSite = conftab.intAt(SQLWanPrms.numOfDataStoresPerSite, 0);
    public static int numOfLocators = conftab.intAt(SQLWanPrms.numOfLocators);
    public static int numOfAccessors = conftab.intAt(SQLWanPrms.numOfAccessors, 0);
    public static int numOfWanSites = conftab.intAt(SQLWanPrms.numOfWanSites);
    public static int numOfThreadPerVM = conftab.intAt(SQLWanPrms.numOfThreadsPerVM, 0);
    public static int numOfThreadsPerSite = conftab.intAt(SQLWanPrms.numOfThreadsPerSite, 0);
    public static int numOfAccessorThreadsPerSite = conftab.intAt(SQLWanPrms.numOfAccessorThreadsPerSite, 0);
    public static int numOfThreadPerStoreVM = conftab.intAt(SQLWanPrms.numOfThreadsPerStoreVM, 0);
    public static int numOfThreadsPerAccessorVM = conftab.intAt(SQLWanPrms.numOfThreadsPerAccessorVM, 0);
    public static boolean setupDataStore = false;
    public static boolean isWanAccessorsConfig = conftab.booleanAt(SQLWanPrms.isWanAccessorsConfig, false);
    public static boolean enableQueueConflation = conftab.booleanAt(SQLWanPrms.enableQueueConflation, false);
    public static boolean manualStart = conftab.booleanAt(GatewaySenderPrms.manualStart, false);
    public static boolean isParallel = conftab.booleanAt(GatewaySenderPrms.isParallel, false);
    public static Blackboard bb = SQLBB.getBB();
    public static boolean isAccessor = false;
    public static boolean isStore = false;
    public static int derbyDDLThread = -1;
    public static int gfeDDLThread = -1;
    public static int myWanSite = -1;
    public String sg;
    String gatewayID = "gatewayID";
    public static SQLWanBB wanBB = SQLWanBB.getBB();
    public static SQLWanSenderBB senderBB = SQLWanSenderBB.getBB();
    public static boolean useSamePartitionAllWanSites = conftab.booleanAt(SQLWanPrms.useSamePartitionAllWanSites, false);
    public static boolean isSingleSitePublisher = TestConfig.tab().booleanAt(SQLWanPrms.isSingleSitePublisher, false);
    public static boolean isTicket43696Fixed = false;
    public static boolean isSender = false;
    public static boolean isAllToAll = false;
    public static boolean isSerial = false;
    public static boolean withChildSite = false;
    public static int childSite = -1;
    protected static Object indexLock = new Object();
    protected static boolean toCreateIndex = true;
    public static boolean useDefaultSenderSetting = TestConfig.tab().booleanAt(SQLWanPrms.useDefaultSenderSetting, false);

    public static void createLocatorTask() {
        FabricServerHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        if (networkServerConfig == null) {
            Log.getLogWriter().info("Starting peer locator only");
            FabricServerHelper.startLocator();
        } else {
            Log.getLogWriter().info("Starting network locator");
            FabricServerHelper.startLocator(networkServerConfig);
        }
    }

    public static void stopLocatorTask() {
        FabricServerHelper.stopLocator();
    }

    public static void stopServerTask() {
        FabricServerHelper.stopFabricServer();
    }

    public static synchronized void HydraTask_initialize() {
        wanTest.initialize();
        if (sqlTest == null) {
            sqlTest = new SQLTest();
        }
    }

    @Override
    protected void initialize() {
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        super.initialize();
    }

    public static void HydraTask_initWanTest() {
        wanTest.initWanTest();
    }

    protected void initWanTest() {
        if (numOfWanSites > 5) {
            throw new TestException("test could not handle more than 5 wan sites yet");
        }
        if (hasHdfs) {
            --myVMid;
        }
        myWanSite = FabricServerHelper.getDistributedSystemId();
        if (myVMid < numOfAccessors) {
            isAccessor = true;
            int whichOne = (int)bb.getSharedCounters().incrementAndRead(SQLBB.wanDerbyDDLThread);
            if (whichOne == 1) {
                derbyDDLThread = WanTest.myTid();
                Log.getLogWriter().info("derbyDDLThread is " + derbyDDLThread);
            }
            if (WanTest.myTid() % numOfAccessorThreadsPerSite == 0) {
                gfeDDLThread = WanTest.myTid();
                Log.getLogWriter().info("gfeDDLThread is " + gfeDDLThread);
                Log.getLogWriter().info("testUniqueKeys is " + testUniqueKeys);
                Log.getLogWriter().info("withReplicateTables is " + TestConfig.tab().booleanAt(SQLPrms.withReplicatedTables, false));
            }
        }
        if (numOfAccessors == 0) {
            throw new TestException("test issue, num of accessors must set in the conf");
        }
        if (myVMid >= numOfAccessors && myVMid < numOfAccessors + numOfDataStoresPerSite * numOfWanSites) {
            int storeId = myVMid - numOfAccessors;
            if (isParallel) {
                isSender = true;
            } else if (storeId % numOfDataStoresPerSite == 0 || storeId % numOfDataStoresPerSite == 1) {
                isSender = true;
            }
        }
    }

    public static void HydraTask_initBBForWanConfig() {
        if (WanTest.myTid() == derbyDDLThread) {
            wanTest.initBBForWanConfig();
        }
    }

    protected void initBBForWanConfig() {
        boolean enableQueuePersistence = conftab.booleanAt(SQLWanPrms.enableQueuePersistence, false);
        bb.getSharedMap().put((Object)"enableQueuePersistence", (Object)enableQueuePersistence);
        Log.getLogWriter().info("enableQueuePersistence is " + enableQueuePersistence);
        int whichOne = random.nextInt(3);
        switch (whichOne) {
            case 0: {
                isAllToAll = true;
                break;
            }
            case 1: {
                isSerial = true;
                break;
            }
            case 2: {
                withChildSite = true;
                childSite = random.nextInt(numOfWanSites) + 1;
            }
        }
        wanBB.getSharedMap().put((Object)"isAllToAll", (Object)isAllToAll);
        wanBB.getSharedMap().put((Object)"isSerial", (Object)isSerial);
        wanBB.getSharedMap().put((Object)"withChildSite", (Object)withChildSite);
        wanBB.getSharedMap().put((Object)"childSite", (Object)childSite);
    }

    public static synchronized void HydraTask_startFabricServerTask() {
        wanTest.startFabricServerTask();
    }

    protected void startFabricServerTask() {
        if (isSender) {
            this.startFabricServerSGSender();
        } else {
            this.startFabricServer();
        }
    }

    public static synchronized void HydraTask_startFabricServerSGTask() {
        wanTest.startFabricServerSGTask();
    }

    protected void startFabricServerSGTask() {
        if (isSender) {
            this.startFabricServerSGSender();
        } else {
            this.startFabricServerSG();
        }
    }

    public static void HydraTask_initForServerGroup() {
        wanTest.initForServerGroup();
    }

    @Override
    protected void initForServerGroup() {
        if (derbyDDLThread == WanTest.myTid()) {
            super.initForServerGroup();
        }
    }

    @Override
    protected String getSGForNode() {
        String sg;
        HydraVector vec = TestConfig.tab().vecAt(SQLPrms.serverGroups);
        int whichOne = -1;
        if (numOfDataStoresPerSite < 6) {
            throw new TestException("not enough data node per site to satisfy all server group requirement must have at least 6 data node per site, but this test only has " + numOfDataStoresPerSite);
        }
        if (myVMid >= numOfAccessors && myVMid < numOfAccessors + numOfDataStoresPerSite * numOfWanSites) {
            int storeId = myVMid - numOfAccessors - 2;
            whichOne = storeId % numOfDataStoresPerSite;
            Log.getLogWriter().info("which one is " + whichOne);
        }
        if (whichOne >= vec.size()) {
            whichOne = vec.size() - 1;
        }
        if ((sg = (String)((HydraVector)vec.elementAt(whichOne)).elementAt(0)).startsWith("random")) {
            ArrayList serverGroups = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"serverGroups");
            if (whichOne >= serverGroups.size()) {
                whichOne = random.nextInt(serverGroups.size());
            }
            sg = (String)serverGroups.get(whichOne);
        }
        Log.getLogWriter().info("This data store is in " + sg);
        return sg;
    }

    protected void startFabricServerSGSender() {
        Log.getLogWriter().info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        if (p != null && "false".equalsIgnoreCase(p.getProperty("host-data"))) {
            throw new TestException("test configure issue: fabric server sg must be a data node");
        }
        p.setProperty("server-groups", sgSender);
        Log.getLogWriter().info("This data store is in " + sgSender);
        this.setClientVmInfoForSenderNode();
        this.startFabricServer(p);
    }

    protected void setClientVmInfoForSenderNode() {
        ClientVmInfo target = new ClientVmInfo(RemoteTestModule.getMyVmid());
        if (target.getVmid() % 2 == 0) {
            wanBB.getSharedMap().put((Object)("wan_" + myWanSite + "_sender1"), (Object)target);
            Log.getLogWriter().info("wan_" + myWanSite + "_sender1: client vmID is " + target.getVmid());
        } else {
            wanBB.getSharedMap().put((Object)("wan_" + myWanSite + "_sender2"), (Object)target);
            Log.getLogWriter().info("wan_" + myWanSite + "_sender2: client vmID is " + target.getVmid());
        }
    }

    protected void startFabricServerSGReciever() {
        Log.getLogWriter().info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        if (p != null && "false".equalsIgnoreCase(p.getProperty("host-data"))) {
            throw new TestException("test configure issue: fabric server sg must be a data node");
        }
        p.setProperty("server-groups", sgReceiver);
        Log.getLogWriter().info("This data store is in " + sgReceiver);
        this.startFabricServer(p);
    }

    public static synchronized void HydraTask_createGatewaySenders() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.createGatewaySenders();
        }
    }

    protected int getNextRemoteSiteId() {
        int myWanSiteId = myWanSite;
        return this.getNextRemoteSiteId(myWanSiteId);
    }

    protected int getNextRemoteSiteId(int myWanSiteId) {
        return ++myWanSiteId > numOfWanSites ? myWanSiteId % numOfWanSites : myWanSiteId;
    }

    protected int getRandomRemoteSiteId() {
        int myWanSiteId = FabricServerHelper.getDistributedSystemId();
        return this.getRandomRemoteSiteId(myWanSiteId);
    }

    protected int getRandomRemoteSiteId(int myWanSiteId) {
        int nextWanSiteId = this.getNextRemoteSiteId(myWanSiteId);
        int randomRemoteSiteId = random.nextInt(numOfWanSites) + 1;
        while (randomRemoteSiteId == myWanSiteId || randomRemoteSiteId == nextWanSiteId) {
            randomRemoteSiteId = random.nextInt(numOfWanSites) + 1;
        }
        return randomRemoteSiteId;
    }

    protected void createGatewaySenders() {
        block14: {
            int[] remoteSiteIds;
            block13: {
                int parentSite;
                remoteSiteIds = this.getRemoteSiteIds();
                int[] allIds = this.getAllSitesIds();
                if (remoteSiteIds != null) break block13;
                isAllToAll = (Boolean)wanBB.getSharedMap().get((Object)"isAllToAll");
                isSerial = (Boolean)wanBB.getSharedMap().get((Object)"isSerial");
                withChildSite = (Boolean)wanBB.getSharedMap().get((Object)"withChildSite");
                childSite = (Integer)wanBB.getSharedMap().get((Object)"childSite");
                if (isAllToAll) {
                    Log.getLogWriter().info("isAllToAll is " + isAllToAll);
                }
                if (isSerial) {
                    Log.getLogWriter().info("isSerial is " + isSerial);
                }
                if (withChildSite) {
                    Log.getLogWriter().info("withChildSite is " + withChildSite);
                    Log.getLogWriter().info("child site is " + childSite);
                }
                if (isSerial) {
                    this.createGatewaySender(this.getNextRemoteSiteId());
                }
                if (isAllToAll) {
                    for (int id : allIds) {
                        if (id == myWanSite) continue;
                        this.createGatewaySender(id);
                    }
                }
                if (!withChildSite) break block14;
                int n = parentSite = numOfWanSites == childSite ? 1 : childSite + 1;
                if (myWanSite == childSite) {
                    this.createGatewaySender(this.getNextRemoteSiteId());
                } else if (myWanSite == parentSite) {
                    for (int id : allIds) {
                        if (id == myWanSite) continue;
                        this.createGatewaySender(id);
                    }
                } else {
                    for (int id : allIds) {
                        if (id == myWanSite || id == childSite) continue;
                        this.createGatewaySender(id);
                    }
                }
                break block14;
            }
            for (int id : remoteSiteIds) {
                this.createGatewaySender(id);
            }
        }
    }

    protected int[] getAllSitesIds() {
        int[] ids = new int[numOfWanSites];
        for (int i = 0; i < numOfWanSites; ++i) {
            ids[i] = i + 1;
        }
        return ids;
    }

    protected int[] getRemoteSiteIds() {
        HydraVector remoteSiteIds = TestConfig.tab().vecAt(SQLWanPrms.mineToRemoteId, new HydraVector());
        if (remoteSiteIds.size() == 0) {
            return null;
        }
        String thisWanRemoteIds = (String)remoteSiteIds.elementAt(myWanSite - 1);
        Log.getLogWriter().info("thisWanRemoteIds is " + thisWanRemoteIds);
        if (thisWanRemoteIds.startsWith("random")) {
            return null;
        }
        String s = thisWanRemoteIds.replaceAll(SPACE, "");
        String[] ids = s.split(",");
        int[] rids = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            rids[i] = Integer.parseInt(ids[i]);
        }
        return rids;
    }

    protected void createGatewaySender(int remoteSiteId) {
        String ddl = this.getSenderDDL(remoteSiteId);
        Connection conn = this.getGFEConnection();
        try {
            Log.getLogWriter().info("executing " + ddl);
            conn.createStatement().execute(ddl);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected String getSenderDDL(int remoteDSID) {
        String senderID = "sender_" + myWanSite + "_" + remoteDSID;
        ArrayList<String> senderIDs = (ArrayList<String>)wanBB.getSharedMap().get((Object)(myWanSite + "_senderIDs"));
        if (senderIDs == null) {
            senderIDs = new ArrayList<String>();
        }
        senderIDs.add(senderID);
        wanBB.getSharedMap().put((Object)(myWanSite + "_senderIDs"), senderIDs);
        StringBuilder buf = new StringBuilder();
        StringBuilder parallelSenderConfig = new StringBuilder();
        if (isParallel || !random.nextBoolean()) {
            parallelSenderConfig.append("isparallel").append(SPACE).append(isParallel).append(SPACE);
        }
        String senderConfig = useDefaultSenderSetting || random.nextBoolean() ? SPACE : this.getSenderConfig();
        buf.append("CREATE GATEWAYSENDER ").append(senderID).append(" ( ").append("remotedsid").append(SPACE).append(remoteDSID).append(SPACE).append(senderConfig).append(parallelSenderConfig.toString()).append(")");
        buf.append(" SERVER GROUPS ( ").append(sgSender).append(" )");
        return buf.toString();
    }

    protected String getSenderConfig() {
        StringBuilder buf = new StringBuilder();
        int socketReadTimeOut = conftab.intAt(GatewaySenderPrms.socketReadTimeout, random.nextInt(10000) + 5000);
        int batchSize = random.nextInt(200) + 50;
        int batchTimeInterval = random.nextInt(2000) + 500;
        boolean enableQueuePersistence = (Boolean)bb.getSharedMap().get((Object)"enableQueuePersistence");
        boolean diskSynchronous = random.nextBoolean();
        int maxQueueMemory = random.nextInt(200) + 10;
        int alertThreashold = random.nextInt(60000) + 60000;
        if (random.nextBoolean()) {
            buf.append("socketreadtimeout").append(SPACE).append(socketReadTimeOut).append(SPACE);
        }
        if (random.nextBoolean()) {
            buf.append("manualstart").append(SPACE).append(manualStart).append(SPACE);
        }
        if (random.nextBoolean()) {
            buf.append("enablebatchconflation").append(SPACE).append(enableQueueConflation).append(SPACE);
        }
        if (random.nextBoolean()) {
            buf.append("batchsize").append(SPACE).append(batchSize).append(SPACE);
        }
        if (random.nextBoolean()) {
            buf.append("batchtimeinterval").append(SPACE).append(batchTimeInterval).append(SPACE);
        }
        if (enableQueuePersistence || random.nextBoolean()) {
            buf.append("enablepersistence").append(SPACE).append(enableQueuePersistence).append(SPACE);
        }
        if (enableQueuePersistence) {
            if (random.nextBoolean()) {
                buf.append("disksynchronous").append(SPACE).append(diskSynchronous).append(SPACE);
            } else {
                Log.getLogWriter().info("Gateway sender DISKSYNCHRONOUS uses default");
            }
        }
        if (random.nextBoolean()) {
            buf.append("diskstorename").append(SPACE).append(diskStore).append(SPACE);
        }
        if (random.nextBoolean()) {
            buf.append("maxqueuememory").append(SPACE).append(maxQueueMemory).append(SPACE);
        }
        if (random.nextBoolean()) {
            buf.append("alertthreshold").append(SPACE).append(alertThreashold).append(SPACE);
        }
        return buf.toString();
    }

    public static synchronized void HydraTask_createGatewayReceivers() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.createGatewayReceivers();
        }
    }

    protected void createGatewayReceivers() {
        this.createGatewayReceivers(sgSender);
    }

    protected void createGatewayReceivers(Connection conn, String sg) {
        try {
            Statement stmt = conn.createStatement();
            List<String> ddls = GatewayReceiverHelper.getGatewayReceiverDDL(myWanSite);
            for (String ddl : ddls) {
                Log.getLogWriter().info("Executing " + ddl + " SERVER GROUPS (" + sg + ")");
                stmt.execute(ddl + " SERVER GROUPS (" + sg + ")");
                Log.getLogWriter().info("Executed " + ddl + " SERVER GROUPS (" + sg + ")");
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createGatewayReceivers(String sg) {
        Connection gConn = this.getGFEConnection();
        this.createGatewayReceivers(gConn, sg);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_createGFEDataStore() {
        wanTest.createGFEDataStore();
    }

    public static synchronized void HydraTask_createGFXDDB() {
        wanTest.createGFXDDB();
    }

    @Override
    protected void createGFEDataStore() {
        if (!setupDataStore) {
            this.setupDataStore();
            setupDataStore = true;
        }
    }

    protected void setupDataStore() {
        this.sg = !isWanAccessorsConfig ? "SG" + ((myVMid - numOfLocators) % numOfPeersPerSite + 1) : "SG" + ((myVMid - numOfLocators - numOfAccessors) % numOfDataStoresPerSite + 1);
        Properties info = this.getGemFireProperties();
        info.setProperty("host-data", "true");
        Log.getLogWriter().info("This data store is in " + this.sg);
        info.setProperty("server-groups", this.sg);
        this.startGFXDDB(info);
    }

    public static void HydraTask_setUpGatewayHub() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.createGatewayHub();
        }
    }

    public static void HydraTask_addGateway() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.addGateway();
            wanTest.addGatewayEndPoint();
        }
    }

    public static void HydraTask_startGatewayHub() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.startGatewayHub();
        }
    }

    public static void HydraTask_startGateway() {
    }

    protected void createGatewayHub() {
        Connection conn = this.getGFEConnection();
        String hubID = "hub_" + myWanSite;
        String hostname = HostHelper.getLocalHost();
        String sg = null;
        for (int i = 1; i < numOfDataStoresPerSite + 1; ++i) {
            sg = "SG" + i;
            this.createGatewayHub(conn, hubID, hostname, sg, i);
        }
    }

    protected void createGatewayHub(Connection conn, String hubID, String hostname, String sg, int portIndex) {
        int hubPort = -1;
        int[] freeTCPPorts = null;
        try {
            CallableStatement cs = conn.prepareCall("CALL SYS.ADD_GATEWAY_HUB(?,?, ?,?,?,?,?)");
            if (wanBB.getSharedCounters().incrementAndRead(SQLWanBB.synchWanEndPorts) == 1L) {
                freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts((int)(numOfWanSites * numOfDataStoresPerSite));
                SQLWanBB.getBB().getSharedMap().put((Object)"wanEndPoints", (Object)freeTCPPorts);
                StringBuilder ports = new StringBuilder();
                for (int port : freeTCPPorts) {
                    ports.append(port + ", ");
                }
                Log.getLogWriter().info("Free TCP ports are :" + ports.toString());
            }
            freeTCPPorts = (int[])SQLWanBB.getBB().getSharedMap().get((Object)"wanEndPoints");
            while (freeTCPPorts == null) {
                MasterController.sleepForMs((int)300);
                freeTCPPorts = (int[])SQLWanBB.getBB().getSharedMap().get((Object)"wanEndPoints");
            }
            hubPort = freeTCPPorts[(myWanSite - 1) * numOfDataStoresPerSite + (portIndex - 1)];
            cs.setString(1, sg);
            cs.setString(2, hubID);
            cs.setInt(3, hubPort);
            cs.setNull(4, 4);
            cs.setNull(5, 4);
            int startupPolicy = random.nextInt(3);
            if (startupPolicy == 0) {
                cs.setNull(6, 12);
            } else if (startupPolicy == 1) {
                cs.setString(6, "primary");
            } else {
                cs.setString(6, "secondary");
                Log.getLogWriter().info("trying to become secondaary");
            }
            if (random.nextBoolean()) {
                cs.setNull(7, 16);
            } else {
                cs.setBoolean(7, true);
                Log.getLogWriter().info("Need to manually start hub");
            }
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        ArrayList<Integer> hubPorts = (ArrayList<Integer>)bb.getSharedMap().get((Object)("portID_wanSite" + myWanSite));
        if (hubPorts == null) {
            hubPorts = new ArrayList<Integer>();
        }
        hubPorts.add(hubPort);
        bb.getSharedMap().put((Object)("portID_wanSite" + myWanSite), hubPorts);
        bb.getSharedMap().put((Object)("hostname_wanSite" + myWanSite), (Object)hostname);
        Log.getLogWriter().info("my wan site is " + myWanSite);
        Log.getLogWriter().info("server group that hub is created on is " + sg);
        Log.getLogWriter().info("the hub created on port " + hubPort);
    }

    protected void addGateway() {
        Connection conn = this.getGFEConnection();
        boolean enableQueuePersistence = (Boolean)bb.getSharedMap().get((Object)"enableQueuePersistence");
        Log.getLogWriter().info("adding Gateway");
        for (int i = 1; i <= numOfWanSites; ++i) {
            if (i == myWanSite) continue;
            try {
                CallableStatement cs1 = conn.prepareCall("CALL SYS.ADD_GATEWAY(?, ?)");
                CallableStatement cs2 = conn.prepareCall("CALL SYS.CONFIGURE_GATEWAY_QUEUE(?,?,?,?,?,?,?,?,?)");
                cs1.setString(1, "hub_" + myWanSite);
                cs1.setString(2, this.gatewayID + i);
                cs1.execute();
                this.commit(conn);
                Log.getLogWriter().info("gateway " + this.gatewayID + i + " is created for hub_" + myWanSite);
                cs2.setString(1, "hub_" + myWanSite);
                cs2.setString(2, this.gatewayID + i);
                cs2.setNull(3, 4);
                cs2.setNull(4, 4);
                cs2.setBoolean(5, enableQueueConflation);
                cs2.setNull(6, 4);
                if (random.nextBoolean()) {
                    cs2.setNull(7, 12);
                    Log.getLogWriter().info("no specific diskstore provided");
                } else {
                    cs2.setString(7, diskStore);
                }
                cs2.setBoolean(8, enableQueuePersistence);
                cs2.setNull(9, 4);
                cs2.execute();
                this.commit(conn);
                Log.getLogWriter().info("Gateway and gateway queue are added");
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void addGatewayEndPoint() {
        Connection conn = this.getGFEConnection();
        String gatewayID = "gatewayID";
        Log.getLogWriter().info("adding Gateway end point");
        try {
            CallableStatement cs = conn.prepareCall("CALL SYS.ADD_GATEWAY_ENDPOINT(?, ?,?,?)");
            for (int i = 1; i <= numOfWanSites; ++i) {
                if (myWanSite == i) continue;
                ArrayList ports = (ArrayList)bb.getSharedMap().get((Object)("portID_wanSite" + i));
                Iterator i$ = ports.iterator();
                while (i$.hasNext()) {
                    int port = (Integer)i$.next();
                    String hostname = (String)bb.getSharedMap().get((Object)("hostname_wanSite" + i));
                    cs.setString(1, "hub_" + myWanSite);
                    cs.setString(2, gatewayID + i);
                    cs.setString(3, hostname);
                    cs.setInt(4, port);
                    cs.execute();
                    this.commit(conn);
                    Log.getLogWriter().info("added end point for hub_" + myWanSite + ": remote hubID: hub_" + i + " port#: " + port);
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void startGatewayHub() {
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("starting the gateway hub_" + myWanSite);
        try {
            CallableStatement cs = conn.prepareCall("CALL SYS.START_GATEWAY_HUB(?,?)");
            cs.setString(1, "hub_" + myWanSite);
            cs.setBoolean(2, true);
            cs.execute();
            Log.getLogWriter().info("gateway hub_" + myWanSite + " is started.");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    @Override
    protected void createTables(Connection conn) {
        String url;
        try {
            String driver = conn.getMetaData().getDriverName();
            url = conn.getMetaData().getURL();
            Log.getLogWriter().info("Driver name is " + driver + " url is " + url);
        }
        catch (SQLException se) {
            throw new TestException("Not able to get driver name" + TestHelper.getStackTrace((Throwable)se));
        }
        String[] derbyTables = SQLPrms.getCreateTablesStatements(true);
        String[] gfeDDL = null;
        try {
            Statement s = conn.createStatement();
            if (url.equals(DiscDBManager.getUrl()) || url.equals(ClientDiscDBManager.getUrl())) {
                for (int i = 0; i < derbyTables.length; ++i) {
                    Log.getLogWriter().info("about to create table " + derbyTables[i]);
                    s.execute(derbyTables[i]);
                    Log.getLogWriter().info("created table " + derbyTables[i]);
                }
            } else if (url.equals(GFEDBManager.getUrl()) || url.startsWith(GFEDBClientManager.getProtocol())) {
                if (!testPartitionBy) {
                    gfeDDL = SQLPrms.getGFEDDL();
                } else {
                    while (wanBB.getSharedCounters().incrementAndRead(SQLWanBB.synchWanSiteParitionKeys) != 1L) {
                        Log.getLogWriter().info("waiting for synchWanSiteParitionKeys to become 1");
                        MasterController.sleepForMs((int)500);
                    }
                    if (!useSamePartitionAllWanSites) {
                        gfeDDL = this.getGFEDDLPartition();
                    } else if (wanBB.getSharedMap().get((Object)"gfeDDL") == null) {
                        gfeDDL = this.getGFEDDLPartition();
                        wanBB.getSharedMap().put((Object)"gfeDDL", (Object)gfeDDL);
                    } else {
                        gfeDDL = (String[])wanBB.getSharedMap().get((Object)"gfeDDL");
                    }
                    this.writePartitionForWanSites();
                    wanBB.getSharedMap().put((Object)("numOfPRs" + myWanSite), (Object)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs));
                    Log.getLogWriter().info("numOfPRs is " + SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs));
                    Log.getLogWriter().info("put numOfPRs into wanBB for " + myWanSite);
                    wanBB.getSharedCounters().zero(SQLWanBB.synchWanSiteParitionKeys);
                }
                if (hasHdfs) {
                    Log.getLogWriter().info("creating hdfs extn...");
                    gfeDDL = SQLPrms.getHdfsDDL(gfeDDL);
                    long numOfPRs = SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
                    SQLBB.getBB().getSharedCounters().add(SQLBB.numOfPRs, numOfPRs);
                    Log.getLogWriter().info("numOfPRs after adding HDFS regions is " + SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs));
                }
                for (int i = 0; i < gfeDDL.length; ++i) {
                    int index;
                    ArrayList senderIDs;
                    String ddl = gfeDDL[i].toUpperCase();
                    if (ddl.contains("REPLICATE")) {
                        if (ddl.contains("SERVER GROUPS") && !ddl.contains(sgSender)) {
                            int index2 = ddl.indexOf("SERVER GROUPS");
                            StringBuffer start = new StringBuffer(gfeDDL[i].substring(0, index2 - 1));
                            StringBuffer sb = new StringBuffer(gfeDDL[i].substring(index2));
                            sb.insert(sb.indexOf("SG"), sgSender + ",");
                            gfeDDL[i] = start.append(sb).toString();
                        }
                        if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && !((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                            int n = i;
                            gfeDDL[n] = gfeDDL[n] + " SERVER GROUPS (" + sgSender + "," + SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG) + ") ";
                        } else if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && ((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                            int n = i;
                            gfeDDL[n] = gfeDDL[n] + " SERVER GROUPS (" + sgSender + ",SG1,SG2,SG3,SG4) ";
                        }
                    }
                    if ((senderIDs = (ArrayList)wanBB.getSharedMap().get((Object)(myWanSite + "_senderIDs"))) == null) {
                        throw new TestException("senderIDs are not setting yet for creating tables");
                    }
                    StringBuilder senders = new StringBuilder();
                    senders.append(" GATEWAYSENDER(");
                    for (int j = 0; j < senderIDs.size(); ++j) {
                        senders.append((String)senderIDs.get(j));
                        if (j >= senderIDs.size() - 1) continue;
                        senders.append(", ");
                    }
                    senders.append(")");
                    if (isOffheap && randomizeOffHeap) {
                        throw new TestException("SqlPrms.isOffheap and SqlPrms.randomizeOffHeap are both set to true");
                    }
                    if (isOffheap) {
                        Log.getLogWriter().info("enabling offheap.");
                        for (index = 0; index < gfeDDL.length; ++index) {
                            if (gfeDDL[index].toLowerCase().indexOf(" OFFHEAP ".toLowerCase()) >= 0) continue;
                            int n = index;
                            gfeDDL[n] = gfeDDL[n] + " OFFHEAP ";
                        }
                    }
                    if (randomizeOffHeap) {
                        Log.getLogWriter().info("Randomizing off-heap in some tables but not others");
                        for (index = 0; index < gfeDDL.length; ++index) {
                            if (gfeDDL[index].toLowerCase().indexOf(" OFFHEAP ".toLowerCase()) >= 0 || TestConfig.tab().getRandGen().nextInt(1, 100) > 50) continue;
                            int n = index;
                            gfeDDL[n] = gfeDDL[n] + " OFFHEAP ";
                        }
                    }
                    Log.getLogWriter().info("about to create table " + gfeDDL[i] + senders.toString());
                    s.execute(gfeDDL[i] + senders.toString());
                    Log.getLogWriter().info("created table " + gfeDDL[i] + senders.toString());
                }
            } else {
                throw new TestException("Got incorrect url or setting.");
            }
            s.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create tables\n" + TestHelper.getStackTrace((Throwable)se));
        }
        if (url.equals(DiscDBManager.getUrl()) || url.equals(ClientDiscDBManager.getUrl())) {
            this.createDerbyIndex(conn);
        }
    }

    protected void writePartitionForWanSites() {
        Log.getLogWriter().info("buyordersPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"buyordersPartition"));
        Log.getLogWriter().info("customersPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"customersPartition"));
        Log.getLogWriter().info("networthPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"networthPartition"));
        Log.getLogWriter().info("portfolioPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"portfolioPartition"));
        Log.getLogWriter().info("securitiesPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"securitiesPartition"));
        Log.getLogWriter().info("sellordersPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"sellordersPartition"));
        Log.getLogWriter().info("txhistoryPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"txhistoryPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_buyordersPartition"), SQLBB.getBB().getSharedMap().get((Object)"buyordersPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_customersPartition"), SQLBB.getBB().getSharedMap().get((Object)"customersPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_networthPartition"), SQLBB.getBB().getSharedMap().get((Object)"networthPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_portfolioPartition"), SQLBB.getBB().getSharedMap().get((Object)"portfolioPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_securitiesPartition"), SQLBB.getBB().getSharedMap().get((Object)"securitiesPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_sellordersPartition"), SQLBB.getBB().getSharedMap().get((Object)"sellordersPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_txhistoryPartition"), SQLBB.getBB().getSharedMap().get((Object)"txhistoryPartition"));
    }

    public static void HydraTask_createDiscDB() {
        if (derbyDDLThread == WanTest.myTid()) {
            wanTest.createDiscDB();
        }
    }

    public static void HydraTask_createDiscSchemas() {
        if (derbyDDLThread == WanTest.myTid()) {
            wanTest.createDiscSchemas();
        }
    }

    public static void HydraTask_createDiscTables() {
        if (derbyDDLThread == WanTest.myTid()) {
            wanTest.createDiscTables();
        }
    }

    public static void HydraTask_createGFEDBForAccessors() {
        wanTest.createGFEDBForAccessors();
    }

    public static void HydraTask_createGFESchemas() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.createGFESchemas();
        }
    }

    @Override
    protected void createGFESchemas() {
        Connection conn = this.getGFEConnection();
        this.createGFESchemas(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void createGFESchemas(Connection conn) {
        Log.getLogWriter().info("creating schemas in gfe.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            while (wanBB.getSharedCounters().incrementAndRead(SQLWanBB.synchWanSiteSchemas) != 1L) {
                Log.getLogWriter().info("waiting for synchWanSiteParitionKeys to become 1");
                MasterController.sleepForMs((int)500);
            }
            if (SQLBB.getBB().getSharedMap().get((Object)SQLTest.tradeSchemaSG) == null) {
                String[] schemas = SQLPrms.getGFESchemas();
                this.createSchemas(conn, schemas);
            } else {
                String sg = (String)SQLBB.getBB().getSharedMap().get((Object)SQLTest.tradeSchemaSG);
                String[] schemas = SQLPrms.getSchemas();
                if (!sg.equals("default")) {
                    schemas[0] = schemas[0] + " DEFAULT SERVER GROUPS (" + sg + ") ";
                } else if ((SQLTest.hasAsyncDBSync || SQLTest.isWanTest) && SQLTest.isHATest) {
                    schemas[0] = schemas[0] + " DEFAULT SERVER GROUPS (SG1,SG2,SG3,SG4) ";
                }
                this.createSchemas(conn, schemas);
            }
            wanBB.getSharedCounters().zero(SQLWanBB.synchWanSiteSchemas);
        }
        Log.getLogWriter().info("done creating schemas in gfe.");
    }

    public static void HydraTask_createDiskStores() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.createDiskStores();
        }
    }

    public static void HydraTask_createGFETables() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.createGFETables();
        }
    }

    @Override
    protected void createGFETables() {
        if (testPartitionBy && !useSamePartitionAllWanSites) {
            this.getLock();
            super.createGFETables();
            this.releaseLock();
        } else {
            super.createGFETables();
        }
    }

    protected static int myTid() {
        return RemoteTestModule.getCurrentThread().getThreadId();
    }

    public static void HydraTask_checkQueueEmpty() {
        wanTest.checkQueueEmpty();
    }

    protected void checkQueueEmpty() {
        if (isSender) {
            this.checkGatewayQueueEmpty();
        }
    }

    public static void HydraTask_verifyPublisherResultSets() {
        wanTest.verifyResultSets();
    }

    public static void HydraTask_verifyResultSets() {
        wanTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (WanTest.myTid() == gfeDDLThread) {
            int sleepMs = 100;
            while (!this.isLastKeyArrived()) {
                Log.getLogWriter().info("last key is not arrived yet, sleep for " + sleepMs + " ms");
                MasterController.sleepForMs((int)sleepMs);
            }
            super.verifyResultSets();
        }
    }

    protected void verifyResultSetsFromBB() {
        Connection gConn = this.getGFEConnection();
        this.verifyResultSetsFromBB(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyResultSetsFromBB(Connection gConn) {
        if (WanTest.myTid() == gfeDDLThread) {
            int sleepMs = 5000;
            while (!this.isLastKeyArrived()) {
                Log.getLogWriter().info("last key is not arrived yet, sleep for " + sleepMs + " ms");
                MasterController.sleepForMs((int)sleepMs);
            }
            List<Struct> myList = null;
            List baseSiteList = null;
            int baseWanSite = (Integer)wanBB.getSharedMap().get((Object)"baseWanSite");
            Log.getLogWriter().info("comparing data from my wan site " + myWanSite + " with wan site " + baseWanSite);
            boolean throwException = false;
            StringBuffer str = new StringBuffer();
            try {
                ResultSet rs = gConn.createStatement().executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname not like 'SYS%'");
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String tableName = rs.getString(2);
                    myList = this.getResultSet(gConn, schemaName, tableName);
                    baseSiteList = (List)wanBB.getSharedMap().get((Object)(schemaName + "_" + tableName));
                    try {
                        Log.getLogWriter().info(ResultSetHelper.listToString(myList));
                        Log.getLogWriter().info("comparing result set for table " + schemaName + "." + tableName);
                        ResultSetHelper.compareResultSets(baseSiteList, myList, "wanSite" + baseWanSite, "wanSite" + myWanSite);
                    }
                    catch (TestException te) {
                        Log.getLogWriter().info("do not throw Exception yet, until all tables are verified");
                        throwException = true;
                        str.append(te.getMessage() + "\n");
                    }
                }
                if (throwException) {
                    throw new TestException("verify results failed: " + str);
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected boolean isLastKeyArrived() {
        Connection gConn = this.getGFEConnection();
        boolean isLastKeyArrived = this.isLastKeyArrived(gConn);
        this.closeGFEConnection(gConn);
        return isLastKeyArrived;
    }

    protected boolean isLastKeyArrived(Connection gConn) {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        int last_key = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.defaultEmployeesPrimary);
        try {
            ResultSet rs = gConn.createStatement().executeQuery("select eid from default1.employees");
            while (rs.next()) {
                aList.add(rs.getInt("EID"));
            }
            Log.getLogWriter().info("list is " + ((Object)aList).toString() + ", expected last key is " + last_key);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return aList.size() == last_key;
    }

    public static void HydraTask_writeSiteOneToBB() {
        wanTest.writeBaseSiteToBB();
    }

    protected void writeBaseSiteToBB() {
        Connection gConn = this.getGFEConnection();
        this.writeBaseSiteToBB(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void writeBaseSiteToBB(Connection gConn) {
        if (WanTest.myTid() == gfeDDLThread && !isSingleSitePublisher) {
            int sleepMs = 5000;
            while (!this.isLastKeyArrived()) {
                Log.getLogWriter().info("last key is not arrived yet, sleep for " + sleepMs + " ms");
                MasterController.sleepForMs((int)sleepMs);
            }
        }
        if (WanTest.myTid() == gfeDDLThread) {
            List<Struct> list = null;
            try {
                ResultSet rs = gConn.createStatement().executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' ");
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String tableName = rs.getString(2);
                    list = this.getResultSet(gConn, schemaName, tableName);
                    wanBB.getSharedMap().put((Object)(schemaName + "_" + tableName), list);
                    Log.getLogWriter().info("base site is wanSite" + myWanSite);
                    wanBB.getSharedMap().put((Object)"baseWanSite", (Object)myWanSite);
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Struct> getResultSet(Connection conn, String schema, String table) {
        List<Struct> tableList = null;
        try {
            String select = "select * from " + schema + "." + table;
            ResultSet rs = conn.createStatement().executeQuery(select);
            tableList = ResultSetHelper.asList(rs, false);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            this.commit(conn);
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSiteOneToBB(Connection gConn, String schema, String table) {
        try {
            String select = "select * from " + schema + "." + table;
            ResultSet rs = gConn.createStatement().executeQuery(select);
            List<Struct> tableList = ResultSetHelper.asList(rs, false);
            wanBB.getSharedMap().put((Object)table, tableList);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            this.commit(gConn);
        }
    }

    public static void HydraTask_verifyWanSiteReplication() {
        wanTest.verifyResultSetsFromBB();
    }

    public static void HydraTask_putLastKey() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.putLastKey();
        }
    }

    protected void putLastKey() {
        Connection gConn = this.getGFEConnection();
        this.putLastKey(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void putLastKey(Connection gConn) {
        try {
            int last_key = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.defaultEmployeesPrimary);
            String insert_last_key = "insert into default1.employees values (" + last_key + ", null, null, null, null)";
            Log.getLogWriter().info("last_key is " + last_key);
            Statement gstmt = gConn.createStatement();
            gstmt.execute(insert_last_key);
            this.commit(gConn);
            if (hasDerbyServer) {
                Log.getLogWriter().info("write last_key to derby");
                Connection dConn = this.getDiscConnection();
                Statement dstmt = dConn.createStatement();
                int count = dstmt.executeUpdate(insert_last_key);
                Log.getLogWriter().info("derby inserts " + count);
                this.commit(dConn);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_stopGateway() {
        wanTest.stopGateway();
    }

    protected void stopGateway() {
        if (random.nextBoolean() && this.getMyTid() == gfeDDLThread) {
            Connection gConn = this.getGFEConnection();
            this.stopGateway(gConn);
        }
    }

    public static void HydraTask_removeGateway() {
        wanTest.removeGateway();
    }

    protected void removeGateway() {
        if (WanTest.myTid() == gfeDDLThread) {
            Connection gConn = this.getGFEConnection();
            this.removeGateway(gConn);
        }
    }

    protected void removeGateway(Connection gConn) {
        SQLWarning warning;
        int i;
        CallableStatement cs;
        try {
            cs = gConn.prepareCall("CALL SYS.REMOVE_GATEWAY(?, ?)");
            for (i = 1; i <= numOfWanSites; ++i) {
                if (myWanSite == i) continue;
                Log.getLogWriter().info("in wan site " + myWanSite + " and removing gateway for nonexisting hub" + i);
                cs.setString(1, "hub_" + i);
                cs.setString(2, this.gatewayID + i);
                cs.execute();
                warning = gConn.getWarnings();
                SQLHelper.printSQLWarning(warning);
                this.commit(gConn);
                Log.getLogWriter().warning("Did not get exception that the hub id is not found");
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        try {
            cs = gConn.prepareCall("CALL SYS.REMOVE_GATEWAY(?, ?)");
            for (i = 1; i <= numOfWanSites; ++i) {
                if (myWanSite == i) continue;
                Log.getLogWriter().info("in wan site " + myWanSite + " and removing gateway for hub" + myWanSite);
                cs.setString(1, "hub_" + myWanSite);
                cs.setString(2, this.gatewayID + i);
                cs.execute();
                warning = gConn.getWarnings();
                SQLHelper.printSQLWarning(warning);
                this.commit(gConn);
                Log.getLogWriter().warning("Did not get exception that the gateway " + this.gatewayID + i + "is not stopped");
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("38000")) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("Got expected gateway not stopped exception, continuing testing");
            }
            if (se.getSQLState().equals("0A000") && !isTicket43696Fixed) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("Got expected not able to remove gateway exception, continuing testing");
            }
            SQLHelper.handleSQLException(se);
        }
        this.stopGateway(gConn);
        try {
            cs = gConn.prepareCall("CALL SYS.REMOVE_GATEWAY(?, ?)");
            for (i = 1; i <= numOfWanSites; ++i) {
                if (myWanSite == i) continue;
                Log.getLogWriter().info("in wan site " + myWanSite + " and removing gateway for hub" + myWanSite);
                cs.setString(1, "hub_" + myWanSite);
                cs.setString(2, this.gatewayID + i);
                cs.execute();
                warning = gConn.getWarnings();
                SQLHelper.printSQLWarning(warning);
                this.commit(gConn);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void stopGateway(Connection gConn) {
        try {
            CallableStatement cs = gConn.prepareCall("CALL SYS.STOP_GATEWAYSENDER(?)");
            ArrayList senderIDs = (ArrayList)wanBB.getSharedMap().get((Object)(myWanSite + "_senderIDs"));
            for (String id : senderIDs) {
                Log.getLogWriter().info("stopping gatewaysender " + id);
                cs.setString(1, id);
                cs.execute();
                SQLWarning warning = gConn.getWarnings();
                SQLHelper.printSQLWarning(warning);
                this.commit(gConn);
                Log.getLogWriter().info("stopped gatewaysender " + id);
            }
            for (int i = 1; i <= numOfWanSites; ++i) {
                if (myWanSite == i) continue;
                Log.getLogWriter().info("in wan site " + myWanSite + " and stopping gateway " + this.gatewayID + i + " for hub" + myWanSite);
                cs.setString(1, "hub_" + myWanSite);
                cs.setString(2, this.gatewayID + i);
                cs.execute();
                SQLWarning warning = gConn.getWarnings();
                SQLHelper.printSQLWarning(warning);
                this.commit(gConn);
                Log.getLogWriter().info("in wan site " + myWanSite + " and stopped gateway " + this.gatewayID + i + " for hub" + myWanSite);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_populateTables() {
        if (dumpThreads && RemoteTestModule.getCurrentThread().getThreadId() == derbyDDLThread) {
            wanTest.dumpThreads();
        } else {
            wanTest.populateTables();
        }
    }

    public static void HydraTask_doDMLOp() {
        wanTest.doDMLOp();
    }

    public static void HydraTask_createFunctionToPopulate() {
        wanTest.createFunctionToPopulate();
    }

    @Override
    protected void createFunctionToPopulate() {
        if (WanTest.myTid() == gfeDDLThread) {
            super.createFunctionToPopulate();
        }
    }

    public static void HydraTask_populateThruLoader() {
        wanTest.populateThruLoader();
    }

    @Override
    protected void populateThruLoader() {
        if (WanTest.myTid() == gfeDDLThread) {
            super.populateThruLoader();
        }
    }

    public static void HydraTask_setTableCols() {
        wanTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        if (WanTest.myTid() == derbyDDLThread) {
            super.setTableCols();
        }
    }

    public static void HydraTask_createIndex() {
        wanTest.createIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createIndex() {
        boolean gotLock = false;
        Object object = indexLock;
        synchronized (object) {
            gotLock = toCreateIndex;
            toCreateIndex = false;
        }
        if (gotLock) {
            super.createIndex();
            MasterController.sleepForMs((int)30000);
            object = indexLock;
            synchronized (object) {
                toCreateIndex = true;
            }
        }
    }

    public static void HydraTask_createProcedures() {
        wanTest.createProcedures();
    }

    public static void HydraTask_callProcedures() {
        wanTest.callProcedures();
    }

    public static void HydraTask_doOp() {
        wanTest.doOps();
    }

    public static void HydraTask_cycleStoreVms() {
        wanTest.cycleStoreVms();
    }

    @Override
    protected void cycleStoreVms() {
        int numToKill = TestConfig.tab().intAt(StopStartPrms.numVMsToStop, 1);
        long numOfPRs = (Long)wanBB.getSharedMap().get((Object)("numOfPRs" + myWanSite));
        List<ClientVmInfo> vms = null;
        if (wanBB.getSharedCounters().incrementAndRead(myWanSite) == 1L) {
            int sleepMS = 20000;
            Log.getLogWriter().info("allow  " + sleepMS / 1000 + " seconds before killing others");
            MasterController.sleepForMs((int)sleepMS);
            vms = this.stopStartNonSenderVMs(numToKill);
            Log.getLogWriter().info("Total number of PR is " + numOfPRs);
            PRObserver.waitForRebalRecov(vms, (int)1, (int)((int)numOfPRs), null, null, (boolean)false);
            wanBB.getSharedCounters().zero(myWanSite);
        }
    }

    protected List<ClientVmInfo> stopStartNonSenderVMs(int numToKill) {
        return this.stopStartNonSenderVMs(numToKill, "datastore_" + myWanSite + "_");
    }

    protected List<ClientVmInfo> stopStartNonSenderVMs(int numToKill, String target) {
        Object vm1 = wanBB.getSharedMap().get((Object)("wan_" + myWanSite + "_sender1"));
        Object vm2 = wanBB.getSharedMap().get((Object)("wan_" + myWanSite + "_sender2"));
        if (vm1 == null || vm2 == null) {
            throw new TestException("each site should have 2 sender nodes");
        }
        ArrayList<Integer> senders = new ArrayList<Integer>();
        senders.add(((ClientVmInfo)vm1).getVmid());
        senders.add(((ClientVmInfo)vm2).getVmid());
        Object[] tmpArr = StopStartVMs.getOtherVMsWithExcludeVmid((int)numToKill, (String)target, senders);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        for (ClientVmInfo client : vmList) {
            PRObserver.initialize((int)client.getVmid());
        }
        if (vmList.size() != 0) {
            StopStartVMs.stopStartVMs((List)vmList, (List)stopModeList);
        }
        return vmList;
    }

    public static void HydraTask_cycleSenderVms() {
        wanTest.cycleSenderVms();
    }

    protected void cycleSenderVms() {
        if (senderBB.getSharedCounters().incrementAndRead(myWanSite) == 1L) {
            Object vm1 = wanBB.getSharedMap().get((Object)("wan_" + myWanSite + "_sender1"));
            Object vm2 = wanBB.getSharedMap().get((Object)("wan_" + myWanSite + "_sender2"));
            ArrayList<ClientVmInfo> vms = new ArrayList<ClientVmInfo>();
            if (random.nextBoolean()) {
                vms.add((ClientVmInfo)vm1);
            } else {
                vms.add((ClientVmInfo)vm2);
            }
            ArrayList<String> stopModeList = new ArrayList<String>();
            stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
            int threeMinutes = 120000;
            int additionalWaitSec = random.nextInt(threeMinutes);
            int sleepMS = 20000 + additionalWaitSec;
            Log.getLogWriter().info("allow  " + sleepMS / 1000 + " seconds before killing others");
            MasterController.sleepForMs((int)sleepMS);
            StopStartVMs.stopStartVMs(vms, stopModeList);
            if (random.nextInt(10) != 1) {
                int msPerMinute = 60000;
                int waitTime = msPerMinute + random.nextInt(msPerMinute);
                MasterController.sleepForMs((int)waitTime);
                Log.getLogWriter().info("allow  " + waitTime / 1000 + " seconds before killing others");
            }
            senderBB.getSharedCounters().zero(myWanSite);
        }
    }

    public static void HydraTask_createFuncForProcedures() {
        if (WanTest.myTid() == gfeDDLThread) {
            wanTest.createFuncForProcedures();
        }
    }

    @Override
    protected void createFuncForProcedures() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createFuncForProcedures(dConn, gConn);
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void createFuncForProcedures(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("performing create function multiply Op, myTid is " + this.getMyTid());
        try {
            FunctionDDLStmt.createFuncMultiply(dConn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("X0Y68") && isWanTest) {
                Log.getLogWriter().info("get expected multiple function creation in derby in multi wan publisher case, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
        try {
            FunctionDDLStmt.createFuncMultiply(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_checkConstraints() {
        if (WanTest.myTid() == derbyDDLThread) {
            wanTest.checkConstraints();
        }
    }

    @Override
    protected void checkConstraints() {
        Connection gConn = this.getGFEConnection();
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createCompaniesTableInDerby() {
        wanTest.createCompaniesTableInDerby();
    }

    public static void HydraTask_createCompaniesTableInGfxd() {
        wanTest.createCompaniesTableInGfxd();
    }

    protected void createCompaniesTableInGfxd() {
        if (WanTest.myTid() == gfeDDLThread) {
            Connection gConn = this.getGFEConnection();
            this.getLock();
            this.createCompaniesTable(gConn);
            this.releaseLock();
            this.commit(gConn);
            this.closeGFEConnection(gConn);
        }
    }

    protected void createCompaniesTableInDerby() {
        Connection dConn = null;
        if (hasDerbyServer && WanTest.myTid() == derbyDDLThread) {
            dConn = this.getDiscConnection();
            try {
                this.log().info(companyTable);
                if (dConn != null) {
                    this.executeStatement(dConn, companyTable);
                }
                this.commit(dConn);
                this.closeDiscConnection(dConn);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void createCompaniesTable(Connection gConn) {
        String companiesDDL = "companiesDDL";
        while (wanBB.getSharedCounters().incrementAndRead(SQLWanBB.synchWanSiteParitionKeys) != 1L) {
            Log.getLogWriter().info("waiting for synchWanSiteParitionKeys to become 1");
            MasterController.sleepForMs((int)500);
        }
        String sql = null;
        if (wanBB.getSharedMap().get((Object)companiesDDL) == null) {
            sql = this.getCompaniesDDL();
            wanBB.getSharedMap().put((Object)companiesDDL, (Object)sql);
        } else {
            sql = (String)wanBB.getSharedMap().get((Object)companiesDDL);
        }
        this.writeCompaniesPartitionForWanSites();
        wanBB.getSharedMap().put((Object)("numOfPRs" + myWanSite), (Object)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs));
        Log.getLogWriter().info("numOfPRs is " + SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs));
        Log.getLogWriter().info("put numOfPRs into wanBB for " + myWanSite);
        wanBB.getSharedCounters().zero(SQLWanBB.synchWanSiteParitionKeys);
        sql = this.getWanExtension(sql);
        try {
            this.log().info("in gfxd executing " + sql);
            this.executeStatement(gConn, sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected String getCompaniesDDL() {
        String companiesPartition = SPACE;
        if (testPartitionBy) {
            companiesPartition = this.getTablePartition(TestConfig.tab().stringAt(SQLPrms.companiesTableDDLExtension, "trade.companies:random"));
        }
        String companiesDDLExtension = companiesPartition + this.getRedundancyClause(companiesPartition, TestConfig.tab().stringAt(SQLPrms.companiesTableRedundancy, SPACE) + WanTest.getCompaniesPersistence());
        return companyTable + companiesDDLExtension;
    }

    protected void writeCompaniesPartitionForWanSites() {
        Log.getLogWriter().info("companiesPartition is :" + SQLBB.getBB().getSharedMap().get((Object)"companiesPartition"));
        wanBB.getSharedMap().put((Object)(myWanSite + "_companiesPartition"), SQLBB.getBB().getSharedMap().get((Object)"companiesPartition"));
    }

    protected String getWanExtension(String sql) {
        ArrayList senderIDs;
        String ddl = sql.toUpperCase();
        if (ddl.contains("REPLICATE")) {
            if (ddl.contains("SERVER GROUPS") && !ddl.contains(sgSender)) {
                int index = ddl.indexOf("SERVER GROUPS");
                StringBuffer start = new StringBuffer(sql.substring(0, index - 1));
                StringBuffer sb = new StringBuffer(sql.substring(index));
                sb.insert(sb.indexOf("SG"), sgSender + ",");
                sql = start.append(sb).toString();
            }
            if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && !((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                sql = sql + "SERVER GROUPS (" + sgSender + "," + SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG) + ")";
            } else if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && ((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                sql = sql + "SERVER GROUPS (" + sgSender + ",SG1,SG2,SG3,SG4)";
            }
        }
        if ((senderIDs = (ArrayList)wanBB.getSharedMap().get((Object)(myWanSite + "_senderIDs"))) == null) {
            throw new TestException("senderIDs are not setting yet for creating tables");
        }
        StringBuilder senders = new StringBuilder();
        senders.append("GATEWAYSENDER(");
        for (int j = 0; j < senderIDs.size(); ++j) {
            senders.append((String)senderIDs.get(j));
            if (j >= senderIDs.size() - 1) continue;
            senders.append(", ");
        }
        senders.append(")");
        return sql + senders.toString();
    }

    public static void HydraTask_dropCompaniesFKInDerby() {
        wanTest.dropCompaniesFKInDerby();
    }

    protected void dropCompaniesFKInDerby() {
        Connection dConn = null;
        if (hasDerbyServer && WanTest.myTid() == derbyDDLThread) {
            dConn = this.getDiscConnection();
            this.log().info("derby executing");
            this.dropCompaniesFK(dConn);
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
    }

    public static void HydraTask_dropCompaniesFKInGfxd() {
        wanTest.dropCompaniesFKInGfxd();
    }

    protected void dropCompaniesFKInGfxd() {
        if (WanTest.myTid() == gfeDDLThread) {
            Connection gConn = this.getGFEConnection();
            this.log().info("gfxd executing");
            this.dropCompaniesFK(gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
        }
    }

    public static void HydraTask_createUDTPriceTypeInDerby() {
        wanTest.createUDTPriceTypeInDerby();
    }

    protected void createUDTPriceTypeInDerby() {
        Connection dConn = null;
        if (hasDerbyServer && WanTest.myTid() == derbyDDLThread) {
            dConn = this.getDiscConnection();
            this.log().info("derby executing");
            this.createUDTPriceType(dConn);
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
    }

    public static void HydraTask_createUDTPriceTypeInGfxd() {
        wanTest.createUDTPriceTypeInGfxd();
    }

    protected void createUDTPriceTypeInGfxd() {
        if (WanTest.myTid() == gfeDDLThread) {
            Connection gConn = this.getGFEConnection();
            this.log().info("gfxd executing");
            this.createUDTPriceType(gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
        }
    }

    public static void HydraTask_createUUIDTypeInDerby() {
        wanTest.createUUIDTypeInDerby();
    }

    protected void createUUIDTypeInDerby() {
        Connection dConn = null;
        if (hasDerbyServer && WanTest.myTid() == derbyDDLThread) {
            dConn = this.getDiscConnection();
            this.log().info("derby executing");
            this.createUUIDType(dConn);
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
    }

    public static void HydraTask_createUUIDTypeInGfxd() {
        wanTest.createUUIDTypeInGfxd();
    }

    protected void createUUIDTypeInGfxd() {
        if (WanTest.myTid() == gfeDDLThread) {
            Connection gConn = this.getGFEConnection();
            this.log().info("gfxd executing");
            this.createUUIDType(gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
        }
    }

    public static void hydraTask_createUDTPriceFunctionsInDerby() {
        wanTest.createUDTPriceFunctionsInDerby();
    }

    protected void createUDTPriceFunctionsInDerby() {
        Connection dConn = null;
        if (hasDerbyServer && WanTest.myTid() == derbyDDLThread) {
            dConn = this.getDiscConnection();
            this.log().info("derby executing");
            this.createUDTPriceFunction(dConn);
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
    }

    public static void hydraTask_createUDTPriceFunctionsInGfxd() {
        wanTest.createUDTPriceFunctionsInGfxd();
    }

    protected void createUDTPriceFunctionsInGfxd() {
        if (WanTest.myTid() == gfeDDLThread) {
            Connection gConn = this.getGFEConnection();
            this.log().info("gfxd executing");
            this.createUDTPriceFunction(gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
        }
    }

    @Override
    protected void doDDLOp(Connection dConn, Connection gConn) {
        if (ddls.length == 0) {
            this.log().info("No ddl statement to be executed");
            return;
        }
        int ddl = ddls[random.nextInt(ddls.length)];
        DDLStmtIF ddlStmt = ddlFactory.createDDLStmt(ddl);
        ddlStmt.doDDLOp(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    public static synchronized void HydraTask_createHDFSSTORE() {
        if (WanTest.myTid() == gfeDDLThread) {
            SQLTest.HydraTask_createHDFSSTORE();
        }
    }

    public static void HydraTask_shutDownAllFabricServers() {
        wanTest.shutDownAllFabricServers();
    }

    @Override
    protected void shutDownAllFabricServers() {
        Log.getLogWriter().info("shuting down all FabricServers");
        FabricServerHelper.shutDownAllFabricServers(300);
        while (!FabricServerHelper.isFabricServerStopped()) {
            Log.getLogWriter().info("Waiting for 5 sec as for shutdown of FabricServer");
            MasterController.sleepForMs((int)5000);
        }
        Log.getLogWriter().info("Completed shutdown of FabricServer...");
    }
}

