/*
 * Decompiled with CFR 0.152.
 */
package sql.wan.thinClient;

import hydra.ClientVmInfo;
import hydra.EdgeHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sql.GFEDBClientManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.ddlStatements.FunctionDDLStmt;
import sql.wan.SQLWanPrms;
import sql.wan.WanTest;
import util.TestException;
import util.TestHelper;

public class WanClientTest
extends WanTest {
    protected static WanClientTest wanClientTest = new WanClientTest();
    static int numOfClientThreadsPerSite = conftab.intAt(SQLWanPrms.numOfClientThreadsPerSite, 0);
    static int numOfClientNodes = conftab.intAt(SQLWanPrms.numOfClientNodes, 0);
    static int numOfServersPerSite = conftab.intAt(SQLWanPrms.numOfServersPerSite);

    public static void createLocatorTask() {
        FabricServerHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        if (networkServerConfig == null) {
            Log.getLogWriter().info("Starting peer locator only");
            FabricServerHelper.startLocator();
        } else {
            Log.getLogWriter().info("Starting network locator");
            FabricServerHelper.startLocator(networkServerConfig);
        }
    }

    public static void stopLocatorTask() {
        FabricServerHelper.stopLocator();
    }

    public static synchronized void HydraTask_initialize() {
        wanClientTest.initialize();
    }

    public static synchronized void HydraTask_initEdges() {
        isEdge = true;
    }

    public static void HydraTask_initWanClientTest() {
        if (numOfWanSites > 5) {
            throw new TestException("test could not handle more than 5 wan sites yet");
        }
        myWanSite = isEdge ? EdgeHelper.toWanSite((String)RemoteTestModule.getMyClientName()) : FabricServerHelper.getDistributedSystemId();
        if (isEdge) {
            int whichOne = (int)bb.getSharedCounters().incrementAndRead(SQLBB.wanDerbyDDLThread);
            if (whichOne == 1) {
                derbyDDLThread = WanClientTest.myTid();
                Log.getLogWriter().info("derbyDDLThread is " + derbyDDLThread);
            }
            if (WanClientTest.myTid() % numOfClientThreadsPerSite == 0) {
                gfeDDLThread = WanClientTest.myTid();
                Log.getLogWriter().info("gfeDDLThread is " + gfeDDLThread);
                Log.getLogWriter().info("testUniqueKeys is " + testUniqueKeys);
                Log.getLogWriter().info("withReplicateTables is " + TestConfig.tab().booleanAt(SQLPrms.withReplicatedTables, false));
            }
        } else {
            int serverId;
            if (numOfClientNodes == 0) {
                throw new TestException("test issue, num of clients must set in the conf");
            }
            Log.getLogWriter().info("myVMid is " + myVMid + " numOfClientNode is " + numOfClientNodes + " numOfLocators is " + numOfLocators);
            if (myVMid >= numOfClientNodes + numOfLocators && ((serverId = myVMid - (numOfClientNodes + numOfLocators)) % numOfServersPerSite == 0 || serverId % numOfServersPerSite == 1)) {
                isSender = true;
            }
        }
    }

    public static void HydraTask_initBBForWanConfig() {
        if (WanClientTest.myTid() == derbyDDLThread) {
            wanClientTest.initBBForWanConfig();
        }
    }

    public static synchronized void HydraTask_startFabricServerTask() {
        wanClientTest.startFabricServerTask();
    }

    @Override
    protected void startFabricServerTask() {
        if (isSender) {
            this.startFabricServerSGSender();
        } else {
            this.startFabricServer();
        }
    }

    public static synchronized void HydraTask_startFabricServerSGTask() {
        wanClientTest.startFabricServerSGTask();
    }

    @Override
    protected void startFabricServerSGTask() {
        if (isSender) {
            this.startFabricServerSGSender();
        } else {
            this.startFabricServerSG();
        }
    }

    public static void HydraTask_initForServerGroup() {
        wanClientTest.initForServerGroup();
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    @Override
    protected String getSGForNode() {
        String sg;
        HydraVector vec = TestConfig.tab().vecAt(SQLPrms.serverGroups);
        int whichOne = -1;
        if (numOfServersPerSite < 6) {
            throw new TestException("not enough data node per site to satisfy all server group requirement must have at least 6 server node per site, but this test only has " + numOfServersPerSite);
        }
        if (myVMid >= numOfClientNodes + numOfLocators) {
            int storeId = myVMid - numOfClientNodes - numOfLocators - 2;
            whichOne = storeId % numOfServersPerSite;
            Log.getLogWriter().info("which one is " + whichOne);
        }
        if (whichOne >= vec.size()) {
            whichOne = vec.size() - 1;
        }
        if ((sg = (String)((HydraVector)vec.elementAt(whichOne)).elementAt(0)).startsWith("random")) {
            ArrayList serverGroups = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"serverGroups");
            if (whichOne >= serverGroups.size()) {
                whichOne = random.nextInt(serverGroups.size());
            }
            sg = (String)serverGroups.get(whichOne);
        }
        Log.getLogWriter().info("This server is in " + sg);
        return sg;
    }

    public static void HydraTask_createDiscDB() {
        if (derbyDDLThread == WanClientTest.myTid()) {
            wanClientTest.createDiscDB();
        }
    }

    public static void HydraTask_createDiscSchemas() {
        if (derbyDDLThread == WanClientTest.myTid()) {
            wanClientTest.createDiscSchemas();
        }
    }

    public static void HydraTask_createDiscTables() {
        if (derbyDDLThread == WanClientTest.myTid()) {
            wanClientTest.createDiscTables();
        }
    }

    public static void HydraTask_createGFESchemas() {
        if (WanClientTest.myTid() == gfeDDLThread) {
            wanClientTest.createGFESchemas();
        }
    }

    @Override
    protected void createGFESchemas() {
        Connection conn = this.getGFXDClientConnection();
        this.createGFESchemas(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected Connection getGFXDClientConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    @Override
    protected Connection getGFXDClientConnection(Properties info) {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getConnection(info);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static synchronized void HydraTask_createGatewaySenders() {
        if (WanClientTest.myTid() == gfeDDLThread) {
            wanClientTest.createGatewaySenders();
        }
    }

    @Override
    protected void createGatewaySender(int remoteSiteId) {
        String ddl = this.getSenderDDL(remoteSiteId);
        Connection conn = this.getGFXDClientConnection();
        try {
            Log.getLogWriter().info("executing " + ddl);
            conn.createStatement().execute(ddl);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static synchronized void HydraTask_createGatewayReceivers() {
        if (WanClientTest.myTid() == gfeDDLThread) {
            wanClientTest.createGatewayReceivers();
        }
    }

    @Override
    protected void createGatewayReceivers() {
        this.createGatewayReceivers(sgSender);
    }

    @Override
    protected void createGatewayReceivers(String sg) {
        Connection gConn = this.getGFXDClientConnection();
        this.createGatewayReceivers(gConn, sg);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createGFETables() {
        if (WanClientTest.myTid() == gfeDDLThread) {
            wanClientTest.createGfxdWanTables();
        }
    }

    protected void createGfxdWanTables() {
        if (testPartitionBy && !useSamePartitionAllWanSites) {
            this.getLock();
            this.createGfxdTables();
            this.releaseLock();
        } else {
            this.createGfxdTables();
        }
    }

    protected void createGfxdTables() {
        Connection conn = this.getGFXDClientConnection();
        Log.getLogWriter().info("dropping tables in gfe.");
        this.dropTables(conn);
        Log.getLogWriter().info("done dropping tables in gfe");
        Log.getLogWriter().info("creating tables in gfe.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfe.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_populateTables() {
        if (dumpThreads && RemoteTestModule.getCurrentThread().getThreadId() == derbyDDLThread) {
            wanClientTest.dumpThreads();
        } else {
            wanClientTest.populateTables();
        }
    }

    @Override
    protected void populateTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_putLastKey() {
        if (WanClientTest.myTid() == gfeDDLThread) {
            wanClientTest.putLastKey();
        }
    }

    @Override
    protected void putLastKey() {
        Connection gConn = this.getGFXDClientConnection();
        this.putLastKey(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_setTableCols() {
        wanClientTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getGFXDClientConnection();
        WanClientTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_checkQueueEmpty() {
        wanClientTest.checkQueueEmpty();
    }

    public static void HydraTask_verifyPublisherResultSets() {
        wanClientTest.verifyResultSets();
    }

    public static void HydraTask_verifyResultSets() {
        wanClientTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (WanClientTest.myTid() != gfeDDLThread) {
            return;
        }
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            return;
        }
        int sleepMs = 100;
        while (!this.isLastKeyArrived()) {
            Log.getLogWriter().info("last key is not arrived yet, sleep for " + sleepMs + " ms");
            MasterController.sleepForMs((int)sleepMs);
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.verifyResultSets(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected boolean isLastKeyArrived() {
        Connection gConn = this.getGFXDClientConnection();
        boolean isLastKeyArrived = this.isLastKeyArrived(gConn);
        this.closeGFEConnection(gConn);
        return isLastKeyArrived;
    }

    public static void HydraTask_verifyWanSiteReplication() {
        wanClientTest.verifyResultSetsFromBB();
    }

    @Override
    protected void verifyResultSetsFromBB() {
        Connection gConn = this.getGFXDClientConnection();
        this.verifyResultSetsFromBB(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createFunctionToPopulate() {
        wanClientTest.createFunctionToPopulate();
    }

    @Override
    protected void createFunctionToPopulate() {
        Connection gConn = this.getGFXDClientConnection();
        try {
            FunctionDDLStmt.createFuncPortf(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_createIndex() {
        wanClientTest.createIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createIndex() {
        boolean gotLock = false;
        Object object = indexLock;
        synchronized (object) {
            gotLock = toCreateIndex;
            toCreateIndex = false;
        }
        if (gotLock) {
            Connection gConn = this.getGFXDClientConnection();
            this.createIndex(gConn);
            this.closeGFEConnection(gConn);
            Object object2 = indexLock;
            synchronized (object2) {
                toCreateIndex = true;
            }
        }
    }

    public static void HydraTask_createProcedures() {
        wanClientTest.createProcedures();
    }

    @Override
    protected void createProcedures() {
        Log.getLogWriter().info("performing create procedure Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        this.createProcedures(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_callProcedures() {
        wanClientTest.callProcedures();
    }

    @Override
    protected void callProcedures() {
        Log.getLogWriter().info("call procedures, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        this.callProcedures(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doOp() {
        wanClientTest.doOps();
    }

    @Override
    protected void doOps() {
        boolean dmlOp;
        int num = 10;
        boolean bl = dmlOp = random.nextInt(num) != 0;
        if (dmlOp) {
            this.doDMLOp();
        } else {
            this.doDDLOp();
        }
    }

    @Override
    protected void doDDLOp() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        this.doDDLOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done ddlOp");
    }

    public static void HydraTask_doDMLOp() {
        wanClientTest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        this.doDMLOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_createDiskStores() {
        if (WanClientTest.myTid() == gfeDDLThread) {
            wanClientTest.createDiskStores();
        }
    }

    @Override
    protected void createDiskStores() {
        Connection conn = this.getGFXDClientConnection();
        this.createDiskStores(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_writeSiteOneToBB() {
        wanClientTest.writeBaseSiteToBB();
    }

    @Override
    protected void writeBaseSiteToBB() {
        Connection gConn = this.getGFXDClientConnection();
        this.writeBaseSiteToBB(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createFuncForProcedures() {
        if (WanClientTest.myTid() == gfeDDLThread) {
            wanClientTest.createFuncForProcedures();
        }
    }

    @Override
    protected void createFuncForProcedures() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        this.createFuncForProcedures(dConn, gConn);
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_cycleStoreVms() {
        wanClientTest.cycleStoreVms();
    }

    @Override
    protected List<ClientVmInfo> stopStartNonSenderVMs(int numToKill) {
        return this.stopStartNonSenderVMs(numToKill, "server_" + myWanSite + "_");
    }

    public static void HydraTask_cycleSenderVms() {
        wanClientTest.cycleSenderVms();
    }

    public static void HydraTask_checkConstraints() {
        if (WanClientTest.myTid() == derbyDDLThread) {
            wanClientTest.checkConstraints();
        }
    }

    @Override
    protected void checkConstraints() {
        Connection gConn = this.getGFXDClientConnection();
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void doDDLOp(Connection dConn, Connection gConn) {
        super.doDDLOp(dConn, gConn);
    }
}

