/*
 * Decompiled with CFR 0.152.
 */
package sql.wan.tx;

import hydra.Log;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.SQLException;
import sql.GFEDBManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlDistTxStatements.TradeNetworthDMLDistTxStmt;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlTx.SQLTxBB;
import sql.sqlutil.DMLDistTxStmtsFactory;
import sql.sqlutil.DMLTxStmtsFactory;
import sql.wan.WanTest;
import util.TestException;
import util.TestHelper;

public class SQLWanTxTest
extends WanTest {
    protected static SQLWanTxTest wanTxTest;
    protected static DMLDistTxStmtsFactory dmlDistTxFactory;
    protected static DMLTxStmtsFactory dmlTxFactory;

    public static synchronized void HydraTask_initialize() {
        if (wanTxTest == null) {
            wanTxTest = new SQLWanTxTest();
            wanTxTest.initialize();
        }
    }

    public static void HydraTask_initWanTest() {
        wanTxTest.initWanTest();
    }

    public static void HydraTask_initBBForWanConfig() {
        if (SQLWanTxTest.myTid() == derbyDDLThread) {
            wanTxTest.initBBForWanConfig();
        }
    }

    public static synchronized void HydraTask_startFabricServerTask() {
        wanTxTest.startFabricServerTask();
    }

    public static void HydraTask_createGFESchemas() {
        if (SQLWanTxTest.myTid() == gfeDDLThread) {
            wanTxTest.createGFESchemas();
        }
    }

    public static void HydraTask_createDiskStores() {
        if (SQLWanTxTest.myTid() == gfeDDLThread) {
            wanTxTest.createDiskStores();
        }
    }

    public static synchronized void HydraTask_createGatewaySenders() {
        if (SQLWanTxTest.myTid() == gfeDDLThread) {
            wanTxTest.createGatewaySenders();
        }
    }

    public static synchronized void HydraTask_createGatewayReceivers() {
        if (SQLWanTxTest.myTid() == gfeDDLThread) {
            wanTxTest.createGatewayReceivers();
        }
    }

    public static void HydraTask_createGFETables() {
        if (SQLWanTxTest.myTid() == gfeDDLThread) {
            wanTxTest.createGFETables();
        }
    }

    @Override
    public Connection getGFEConnection() {
        return this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
    }

    protected Connection getGFXDTxConnection(GFEDBManager.Isolation isolation) {
        Connection conn = null;
        try {
            conn = GFEDBManager.getTxConnection(isolation);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static void HydraTask_populateTables() {
        wanTxTest.populateTables();
    }

    public static void HydraTask_putLastKey() {
        if (SQLWanTxTest.myTid() == gfeDDLThread) {
            wanTxTest.putLastKey();
        }
    }

    public static void HydraTask_checkQueueEmpty() {
        wanTxTest.checkQueueEmpty();
    }

    public static void HydraTask_writeSiteOneToBB() {
        wanTxTest.writeBaseSiteToBB();
    }

    public static void HydraTask_verifyWanSiteReplication() {
        wanTxTest.verifyResultSetsFromBB();
    }

    public static void HydraTask_doDMLOp() {
        wanTxTest.doDMLOp();
    }

    @Override
    protected void doDMLOp(Connection dConn, Connection gConn) {
        this.doDMLGfxdOnlyOps(gConn);
    }

    protected void doDMLGfxdOnlyOps(Connection gConn) {
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid() + " and txId is " + txId);
        boolean withDerby = false;
        int total = 20;
        int numOfIter = random.nextInt(total) + 1;
        for (int i = 0; i < numOfIter; ++i) {
            this.doDMLGfxdOnlyOp(gConn, 1, withDerby);
        }
        this.commitOrRollbackGfxdOnly(gConn);
    }

    protected void doDMLGfxdOnlyOp(Connection gConn, int size, boolean withDerby) {
        for (int i = 0; i < size; ++i) {
            this.doOneGfxdOnlyDMLOp(gConn, withDerby);
        }
    }

    protected void doOneGfxdOnlyDMLOp(Connection gConn, boolean withDerby) {
        String operation;
        boolean succeed = true;
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createDMLDistTxStmt(table);
        if (table != 1) {
            if (table != 4) {
                if (table != 2) {
                    if (table != 3) {
                        if (table != 5) {
                            return;
                        }
                    }
                }
            }
        }
        if ((operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations)).equals("insert")) {
            succeed = dmlStmt.insertGfxd(gConn, withDerby);
        } else if (operation.equals("update")) {
            succeed = dmlStmt.updateGfxd(gConn, withDerby);
        } else if (operation.equals("delete")) {
            succeed = dmlStmt.deleteGfxd(gConn, withDerby);
        } else if (operation.equals("query")) {
            succeed = dmlStmt.queryGfxd(gConn, withDerby);
        } else {
            throw new TestException("Unknown dml operation: " + operation);
        }
        if (table == 1 && operation.equals("insert") && succeed) {
            Log.getLogWriter().info("inserting into networth table");
            TradeNetworthDMLDistTxStmt networth = new TradeNetworthDMLDistTxStmt();
            succeed = testUniqueKeys ? networth.insertGfxd(gConn, withDerby, AbstractDMLStmt.getCid(gConn)) : networth.insertGfxd(gConn, withDerby, AbstractDMLStmt.getCid());
        }
        if (!succeed) {
            Log.getLogWriter().info("this tx get conflict exception");
        }
    }

    protected void commitOrRollbackGfxdOnly(Connection gConn) {
        int chanceToRollback = 20;
        if (random.nextInt(chanceToRollback) == 1) {
            Log.getLogWriter().info("roll back the tx");
            this.rollback(gConn);
        } else {
            Log.getLogWriter().info("commit the tx");
            this.commitGfxdOnly(gConn);
        }
    }

    protected boolean commitGfxdOnly(Connection gConn) {
        this.commit(gConn);
        return true;
    }

    protected void rollback(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.rollback();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_setTableCols() {
        wanTxTest.setTableCols();
    }

    public static void HydraTask_createIndex() {
        wanTxTest.createIndex();
    }

    public static void HydraTask_createFuncForProcedures() {
        if (SQLWanTxTest.myTid() == gfeDDLThread) {
            wanTxTest.createFuncForProcedures();
        }
    }

    public static void HydraTask_createProcedures() {
        wanTxTest.createProcedures();
    }

    public static void HydraTask_callProcedures() {
        wanTxTest.callProcedures();
    }

    public static void HydraTask_doOp() {
        wanTxTest.doOps();
    }

    @Override
    protected void populateTables(Connection dConn, Connection gConn) {
        for (int i = 0; i < dmlTables.length; ++i) {
            DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createDMLDistTxStmt(dmlTables[i]);
            if (dmlStmt == null) continue;
            dmlStmt.populate(dConn, gConn);
            if (dConn == null) continue;
            this.waitForBarrier();
        }
    }

    static {
        dmlDistTxFactory = new DMLDistTxStmtsFactory();
        dmlTxFactory = new DMLTxStmtsFactory();
    }
}

