DROP TABLE PUNTOSAPP.PTO_CTLPLANESTARIFARIOS;
DROP TABLE PUNTOSAPP.PTO_CTLSEGMENTOS;
DROP TABLE PUNTOSAPP.PTO_TBLTOTALES;
DROP TABLE PUNTOSAPP.PTO_TBLLINEAS;

CREATE TABLE PUNTOSAPP.PTO_TBLLINEAS ( 
    CUENTA              VARCHAR(10) NOT NULL,
    SECUENCIA           BIGINT NOT NULL,
    CTAPADRE            VARCHAR(10) NULL,
    LINEA               VARCHAR(10) NULL,
    IDREGION            SMALLINT NULL,
    PLAN                VARCHAR(5) NULL,
    STATUSTEL           VARCHAR(2) NULL,
    CICLOFACT           BIGINT NULL,
    ADDENDUM            BIGINT NULL,
    FECHAADD            DATE NULL,
    FECHAALTA           DATE NULL,
    FECHAANT            DATE NULL,
    SISTEMA             VARCHAR(7) NULL,
    STATUSPUNTOS        VARCHAR(1) NULL,
    STATUSCARTA         VARCHAR(1) NULL,
    MODSUBASTA          SMALLINT DEFAULT 0 NULL,
    IDUSUARIOSUB        VARCHAR(7) NULL,
    FECHAACTMOD         TIMESTAMP NULL,
    NICKNAME            VARCHAR(10) NULL,
    ANACR               VARCHAR(10) NULL,
    PRIMARY KEY(CUENTA,SECUENCIA)
)
PARTITION BY PRIMARY KEY
REDUNDANCY 1;

CREATE TABLE PUNTOSAPP.PTO_TBLTOTALES ( 
    CUENTA              VARCHAR(10) NOT NULL,
    SECUENCIA           BIGINT NOT NULL,
    FECHAFAC            DATE NULL,
    PUNTOSACUM          BIGINT NULL,
    PUNTOSREDIM         BIGINT NULL,
    PUNTOSTRANSF        BIGINT NULL,
    PUNTOSALIANZAS      BIGINT NULL,
    PUNTOSCADUC         BIGINT NULL,
    PUNTOSACAD          BIGINT NULL,
    PUNTOSACAD2         BIGINT NULL,
    PUNTOSPORBONO       BIGINT NULL,
    PUNTOSBONOANT       BIGINT NULL,
    PUNTOSRENTA         BIGINT NULL,
    PUNTOSEXCEDENTES    BIGINT NULL,
    FECHACAD            DATE NULL,
    FECHACAD2           DATE NULL,
    PUNTOSACAD1         BIGINT NULL,
    FECHACAD1           DATE NULL,
    PUNTOSPROM          BIGINT NULL,
    FECHACADU           DATE NULL,
    BBONO               VARCHAR(1) NULL,
    SALDOANT            BIGINT NULL,
    PUNTOSACADDISP      BIGINT NULL,
    PUNTOSACAD2DISP     BIGINT NULL,
    PUNTOSACAD1DISP     BIGINT NULL,
    PUNTOSRENTADISP     BIGINT NULL,
    PUNTOSANTIG         BIGINT NULL,
    PUNTOSSUBASTA       BIGINT NULL,
    PUNTOSANTIGUEDAD    BIGINT NULL,
    PUNTOSPROMOCION     BIGINT NULL,
    BONOEQUIPO          BIGINT NULL,
    FECHAASIGNACADU     DATE NULL,
    PRIMARY KEY(CUENTA,SECUENCIA)
)
PARTITION BY PRIMARY KEY
COLOCATE WITH (PUNTOSAPP.PTO_TBLLINEAS)
REDUNDANCY 1;

CREATE TABLE PUNTOSAPP.PTO_CTLSEGMENTOS ( 
    IDSEGMENTO          BIGINT NOT NULL,
    SEGMENTO            VARCHAR(10) NULL,
    BONOXSEGMENTO       BIGINT NULL,
    IDREGION            SMALLINT NULL,
    PRIMARY KEY(IDSEGMENTO)
)
REPLICATE;

CREATE TABLE PUNTOSAPP.PTO_CTLPLANESTARIFARIOS ( 
    IDPLAN              VARCHAR(5) NOT NULL,
    IDSEGMENTO          BIGINT NOT NULL,
    IDREGION            SMALLINT NOT NULL,
    IDGRUPOPROMOCION    BIGINT NULL,
    DESCRIPCION         VARCHAR(30) NULL,
    TECNOLOGIA          VARCHAR(10) NULL,
    BMIXTO              VARCHAR(1) NULL,
    MODALIDAD           VARCHAR(10) NULL,
    BSISACT             VARCHAR(1) NULL,
    ADENDUM             BIGINT NULL,
    RENTA               BIGINT NULL,
    BREDENCION          SMALLINT NULL,
    ESTATUS             VARCHAR(2) NULL,
    BREDENCIONANTC      VARCHAR(1) NULL,
    TIPO_PLAN           VARCHAR(10) NULL,
    PRIMARY KEY(IDPLAN,IDSEGMENTO,IDREGION)
)
REPLICATE;

CREATE INDEX PUNTOSAPP.IDX_LINEALIN
    ON PUNTOSAPP.PTO_TBLLINEAS(LINEA);
CREATE INDEX PUNTOSAPP.IDX_LINEASCICS
    ON PUNTOSAPP.PTO_TBLLINEAS(CICLOFACT, IDREGION, CUENTA, SECUENCIA);
CREATE INDEX PUNTOSAPP.IDX_LINEASCICLO
    ON PUNTOSAPP.PTO_TBLLINEAS(CICLOFACT);
CREATE INDEX PUNTOSAPP.IDX_LINEASSEC
    ON PUNTOSAPP.PTO_TBLLINEAS(SECUENCIA);
CREATE INDEX PUNTOSAPP.IDX_LINEASPILSC
    ON PUNTOSAPP.PTO_TBLLINEAS(PLAN, IDREGION, LINEA, SECUENCIA, CUENTA);
CREATE UNIQUE INDEX PUNTOSAPP.PK_TBLLINEAS
    ON PUNTOSAPP.PTO_TBLLINEAS(CUENTA, SECUENCIA);
CREATE INDEX PUNTOSAPP.IDX_LINEASCTA
    ON PUNTOSAPP.PTO_TBLLINEAS(CUENTA);
CREATE INDEX PUNTOSAPP.IDX_LINEAPLAN
    ON PUNTOSAPP.PTO_TBLLINEAS(PLAN);
CREATE UNIQUE INDEX PUNTOSAPP.IDX_SEGMENTOS
    ON PUNTOSAPP.PTO_CTLSEGMENTOS(SEGMENTO, IDREGION);
CREATE UNIQUE INDEX PUNTOSAPP.PK_CTLSEGMENTOS
    ON PUNTOSAPP.PTO_CTLSEGMENTOS(IDSEGMENTO);
CREATE INDEX PUNTOSAPP.IDX_TOTALESCTA
    ON PUNTOSAPP.PTO_TBLTOTALES(CUENTA);
CREATE INDEX PUNTOSAPP.IDX_TOTALESPTCTSEC
    ON PUNTOSAPP.PTO_TBLTOTALES(PUNTOSANTIG, CUENTA, SECUENCIA);
CREATE INDEX PUNTOSAPP.IDX_TOTALESFEC
    ON PUNTOSAPP.PTO_TBLTOTALES(FECHAFAC);
CREATE INDEX PUNTOSAPP.IDX_TOTALESPEXCED
    ON PUNTOSAPP.PTO_TBLTOTALES(PUNTOSEXCEDENTES);
CREATE UNIQUE INDEX PUNTOSAPP.PK_CTLPLNSTARIF
    ON PUNTOSAPP.PTO_CTLPLANESTARIFARIOS(IDPLAN, IDSEGMENTO, IDREGION);
CREATE INDEX idx1 ON PUNTOSAPP.PTO_TBLLINEAS (FECHAADD DESC, FECHAALTA DESC);
