DROP TABLE TX_PL_POSITION;
DROP TABLE TF_PL_POSITION_DLY; 
DROP TABLE TF_GEMFIRE_PAA;
DROP TABLE TF_EQRMS_PAA;
DROP TABLE TF_EDEALER_PAA;
DROP TABLE TX_PL_USER_POSN_MAP;
DROP TABLE TL_SOURCE_SYSTEM;
DROP TABLE TL_REGION;
DROP TABLE TL_CURRENCY;
DROP TABLE TF_PL_POSITION_YTD;
DROP TABLE TF_PL_POSITION_PTD;
DROP TABLE TF_PL_POSITION_FUNC; 
DROP TABLE TF_PL_ADJ_REPORT;
DROP TABLE TD_TRADER_SCD;
DROP TABLE TD_POSN_EXTENDED_KEY;
DROP TABLE TD_PL_POSITION_INDICATIVE;
DROP TABLE TD_INSTRUMENT_SCD;
DROP TABLE TD_FIRM_ACCOUNT_SCD;

CREATE TABLE TX_PL_POSITION 
  (	PL_POSN_ID NUMERIC(21,0) NOT NULL, 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(16,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_MNEM_CD VARCHAR(16), 
	CUSIP_CD VARCHAR(30), 
	CORPUS_ID NUMERIC(21,0) NOT NULL, 
	CCY_CD VARCHAR(3), 
	LNG_SHRT_CD VARCHAR(1), 
	BRKR_CD VARCHAR(2), 
	TRAN_TYP_CD VARCHAR(30), 
	REGIS_COUP_CD VARCHAR(1), 
	SUB_ACCT_CD VARCHAR(1), 
	SRC_SYS_CD VARCHAR(20), 
	RGN_CD VARCHAR(2), 
	ORIG_FIRM_ACCT_ID NUMERIC(21,0), 
	SCR_FI_CD NUMERIC(21,0), 
	CCY_ID NUMERIC(21,0) NOT NULL, 
	SRC_SYS_ID NUMERIC(21,0), 
	POSN_EXT_KEY_ID NUMERIC(21,0) NOT NULL, 
	RGN_ID NUMERIC(21,0), 
	LTD_OFS_TM_ID NUMERIC(21,0), 
	STRC_DESC VARCHAR(64), 
	CUSIP_SRC_CD VARCHAR(20)
   );

CREATE TABLE TF_PL_POSITION_DLY 
  (	TM_ID NUMERIC(21,0) NOT NULL, 
	PL_POSN_ID NUMERIC(21,0) NOT NULL, 
	OBJ_INST_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_ID NUMERIC(21,0) NOT NULL, 
	INSM_ID NUMERIC(21,0) NOT NULL, 
	CCY_ID NUMERIC(21,0) NOT NULL, 
	POSN_EXT_KEY_ID NUMERIC(21,0) NOT NULL, 
	TRDR_ID NUMERIC(21,0), 
	SRC_SYS_ID NUMERIC(21,0) NOT NULL, 
	RGN_ID NUMERIC(21,0) NOT NULL, 
	TD_PL_POSN_INDIC_ID NUMERIC(21,0) NOT NULL, 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	REC_STA_CD VARCHAR(1), 
	DLY_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	DLY_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	DLY_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	FUNC_CURX_FAC NUMERIC(31,19) DEFAULT 0, 
	USD_CURX_FAC NUMERIC(31,19) DEFAULT 0, 
	PRC_FAC NUMERIC(31,19) DEFAULT 0, 
	DLY_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_ERY_ALOC_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	DLY_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_NEW_TRD_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	DLY_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_VAR_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	DLY_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PYDN_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	DLY_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	UREL_DISP_FAC NUMERIC(1,0) DEFAULT 1, 
	UREL_CALC_FAC NUMERIC(1,0) DEFAULT 1
   );

CREATE TABLE TF_GEMFIRE_PAA
 (
    TM_ID                 NUMERIC(21,0) NOT NULL,
    PL_POSN_ID            NUMERIC(21,0),
    RISKSRCSYS            VARCHAR(20),
    VALUATIONDATE         NUMERIC(21,0),
    BUSINESS              VARCHAR(99),
    SUBBUSINESS           VARCHAR(99),
    FIRMACCOUNTMNEMONIC   VARCHAR(20),
    STRATEGY              VARCHAR(99),
    STRATEGYDESC          VARCHAR(99),
    SUBSTRATEGY           VARCHAR(99),
    TRADERPOD             VARCHAR(99),
    CREDITCURVECRCY       VARCHAR(99),
    CURVEDESC             VARCHAR(99),
    CURVEID               VARCHAR(99),
    INDUSTRYSECTOR        VARCHAR(99),
    ISSUER                VARCHAR(99),
    ISSUERCODE            VARCHAR(99),
    PARENTNAME            VARCHAR(99),
    RED6                  VARCHAR(99),
    MOODYRATING           VARCHAR(99),
    SNPRATING             VARCHAR(99),
    FITCHRATING           VARCHAR(99),
    RNIRATING             VARCHAR(99),
    SENIORITY             VARCHAR(99),
    CPTYACTMNEM           VARCHAR(99),
    CPTYDESC              VARCHAR(99),
    LEGALENTITY           VARCHAR(99),
    TRADESTATUS           VARCHAR(99),
    TRADEVER              VARCHAR(99),
    TRADEID               VARCHAR(16),
    OASYSDEALID           VARCHAR(30),
    OASYSTRANSACTIONID    NUMERIC(21,0),
    CORPUSID              NUMERIC(21,0),
    OPSFILE               VARCHAR(99),
    ASSETSUBTYPE          VARCHAR(99),
    ASSETTYPE             VARCHAR(99),
    ASSIGNMENTFEE         NUMERIC(31,8),
    UPFRONTFEE            NUMERIC(31,8),
    BROKERFEE             NUMERIC(31,8),
    TERMINATIONFEE        NUMERIC(31,8),
    BUYSELL               VARCHAR(99),
    CLOSINGPRICE          VARCHAR(99),
    TRADECOMMENT          VARCHAR(99),
    MATURITY              VARCHAR(99),
    TRADEDATE             NUMERIC(21,0),
    TERMINATIONDATE       NUMERIC(21,0),
    RECOVERY              NUMERIC(31,8),
    POSITIONSRCSYS        VARCHAR(99),
    RESTRUCTURING         VARCHAR(99),
    STRIKECOUPON          NUMERIC(31,8),
    CURRENCY              VARCHAR(20),
    TRADER                VARCHAR(99),
    NOTIONALLOCAL         NUMERIC(31,8),
    FIRSTCPNDATE          NUMERIC(21,0),
    EFFECTIVEDATE         NUMERIC(21,0),
    DAYCOUNT              VARCHAR(99),
    CPNFREQ               VARCHAR(99),
    RESETDATE             NUMERIC(21,0),
    ROLLTYPE              VARCHAR(99),
    FXRATE                NUMERIC(31,8),
    FXDV01                NUMERIC(31,8),
    MTM                   NUMERIC(31,8),
    ACCRUED               NUMERIC(31,8),
    ACCRUEDLOCAL          NUMERIC(31,8),
    ATM                   NUMERIC(31,8),
    CASH                  NUMERIC(31,8),
    CONVERTIBILITY        NUMERIC(31,8),
    CONVEXITY             NUMERIC(31,8),
    CR01PROP              NUMERIC(31,8),
    CURRENTNOTIONAL       NUMERIC(31,8),
    CURVEROLL             NUMERIC(31,8),
    CREDITGAMMA           NUMERIC(31,8),
    EQUIVALENTRATIO       NUMERIC(31,8),
    FEESPV                NUMERIC(31,8),
    FXHEDGE               NUMERIC(31,8),
    JTD                   NUMERIC(31,8),
    MODDURATION           NUMERIC(31,8),
    JTR                   NUMERIC(31,8),
    RECOVERY01            NUMERIC(31,8),
    MTMLOCAL              NUMERIC(31,8),
    THETASC               NUMERIC(31,8),
    THETAROLL             NUMERIC(31,8),
    THETACARRY            NUMERIC(31,8),
    YIELD                 NUMERIC(31,8),
    ZSPREAD               NUMERIC(31,8),
    CR01                  NUMERIC(31,8),
    FEE10CENTS            NUMERIC(31,8),
    IR01ISSRCRCY          NUMERIC(31,8),
    IR01TRDCRCY           NUMERIC(31,8),
    CR01_M03              NUMERIC(31,8),
    CR01_M06              NUMERIC(31,8),
    CR01_M09              NUMERIC(31,8),
    CR01_Y01              NUMERIC(31,8),
    CR01_Y02              NUMERIC(31,8),
    CR01_Y03              NUMERIC(31,8),
    CR01_Y04              NUMERIC(31,8),
    CR01_Y05              NUMERIC(31,8),
    CR01_Y06              NUMERIC(31,8),
    CR01_Y07              NUMERIC(31,8),
    CR01_Y08              NUMERIC(31,8),
    CR01_Y09              NUMERIC(31,8),
    CR01_Y10              NUMERIC(31,8),
    CR01_Y15              NUMERIC(31,8),
    CR01_Y20              NUMERIC(31,8),
    CR01_Y30              NUMERIC(31,8),
    RISK_M002             NUMERIC(31,8),
    RISK_M001             NUMERIC(31,8),
    RISK_M003             NUMERIC(31,8),
    RISK_M004             NUMERIC(31,8),
    RISK_M005             NUMERIC(31,8),
    RISK_M006             NUMERIC(31,8),
    RISK_M007             NUMERIC(31,8),
    RISK_M008             NUMERIC(31,8),
    RISK_M009             NUMERIC(31,8),
    RISK_M010             NUMERIC(31,8),
    RISK_M011             NUMERIC(31,8),
    RISK_M012_Y1          NUMERIC(31,8),
    RISK_M018             NUMERIC(31,8),
    RISK_M024_Y2          NUMERIC(31,8),
    RISK_M030             NUMERIC(31,8),
    RISK_M036_Y3          NUMERIC(31,8),
    RISK_M042             NUMERIC(31,8),
    RISK_M048_Y4          NUMERIC(31,8),
    RISK_M054             NUMERIC(31,8),
    RISK_M060_Y5          NUMERIC(31,8),
    RISK_M066             NUMERIC(31,8),
    RISK_M072_Y6          NUMERIC(31,8),
    RISK_M078             NUMERIC(31,8),
    RISK_M084_Y7          NUMERIC(31,8),
    RISK_M090             NUMERIC(31,8),
    RISK_M096_Y8          NUMERIC(31,8),
    RISK_M102             NUMERIC(31,8),
    RISK_M108_Y9          NUMERIC(31,8),
    RISK_M114             NUMERIC(31,8),
    RISK_M120_Y10         NUMERIC(31,8),
    FEE10CENTS_M03        NUMERIC(31,8),
    FEE10CENTS_M06        NUMERIC(31,8),
    FEE10CENTS_M09        NUMERIC(31,8),
    FEE10CENTS_Y01        NUMERIC(31,8),
    FEE10CENTS_Y02        NUMERIC(31,8),
    FEE10CENTS_Y03        NUMERIC(31,8),
    FEE10CENTS_Y04        NUMERIC(31,8),
    FEE10CENTS_Y05        NUMERIC(31,8),
    FEE10CENTS_Y06        NUMERIC(31,8),
    FEE10CENTS_Y07        NUMERIC(31,8),
    FEE10CENTS_Y08        NUMERIC(31,8),
    FEE10CENTS_Y09        NUMERIC(31,8),
    FEE10CENTS_Y10        NUMERIC(31,8),
    FEE10CENTS_Y15        NUMERIC(31,8),
    FEE10CENTS_Y20        NUMERIC(31,8),
    FEE10CENTS_Y30        NUMERIC(31,8),
    IR01_TRDCRCY_M03      NUMERIC(31,8),
    IR01_TRDCRCY_M06      NUMERIC(31,8),
    IR01_TRDCRCY_M09      NUMERIC(31,8),
    IR01_TRDCRCY_Y01      NUMERIC(31,8),
    IR01_TRDCRCY_Y02      NUMERIC(31,8),
    IR01_TRDCRCY_Y03      NUMERIC(31,8),
    IR01_TRDCRCY_Y04      NUMERIC(31,8),
    IR01_TRDCRCY_Y05      NUMERIC(31,8),
    IR01_TRDCRCY_Y06      NUMERIC(31,8),
    IR01_TRDCRCY_Y07      NUMERIC(31,8),
    IR01_TRDCRCY_Y08      NUMERIC(31,8),
    IR01_TRDCRCY_Y09      NUMERIC(31,8),
    PAACASH               NUMERIC(31,8),
    PAACREDITGAMMA        NUMERIC(31,8),
    PAAFXHEDGE            NUMERIC(31,8),
    PAANETECONOMIC        NUMERIC(31,8),
    PAARECOVERY01         NUMERIC(31,8),
    PAARESIDUAL           NUMERIC(31,8),
    PAATHETASC            NUMERIC(31,8),
    PAATHETAROLL          NUMERIC(31,8),
    PAATHETACARRY         NUMERIC(31,8),
    PAAIR01_TRDCRCY       NUMERIC(31,8),
    PAATOTALEXPLANATION   NUMERIC(31,8),
    PAACR01               NUMERIC(31,8),
    PAAIR01_ISSRCRCY      NUMERIC(31,8),
    PAAFEE10CENTS         NUMERIC(31,8),
    CUSIP                 VARCHAR(30),
    ISIN                  VARCHAR(99),
    LOANXID               NUMERIC(31,8),
    LPCID                 NUMERIC(31,8),
    REFOBLIGATION         NUMERIC(31,8),
    USPRODUCTSUBTYPE      NUMERIC(31,8),
    USPRODUCTTYPE         VARCHAR(99),
    COUPON                NUMERIC(31,8),
    DEFAULTED             VARCHAR(9),
    FACILITYNAME          NUMERIC(31,8),
    MATURED               VARCHAR(9),
    MATURITYDATE          NUMERIC(21,0),
    LASTCPNDATE           NUMERIC(21,0),
    NEXTCALLDATE          NUMERIC(21,0),
    PRICINGOPTION         VARCHAR(99),
    RATEINDEX             VARCHAR(99),
    SPREAD                NUMERIC(31,8),
    CALLABLE              VARCHAR(9),
    FLOATER               VARCHAR(9),
    PERPETUAL             VARCHAR(9),
    TRADINGFLAT           VARCHAR(99),
    FULLPX                NUMERIC(31,8),
    FULLPXPERCENT         NUMERIC(31,8),
    FLATPX                NUMERIC(31,8),
    FLATPXPERCENT         NUMERIC(31,8),
    LOCALFLATPX           NUMERIC(31,8),
    BFPAABASEPVT0         NUMERIC(31,8),
    BFPAABASEPVT1         NUMERIC(31,8),
    BFPAACHANGEUNREALISED NUMERIC(31,8),
    BFPAANETECONOMIC      NUMERIC(31,8),
    BFPAATOTALEXPLANATION NUMERIC(31,8),
    BFPAATRADEACTION      NUMERIC(31,8),
    BFPAACREDITCURVE      NUMERIC(31,8),
    BFPAAFX               NUMERIC(31,8),
    BFPAACASH             NUMERIC(31,8),
    BFPAAIRCURVE          NUMERIC(31,8),
    BFPAARESIDUAL         NUMERIC(31,8),
    BFPAATHETA            NUMERIC(31,8),
    CR01_3M               NUMERIC(31,8),
    CR01_6M               NUMERIC(31,8),
    CR01_9M               NUMERIC(31,8),
    CR01_1Y               NUMERIC(31,8),
    CR01_2Y               NUMERIC(31,8),
    CR01_3Y               NUMERIC(31,8),
    CR01_4Y               NUMERIC(31,8),
    CR01_5Y               NUMERIC(31,8),
    CR01_6Y               NUMERIC(31,8),
    CR01_7Y               NUMERIC(31,8),
    CR01_8Y               NUMERIC(31,8),
    CR01_9Y               NUMERIC(31,8),
    CR01_10Y              NUMERIC(31,8),
    CR01_15Y              NUMERIC(31,8),
    CR01_20Y              NUMERIC(31,8),
    CR01_30Y              NUMERIC(31,8),
    PAAFEE10CENTS_3M      NUMERIC(31,8),
    PAAFEE10CENTS_6M      NUMERIC(31,8),
    PAAFEE10CENTS_9M      NUMERIC(31,8),
    PAAFEE10CENTS_1Y      NUMERIC(31,8),
    PAAFEE10CENTS_2Y      NUMERIC(31,8),
    PAAFEE10CENTS_3Y      NUMERIC(31,8),
    PAAFEE10CENTS_4Y      NUMERIC(31,8),
    PAAFEE10CENTS_5Y      NUMERIC(31,8),
    PAAFEE10CENTS_6Y      NUMERIC(31,8),
    PAAFEE10CENTS_7Y      NUMERIC(31,8),
    PAAFEE10CENTS_8Y      NUMERIC(31,8),
    PAAFEE10CENTS_9Y      NUMERIC(31,8),
    PAAFEE10CENTS_10Y     NUMERIC(31,8),
    PAAFEE10CENTS_15Y     NUMERIC(31,8),
    PAAFEE10CENTS_20Y     NUMERIC(31,8),
    PAAFEE10CENTS_30Y     NUMERIC(31,8),
    MTD_REALIZEDPL        NUMERIC(31,8),
    MTD_UNREALIZED_PL     NUMERIC(31,8),
    MTD_TOTAL_PL          NUMERIC(31,8),
    MTD_TOTAL_EXPLAIN     NUMERIC(31,8),
    MTD_RESIDUAL          NUMERIC(31,8),
    MTD_IR_EFFECT         NUMERIC(31,8),
    MTD_CREDIT_EFFECT     NUMERIC(31,8),
    MTD_THETA             NUMERIC(31,8),
    MTD_TRADE_ACTION      NUMERIC(31,8),
    MTD_NEW_TRADES        NUMERIC(31,8),
    MTD_CANCEL_TRADES     NUMERIC(31,8),
    MTD_CREDIT_GAMMA      NUMERIC(31,8),
    MTD_FX_EFFECT         NUMERIC(31,8),
    VALUATION_NAME        VARCHAR(99),
    CCY_ID                NUMERIC(21,0),
    FIRM_ACCT_ID          NUMERIC(21,0),
    INSM_ID               NUMERIC(21,0),
    LOAD_FILE_NAME        VARCHAR(64),
    LOAD_LINE_NO          NUMERIC(21,0),
    REC_MDFY_USER_ID      VARCHAR(16),
    REC_MDFY_DTM TIMESTAMP,
    REC_MDFY_METH_DESC VARCHAR(30),
    PROC_LOG_ID        NUMERIC(16,0),
    ERR_ID             NUMERIC(21,0),
    PAA_ID             NUMERIC(21,0),
    RGN_ID             NUMERIC(21,0),
    SETTLEMENTDATE     NUMERIC(21,0),
    MTD_RECOVERY01     NUMERIC(31,8),
    REFOBLIGATNDESC    VARCHAR(99)
  );

CREATE INDEX TF_GEMFIRE_PAA_ID ON TF_GEMFIRE_PAA
 (
    TM_ID, PAA_ID, RGN_ID
  );

CREATE
    INDEX TF_GEMFIRE_PAA_NUI ON TF_GEMFIRE_PAA
   (
      TM_ID,
      PL_POSN_ID,
      RGN_ID
    );

CREATE TABLE TF_EQRMS_PAA
 (
    TM_ID                NUMERIC(21,0) NOT NULL,
    PL_POSN_ID           NUMERIC(21,0),
    POSITION_ID          VARCHAR(99),
    COMPOUND_POS_ID      VARCHAR(99),
    OASYSDEALID          VARCHAR(30),
    OASYSTRANSACTIONID   NUMERIC(21,0),
    CORPUSID             NUMERIC(21,0),
    CUSIP                VARCHAR(30),
    PACKAGE_NUMERIC       VARCHAR(99),
    COMPONENT_MNEM       VARCHAR(99),
    FIRMACCOUNTMNEMONIC  VARCHAR(99),
    EXPIRY               VARCHAR(99),
    STRIKE               NUMERIC(31,8),
    PC1                  VARCHAR(10),
    SECURITY_TYPE        VARCHAR(99),
    MODEL_NAME           VARCHAR(99),
    AVERAGE_COST         NUMERIC(31,8),
    CURRENCY             VARCHAR(99),
    FX_RATE              NUMERIC(31,8),
    QUANTITY_T2          NUMERIC(31,8),
    QUANTITY_T1          NUMERIC(31,8),
    TRADE_QUANTITY       NUMERIC(31,8),
    FAIR_VALUE           NUMERIC(31,8),
    COB_PRICE            NUMERIC(31,8),
    UNDERLYING_PRICE_T2  NUMERIC(31,8),
    UNDERLYING_PRICE_T1  NUMERIC(31,8),
    TOTAL_DELTA          NUMERIC(31,8),
    TOTAL_GAMMA          NUMERIC(31,8),
    VEGA                 NUMERIC(31,8),
    PV01_BP              NUMERIC(31,8),
    CR01                 NUMERIC(31,8),
    DELTA                NUMERIC(31,8),
    GAMMA                NUMERIC(31,8),
    OTHER_SPOT           NUMERIC(31,8),
    SPOT_PAA             NUMERIC(31,8),
    SPOT_VOL             NUMERIC(31,8),
    SPOT_INTRATE         NUMERIC(31,8),
    SPOT_THETA           NUMERIC(31,8),
    DVD_PL               NUMERIC(31,8),
    VOLATILITY           NUMERIC(31,8),
    RATE                 NUMERIC(31,8),
    CORRELATION          NUMERIC(31,8),
    ASSET_FX_CORRELATION NUMERIC(31,8),
    DIVIDEND             NUMERIC(31,8),
    BORROW_COST          NUMERIC(31,8),
    THETA                NUMERIC(31,8),
    FX_DELTA             NUMERIC(31,8),
    MARK_TO_MKT          NUMERIC(31,8),
    STATIC_PAA_TOTAL     NUMERIC(31,8),
    SECURITY_CHANGE      NUMERIC(31,8),
    KO_TRADES            NUMERIC(31,8),
    EXTROADINARY_PL_T1   NUMERIC(31,8),
    NEW_TRADES           NUMERIC(31,8),
    DAY_TRADING          NUMERIC(31,8),
    UPSIZE_DOWNSIZE      NUMERIC(31,8),
    TERMINATED_TRADES    NUMERIC(31,8),
    INTRADAY_TRADING_PL  NUMERIC(31,8),
    FINANCING_T1         NUMERIC(31,8),
    TOTAL_PAA            NUMERIC(31,8),
    FAIR_ECONOMIC_PL     NUMERIC(31,8),
    RESIDUAL             NUMERIC(31,8),
    UNDERLYINGMNEM       VARCHAR(99),
    PL_CURRENCY          VARCHAR(99),
    UNDERLYINGRIC        VARCHAR(99),
    UNDERLYINGISSUERIC   VARCHAR(99),
    COMPANY_NAME         VARCHAR(99),
    IR_VOL_CUBE          NUMERIC(31,8),
    OSYS                 VARCHAR(99),
    DLY_FX_IMPACT        NUMERIC(31,8),
    MTD_OFF_ECONOM_DFX   NUMERIC(31,8),
    MTD_OFF_ECONOM_USD   NUMERIC(31,8),
    POSN_ALT_STR1        VARCHAR(99),
    POSN_ALT_STR2        VARCHAR(99),
    POSN_ALT_COM2        VARCHAR(99),
    COMPONENT_MNEM_RIC   VARCHAR(99),
    FAIR_VOL             NUMERIC(31,8),
    SECURITY_MNEM        VARCHAR(99),
    ACCOUNT_ENTITY       VARCHAR(99),
    EXOTIC_TYPE          VARCHAR(99),
    SECURITY_CLASS       VARCHAR(99),
    UNDERLYING_TYPE      VARCHAR(99),
    REALISED             NUMERIC(31,8),
    DIVIDEND_PL          NUMERIC(31,8),
    INTEREST_PL          NUMERIC(31,8),
    COMMISSION_PL        NUMERIC(31,8),
    EXTRAORDINARY_PL     NUMERIC(31,8),
    COUPON_PL            NUMERIC(31,8),
    FAIR_ECONOMIC        NUMERIC(31,8),
    FAIR_VALUE_UCCY      NUMERIC(31,8),
    PL_CURR_ID           NUMERIC(21,0),
    CCY_ID               NUMERIC(21,0),
    FIRM_ACCT_ID         NUMERIC(21,0),
    INSM_ID              NUMERIC(21,0),
    LOAD_FILE_NAME       VARCHAR(64),
    LOAD_LINE_NO         NUMERIC(21,0),
    REC_MDFY_USER_ID     VARCHAR(16),
    REC_MDFY_DTM TIMESTAMP,
    REC_MDFY_METH_DESC VARCHAR(30),
    PROC_LOG_ID        NUMERIC(16,0),
    ERR_ID             NUMERIC(21,0),
    PAA_ID             NUMERIC(21,0),
    RGN_ID             NUMERIC(21,0),
    DESCRIPTION        VARCHAR(99)
  );

CREATE INDEX TF_EQRMS_PAA_ID ON 
  TF_EQRMS_PAA
 (
    TM_ID, PAA_ID, RGN_ID
  );

CREATE
    INDEX TF_EQRMS_PAA_NUI ON TF_EQRMS_PAA
   (
      TM_ID,
      PL_POSN_ID,
      RGN_ID
    );

CREATE TABLE TF_EDEALER_PAA
 (
    TM_ID               NUMERIC(21,0) NOT NULL,
    PL_POSN_ID          NUMERIC(21,0),
    FIRMACCOUNTMNEMONIC VARCHAR(99),
    CURRENCY            VARCHAR(99),
    CURRENCYPAIR        VARCHAR(99),
    OASYSDEALID         VARCHAR(30),
    OASYSTRANSACTIONID  NUMERIC(21,0),
    CORPUSID            NUMERIC(21,0),
    DELTASPOT           NUMERIC(31,8),
    DELTAFORWARD        NUMERIC(31,8),
    THETA               NUMERIC(31,8),
    NEWTRADES           NUMERIC(31,8),
    TRADEADJUSTMENTS    NUMERIC(31,8),
    CARRYONCHARGE       NUMERIC(31,8),
    NRFFFUNDING         NUMERIC(31,8),
    RESIDUE             NUMERIC(31,8),
    CCY_ID              NUMERIC(21,0),
    FIRM_ACCT_ID        NUMERIC(21,0),
    INSM_ID             NUMERIC(21,0),
    LOAD_FILE_NAME      VARCHAR(64),
    LOAD_LINE_NO        NUMERIC(21,0),
    REC_MDFY_USER_ID    VARCHAR(16),
    REC_MDFY_DTM TIMESTAMP,
    REC_MDFY_METH_DESC VARCHAR(30),
    PROC_LOG_ID        NUMERIC(16,0),
    ERR_ID             NUMERIC(21,0),
    PAA_ID             NUMERIC(21,0),
    RGN_ID             NUMERIC(21,0)
  );

CREATE INDEX TF_EDEALER_PAA_ID ON 
  TF_EDEALER_PAA
 (
    TM_ID, PAA_ID, RGN_ID
  );

CREATE INDEX TF_EDEALER_PAA_NUI ON TF_EDEALER_PAA
   (
      TM_ID,
      PL_POSN_ID,
      RGN_ID
    );

CREATE TABLE TX_PL_USER_POSN_MAP 
  (	TM_ID NUMERIC(21,0) NOT NULL, 
	PL_POSN_ID NUMERIC(21,0) NOT NULL, 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(16,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	USER_DEFN_1 VARCHAR(255), 
	USER_DEFN_2 VARCHAR(255), 
	USER_DEFN_3 VARCHAR(255), 
	USER_DEFN_4 VARCHAR(255), 
	USER_DEFN_5 VARCHAR(255), 
	PC_RGN VARCHAR(50), 
	STRC_DESC VARCHAR(64), 
	COUP_RT NUMERIC(31,19), 
	TRD_CLAS_CD VARCHAR(1), 
	MDTS_SCR_TYP_ID NUMERIC(21,0), 
	MDTS_SCR_TYP_DESC VARCHAR(30), 
	SETL_ACCT_PRD_NO NUMERIC(5,0), 
	OBJ_INST_ID NUMERIC(21,0), 
	FIRM_ACCT_ID NUMERIC(21,0), 
	INSM_ID NUMERIC(21,0), 
	CCY_ID NUMERIC(21,0), 
	POSN_EXT_KEY_ID NUMERIC(21,0), 
	SRC_SYS_ID NUMERIC(21,0), 
	RGN_ID NUMERIC(21,0), 
	TD_PL_POSN_INDIC_ID NUMERIC(21,0), 
	FUNC_CURX_FAC NUMERIC(31,19), 
	USD_CURX_FAC NUMERIC(31,19), 
	PRC_FAC NUMERIC(31,19), 
	USER_DEFN_MAT_DT DATE, 
	GFRN_CD VARCHAR(100), 
	LN_EFF_DT DATE, 
	PRNT_CUSIP_CD VARCHAR(30), 
	PRNT_INSM_ID NUMERIC(21,0), 
	PROOF_CD VARCHAR(10), 
	PRNT_ID VARCHAR(30), 
	SUB_CAT_DESC VARCHAR(40)
   );

CREATE TABLE TL_SOURCE_SYSTEM 
  (	SRC_SYS_ID NUMERIC(21,0), 
	SRC_SYS_CD VARCHAR(20), 
	SRC_SYS_DESC VARCHAR(30), 
	VARTN_CD VARCHAR(2), 
	CMPO_SRC1_DESC VARCHAR(30), 
	CMPO_SRC2_DESC VARCHAR(30), 
	CMPO_SRC3_DESC VARCHAR(30), 
	CMPO_SRC4_DESC VARCHAR(30), 
	CMPO_SRC5_DESC VARCHAR(30), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(21,0), 
	ERR_ID NUMERIC(21,0), 
	RACE_CORR_CD VARCHAR(1)
   );

CREATE TABLE TL_REGION 
  (	RGN_ID NUMERIC(21,0) NOT NULL, 
	RGN_CD VARCHAR(10), 
	RGN_NM VARCHAR(50), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	 PRIMARY KEY(RGN_ID)

   );

CREATE TABLE TL_CURRENCY 
  (	CCY_ID NUMERIC(21,0) NOT NULL, 
	OBJ_ID NUMERIC(21,0) NOT NULL, 
	CCY_CD VARCHAR(3) NOT NULL, 
	CCY_DESC VARCHAR(255), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL
   );

CREATE TABLE TF_PL_POSITION_YTD 
  (	TM_ID NUMERIC(21,0) NOT NULL, 
	PL_POSN_ID NUMERIC(21,0) NOT NULL, 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	REC_STA_CD VARCHAR(1), 
	YTD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	YTD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	YTD_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	QTD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	QTD_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	FIRM_ACCT_ID NUMERIC(21,0) DEFAULT -1, 
	CCY_ID NUMERIC(21,0) DEFAULT -1, 
	PROC_LOG_ID NUMERIC(21,0), 
	ERR_ID NUMERIC(21,0), 
	OBJ_INST_ID NUMERIC(21,0), 
	YTD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_ERY_ALOC_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	YTD_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_NEW_TRD_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	YTD_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_VAR_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	YTD_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_PYDN_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	YTD_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_USD_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_FUNC_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_ERY_ALOC_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	QTD_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_NEW_TRD_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	QTD_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_VAR_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	QTD_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_PYDN_PL_QTY NUMERIC(18,6) DEFAULT 0, 
	QTD_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_USD_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	QTD_FUNC_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	YTD_OCI_INV_AMT NUMERIC(31,8), 
	YTD_OCI_ACRTN_AMT NUMERIC(31,8), 
	YTD_IMPRMT_PL_AMT NUMERIC(31,8), 
	YTD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	YTD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	YTD_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	YTD_USD_OCI_INV_AMT NUMERIC(31,8), 
	YTD_USD_OCI_ACRTN_AMT NUMERIC(31,8), 
	YTD_USD_IMPRMT_PL_AMT NUMERIC(31,8), 
	YTD_USD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	YTD_USD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	YTD_USD_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	YTD_FUNC_OCI_INV_AMT NUMERIC(31,8), 
	YTD_FUNC_OCI_ACRTN_AMT NUMERIC(31,8), 
	YTD_FUNC_IMPRMT_PL_AMT NUMERIC(31,8), 
	YTD_FUNC_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	YTD_FUNC_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	YTD_FUNC_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	YTD_FAIR_VAL_AMT NUMERIC(31,8), 
	YTD_TOT_OCI_AMT NUMERIC(31,8), 
	YTD_GRO_ECON_OCI_PL_AMT NUMERIC(31,8), 
	YTD_NET_ECON_OCI_PL_AMT NUMERIC(31,8), 
	YTD_USD_FAIR_VAL_AMT NUMERIC(31,8), 
	YTD_USD_TOT_OCI_AMT NUMERIC(31,8), 
	YTD_USD_GRO_ECON_OCI_PL_AMT NUMERIC(31,8), 
	YTD_USD_NET_ECON_OCI_PL_AMT NUMERIC(31,8), 
	YTD_FUNC_FAIR_VAL_AMT NUMERIC(31,8), 
	YTD_FUNC_TOT_OCI_AMT NUMERIC(31,8), 
	YTD_FUNC_GRO_ECON_OCI_PL_AMT NUMERIC(31,8), 
	YTD_FUNC_NET_ECON_OCI_PL_AMT NUMERIC(31,8), 
	QTD_OCI_INV_AMT NUMERIC(31,8), 
	QTD_OCI_ACRTN_AMT NUMERIC(31,8), 
	QTD_IMPRMT_PL_AMT NUMERIC(31,8), 
	QTD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	QTD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	QTD_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	QTD_USD_OCI_INV_AMT NUMERIC(31,8), 
	QTD_USD_OCI_ACRTN_AMT NUMERIC(31,8), 
	QTD_USD_IMPRMT_PL_AMT NUMERIC(31,8), 
	QTD_USD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	QTD_USD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	QTD_USD_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	QTD_FUNC_OCI_INV_AMT NUMERIC(31,8), 
	QTD_FUNC_OCI_ACRTN_AMT NUMERIC(31,8), 
	QTD_FUNC_IMPRMT_PL_AMT NUMERIC(31,8), 
	QTD_FUNC_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	QTD_FUNC_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	QTD_FUNC_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	QTD_FAIR_VAL_AMT NUMERIC(31,8), 
	QTD_TOT_OCI_AMT NUMERIC(31,8), 
	QTD_GRO_ECON_OCI_PL_AMT NUMERIC(31,8), 
	QTD_NET_ECON_OCI_PL_AMT NUMERIC(31,8), 
	QTD_USD_FAIR_VAL_AMT NUMERIC(31,8), 
	QTD_USD_TOT_OCI_AMT NUMERIC(31,8), 
	QTD_USD_GRO_ECON_OCI_PL_AMT NUMERIC(31,8), 
	QTD_USD_NET_ECON_OCI_PL_AMT NUMERIC(31,8), 
	QTD_FUNC_FAIR_VAL_AMT NUMERIC(31,8), 
	QTD_FUNC_TOT_OCI_AMT NUMERIC(31,8), 
	QTD_FUNC_GRO_ECON_OCI_PL_AMT NUMERIC(31,8), 
	QTD_FUNC_NET_ECON_OCI_PL_AMT NUMERIC(31,8), 
	UREL_DISP_FAC NUMERIC, 
	UREL_CALC_FAC NUMERIC
   );

CREATE TABLE TF_PL_POSITION_PTD 
  (	TM_ID NUMERIC(21,0) NOT NULL, 
	PL_POSN_ID NUMERIC(21,0) NOT NULL, 
	OBJ_INST_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_ID NUMERIC(21,0) NOT NULL, 
	INSM_ID NUMERIC(21,0) NOT NULL, 
	CCY_ID NUMERIC(21,0) NOT NULL, 
	POSN_EXT_KEY_ID NUMERIC(21,0) NOT NULL, 
	TRDR_ID NUMERIC(21,0), 
	SRC_SYS_ID NUMERIC(21,0) NOT NULL, 
	RGN_ID NUMERIC(21,0) NOT NULL, 
	TD_PL_POSN_INDIC_ID NUMERIC(21,0) NOT NULL, 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	LTD_OFS_TM_ID NUMERIC(21,0), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	REC_STA_CD VARCHAR(1), 
	PAY_SIDE_COUP_RT NUMERIC(18,6) DEFAULT 0, 
	PAY_SIDE_NOTNL_AMT NUMERIC(31,8) DEFAULT 0, 
	RAP_NOTNL_AMT NUMERIC(31,8) DEFAULT 0, 
	RECV_SIDE_COUP_RT NUMERIC(18,6) DEFAULT 0, 
	RECV_SIDE_NOTNL_AMT NUMERIC(31,8) DEFAULT 0, 
	DISC_AMT NUMERIC(31,8) DEFAULT 0, 
	YLD_AMT NUMERIC(31,8) DEFAULT 0, 
	PRI_PRD_YLD_AMT NUMERIC(31,8) DEFAULT 0, 
	OS_ACCR_AMT NUMERIC(31,8) DEFAULT 0, 
	FIN_RT NUMERIC(31,30) DEFAULT 0, 
	TRADE_DATE_COST_AMT NUMERIC(31,8) DEFAULT 0, 
	POOL_RT_AMT NUMERIC(31,8) DEFAULT 0, 
	OPS_FILE_NO VARCHAR(15), 
	ERY_TRMT_DTM TIMESTAMP, 
	MARK_LST_MDFY_DT DATE, 
	STALEMARK_CD VARCHAR(20), 
	PRC_SYS_NM VARCHAR(20), 
	INT_RT NUMERIC(31,19) DEFAULT 0, 
	INT_SPRD NUMERIC(31,8), 
	MTM_PRC NUMERIC(18,5) DEFAULT 0, 
	WACST_AMT NUMERIC(31,8) DEFAULT 0, 
	INVC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	PTD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	LTD_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	LTD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	FUNC_CURX_FAC NUMERIC(31,19) DEFAULT 0, 
	USD_CURX_FAC NUMERIC(31,19) DEFAULT 0, 
	PRC_FAC NUMERIC(31,19) DEFAULT 0, 
	PTD_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	PTD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	CMSN_SRC_CD VARCHAR(1), 
	AMORT_AMT NUMERIC(31,8) DEFAULT 0, 
	DV01_AMT NUMERIC(31,8) DEFAULT 0, 
	NEW_TRDS_AMT NUMERIC(31,8) DEFAULT 0, 
	CANC_TRDS_AMT NUMERIC(31,8) DEFAULT 0, 
	HCUT_AMT NUMERIC(31,8) DEFAULT 0, 
	GUTS_ID VARCHAR(20) DEFAULT null, 
	PTD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UAMRD_FEE_AMT NUMERIC(31,8), 
	PTD_MKT_PL_AMT NUMERIC(31,8), 
	PTD_CLEAN_PL_AMT NUMERIC(31,8), 
	LTD_PRI_TOT_POSN_QTY NUMERIC(31,8), 
	PTD_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8), 
	PTD_NEW_TRD_PL_AMT NUMERIC(31,8), 
	PTD_NEW_TRD_PL_QTY NUMERIC(18,6), 
	PTD_FEE_INCM_AMT NUMERIC(31,8), 
	PTD_VAR_PL_AMT NUMERIC(31,8), 
	PTD_VAR_PL_QTY NUMERIC(18,6), 
	PTD_ADMIN_EXPN_AMT NUMERIC(31,8), 
	PTD_PYDN_PL_AMT NUMERIC(31,8), 
	PTD_PYDN_PL_QTY NUMERIC(18,6), 
	PTD_OTH_EXPN_AMT NUMERIC(31,8), 
	PTD_USD_UAMRD_FEE_AMT NUMERIC(31,8), 
	PTD_USD_MKT_PL_AMT NUMERIC(31,8), 
	PTD_USD_CLEAN_PL_AMT NUMERIC(31,8), 
	PTD_USD_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8), 
	PTD_USD_NEW_TRD_PL_AMT NUMERIC(31,8), 
	PTD_USD_FEE_INCM_AMT NUMERIC(31,8), 
	PTD_USD_VAR_PL_AMT NUMERIC(31,8), 
	PTD_USD_ADMIN_EXPN_AMT NUMERIC(31,8), 
	PTD_USD_PYDN_PL_AMT NUMERIC(31,8), 
	PTD_USD_OTH_EXPN_AMT NUMERIC(31,8), 
	ACRTN_BAS_CSHFL_AMT NUMERIC(31,8), 
	IMPRMT_FAIR_VAL_AMT NUMERIC(31,8), 
	PTD_OCI_INV_AMT NUMERIC(31,8), 
	USER_DEFN_BAS_CSHFL_AMT NUMERIC(31,8), 
	UNACRTD_WACST_AMT NUMERIC(31,8), 
	PTD_OCI_ACRTN_AMT NUMERIC(31,8), 
	PTD_IMPRMT_PL_AMT NUMERIC(31,8), 
	PTD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	PTD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	PTD_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	PTD_USD_OCI_INV_AMT NUMERIC(31,8), 
	PTD_USD_OCI_ACRTN_AMT NUMERIC(31,8), 
	PTD_USD_IMPRMT_PL_AMT NUMERIC(31,8), 
	PTD_USD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8), 
	PTD_USD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8), 
	PTD_USD_PYDN_RLZD_PL_AMT NUMERIC(31,8), 
	UREL_DISP_FAC NUMERIC(1,0) DEFAULT 1, 
	UREL_CALC_FAC NUMERIC(1,0) DEFAULT 1, 
	MTG_POSN_IND NUMERIC(1,0), 
	ACCT_SUB_CAT_CD VARCHAR(1), 
	IMPRMT_IND NUMERIC(1,0), 
	IMPRMT_COST_BSIS_AMT NUMERIC(31,8), 
	ACCRETIBLE_DISC_AMT NUMERIC(31,8), 
	REMN_RCVR_AMT NUMERIC(31,8), 
	COST_BSIS_DISC_PRC NUMERIC(18,5), 
	ACRTN_ACTG_MDL_CD VARCHAR(1), 
	PRC_UNCHNG_DAYS_CNT NUMERIC(17,0) DEFAULT 0, 
	LTD_OCI_INV_AMT NUMERIC(31,8), 
	LTD_USD_OCI_INV_AMT NUMERIC(31,8), 
	LTD_UAMRD_FEE_AMT NUMERIC(31,8), 
	LTD_USD_UAMRD_FEE_AMT NUMERIC(31,8), 
	LTD_NEW_TRD_PL_QTY NUMERIC(31,8), 
	LTD_VAR_PL_QTY NUMERIC(31,8), 
	LTD_PYDN_PL_QTY NUMERIC(31,8), 
	LTD_UREL_PL_FX_AMT NUMERIC(31,8), 
	LTD_UREL_PL_PREM_AMT NUMERIC(31,8), 
	LTD_USD_UREL_PL_FX_AMT NUMERIC(31,8), 
	LTD_USD_UREL_PL_PREM_AMT NUMERIC(31,8)
   );

CREATE TABLE TF_PL_POSITION_FUNC 
  (	TM_ID NUMERIC(21,0) NOT NULL, 
	PL_POSN_ID NUMERIC(21,0) NOT NULL, 
	OBJ_INST_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_ID NUMERIC(21,0) NOT NULL, 
	INSM_ID NUMERIC(21,0) NOT NULL, 
	CCY_ID NUMERIC(21,0) NOT NULL, 
	POSN_EXT_KEY_ID NUMERIC(21,0) NOT NULL, 
	TRDR_ID NUMERIC(21,0), 
	SRC_SYS_ID NUMERIC(21,0) NOT NULL, 
	RGN_ID NUMERIC(21,0) NOT NULL, 
	TD_PL_POSN_INDIC_ID NUMERIC(21,0) NOT NULL, 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	LTD_OFS_TM_ID NUMERIC(21,0), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	REC_STA_CD VARCHAR(1), 
	FUNC_CURX_FAC NUMERIC(31,19) DEFAULT 0, 
	USD_CURX_FAC NUMERIC(31,19) DEFAULT 0, 
	PRC_FAC NUMERIC(31,19) DEFAULT 0, 
	UREL_DISP_FAC NUMERIC(1,0) DEFAULT 1, 
	UREL_CALC_FAC NUMERIC(1,0) DEFAULT 1, 
	PTD_FUNC_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CLEAN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_ADJS_AND_REFDS_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_FEE_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_ADMIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_OTH_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CR_COST_FAS_114_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CR_COST_RCVRIES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CR_COST_SALE_LOSS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CR_COST_WRTOFF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_UAMRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0
   );

CREATE  TABLE TF_PL_ADJ_REPORT 
  (	TM_ID NUMERIC(21,0), 
	PL_POSN_ID NUMERIC(21,0), 
	RGN_ID NUMERIC(21,0), 
	PROC_LOG_ID NUMERIC(21,0), 
	ERR_ID NUMERIC(21,0), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	FUNC_CURX_FAC NUMERIC(31,19), 
	USD_CURX_FAC NUMERIC(31,19), 
	MKT_CLO_PRC_AMT NUMERIC(31,8) DEFAULT 0, 
	USD_MKT_CLO_PRC_AMT NUMERIC(31,8) DEFAULT 0, 
	FUNC_MKT_CLO_PRC_AMT NUMERIC(31,8) DEFAULT 0, 
	ADJ_PRC NUMERIC(31,8) DEFAULT 0, 
	ADJ_USD_PRC NUMERIC(31,8) DEFAULT 0, 
	ADJ_FUNC_PRC NUMERIC(31,8) DEFAULT 0, 
	DLY_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CPS_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	DLY_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	DLY_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	DLY_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_MIDMKT_AGY_CMSN_AM NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CPS_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_MIDMKT_AGYCMSN_AM NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CPS_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CPS_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	PTD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	PTD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	PTD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_MIDMKT_AGY_CMSN_AM NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CPS_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_BRKG_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_INST_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_MIDMKT_AGYCMSN_AM NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_REV_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CPS_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_CUM_MARKDOWN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_DIV_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_FLR_BRKG_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_FX_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_GL_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IIG_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_INST_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MIDMKT_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_POSN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_PRIN_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_OFS_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_SHR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_SHR_INT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_SHR_PRIN_TRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_AGY_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_CMSN_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_SC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_RTL_SC_RBT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_ACCRETION_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_AI_INCM_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_FIN_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_FIN_INCM_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SD_TO_BE_FIN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SYND_RLZD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_TRAN_TAX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_ORIG_FV_QTY NUMERIC(31,8) DEFAULT 0, 
	LTD_POSN_QTY NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_SD_QTY NUMERIC(31,8) DEFAULT 0, 
	LTD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_ACCRETION_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_AI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_SD_PUR_INT_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_UREL_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_UREL_PL_FX_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_UREL_PL_PREM_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_TRD_FEE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_LEAD_SPRD_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MGT_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UNDWR_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_PRCPM_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SELL_CNCES_POT_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SELL_CNCES_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_INVT_BANK_SHR_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_OTH_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_GL_REV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_LEAD_MGT_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_HDGE_ALOC_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_DEAL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_OVRSL_EXPN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_LGL_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_TRD_SELL_CNCES_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_REV_TRF_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_AGED_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MBDDO_CMSN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_EXPN_RSRVE_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SELL_CNCES_POT2_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SELL_CNCES_POT3_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_SELL_CNCES_POT4_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_MKT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_NEW_TRD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_VAR_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_ACRTN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IMPRMT_FAIR_VAL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USER_DEFN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UNACRTD_WACST_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_ACRTN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IMPRMT_FAIR_VAL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_USER_DEFN_BAS_CSHFL_AM NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UNACRTD_WACST_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_USD_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_ACRTN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IMPRMT_FAIR_VAL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_USER_DEFN_BAS_CSHFL_A NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UNACRTD_WACST_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	DLY_FUNC_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_ACRTN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IMPRMT_FAIR_VAL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USER_DEFN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UNACRTD_WACST_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_ACRTN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IMPRMT_FAIR_VAL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_USER_DEFN_BAS_CSHFL_AM NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UNACRTD_WACST_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_USD_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_ACRTN_BAS_CSHFL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IMPRMT_FAIR_VAL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_USER_DEFN_BAS_CSHFL_A NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UNACRTD_WACST_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_OCI_ACRTN_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_IMPRMT_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UNACRTD_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_UNACRTD_PYDN_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	PTD_FUNC_PYDN_RLZD_PL_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_USD_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	LTD_FUNC_OCI_INV_AMT NUMERIC(31,8) DEFAULT 0, 
	UREL_DISP_FAC NUMERIC(1,0) DEFAULT 1, 
	UREL_CALC_FAC NUMERIC(1,0) DEFAULT 1
   );

CREATE TABLE TD_TRADER_SCD 
  (	TRDR_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_ID NUMERIC(21,0) NOT NULL, 
	CCY_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_MNEM_CD VARCHAR(16) NOT NULL, 
	CCY_CD VARCHAR(3), 
	TRDR_NM VARCHAR(30), 
	STRT_EFF_DT DATE, 
	END_EFF_DT DATE, 
	CURR_IND NUMERIC(1,0), 
	ORIG_FIRM_ACCT_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_NO VARCHAR(8), 
	FIRM_ACCT_DESC VARCHAR(30), 
	FIRM_ACCT_TYP_CD VARCHAR(1), 
	FIRM_ACCT_SUB_TYP_CD VARCHAR(1), 
	SUPER_BSUNIT_ID NUMERIC(21,0) NOT NULL, 
	SUPER_BSUNIT_NM VARCHAR(50), 
	SUPER_BSUNIT_CD VARCHAR(20), 
	BSUNIT_ID NUMERIC(21,0) NOT NULL, 
	BSUNIT_CD VARCHAR(2), 
	BSUNIT_NM VARCHAR(50), 
	SUB_MICRO_ID NUMERIC(21,0) NOT NULL, 
	SUB_MICRO_CD VARCHAR(7), 
	SUB_STGY_ID NUMERIC(21,0) NOT NULL, 
	SUB_STGY_CD VARCHAR(5), 
	SUB_STGY_NM VARCHAR(30), 
	STGY_ID NUMERIC(21,0) NOT NULL, 
	STGY_CD VARCHAR(3), 
	STGY_NM VARCHAR(30), 
	LE_ID NUMERIC(21,0) NOT NULL, 
	LE_CD VARCHAR(3), 
	LE_NM VARCHAR(30), 
	LE_MNEM_CD VARCHAR(20), 
	LV_NM VARCHAR(30), 
	DESK_ID NUMERIC(21,0) NOT NULL, 
	DESK_CD VARCHAR(2), 
	DESK_NM VARCHAR(30), 
	EXPN_ID NUMERIC(21,0) NOT NULL, 
	EXPN_CD VARCHAR(8), 
	CONDI_ID NUMERIC(21,0) NOT NULL, 
	CONDI_CD VARCHAR(10), 
	PROF_CTR_ID NUMERIC(21,0) NOT NULL, 
	PROF_CTR_CD VARCHAR(3), 
	CDS_DIVN_CD VARCHAR(15), 
	TRESTEL_WHS_CD VARCHAR(15), 
	PORT_CD VARCHAR(32), 
	ACCT_ORG_CD VARCHAR(4), 
	SOL_SPEC_ACCT_IND NUMERIC(1,0), 
	REC_STA_CD VARCHAR(1), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	ACCT_GRP_ID NUMERIC(21,0), 
	ACCT_GRP_NM VARCHAR(50), 
	ACCT_FMLY_ID NUMERIC(21,0), 
	ACCT_FMLY_NM VARCHAR(50), 
	TRADING_AREA VARCHAR(8), 
	SYND_IND VARCHAR(10), 
	OUC_CD VARCHAR(8), 
	PL_CTR_NM VARCHAR(8), 
	COM_FIRM_ACCT_MNEM_CD VARCHAR(16), 
	LV_CD VARCHAR(8) DEFAULT 'N/A', 
	AFFL_CD VARCHAR(12) DEFAULT 'N/A', 
	EXPN_NM VARCHAR(30) DEFAULT 'N/A', 
	DEPT_CD VARCHAR(10) DEFAULT 'N/A', 
	DEPT_NM VARCHAR(30) DEFAULT 'N/A', 
	TMS_FIRM_ACCT_NO VARCHAR(8) DEFAULT 'N/A', 
	TMS_FIRM_ACCT_TYP VARCHAR(1) DEFAULT '?', 
	TMS_FIRM_ACCT_CKDG VARCHAR(1) DEFAULT '?', 
	JNT_VNTUR_IND VARCHAR(1) DEFAULT '?', 
	TMS_ACCT_SUB_TYP VARCHAR(3) DEFAULT 'N/A', 
	ACCT_BLOT_CD VARCHAR(5) DEFAULT 'N/A', 
	ESALES_ACCT_ID NUMERIC(21,0), 
	BKG_AREA_CD VARCHAR(16) DEFAULT 'N/A', 
	FLEX_BR_CD VARCHAR(8) DEFAULT 'N/A', 
	FX_SPRD_IND CHAR(1) DEFAULT '?', 
	FUNC_CCY_CD CHAR(3) DEFAULT 'USD', 
	FX_OBJ_NM VARCHAR(128) DEFAULT 'fx_spot_rate', 
	SRC_SYS_NM VARCHAR(16), 
	CTRY_CD VARCHAR(2), 
	MNGD_SEG_LVL_1_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_1_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_1_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_2_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_2_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_2_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_3_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_3_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_3_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_4_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_4_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_4_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_5_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_5_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_5_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_6_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_6_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_6_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_7_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_7_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_7_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_8_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_8_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_8_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_9_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_9_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_9_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_10_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_10_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_10_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_11_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_11_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_11_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_12_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_12_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_12_DESC VARCHAR(100) DEFAULT 'N/A', 
	GOC_ID NUMERIC(21,0), 
	GOC_CD VARCHAR(30) DEFAULT 'N/A', 
	GOC_DESC VARCHAR(100) DEFAULT 'N/A', 
	MICRO_CONTROL_ID NUMERIC(21,0), 
	MICRO_CONTROL_CD VARCHAR(20) DEFAULT 'N/A', 
	MICRO_CONTROL_DESC VARCHAR(100) DEFAULT 'N/A', 
	LE_USECASE3_CGM_IND VARCHAR(3) DEFAULT 'N/A', 
	LE_USECASE3_CGM_DESC VARCHAR(96) DEFAULT 'N/A', 
	GOC_GEO_CD VARCHAR(30) DEFAULT 'N/A', 
	MNGD_SEG_LVL_13_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_13_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_13_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_14_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_14_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_14_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_15_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_15_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_15_DESC VARCHAR(100) DEFAULT 'N/A', 
	GOC_RGN_CD VARCHAR(10) DEFAULT 'N/A', 
	GOC_RGN_DESC VARCHAR(60) DEFAULT 'N/A', 
	HOLDING_CORP_CD VARCHAR(1) DEFAULT '?'
   );

CREATE TABLE TD_POSN_EXTENDED_KEY 
  (	POSN_EXT_KEY_ID NUMERIC(21,0) NOT NULL, 
	LNG_SHRT_ID NUMERIC(21,0) NOT NULL, 
	LNG_SHRT_CD VARCHAR(1) NOT NULL, 
	LNG_SHRT_DESC VARCHAR(30), 
	BRKR_ID NUMERIC(21,0) NOT NULL, 
	BRKR_CD VARCHAR(2) NOT NULL, 
	BRKR_DESC VARCHAR(30), 
	REGIS_COUP_ID NUMERIC(21,0) NOT NULL, 
	REGIS_COUP_CD VARCHAR(1) NOT NULL, 
	RGST_COUP_DESC VARCHAR(30), 
	SUB_ACCT_ID NUMERIC(21,0) NOT NULL, 
	SUB_ACCT_CD VARCHAR(1) NOT NULL, 
	CORPUS_ID NUMERIC(5,0) NOT NULL, 
	TRAN_TYP_CD VARCHAR(30) NOT NULL, 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(16,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	TRAN_TYP_DESC VARCHAR(40), 
	SUB_ACCT_DESC VARCHAR(40)
   );

CREATE TABLE TD_PL_POSITION_INDICATIVE 
  (	TD_PL_POSN_INDIC_ID NUMERIC(21,0) NOT NULL, 
	CTP_ACCT VARCHAR(8), 
	CTP_LE_CD VARCHAR(3), 
	CTP_NM VARCHAR(30), 
	PAY_SIDE_NOTNL_CCY_CD VARCHAR(3), 
	RECV_SIDE_NOTNL_CCY_CD VARCHAR(3), 
	RAP_NOTNL_CCY_CD VARCHAR(3), 
	DEF_SWAP_REF_ENTY VARCHAR(255), 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	CUST_NM VARCHAR(255), 
	GFCID_CD VARCHAR(15), 
	SIC_CD VARCHAR(20), 
	CTP_CONDI_CD VARCHAR(15), 
	QMEMO_PROD_CD VARCHAR(15), 
	QMEMO_PROD_DESC VARCHAR(255), 
	TRD_STATUS_IND_CD VARCHAR(15)
   );

CREATE TABLE TD_INSTRUMENT_SCD 
  (	INSM_ID NUMERIC(21,0) NOT NULL, 
	STRT_EFF_DT DATE, 
	END_EFF_DT DATE, 
	CURR_IND NUMERIC(1,0) NOT NULL, 
	SCR_FI_CD NUMERIC(21,0) NOT NULL, 
	CUSIP_CD VARCHAR(30) NOT NULL, 
	CUSIP_SRC_CD VARCHAR(10) NOT NULL, 
	CUSIP_DESC VARCHAR(50) NOT NULL, 
	UNDL_CUSIP_CD VARCHAR(30), 
	INSM_MAT_DT DATE, 
	COUP_RT NUMERIC(31,19), 
	UNIT_OF_PRC NUMERIC(31,8), 
	UNIT_OF_TRD NUMERIC(31,8), 
	CURR_RT NUMERIC(31,19), 
	NO_OF_CON_RT NUMERIC(31,19), 
	STRK_PRC NUMERIC(31,8), 
	FIT_CD VARCHAR(3), 
	FIT_DESC VARCHAR(42), 
	GCT_CD VARCHAR(5), 
	GCT_DESC VARCHAR(255), 
	PUT_CALL_IND VARCHAR(1), 
	SCR_NO_CD VARCHAR(30) NOT NULL, 
	SCR_IND_CD VARCHAR(7), 
	SCR_TYP_CD VARCHAR(10), 
	SCR_TYP_DESC VARCHAR(42), 
	SCR_SUB_TYP_CD VARCHAR(10), 
	SCR_TICKR_CD VARCHAR(40), 
	SCR_OFFR_CD VARCHAR(1), 
	SCR_CLAS_DESC VARCHAR(42), 
	BNCHMARK_CUSIP_CD VARCHAR(30), 
	BNCHMARK_DESC VARCHAR(50), 
	BNCHMARK_MAT_DT DATE, 
	BNCHMARK_SPRD_AMT NUMERIC(31,8), 
	PROD_CLAS_CD VARCHAR(30), 
	QUICK_CD VARCHAR(9), 
	CDS_PROD_CD VARCHAR(10), 
	LON_PROD_CD VARCHAR(3), 
	TRESTEL_PROD_CD VARCHAR(4), 
	EXPR_DT DATE, 
	CUSIP_DEAL_TRAN_CD VARCHAR(30), 
	TRAN_ID NUMERIC(21,0) NOT NULL, 
	DEAL_CD VARCHAR(30) NOT NULL, 
	CORPUS_ID NUMERIC(21,0) NOT NULL, 
	OTC_CUSIP_CD VARCHAR(30), 
	REC_STA_CD VARCHAR(1), 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	CON_CD VARCHAR(6), 
	VER_NO NUMERIC(21,0), 
	EXCH_CD VARCHAR(6), 
	GEO_CLAS_CD VARCHAR(8), 
	GEO_CLAS_DESC VARCHAR(35), 
	POOL_NO VARCHAR(16), 
	MDY_RTNG VARCHAR(8), 
	SNP_RTNG VARCHAR(8), 
	SCR_OFFR_DESC VARCHAR(42), 
	CCY_CD VARCHAR(3) DEFAULT 'N/A', 
	RIC_CD VARCHAR(40) DEFAULT 'N/A', 
	ISIN_CD VARCHAR(40) DEFAULT 'N/A', 
	OCC_CD VARCHAR(40) DEFAULT 'N/A', 
	ISS_ISIN_CD VARCHAR(40) DEFAULT 'N/A', 
	MSD_CUSIP_CD VARCHAR(40) DEFAULT 'N/A', 
	SEDOL_CD VARCHAR(40) DEFAULT 'N/A', 
	MSD_TAX_CD VARCHAR(8) DEFAULT 'N/A' 

   );

CREATE TABLE TD_FIRM_ACCOUNT_SCD 
  (	FIRM_ACCT_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_MNEM_CD VARCHAR(16), 
	STRT_EFF_DT DATE, 
	END_EFF_DT DATE, 
	CURR_IND NUMERIC(1,0), 
	ORIG_FIRM_ACCT_ID NUMERIC(21,0) NOT NULL, 
	FIRM_ACCT_NO VARCHAR(8), 
	FIRM_ACCT_DESC VARCHAR(30), 
	FIRM_ACCT_TYP_CD VARCHAR(1), 
	FIRM_ACCT_SUB_TYP_CD VARCHAR(1), 
	SUPER_BSUNIT_ID NUMERIC(21,0) NOT NULL, 
	SUPER_BSUNIT_NM VARCHAR(50), 
	SUPER_BSUNIT_CD VARCHAR(20), 
	BSUNIT_ID NUMERIC(21,0) NOT NULL, 
	BSUNIT_CD VARCHAR(2), 
	BSUNIT_NM VARCHAR(50), 
	SUB_MICRO_ID NUMERIC(21,0) NOT NULL, 
	SUB_MICRO_CD VARCHAR(7), 
	SUB_STGY_ID NUMERIC(21,0) NOT NULL, 
	SUB_STGY_CD VARCHAR(5), 
	SUB_STGY_NM VARCHAR(30), 
	STGY_ID NUMERIC(21,0) NOT NULL, 
	STGY_CD VARCHAR(3), 
	STGY_NM VARCHAR(30), 
	LE_ID NUMERIC(21,0) NOT NULL, 
	LE_CD VARCHAR(3), 
	LE_NM VARCHAR(30), 
	LE_MNEM_CD VARCHAR(20), 
	LV_NM VARCHAR(30), 
	DESK_ID NUMERIC(21,0) NOT NULL, 
	DESK_CD VARCHAR(2), 
	DESK_NM VARCHAR(30), 
	EXPN_ID NUMERIC(21,0) NOT NULL, 
	EXPN_CD VARCHAR(8), 
	CONDI_ID NUMERIC(21,0) NOT NULL, 
	CONDI_CD VARCHAR(10), 
	PROF_CTR_ID NUMERIC(21,0) NOT NULL, 
	PROF_CTR_CD VARCHAR(3), 
	CDS_DIVN_CD VARCHAR(15), 
	TRESTEL_WHS_CD VARCHAR(15), 
	PORT_CD VARCHAR(32), 
	ACCT_ORG_CD VARCHAR(4), 
	SOL_SPEC_ACCT_IND NUMERIC(1,0), 
	REC_STA_CD VARCHAR(1), 
	REC_MDFY_DTM TIMESTAMP, 
	REC_MDFY_USER_ID VARCHAR(16), 
	REC_MDFY_METH_DESC VARCHAR(30), 
	PROC_LOG_ID NUMERIC(21,0) NOT NULL, 
	ERR_ID NUMERIC(21,0) NOT NULL, 
	ACCT_GRP_ID NUMERIC(21,0), 
	ACCT_GRP_NM VARCHAR(50), 
	ACCT_FMLY_ID NUMERIC(21,0), 
	ACCT_FMLY_NM VARCHAR(50), 
	TRADING_AREA VARCHAR(8), 
	SYND_IND VARCHAR(10), 
	OUC_CD VARCHAR(8), 
	PL_CTR_NM VARCHAR(8), 
	COM_FIRM_ACCT_MNEM_CD VARCHAR(16), 
	LV_CD VARCHAR(8) DEFAULT 'N/A', 
	AFFL_CD VARCHAR(12) DEFAULT 'N/A', 
	EXPN_NM VARCHAR(30) DEFAULT 'N/A', 
	DEPT_CD VARCHAR(10) DEFAULT 'N/A', 
	DEPT_NM VARCHAR(30) DEFAULT 'N/A', 
	TMS_FIRM_ACCT_NO VARCHAR(8) DEFAULT 'N/A', 
	TMS_FIRM_ACCT_TYP VARCHAR(1) DEFAULT '?', 
	TMS_FIRM_ACCT_CKDG VARCHAR(1) DEFAULT '?', 
	JNT_VNTUR_IND VARCHAR(1) DEFAULT '?', 
	TMS_ACCT_SUB_TYP VARCHAR(3) DEFAULT 'N/A', 
	ACCT_BLOT_CD VARCHAR(5) DEFAULT 'N/A', 
	ESALES_ACCT_ID NUMERIC(21,0), 
	BKG_AREA_CD VARCHAR(16) DEFAULT 'N/A', 
	FLEX_BR_CD VARCHAR(8) DEFAULT 'N/A', 
	FX_SPRD_IND CHAR(1) DEFAULT '?', 
	FUNC_CCY_CD CHAR(3) DEFAULT 'USD', 
	FX_OBJ_NM VARCHAR(128) DEFAULT 'fx_spot_rate', 
	SRC_SYS_NM VARCHAR(16), 
	CTRY_CD VARCHAR(2), 
	MNGD_SEG_LVL_1_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_1_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_1_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_2_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_2_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_2_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_3_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_3_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_3_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_4_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_4_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_4_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_5_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_5_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_5_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_6_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_6_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_6_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_7_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_7_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_7_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_8_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_8_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_8_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_9_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_9_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_9_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_10_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_10_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_10_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_11_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_11_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_11_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_12_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_12_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_12_DESC VARCHAR(100) DEFAULT 'N/A', 
	GOC_ID NUMERIC(21,0), 
	GOC_CD VARCHAR(30) DEFAULT 'N/A', 
	GOC_DESC VARCHAR(100) DEFAULT 'N/A', 
	MICRO_CONTROL_ID NUMERIC(21,0), 
	MICRO_CONTROL_CD VARCHAR(20) DEFAULT 'N/A', 
	MICRO_CONTROL_DESC VARCHAR(100) DEFAULT 'N/A', 
	LE_USECASE3_CGM_IND VARCHAR(3) DEFAULT 'N/A', 
	LE_USECASE3_CGM_DESC VARCHAR(96) DEFAULT 'N/A', 
	GOC_GEO_CD VARCHAR(30) DEFAULT 'N/A', 
	MNGD_SEG_LVL_13_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_13_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_13_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_14_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_14_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_14_DESC VARCHAR(100) DEFAULT 'N/A', 
	MNGD_SEG_LVL_15_ID NUMERIC(21,0), 
	MNGD_SEG_LVL_15_CD VARCHAR(20) DEFAULT 'N/A', 
	MNGD_SEG_LVL_15_DESC VARCHAR(100) DEFAULT 'N/A', 
	GOC_RGN_CD VARCHAR(10) DEFAULT 'N/A', 
	GOC_RGN_DESC VARCHAR(60) DEFAULT 'N/A', 
	HOLDING_CORP_CD VARCHAR(1) DEFAULT '?'
   );
