create diskstore AppDiskStore autocompact false;

CREATE SCHEMA SEC_OWNER;

SET CURRENT SCHEMA SEC_OWNER;

CREATE TABLE SECL_BO_DATA_STATUS_HIST
    (
     BO_TXN_ID VARCHAR (36) NOT NULL ,
     CLIENT_ID VARCHAR (100) ,
     CLIENT_NAME VARCHAR (100) ,
     CLIENT_ACCOUNT VARCHAR (100) ,
     COMPANY_ID VARCHAR (100) ,
     CLIENT_REF_NO VARCHAR (100) ,
     VALUE_DATE TIMESTAMP ,
     AMOUNT DECIMAL (16,2) ,
     CURRENCY VARCHAR (20) ,
     ORIG_BANK_ID VARCHAR (100) ,
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     BENE_ACCNT_NO VARCHAR (100) ,
     BENE_NAME VARCHAR (100) ,
     BENE_ADDR VARCHAR (256) ,
     BENE_BANK_ID VARCHAR (100) ,
     BENE_BANK_NAME VARCHAR (100) ,
     BENE_BANK_ADDR VARCHAR (256) ,
     INSTR_CREATED_TIME TIMESTAMP ,
     INSTR_CREATED_BY VARCHAR (100) ,
     DATA_LIFE_STATUS SMALLINT WITH DEFAULT 0 ,
     MATCH_STATUS SMALLINT WITH DEFAULT 0 ,
     MATCH_DATE TIMESTAMP ,
     MATCH_CATEG_ID INTEGER ,
     MATCHING_TIME INTEGER WITH DEFAULT -1 ,
     MANUAL_MATCH CHAR (1) WITH DEFAULT 'N' ,
     MATCHING_REASON VARCHAR (128) ,
     SCREENING_TIME INTEGER NOT NULL ,
     IS_MANUAL CHAR (1) WITH DEFAULT 'N' ,
     IS_RESENT CHAR (1) WITH DEFAULT 'N' ,
     CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,
     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,
     OFAC_MSG_ID VARCHAR (64) NOT NULL ,
     HIT_STATUS SMALLINT ,
     FILE_TYPE VARCHAR (36) WITH DEFAULT 'NA',
     ACTUAL_VALUE_DATE TIMESTAMP ,
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP NOT NULL
     )
    PARTITION BY COLUMN (BO_TXN_ID)                                     
    REDUNDANCY 1 
	EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS						    
;

ALTER TABLE SECL_BO_DATA_STATUS_HIST
    ADD CONSTRAINT SECL_BO_DATA_STATUS_HIST_PK PRIMARY KEY
    (
      BO_TXN_ID,
      LAST_UPDATE_TIME
    )
;

CREATE TABLE SECL_BO_RAW_DATA
    (
     BO_TXN_ID VARCHAR (36) NOT NULL ,
     BO_RAW_DATA CLOB,
     MESSAGE_ID VARCHAR (64) ,
     INCOMING_QUEUE VARCHAR (64),
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP
    )  
    PARTITION BY COLUMN (BO_TXN_ID)                          
    COLOCATE WITH (SECL_BO_DATA_STATUS_HIST)                
    REDUNDANCY 1 
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                                       	
;

ALTER TABLE SECL_BO_RAW_DATA
    ADD CONSTRAINT SECL_BO_RAW_DATA_PK PRIMARY KEY
    (
      BO_TXN_ID
    )
;

CREATE TABLE SECL_MATCHED_DATA
    (
     BACKOFFICE_TXN_ID VARCHAR (36) NOT NULL ,
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     MATCH_DATE TIMESTAMP NOT NULL ,
     MATCH_STATUS SMALLINT NOT NULL
    )
    PARTITION BY COLUMN (BACKOFFICE_TXN_ID)             
    COLOCATE WITH (SECL_BO_DATA_STATUS_HIST)                
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;

CREATE TABLE SECL_BO_DATA_STATUS_HIST_TEMP
    (
                BO_TXN_ID VARCHAR (36) NOT NULL,
   				DATA_LIFE_STATUS SMALLINT WITH DEFAULT 0,
                VALUE_DATE TIMESTAMP ,
                LAST_UPDATE_TIME TIMESTAMP
    )
    PARTITION BY COLUMN (BO_TXN_ID)                
    COLOCATE WITH (SECL_BO_DATA_STATUS_HIST)                   
    REDUNDANCY 1
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS  

;

CREATE TABLE SECT_CHANNEL_DATA
    (
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     CLIENT_ID VARCHAR (100) ,
     CLIENT_NAME VARCHAR (100) ,
     CLIENT_ACCOUNT VARCHAR (100) ,
     COMPANY_ID VARCHAR (100) ,
     CLIENT_REF_NO VARCHAR (100) ,
     VALUE_DATE TIMESTAMP ,
     AMOUNT DECIMAL (16,2) ,
     CURRENCY VARCHAR (20) ,
     PAY_METHOD VARCHAR (100) ,
     PAY_VEHICLE VARCHAR (100) ,
     ORIG_BANK_ID VARCHAR (100) ,
     BACKOFFICE_CODE VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,
     BENE_ACCNT_NO VARCHAR (100) ,
     BENE_NAME VARCHAR (100) ,
     BENE_ADDR VARCHAR (100) ,
     BENE_BANK_ID VARCHAR (100) ,
     BENE_BANK_NAME VARCHAR (100) ,
     BENE_BANK_ADDR VARCHAR (256) ,
     CLIENT_FILE_ID VARCHAR (255) ,
     CLIENT_FILE_TIME TIMESTAMP ,
     CHN_TXN_CREATED_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,
     RAW_DATA CLOB NOT NULL ,
     DATA_LIFE_STATUS SMALLINT NOT NULL ,
     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,
     LAST_MATCH_DATE TIMESTAMP ,
     MATCH_CATEG_ID INTEGER ,
     IS_REJECTED CHAR (1) WITH DEFAULT 'N' ,
     IS_CANCELLED CHAR (1) WITH DEFAULT 'N' ,
     FILE_TYPE_ID VARCHAR (36) NOT NULL ,
     ETL_TIME INTEGER NOT NULL ,
     CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,
     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,
     HIT_STATUS SMALLINT ,
     ACTUAL_VALUE_DATE TIMESTAMP ,
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP ,
     CONSTRAINT SECT_CHANNEL_DATA_PK PRIMARY KEY(CHANNEL_TXN_ID)
    )
    
    PARTITION BY PRIMARY KEY                            
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;

CREATE TABLE SECL_CHN_DATA_STATUS_HIST
    (
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     BACKOFFICE_CODE VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,
     CHN_TXN_CREATED_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,
     DATA_LIFE_STATUS SMALLINT NOT NULL ,
     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,
     MATCH_CATEG_ID INTEGER ,
     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,
     HIT_STATUS SMALLINT ,
     ACTUAL_VALUE_DATE TIMESTAMP ,
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP NOT NULL 
    )
    PARTITION BY COLUMN (CHANNEL_TXN_ID)                
    COLOCATE WITH (SECT_CHANNEL_DATA)                   
    REDUNDANCY 1
	EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS  
;

ALTER TABLE SECL_CHN_DATA_STATUS_HIST
    ADD CONSTRAINT SECL_CHN_DATA_STATUS_HIST_PK PRIMARY KEY
    (
      CHANNEL_TXN_ID,
	  LAST_UPDATE_TIME
    )
;

CREATE TABLE SECT_CHANNEL_RAW_DATA
    (
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     CHN_RAW_DATA CLOB,
     ERROR_CODE   VARCHAR (36),
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,
	 CONSTRAINT SECT_CHANNEL_RAW_DATA_PK PRIMARY KEY
    (
    CHANNEL_TXN_ID
    )
    )
    PARTITION BY PRIMARY KEY
    COLOCATE WITH (SECT_CHANNEL_DATA)
    REDUNDANCY 1
;

CREATE TABLE SECL_CHN_ORPHAN_DATA_STATUS
    (
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     CHANNEL_NAME VARCHAR (100) NOT NULL ,
     FILE_TYPE VARCHAR (30) NOT NULL ,
     TXN_TYPE VARCHAR (30) NOT NULL ,
     DATA_LIFE_STATUS SMALLINT NOT NULL ,
     MATCH_STATUS SMALLINT NOT NULL ,
     MATCH_CATEG_ID SMALLINT NOT NULL ,
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP
    )
    PARTITION BY (DATE(LAST_UPDATE_TIME))               
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;


ALTER TABLE SECL_CHN_ORPHAN_DATA_STATUS
    ADD CONSTRAINT SECL_CHN_ORPHAN_DATA_STATUS_PK PRIMARY KEY
    (
    CHANNEL_TXN_ID
    )
;



CREATE TABLE SECL_OFAC_MESSAGE
    (
     BO_TXN_ID VARCHAR (36) ,
     CHN_TXN_ID VARCHAR (36) ,
     HIT_STATUS SMALLINT ,
     MESSAGE_GUID VARCHAR (36) NOT NULL ,
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP ,
     SCREENING_TIME INTEGER ,
     NO_OF_CHUNKS INTEGER ,
     FS_MESSAGE_ID VARCHAR (64) NOT NULL ,
     DATA_LIFE_STATUS SMALLINT
    )
    PARTITION BY COLUMN (FS_MESSAGE_ID)                    
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;


CREATE TABLE SECL_OFAC_CHUNKED_MESSAGE
    (
     CHUNK_ID VARCHAR (36) NOT NULL ,  
     FS_MESSAGE_ID VARCHAR (64) NOT NULL ,
     BACKOFFICE_TXN_ID VARCHAR (36) ,
     CHANNEL_TXN_ID VARCHAR (36) ,
     CHUNK_SEQ INTEGER ,
     CHUNKED_MSG CLOB ,
     FIRC_OUT_RES_HEADER CLOB, 
     SENT_DATE TIMESTAMP ,
     RECEIVING_TIME TIMESTAMP ,
     ACK_STATUS SMALLINT ,  
     OUT_STATUS SMALLINT , 
	 SENT_LIFE_STATUS SMALLINT, 
     OFAC_COMMENTS VARCHAR (512),
     CHECKSUM VARCHAR (32),
	 LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP 
    )
    PARTITION BY COLUMN (FS_MESSAGE_ID)                    
    COLOCATE WITH (SECL_OFAC_MESSAGE)
    REDUNDANCY 1
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;




CREATE TABLE SECT_FILE_DETAIL
    (
     FILE_INTERNAL_ID VARCHAR (36) NOT NULL ,
     FILE_ID VARCHAR (100) ,
     FILE_TYPE VARCHAR (30) NOT NULL ,
     PROCESS_DT TIMESTAMP NOT NULL WITH DEFAULT CURRENT TIMESTAMP ,
     FILE_HEADER CLOB NOT NULL
        ,
     FILE_TRAIL CLOB NOT NULL
        ,
     SUB_FILE_HEADER CLOB
        ,
     SUB_FILE_HEADER2 CLOB
        ,
     BATCH_FILE_DEADER CLOB

    )
;

ALTER TABLE SECT_FILE_DETAIL
    ADD CONSTRAINT SECT_FILE_DETAIL_PK PRIMARY KEY
    (
    FILE_INTERNAL_ID
    )
;


CREATE TABLE SECL_APP_LOG
    (
     APP_LOG_ID VARCHAR (36) NOT NULL ,
     LOG_TYPE CHAR (1) NOT NULL ,
     LOG_SUB_TYPE VARCHAR (30) NOT NULL ,
     LOG_KEY_VALUE VARCHAR (32) ,
     LOG_MSG LONG VARCHAR,
     LOG_TIMESTAMP TIMESTAMP NOT NULL
    )

    PARTITION BY (DATE(LOG_TIMESTAMP))                  
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
    
;

ALTER TABLE SECL_APP_LOG
    ADD CONSTRAINT SECL_APP_LOG_PK PRIMARY KEY
    (
    APP_LOG_ID
    )
;

CREATE TABLE SECL_CHANGE_CONTROL
    (
     CHANGE_ID VARCHAR (36) NOT NULL ,
     CHANGE_TYPE VARCHAR (10) NOT NULL ,
     CHANGE_CATEGORY VARCHAR (20) NOT NULL ,
     CHANGE_DETAIL CLOB
         ,
     CREATE_DATE TIMESTAMP NOT NULL ,
     CREATE_BY VARCHAR (20) NOT NULL ,
     IS_APPROVED CHAR (1) NOT NULL ,
     APPROVE_DATE TIMESTAMP NOT NULL ,
     APPROVED_BY VARCHAR (20) NOT NULL ,
     IS_COMMIT CHAR (1) NOT NULL ,
     COMMIT_DATE TIMESTAMP NOT NULL
    )

    REPLICATE                                           
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             

;


ALTER TABLE SECL_CHANGE_CONTROL
    ADD CONSTRAINT SECL_CHANGE_CONTROL_PK PRIMARY KEY
    (
    CHANGE_ID
    )
;

CREATE TABLE SECL_EXCEPTION_LOG
    (
     EXCEPTION_ID VARCHAR (36) NOT NULL ,
     EXCEPTION_TYPE SMALLINT WITH DEFAULT 0 ,
     EXCEPTION_MODULE VARCHAR (10) NOT NULL ,
     SEVERITY SMALLINT WITH DEFAULT 3 ,
     EXCEPTION_MSG CLOB NOT NULL,
     EXCEPTION_TIME TIMESTAMP NOT NULL
    )
    PARTITION BY COLUMN (EXCEPTION_ID)                  
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;


ALTER TABLE SECL_EXCEPTION_LOG
    ADD CONSTRAINT SECL_EXCEPTION_LOG_PK PRIMARY KEY
    (
    EXCEPTION_ID
    )
;


CREATE TABLE SECL_EXCEPTION_REPORTS
    (
     EXCEPTION_ID VARCHAR (36) NOT NULL ,
     REPORT_DATE TIMESTAMP NOT NULL ,
     REPORT_CHANNEL VARCHAR (10) NOT NULL ,
     REPORT_STATUS SMALLINT WITH DEFAULT 1 ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_COMMENT VARCHAR (256) NOT NULL
    )
    
    PARTITION BY COLUMN (EXCEPTION_ID)                  
    COLOCATE WITH (SECL_EXCEPTION_LOG)                  
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                           
    
;

CREATE TABLE SECL_MQ_LOG
    (
     OFAC_MQ_LOG_ID VARCHAR (36) NOT NULL ,
     MQ_MSG_ID VARCHAR (24) ,
     MQ_CORRELATION_ID VARCHAR (24) ,
     STATUS VARCHAR (3) NOT NULL ,
     MQ_FEEDBACK VARCHAR (30) ,
     MQ_CONTENT CLOB NOT NULL
         ,
     LAST_UPDATE_USER VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE DATE NOT NULL ,
     IN_OUT_IND CHAR (1) NOT NULL ,
     SECT_MQ_ID VARCHAR (36) NOT NULL
    )
    
    PARTITION BY (DATE(LAST_UPDATE_DATE))               
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
    
;


ALTER TABLE SECL_MQ_LOG
    ADD CONSTRAINT SECT_ORPHAN_MQ_LOG_PK PRIMARY KEY
    (
    OFAC_MQ_LOG_ID
    )
;


CREATE TABLE SECL_SYS_LOG
    (
     SYS_LOG_ID VARCHAR (36) NOT NULL ,
     LOG_TYPE CHAR (1) NOT NULL ,
     LOG_SUB_TYPE VARCHAR (30) NOT NULL ,
     LOG_KEY_VALUE VARCHAR (32) ,
     LOG_MSG CLOB
         ,
     LOG_DATE TIMESTAMP ,
     LOG_USER VARCHAR (30)
    )
    
    PARTITION BY (DATE(LOG_DATE))                       
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
    
;


ALTER TABLE SECL_SYS_LOG
    ADD CONSTRAINT SECL_SYS_LOG_PK PRIMARY KEY
    (
    SYS_LOG_ID
    )
;


CREATE TABLE SECL_USER_ACCESS_LOG
    (
     LOG_SEQ VARCHAR (36) NOT NULL ,
     ACCESS_USER VARCHAR (30) NOT NULL ,
     ACCESS_TIME TIMESTAMP NOT NULL ,
     FROM_SERVER VARCHAR (100) NOT NULL ,
     ACTION_TYPE CHAR (1) NOT NULL ,
     SQL_STMT CLOB

    )
    
    PARTITION BY (DATE(ACCESS_TIME))                    
    REDUNDANCY 1                                        
    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
    
;

ALTER TABLE SECL_USER_ACCESS_LOG
    ADD CONSTRAINT SECL_USER_ACCESS_LOG_PK PRIMARY KEY
    (
    LOG_SEQ
    )
;

CREATE TABLE SECM_BACKOFFICE_ONBOARDED
    (
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     BACKOFFICE_NAME VARCHAR (30) NOT NULL ,
     DESCRIPTION VARCHAR (100) ,
     BACKOFFICE_LOC VARCHAR (10) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_BACKOFFICE_ONBOARDED
    ADD CONSTRAINT SECM_BACKOFFICE_ONBOARDED_PK PRIMARY KEY
    (
    BACKOFFICE_CODE
    )
;


CREATE TABLE SECM_BO_MESSAGE_TAG_MAPPING
    (
     TAG VARCHAR (64) ,
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     MESSAGE_TYPE VARCHAR (64) ,
     KEY_ID VARCHAR (64) ,
     COMMENTS VARCHAR (64) NOT NULL ,
     ONBOARDED_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL ,
     ACTION_KEY VARCHAR (36) NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;



CREATE TABLE SECM_BS_DETERMINATION_GENERAL
    (
     FILE_CATEGORY VARCHAR (30) NOT NULL ,
     "FACTOR#1" VARCHAR (30) NOT NULL ,
     "FACTOR#2" VARCHAR (30) NOT NULL ,
     FULL_DESTINATION VARCHAR (50) NOT NULL ,
     FINAL_DESTINATION VARCHAR (30) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_BS_DETERMINATION_GENERAL
    ADD CONSTRAINT SECM_BS_DETERMINATION_GENERAL_PK PRIMARY KEY
    (
    FILE_CATEGORY,
    "FACTOR#1",
    "FACTOR#2"
    )
;


CREATE TABLE SECM_BS_DETERMINATION_PAIN001
    (
     FILE_CATEGORY VARCHAR (30) NOT NULL ,
     CLEARING_CHANNEL VARCHAR (30) NOT NULL ,
     BANK_ID VARCHAR (30) NOT NULL ,
     PAYMENT_TYPE VARCHAR (30) ,
     CHECK_TYPE VARCHAR (30) ,
     SERVICE_LEVEL VARCHAR (30) ,
     PRIORITY VARCHAR (30) ,
     FULL_DESTINATION VARCHAR (50) NOT NULL ,
     FINAL_DESTINATION VARCHAR (30) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;



CREATE TABLE SECM_CATEGORIZATION
    (
     CATEG_ID INTEGER NOT NULL ,
     CATEG_TYPE VARCHAR (30) NOT NULL ,
     CATEG_DESC VARCHAR (1000) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_CATEGORIZATION
    ADD CONSTRAINT SECM_CATEORISACTION_PK PRIMARY KEY
    (
    CATEG_ID
    )
;


CREATE TABLE SECM_DATA_DESTINATION
    (
     DATA_DESTI VARCHAR (20) NOT NULL ,
     LOC_DESC VARCHAR (100) NOT NULL ,
     SRC_TABLE VARCHAR (30) NOT NULL ,
     TGT_TABLE VARCHAR (30) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_DATA_DESTINATION
    ADD CONSTRAINT SECM_DATA_DESTINATION_PK PRIMARY KEY
    (
    DATA_DESTI
    )
;


CREATE TABLE SECM_FILE_CATEGORY
    (
     FILE_CATEGORY VARCHAR (30) NOT NULL ,
     BS_DETERMINATION_TAB VARCHAR (30) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_FILE_CATEGORY
    ADD CONSTRAINT SECM_FILE_CATEGORY_PK PRIMARY KEY
    (
    FILE_CATEGORY
    )
;


CREATE TABLE SECM_FILE_TYPE_ONBOARDED
    (
     FILE_TYPE_ID VARCHAR (36) NOT NULL ,
     FILE_TYPE VARCHAR (30) NOT NULL ,
     FILE_CATEGORY VARCHAR (30) NOT NULL ,
     DESCRIPTION VARCHAR (100) ,
     FILE_TYPE_MAPPING_TAB VARCHAR (30) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;



ALTER TABLE SECM_FILE_TYPE_ONBOARDED
    ADD CONSTRAINT SECM_FILE_ONBOARDED_PK PRIMARY KEY
    (
    FILE_TYPE_ID
    )
;


CREATE TABLE SECM_FILE_WATCHER
    (
     FILE_WATCHER_ID VARCHAR (36) NOT NULL ,
     BACKOFFICE_CODE VARCHAR (30) NOT NULL ,
     BACKOFFICE_NAME VARCHAR (30) NOT NULL ,
     CHANNEL VARCHAR (100) ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_FILE_WATCHER
    ADD CONSTRAINT SECM_FILE_WATCHER_PK PRIMARY KEY
    (
    FILE_WATCHER_ID
    )
;


CREATE TABLE SECM_FILE_WATCHER_CONFIGS
    (
     FILE_WATCHER_ID VARCHAR (36) NOT NULL ,
     CONFIG_KEY VARCHAR (20) NOT NULL ,
     CONFIG_VALUE VARCHAR (256) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;



CREATE TABLE SECM_FIRCOSOFT_HEADER_MAPPING
    (
     FIELD_NAME VARCHAR (30) NOT NULL ,
     EXPLANATION VARCHAR (256) ,
     IS_MANDATORY CHAR (1) NOT NULL ,
     USED_BY VARCHAR (50) ,
     BYTES INTEGER NOT NULL ,
     FIELD_TYPE VARCHAR (10) NOT NULL ,
     FMF_VERIFY_FIELD VARCHAR (20) ,
     SECURITAS_VALUE VARCHAR (100) ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_FIRCOSOFT_HEADER_MAPPING
    ADD CONSTRAINT SECM_FIRCOSOFT_HEADER_MAPPING_PK PRIMARY KEY
    (
    FIELD_NAME
    )
;


CREATE TABLE SECM_FIRCOSOFT_XML_TAGS
    (
     XML_TAG VARCHAR (30) NOT NULL ,
     DESCRIPTION VARCHAR (100) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_FIRCOSOFT_XML_TAGS
    ADD CONSTRAINT SECM_FIRCOSOFT_XML_TAGS_PK PRIMARY KEY
    (
    XML_TAG
    )
;


CREATE TABLE SECM_HIT_STATUS_MAP
    (
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     OFAC_STATUS SMALLINT NOT NULL ,
     SEC_STATUS SMALLINT ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_HIT_STATUS_MAP
    ADD CONSTRAINT SECM_HIT_STATUS_MAP_PK PRIMARY KEY
    (
    OFAC_STATUS,
    BACKOFFICE_CODE
    )
;


CREATE TABLE SECM_KEY_LIST
    (
     KEY_ID VARCHAR (36) NOT NULL ,
     KEY_NAME VARCHAR (30) NOT NULL ,
     DESCRIPTION VARCHAR (50) ,
     DEFINED_BY VARCHAR (10) WITH DEFAULT 'SECURITAS' ,
     KEY_DT VARCHAR (10) NOT NULL ,
     KEY_CATEGORY CHAR (1) WITH DEFAULT 'P' ,
     CHN_DATA_TABLE VARCHAR (30) NOT NULL ,
     BO_DATA_TABLE VARCHAR (30) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_KEY_LIST
    ADD CONSTRAINT SECM_KEY_LIST_PK PRIMARY KEY
    (
    KEY_ID
    )
;


CREATE TABLE SECM_LOCATION
    (
     LOCATION_CODE VARCHAR (10) NOT NULL ,
     LOCATION_NAME VARCHAR (20) NOT NULL ,
     DATA_ARCHIVE INTEGER NOT NULL ,
     TIME_ZONE VARCHAR (10) NOT NULL ,
     TIME_FORMAT VARCHAR (30) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_LOCATION
    ADD CONSTRAINT SECM_LOCATION_PK PRIMARY KEY
    (
    LOCATION_CODE
    )
;


CREATE TABLE SECM_MATCHING_KEY_INFO
    (
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     KEY_ID VARCHAR (36) NOT NULL ,
     MATCHING_PRIORITY SMALLINT NOT NULL,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP
    )

    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_MATCHING_KEY_INFO
    ADD CONSTRAINT SECM_MATCHING_KEY_INFO_PK PRIMARY KEY
    (
    BACKOFFICE_CODE,
    KEY_ID,
	MATCHING_PRIORITY
    )
;


CREATE TABLE SECM_MQ
    (
     MQ_ID VARCHAR (36) NOT NULL ,
     MGR_NAME VARCHAR (15) NOT NULL ,
     MQ_NAME VARCHAR (30) NOT NULL ,
     TXN_ACTION VARCHAR (25) ,
     TRANSFORMER_REFS VARCHAR (100) ,
     EXCHANGE_PATTERN VARCHAR (16) NOT NULL ,
     MQ_STATUS VARCHAR (10) WITH DEFAULT 'ACTIVE' ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_MQ
    ADD CONSTRAINT SECM_MQ_PK PRIMARY KEY
    (
    MQ_ID
    )
;


CREATE TABLE SECM_MQ_BO_MAP
    (
     MQ_ID VARCHAR (36) NOT NULL ,
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_MQ_BO_MAP
    ADD CONSTRAINT SECM_MQ_BO_MAP_PK PRIMARY KEY
    (
    BACKOFFICE_CODE,
    MQ_ID
    )
;


CREATE TABLE SECM_MQ_MGR
    (
     MGR_NAME VARCHAR (15) NOT NULL ,
     PROCESS_ID VARCHAR (10) NOT NULL ,
     CONNECTOR_CONFIG CLOB NOT NULL
         ,
     MQ_MGR VARCHAR (10) NOT NULL ,
     MQ_FACTORY_NAME VARCHAR (10) NOT NULL ,
     HOSTNAME VARCHAR (50) NOT NULL ,
     CHANNEL VARCHAR (30) ,
     MQ_PORT VARCHAR (50) NOT NULL ,
     TRANSPORT_TYPE VARCHAR (50) ,
     SSL_CIPHER VARCHAR (50) ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_MQ_MGR
    ADD CONSTRAINT SECM_MQ_MGR_PK PRIMARY KEY
    (
    MGR_NAME
    )
;


CREATE TABLE SECM_OFAC_MQ_ROUTING
    (
     INPUT_MQ_ID VARCHAR (36) NOT NULL ,
     LOB VARCHAR (10) NOT NULL ,
     LEGAL_ENTITY VARCHAR (50) ,
     BUSINESS_TYPE VARCHAR (50) ,
     MSG_TYPE VARCHAR (50) ,
     CURRENCY VARCHAR (10) ,
     FIRCOSOFT_MQ_ID VARCHAR (36) NOT NULL ,
     ACK_MQ_ID VARCHAR (36) NOT NULL ,
     DECISION_MQ_ID VARCHAR (36) NOT NULL ,
     STOP_MQ_ID VARCHAR (36) ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPADTE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;

CREATE TABLE SECM_PARSER_CONFIGURATION
    (
     PARSER_ID INTEGER ,
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     PARSER_NAME VARCHAR (64) ,
     MESSAGE_TYPE VARCHAR (64) ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;



CREATE TABLE SECM_PREMATCH_TRANSFORMATION
    (
     ACTION_KEY VARCHAR (36) NOT NULL ,
     ACTION_NAME VARCHAR (30) NOT NULL ,
     DESCRIPTION VARCHAR (100) ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_PREMATCH_TRANSFORMATION
    ADD CONSTRAINT SECM_PREMATCH_TRANSF_PK PRIMARY KEY
    (
    ACTION_KEY
    )
;


CREATE TABLE SECM_PROCESS_CONFIG
    (
     PROCESS_ID VARCHAR (10) NOT NULL ,
     HOSTNAME VARCHAR (100) NOT NULL ,
     ROOT_PATH VARCHAR (200) NOT NULL ,
     MULE_CONFIG CLOB NOT NULL
         ,
     START_COMMAND VARCHAR (200) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_PROCESS_CONFIG
    ADD CONSTRAINT SECM_PROCESS_CONFIG_PK PRIMARY KEY
    (
    PROCESS_ID
    )
;


CREATE TABLE SECM_STATUS_DECISION_DATA
    (
     PREV_MATCH_STATUS SMALLINT NOT NULL ,
     CURRENT_STATUS SMALLINT ,
     NEEDS_UPDATE CHAR (1) ,
     APPLICABLE_FOR VARCHAR (10)
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


CREATE TABLE SECM_TXN_MANAGEMENT
    (
     BACKOFFICE_CODE VARCHAR (100) NOT NULL ,
     TXN_TYPE VARCHAR (30) NOT NULL WITH DEFAULT 'UNKNOWN' ,
     DESCRIPTION VARCHAR (100) ,
     TXN_RETENTION INTEGER NOT NULL ,
     TXN_ORPHAN INTEGER NOT NULL ,
     TXN_HOUSEKEEPING INTEGER NOT NULL ,
     --TXN_HOUSEKEEPING_ORPHAN INTEGER NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_TXN_MANAGEMENT
    ADD CONSTRAINT SECM_TXN_MANAGEMENT_PK PRIMARY KEY
    (
    BACKOFFICE_CODE,
    TXN_TYPE
    )
;


CREATE TABLE SECM_XML_TAG_MAPPINGS
    (
     FILE_TYPE_ID VARCHAR (36) NOT NULL ,
     XML_START_TAG VARCHAR (30) NOT NULL ,
     XML_CLOSE_TAG VARCHAR (30) NOT NULL ,
     XML_COMMENT VARCHAR (100) ,
     TAG_FORMAT VARCHAR (50) ,
     KEY_ID VARCHAR (36) NOT NULL ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
    
    REPLICATE                                   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                     
    
;


ALTER TABLE SECM_XML_TAG_MAPPINGS
    ADD CONSTRAINT SECM_XML_TAG_MAPPINGS_PK PRIMARY KEY
    (
    FILE_TYPE_ID,
    XML_START_TAG,
    XML_CLOSE_TAG
    )
;


CREATE TABLE SECM_TEMPLATE
    (
     TEMPLATE_ID VARCHAR (50),
     TEMPLATE_FILE_NAME VARCHAR(200),
     DESCRIPTION VARCHAR (200),
     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,
	 CONSTRAINT SECM_TEMPLATE_PK PRIMARY KEY
         (
         TEMPLATE_ID
         )
    )
	REPLICATE   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;

CREATE TABLE SECM_ACTION_HANDLER
	(
		ACTION_HANDLER_ID VARCHAR (50),
		DESCRIPTION VARCHAR (200),
		FQCN VARCHAR(200),
		CONSTRAINT SECM_ACTION_HANDLERS_PK PRIMARY KEY(
			ACTION_HANDLER_ID
		)
	)
	REPLICATE    
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS                             
;

CREATE TABLE SECM_ERROR_CODES
	(
		ERROR_CODE VARCHAR(50),
		DESCRIPTION VARCHAR(200),
		CONSTRAINT SECM_ERROR_CODES_PK PRIMARY KEY
		(
			ERROR_CODE
		)
	)
	
	REPLICATE    
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;
    
CREATE TABLE SECM_USER
	(
		USERID VARCHAR (50),
		USER_EMAIL_ID VARCHAR (50),
		CONSTRAINT SECM_USER_PK PRIMARY KEY
			(
				USERID
			)
	)
	
	REPLICATE   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;
	                              
CREATE TABLE SECM_GROUP
	(
		GROUPID VARCHAR (50),
		GROUP_NAME VARCHAR(50),
		DESCRIPTION VARCHAR(200),
		CONSTRAINT SECM_GROUP_PK PRIMARY KEY
		(
			GROUPID
		)
	)
	
	REPLICATE  
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;
	
CREATE TABLE SECM_COUNTRY
	(
		COUNTRY_CODE VARCHAR(10),
		COUNTRY_NAME VARCHAR(50),
		LOCALE VARCHAR(10),
		CONSTRAINT SECM_COUNTRY_PK PRIMARY KEY
		(
			COUNTRY_CODE
		),
		
		CONSTRAINT SECM_COUNTRY_UNQ UNIQUE
		(
		LOCALE
		)
		
	)	
	
	REPLICATE   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;
	

CREATE TABLE SECM_ERROR_TEMPLATE
	(
	ERROR_CODE VARCHAR (50),
	TEMPLATE_ID VARCHAR (50),
	USER_GROUP_ID VARCHAR (50),
	CONSTRAINT SECM_ERROR_TEMPLATE_PK PRIMARY KEY
		(
			ERROR_CODE,
			USER_GROUP_ID
		),
		
	CONSTRAINT SECM_ERROR_TEMPLATE_FK FOREIGN KEY(
		TEMPLATE_ID
		)
	REFERENCES SECM_TEMPLATE (
		TEMPLATE_ID
		),
		
	CONSTRAINT SECM_ERROR_TEMPLATE_FK2 FOREIGN KEY(
		ERROR_CODE
		)	
	REFERENCES SECM_ERROR_CODES(
		ERROR_CODE
		)
	)
	
	REPLICATE  
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;
    
 CREATE TABLE SECM_ERROR_ACTION_HANDLER(
 	ERROR_CODE VARCHAR(50),
 	ACTION_HANDLER_ID VARCHAR(50),
 	CONSTRAINT SECM_ERROR_ACTION_HANDLER_PK PRIMARY KEY(
 			ERROR_CODE,
 			ACTION_HANDLER_ID
 		),
 		
 	CONSTRAINT SECM_ERROR_ACTION_HANDLER_FK FOREIGN KEY(
		ACTION_HANDLER_ID
		)
	REFERENCES SECM_ACTION_HANDLER (
		ACTION_HANDLER_ID
		),
		
	CONSTRAINT SECM_ERROR_ACTION_HANDLER_FK2 FOREIGN KEY(
		ERROR_CODE
		)	
	REFERENCES SECM_ERROR_CODES(
		ERROR_CODE
		)
 )
 	REPLICATE    
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;
    
  CREATE TABLE SECM_ERROR_MESSAGE(
  	ERROR_CODE VARCHAR(50),
  	ERROR_MESSAGE VARCHAR(500),
  	LOCALE VARCHAR(10),
  	CONSTRAINT SECM_ERROR_MESSAGE_PK PRIMARY KEY(
  			ERROR_CODE,
  			LOCALE
  	),
  	
  	CONSTRAINT SECM_ERROR_MESSAGE_FK FOREIGN KEY
  		(
  		ERROR_CODE
  		)
  		REFERENCES SECM_ERROR_CODES
  		(
  		ERROR_CODE
  		),
  	
  	CONSTRAINT SECM_ERROR_MESSAGE_FK2 FOREIGN KEY
	  	(
	  		LOCALE
	  	)
	  	REFERENCES SECM_COUNTRY
	  	(
	  		LOCALE
	  	)
  )
  	REPLICATE    
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;
  
  CREATE TABLE SECM_USER_GROUP(
  	USERID VARCHAR(50),
  	GROUPID VARCHAR(50),
  	CONSTRAINT SECM_USER_GROUP_PK PRIMARY KEY
	  	(
	  	 USERID,
	  	 GROUPID
	  	),
	  CONSTRAINT SECM_USER_GROUP_FK FOREIGN KEY
		  (
		  	USERID
		  )
		  REFERENCES SECM_USER
		  (
		  	USERID
		  ),
	CONSTRAINT SECM_USER_GROUP_FK2 FOREIGN KEY
		  (
		  	GROUPID
		  )
		  REFERENCES SECM_GROUP
		  (
		  	GROUPID
		  )		  
  )
  
  	REPLICATE   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
    ;

CREATE TABLE SECM_ERROR_MAIL_CONFIG(
       ERROR_CODE VARCHAR(50),
       USER_EMAIL_ID VARCHAR(200),
       CONSTRAINT SECM_ERROR_GROUP_PK PRIMARY KEY
              (
                     ERROR_CODE,
                     USER_EMAIL_ID
              ),
       CONSTRAINT SECM_ERROR_GROUP_FK1 FOREIGN KEY
              (
                     ERROR_CODE
              )
              REFERENCES SECM_ERROR_CODES
              (
                     ERROR_CODE
              )
                     
  
  )
    REPLICATE   
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
 ;
 
 CREATE TABLE SECM_CHANNEL_ONBOARDED
    (
     CHANNEL_ID VARCHAR (36) NOT NULL ,
     CHANNEL_NAME VARCHAR (100) NOT NULL ,
     CHANNEL_LOC VARCHAR (20) NOT NULL ,
     DESCRIPTION VARCHAR (100) ,
     ONBOARD_DATE TIMESTAMP NOT NULL ,
     END_DATE TIMESTAMP NOT NULL ,
     LAST_UPDATE_BY VARCHAR (20) NOT NULL ,
     LAST_UPDATE_DATE TIMESTAMP NOT NULL
    )
	
	REPLICATE 									
	PERSISTENT 'AppDiskStore'  SYNCHRONOUS 					
	
;


ALTER TABLE SECM_CHANNEL_ONBOARDED
    ADD CONSTRAINT SECM_CHANNEL_ONBOARDED_PK PRIMARY KEY
    (
    CHANNEL_ID
    )
;

CREATE TABLE SECT_JOB_CONTROL ( 
    job_name          VARCHAR(200)  NOT NULL,
    description       VARCHAR(250),
    job_class_name    VARCHAR(250),
    owner             VARCHAR(250)  NOT NULL,
    status            VARCHAR(10)   NOT NULL,
    start_time        TIMESTAMP,
    end_time          TIMESTAMP, 
    CONSTRAINT SECT_JOB_CONTROL_PK PRIMARY KEY(job_name)
    )
    PARTITION BY COLUMN (job_name)                                     
    REDUNDANCY 1 
	EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS           
;

CREATE TABLE SECW_CHANNEL_DATA_APAC
    (
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     CLIENT_ID VARCHAR (100) ,
     CLIENT_NAME VARCHAR (100) ,
     CLIENT_ACCOUNT VARCHAR (100) ,
     COMPANY_ID VARCHAR (100) ,
     CLIENT_REF_NO VARCHAR (100) ,
     VALUE_DATE TIMESTAMP ,
     AMOUNT DECIMAL (16,2) ,
     CURRENCY VARCHAR (20) ,
     PAY_METHOD VARCHAR (100) ,
     PAY_VEHICLE VARCHAR (100) ,
     ORIG_BANK_ID VARCHAR (100) ,
     BACKOFFICE_CODE VARCHAR (10) WITH DEFAULT 'UNKNOWN' ,
     BENE_ACCNT_NO VARCHAR (100) ,
     BENE_NAME VARCHAR (100) ,
     BENE_ADDR VARCHAR (100) ,
     BENE_BANK_ID VARCHAR (100) ,
     BENE_BANK_NAME VARCHAR (100) ,
     BENE_BANK_ADDR VARCHAR (256) ,
     CLIENT_FILE_ID VARCHAR (100) ,
     CLIENT_FILE_TIME TIMESTAMP ,
     CHN_TXN_CREATED_TIME TIMESTAMP ,
     RAW_DATA CLOB NOT NULL
         ,
     DATA_LIFE_STATUS SMALLINT NOT NULL ,
     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,
     LAST_MATCH_DATE TIMESTAMP ,
     MATCH_CATEG_ID INTEGER ,
     IS_REJECTED CHAR (1) WITH DEFAULT 'N' ,
     IS_CANCELLED CHAR (1) WITH DEFAULT 'N' ,
     FILE_TYPE_ID VARCHAR (36) NOT NULL ,
     ETL_TIME INTEGER NOT NULL ,
     CHANNEL_ID VARCHAR (36) NOT NULL ,
     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN'
    )

    
    PARTITION BY COLUMN (CHANNEL_TXN_ID)                
    REDUNDANCY 1                                        
    EXPIRE ENTRY WITH TIMETOLIVE 3600 ACTION DESTROY    
    
;


ALTER TABLE SECW_CHANNEL_DATA_APAC
    ADD CONSTRAINT SECW_CHANNEL_DATA_APAC_PK PRIMARY KEY
    (
    CHANNEL_TXN_ID
    )
;




CREATE TABLE SECW_CHANNEL_DATA_EMEA
    (
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     CLIENT_ID VARCHAR (100) ,
     CLIENT_NAME VARCHAR (100) ,
     CLIENT_ACCOUNT VARCHAR (100) ,
     COMPANY_ID VARCHAR (100) ,
     CLIENT_REF_NO VARCHAR (100) ,
     VALUE_DATE TIMESTAMP ,
     AMOUNT DECIMAL (16,2) ,
     CURRENCY VARCHAR (20) ,
     PAY_METHOD VARCHAR (100) ,
     PAY_VEHICLE VARCHAR (100) ,
     ORIG_BANK_ID VARCHAR (100) ,
     BACKOFFICE_CODE VARCHAR (10) WITH DEFAULT 'UNKNOWN' ,
     BENE_ACCNT_NO VARCHAR (100) ,
     BENE_NAME VARCHAR (100) ,
     BENE_ADDR VARCHAR (100) ,
     BENE_BANK_ID VARCHAR (100) ,
     BENE_BANK_NAME VARCHAR (100) ,
     BENE_BANK_ADDR VARCHAR (256) ,
     CLIENT_FILE_ID VARCHAR (100) ,
     CLIENT_FILE_TIME TIMESTAMP ,
     CHN_TXN_CREATED_TIME TIMESTAMP ,
     RAW_DATA CLOB NOT NULL
         ,
     DATA_LIFE_STATUS SMALLINT NOT NULL ,
     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,
     LAST_MATCH_DATE TIMESTAMP ,
     MATCH_CATEG_ID INTEGER ,
     IS_REJECTED CHAR (1) WITH DEFAULT 'N' ,
     IS_CANCELLED CHAR (1) WITH DEFAULT 'N' ,
     FILE_TYPE_ID VARCHAR (36) NOT NULL ,
     ETL_TIME INTEGER NOT NULL ,
     CHANNEL_ID VARCHAR (36) NOT NULL ,
     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN'
    )
    
    PARTITION BY COLUMN (CHANNEL_TXN_ID)                
    REDUNDANCY 1                                        
    EXPIRE ENTRY WITH TIMETOLIVE 3600 ACTION DESTROY    
    
;


ALTER TABLE SECW_CHANNEL_DATA_EMEA
    ADD CONSTRAINT SECW_CHANNEL_DATA_EMEA_PK PRIMARY KEY
    (
    CHANNEL_TXN_ID
    )
;


CREATE TABLE SECW_CHANNEL_DATA_WHEM
    (
     CHANNEL_TXN_ID VARCHAR (36) NOT NULL ,
     CLIENT_ID VARCHAR (100) ,
     CLIENT_NAME VARCHAR (100) ,
     CLIENT_ACCOUNT VARCHAR (100) ,
     COMPANY_ID VARCHAR (100) ,
     CLIENT_REF_NO VARCHAR (100) ,
     VALUE_DATE TIMESTAMP ,
     AMOUNT DECIMAL (16,2) ,
     CURRENCY VARCHAR (20) ,
     PAY_METHOD VARCHAR (100) ,
     PAY_VEHICLE VARCHAR (100) ,
     ORIG_BANK_ID VARCHAR (100) ,
     BACKOFFICE_CODE VARCHAR (10) WITH DEFAULT 'UNKNOWN' ,
     BENE_ACCNT_NO VARCHAR (100) ,
     BENE_NAME VARCHAR (100) ,
     BENE_ADDR VARCHAR (100) ,
     BENE_BANK_ID VARCHAR (100) ,
     BENE_BANK_NAME VARCHAR (100) ,
     BENE_BANK_ADDR VARCHAR (256) ,
     CLIENT_FILE_ID VARCHAR (100) ,
     CLIENT_FILE_TIME TIMESTAMP ,
     CHN_TXN_CREATED_TIME TIMESTAMP ,
     RAW_DATA CLOB NOT NULL
         ,
     DATA_LIFE_STATUS SMALLINT NOT NULL ,
     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,
     LAST_MATCH_DATE TIMESTAMP ,
     MATCH_CATEG_ID INTEGER ,
     IS_REJECTED CHAR (1) WITH DEFAULT 'N' ,
     IS_CANCELLED CHAR (1) WITH DEFAULT 'N' ,
     FILE_TYPE_ID VARCHAR (36) NOT NULL ,
     ETL_TIME INTEGER NOT NULL ,
     CHANNEL_ID VARCHAR (36) NOT NULL ,
     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN'
    )
    
    PARTITION BY COLUMN (CHANNEL_TXN_ID)                
    REDUNDANCY 1                                        
    EXPIRE ENTRY WITH TIMETOLIVE 3600 ACTION DESTROY    
    
;


ALTER TABLE SECW_CHANNEL_DATA_WHEM
    ADD CONSTRAINT SECW_CHANNEL_DATA_WHEM_PK PRIMARY KEY
    (
    CHANNEL_TXN_ID
    )
;


ALTER TABLE SECM_TXN_MANAGEMENT
    ADD CONSTRAINT SECM_APP_CHN_FILE_MAP_APP_FK FOREIGN KEY
    (
     BACKOFFICE_CODE
    )
    REFERENCES SECM_BACKOFFICE_ONBOARDED
    (
     BACKOFFICE_CODE
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_BACKOFFICE_ONBOARDED
    ADD CONSTRAINT SECM_BACKOFFICE_ONBOARDED_LOC_FK FOREIGN KEY
    (
     BACKOFFICE_LOC
    )
    REFERENCES SECM_LOCATION
    (
     LOCATION_CODE
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_BO_MESSAGE_TAG_MAPPING
    ADD CONSTRAINT SECM_BO_MESSAGE_TAG_MAPPING_BO_FK FOREIGN KEY
    (
     BACKOFFICE_CODE
    )
    REFERENCES SECM_BACKOFFICE_ONBOARDED
    (
     BACKOFFICE_CODE
    )
    ON DELETE NO ACTION

;



ALTER TABLE SECM_BS_DETERMINATION_GENERAL
    ADD CONSTRAINT SECM_BS_DETERMI_GENERAL_CATE_FK FOREIGN KEY
    (
     FILE_CATEGORY
    )
    REFERENCES SECM_FILE_CATEGORY
    (
     FILE_CATEGORY
    )
    ON DELETE RESTRICT

;




ALTER TABLE SECM_BS_DETERMINATION_PAIN001
    ADD CONSTRAINT SECM_BS_DET_PAIN001_CATE_FK FOREIGN KEY
    (
     FILE_CATEGORY
    )
    REFERENCES SECM_FILE_CATEGORY
    (
     FILE_CATEGORY
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_FILE_TYPE_ONBOARDED
    ADD CONSTRAINT SECM_FILE_TYPE_ONBOARDED_CATE_FK FOREIGN KEY
    (
     FILE_CATEGORY
    )
    REFERENCES SECM_FILE_CATEGORY
    (
     FILE_CATEGORY
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_FILE_WATCHER_CONFIGS
    ADD CONSTRAINT SECM_FILE_WATCHER_CONFIGS_FK FOREIGN KEY
    (
     FILE_WATCHER_ID
    )
    REFERENCES SECM_FILE_WATCHER
    (
     FILE_WATCHER_ID
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_HIT_STATUS_MAP
    ADD CONSTRAINT SECM_HIT_STATUS_MAP_BO_FK FOREIGN KEY
    (
     BACKOFFICE_CODE
    )
    REFERENCES SECM_BACKOFFICE_ONBOARDED
    (
     BACKOFFICE_CODE
    )
    ON DELETE RESTRICT

;


ALTER TABLE SECM_MATCHING_KEY_INFO
    ADD CONSTRAINT SECM_MATCHING_KEY_INFOBO_FK FOREIGN KEY
    (
     BACKOFFICE_CODE
    )
    REFERENCES SECM_BACKOFFICE_ONBOARDED
    (
     BACKOFFICE_CODE
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_MATCHING_KEY_INFO
    ADD CONSTRAINT SECM_MATCHING_KEY_INFO_KEY_FK FOREIGN KEY
    (
     KEY_ID
    )
    REFERENCES SECM_KEY_LIST
    (
     KEY_ID
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_MQ_BO_MAP
    ADD CONSTRAINT SECM_MQ_BO_MAP_BO_FK FOREIGN KEY
    (
     BACKOFFICE_CODE
    )
    REFERENCES SECM_BACKOFFICE_ONBOARDED
    (
     BACKOFFICE_CODE
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_MQ_BO_MAP
    ADD CONSTRAINT SECM_MQ_BO_MAP_MQ_FK FOREIGN KEY
    (
     MQ_ID
    )
    REFERENCES SECM_MQ
    (
     MQ_ID
    )
    ON DELETE RESTRICT


;



ALTER TABLE SECM_MQ
    ADD CONSTRAINT SECM_MQ_MGR_FK FOREIGN KEY
    (
     MGR_NAME
    )
    REFERENCES SECM_MQ_MGR
    (
     MGR_NAME
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_MQ_MGR
    ADD CONSTRAINT SECM_MQ_MGR_PROC_CONF_FK FOREIGN KEY
    (
     PROCESS_ID
    )
    REFERENCES SECM_PROCESS_CONFIG
    (
     PROCESS_ID
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_OFAC_MQ_ROUTING
    ADD CONSTRAINT SECM_OFAC_MQ_ROUTING_INQ_FK FOREIGN KEY
    (
     INPUT_MQ_ID
    )
    REFERENCES SECM_MQ
    (
     MQ_ID
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_PARSER_CONFIGURATION
    ADD CONSTRAINT SECM_PARSER_CONFIGURATION_BO_FK FOREIGN KEY
    (
     BACKOFFICE_CODE
    )
    REFERENCES SECM_BACKOFFICE_ONBOARDED
    (
     BACKOFFICE_CODE
    )
    ON DELETE NO ACTION

;



ALTER TABLE SECM_XML_TAG_MAPPINGS
    ADD CONSTRAINT SECM_XML_TAG_MAPPINGS_FTYPE_FK FOREIGN KEY
    (
     FILE_TYPE_ID
    )
    REFERENCES SECM_FILE_TYPE_ONBOARDED
    (
     FILE_TYPE_ID
    )
    ON DELETE RESTRICT

;



ALTER TABLE SECM_XML_TAG_MAPPINGS
    ADD CONSTRAINT SECM_XML_TAG_MAPPINGS_KEY_FK FOREIGN KEY
    (
     KEY_ID
    )
    REFERENCES SECM_KEY_LIST
    (
     KEY_ID
    )
    ON DELETE RESTRICT

;

CREATE TABLE qrtz_job_details (
    job_name          VARCHAR(200) NOT NULL,
    job_group         VARCHAR(200) NOT NULL,
    description       VARCHAR(250),
    job_class_name    VARCHAR(250) NOT NULL,
    is_durable        VARCHAR(5)   NOT NULL,
    is_volatile       VARCHAR(5)   NOT NULL,
    is_stateful       VARCHAR(5)   NOT NULL,
    requests_recovery VARCHAR(5)   NOT NULL,
    job_data          BLOB,
    PRIMARY KEY (job_name, job_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_job_listeners (
    job_name     VARCHAR(200) NOT NULL,
    job_group    VARCHAR(200) NOT NULL,
    job_listener VARCHAR(200) NOT NULL,
    PRIMARY KEY (job_name, job_group, job_listener),
    FOREIGN KEY (job_name, job_group) REFERENCES qrtz_job_details (job_name, job_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_triggers (
    trigger_name   VARCHAR(200) NOT NULL,
    trigger_group  VARCHAR(200) NOT NULL,
    job_name       VARCHAR(200) NOT NULL,
    job_group      VARCHAR(200) NOT NULL,
    is_volatile    VARCHAR(5)   NOT NULL,
    description    VARCHAR(250),
    next_fire_time BIGINT,
    prev_fire_time BIGINT,
    priority       INTEGER,
    trigger_state  VARCHAR(16)  NOT NULL,
    trigger_type   VARCHAR(8)   NOT NULL,
    start_time     BIGINT       NOT NULL,
    end_time       BIGINT,
    calendar_name  VARCHAR(200),
    misfire_instr  SMALLINT,
    job_data       BLOB,
    PRIMARY KEY (trigger_name, trigger_group),
    FOREIGN KEY (job_name, job_group) REFERENCES qrtz_job_details (job_name, job_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_simple_triggers (
    trigger_name    VARCHAR(200) NOT NULL,
    trigger_group   VARCHAR(200) NOT NULL,
    repeat_count    BIGINT       NOT NULL,
    repeat_interval BIGINT       NOT NULL,
    times_triggered BIGINT       NOT NULL,
    PRIMARY KEY (trigger_name, trigger_group),
    FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers (trigger_name, trigger_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_cron_triggers (
    trigger_name    VARCHAR(200) NOT NULL,
    trigger_group   VARCHAR(200) NOT NULL,
    cron_expression VARCHAR(120) NOT NULL,
    time_zone_id    VARCHAR(80),
    PRIMARY KEY (trigger_name, trigger_group),
    FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers (trigger_name, trigger_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_blob_triggers (
    trigger_name  VARCHAR(200) NOT NULL,
    trigger_group VARCHAR(200) NOT NULL,
    blob_data     BLOB,
    PRIMARY KEY (trigger_name, trigger_group),
    FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers (trigger_name, trigger_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_trigger_listeners (
    trigger_name     VARCHAR(200) NOT NULL,
    trigger_group    VARCHAR(200) NOT NULL,
    trigger_listener VARCHAR(200) NOT NULL,
    PRIMARY KEY (trigger_name, trigger_group, trigger_listener),
    FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers (trigger_name, trigger_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_calendars (
    calendar_name VARCHAR(200) NOT NULL,
    calendar      BLOB         NOT NULL,
    PRIMARY KEY (calendar_name)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_paused_trigger_grps
  (
    trigger_group VARCHAR(200) NOT NULL,
    PRIMARY KEY (trigger_group)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_fired_triggers (
    entry_id          VARCHAR(95)  NOT NULL,
    trigger_name      VARCHAR(200) NOT NULL,
    trigger_group     VARCHAR(200) NOT NULL,
    is_volatile       VARCHAR(5)   NOT NULL,
    instance_name     VARCHAR(200) NOT NULL,
    fired_time        BIGINT       NOT NULL,
    priority          INTEGER      NOT NULL,
    state             VARCHAR(16)  NOT NULL,
    job_name          VARCHAR(200),
    job_group         VARCHAR(200),
    is_stateful       VARCHAR(5),
    requests_recovery VARCHAR(5),
    PRIMARY KEY (entry_id)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_scheduler_state
  (
    instance_name     VARCHAR(200) NOT NULL,
    last_checkin_time BIGINT       NOT NULL,
    checkin_interval  BIGINT       NOT NULL,
    PRIMARY KEY (instance_name)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE TABLE qrtz_locks
  (
    lock_name VARCHAR(40) NOT NULL,
    PRIMARY KEY (lock_name)
)

EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW     
    PERSISTENT 'AppDiskStore'  SYNCHRONOUS
;

CREATE INDEX SECL_BO_DATA_STATUS_TXN_IDX
    ON SECL_BO_DATA_STATUS_HIST
    (
      BO_TXN_ID
    );

CREATE UNIQUE INDEX SECL_BO_RAW_DATA_TXN_IDX
    ON SECL_BO_RAW_DATA
    (
      BO_TXN_ID
    );

CREATE INDEX SECL_MATCHED_DATA_TXN_IDX
    ON SECL_MATCHED_DATA
    (
       BACKOFFICE_TXN_ID
    );

	 
CREATE INDEX SECL_CHN_DATA_STATUS_TXN_ID_MATCH_TIME_IDX
    ON SECL_CHN_DATA_STATUS_HIST
    (
     CHANNEL_TXN_ID,
	 MATCH_STATUS,
	 CHN_TXN_CREATED_TIME,
	 ACTUAL_VALUE_DATE
    )
;

CREATE INDEX SECL_OFAC_MESSAGE_FS_TXN_ID_IDX
    ON SECL_OFAC_MESSAGE
    (
     FS_MESSAGE_ID,
	 BO_TXN_ID
    )
;

CREATE INDEX SECL_OFAC_CHUNKED_MESSAGE_FS_ID_IDX
    ON SECL_OFAC_CHUNKED_MESSAGE
    (
     FS_MESSAGE_ID,
	 CHUNK_SEQ
    )
;

CREATE INDEX SECL_OFAC_CHUNKED_MESSAGE_CHUNK_ID_IDX
    ON SECL_OFAC_CHUNKED_MESSAGE
    (
	 CHUNK_ID
    )
;

CREATE INDEX SECT_CHANNEL_DATA_MATCHING_IDX
    ON SECT_CHANNEL_DATA
    (
     CHANNEL_TXN_ID,
     DATA_LIFE_STATUS,
	 MATCH_STATUS
    )
;

CREATE INDEX SECM_OFAC_MQ_ROUTING_LOB_INQ_IDX
    ON SECM_OFAC_MQ_ROUTING
    (
     INPUT_MQ_ID,
     LOB
    )
;

CREATE TABLE BO_DATA
(
	OFAC_MSG_ID VARCHAR (64),
	BO_QUEUE_NAME VARCHAR (64),
	BO_CODE VARCHAR (64),
	LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP
);


CREATE INDEX SECT_CHANNEL_DATA_IPAY_MATCHING_KEY_IDX  
ON SECT_CHANNEL_DATA 
    ( 
     CLIENT_REF_NO ASC ,
     AMOUNT ASC ,
     CURRENCY ASC ,
     VALUE_DATE ASC
    ) --gemfirexd-properties caseSensitive=false ;
