CREATE TABLE APP.ACCOUNT
(
    ACCOUNTID INTEGER NOT NULL,
    BALANCE NUMERIC(14,2),
    CREATIONDATE DATE,
    LASTLOGIN DATE,
    LOGINCOUNT INTEGER NOT NULL,
    LOGOUTCOUNT INTEGER NOT NULL,
    OPENBALANCE NUMERIC(14,2),
    PROFILE_PROFILEID INTEGER,
    VERSION INTEGER,
    PRIMARY KEY (ACCOUNTID)
)
PERSISTENT SYNCHRONOUS
REDUNDANCY 1
PARTITION BY PRIMARY KEY;

CREATE TABLE APP.ACCOUNTPROFILE
(
    PROFILEID INTEGER NOT NULL,
    ADDRESS VARCHAR(250),
    AUTHTOKEN VARCHAR(100),
    CREDITCARD VARCHAR(250),
    EMAIL VARCHAR(250),
    FULLNAME VARCHAR(250),
    PASSWD VARCHAR(250),
    USERID VARCHAR(250) NOT NULL,
    PRIMARY KEY (PROFILEID)
)
REDUNDANCY 1
PERSISTENT SYNCHRONOUS;

CREATE UNIQUE INDEX ACCOUNTPROFILE_USERID_KEY ON APP.ACCOUNTPROFILE (USERID);

CREATE TABLE APP.HOLDING
(
    HOLDINGID INTEGER NOT NULL,
    ACCOUNT_ACCOUNTID INTEGER,
    PURCHASEDATE DATE,
    PURCHASEPRICE NUMERIC(14,2),
    QUANTITY NUMERIC(14,0) NOT NULL,
    QUOTE_SYMBOL VARCHAR(250),
    PRIMARY KEY (HOLDINGID)
)
REDUNDANCY 1
PERSISTENT SYNCHRONOUS
PARTITION BY COLUMN (ACCOUNT_ACCOUNTID)
COLOCATE WITH (APP.ACCOUNT);

CREATE TABLE APP.ORDERS
(
    ORDERID INTEGER NOT NULL,
    COMPLETIONDATE DATE,
    OPENDATE DATE,
    ORDERFEE NUMERIC(14,2),
    ORDERSTATUS VARCHAR(250),
    ORDERTYPE VARCHAR(250),
    PRICE NUMERIC(14,2),
    QUANTITY NUMERIC(19,2) NOT NULL,
    ACCOUNT_ACCOUNTID INTEGER,
    HOLDING_HOLDINGID INTEGER,
    QUOTE_SYMBOL VARCHAR(250),
    PRIMARY KEY (ORDERID)
)
REDUNDANCY 1
PERSISTENT SYNCHRONOUS
PARTITION BY COLUMN (ACCOUNT_ACCOUNTID)
COLOCATE WITH (APP.ACCOUNT);

CREATE TABLE APP.QUOTE
(
    QUOTEID INTEGER NOT NULL,
    LOW NUMERIC(14,2),
    OPEN1 NUMERIC(14,2),
    VOLUME NUMERIC(19,2) NOT NULL,
    PRICE NUMERIC(14,2),
    HIGH NUMERIC(14,2),
    COMPANYNAME VARCHAR(250),
    SYMBOL VARCHAR(250) NOT NULL,
    CHANGE1 NUMERIC(19,2) NOT NULL,
    VERSION INTEGER,
    PRIMARY KEY (QUOTEID)
)
PERSISTENT SYNCHRONOUS
REPLICATE;

CREATE UNIQUE INDEX QUOTE_SYMBOL_KEY ON APP.QUOTE (SYMBOL);

ALTER TABLE APP.ACCOUNT
    ADD CONSTRAINT FKE49F160D2BA34895 FOREIGN KEY (PROFILE_PROFILEID) REFERENCES APP.ACCOUNTPROFILE (PROFILEID);

ALTER TABLE APP.ORDERS
    ADD CONSTRAINT FKC3DF62E518A618B8 FOREIGN KEY (ACCOUNT_ACCOUNTID) REFERENCES APP.ACCOUNT (ACCOUNTID);

ALTER TABLE APP.ORDERS
    ADD CONSTRAINT FKC3DF62E5D2E54D7A FOREIGN KEY (HOLDING_HOLDINGID) REFERENCES APP.HOLDING (HOLDINGID);
    
CREATE PROCEDURE CHAOSFUNCTION ()
    
    LANGUAGE JAVA 
    PARAMETER STYLE JAVA 
    READS SQL DATA 
EXTERNAL NAME 'org.springframework.useCase4.chaos.gemfirexd.ChaosFunction.killProcess';

