include $JTESTS/sql/generic/schema/trade/TradeSchema.inc;

sql.SQLPrms-dmlTables = 
    "trade.securities" 
    "trade.customers" 
    "trade.networth" 
    "trade.portfolio" 
    "trade.sellorders" 
    "trade.buyorders" 
    "trade.txhistory"
    ;

sql.SQLPrms-createSchemas = 
    "create schema trade" 
    "create schema default1"
    "create schema emp"
    ;             	 

sql.SQLPrms-createTablesStatements =
	"create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))"
    "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))"
	"create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int, constraint netw_pk primary key (cid),  constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))"
	"create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))" 
	"create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10) default 'open', tid int, constraint status_ch check (status in ('cancelled', 'open', 'filled')))"
	"create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))"
	"create table trade.txhistory(cid int, oid int, sid int, qty int, price decimal (30, 20), ordertime timestamp, type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))"
	"create table emp.employees (eid int not null constraint employees_pk primary key, emp_name varchar(100), deptid int , since date, addr varchar(100), picture blob ,  ssn varchar(9) , tid int)"
	"create table trade.trades (tid int, cid int, eid int, tradedate date, primary Key (tid))"	
	"create table default1.employees (eid int not null constraint employees_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9))"
	;

sql.SQLPrms-gfeDDLExtension =
    "trade.securities:random"
    "trade.customers:random"
    "trade.networth:random"
    "trade.portfolio:random"
    "trade.sellorders:random"
    "trade.buyorders:random"
    "trade.txhistory:random"
    "emp.employees:random"
    "trade.trades:random"
    "default1.employees:random"
    ;

// todo - make this generic
sql.SQLPrms-gfePersistExtension = 
   " PERSISTENT "
   " " 
   " " 
   " PERSISTENT "
   " "
   " "
   " "
   " " 
   " "
   " "
   ;