hydra.Prms-testDescription = " this tests derby on gfe";

INCLUDE $JTESTS/hydraconfig/hydraparams1.inc;
include $JTESTS/hydraconfig/gemfirexd/topology_2_locator.inc;

hydra.VmPrms-extraClassPaths        += $GEMFIRE/../product-gfxd/lib/gemfirexd.jar;
 
THREADGROUP locator
  totalThreads = fcn  ${locatorHosts} * ${locatorVMsPerHost} * ${locatorThreadsPerVM} ncf
  totalVMs     = fcn "(${locatorHosts} * ${locatorVMsPerHost})" ncf
  clientNames  = fcn "hydra.TestConfigFcns.generateNames(\"locator\",
                                ${locatorHosts}, true)" ncf;           
THREADGROUP dataStoreThreads
            totalThreads = fcn "(${${A}Hosts} * ${${A}VMsPerHost} *  ${${A}ThreadsPerVM}) " ncf
            totalVMs     = fcn "(${${A}Hosts} * ${${A}VMsPerHost})" ncf
            clientNames  = fcn "hydra.TestConfigFcns.generateNames(\"${A}\",
                                ${${A}Hosts}, true)" ncf;

THREADGROUP accessorThreads
            totalThreads = fcn "(${${B}Hosts} * ${${B}VMsPerHost} *  ${${B}ThreadsPerVM}) -1  " ncf
            totalVMs     = fcn "(${${B}Hosts} * ${${B}VMsPerHost})" ncf
            clientNames  = fcn "hydra.TestConfigFcns.generateNames(\"${B}\",
                                ${${B}Hosts}, true)" ncf;  

THREADGROUP ddlThread
            totalThreads = 1
            totalVMs     = 1
            clientNames  = fcn "hydra.TestConfigFcns.generateNames(\"${B}\",
                               ${${B}Hosts}, true)" ncf;
                                                                    
hydra.gemfirexd.FabricServerPrms-persistDD = fcn "hydra.TestConfigFcns.oneof(\"true\", \"false\")" ncf;
sql.SQLPrms-useGfxdConfig = true;

//temp for quick test   
//sql.SQLPrms-initCustomersSizePerThread = RANGE 20 30 EGNAR;
//sql.SQLPrms-initSecuritiesSizePerThread = RANGE 10 30 EGNAR;
   
hydra.Prms-manageDerbyServer = false;
hydra.Prms-totalTaskTimeSec           = 1800; 
hydra.Prms-maxResultWaitSec           = 300;
hydra.Prms-maxCloseTaskResultWaitSec  = 300;
hydra.Prms-serialExecution            = false;  
  
INITTASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_initialize
  runMode = always
  threadGroups = dataStoreThreads, ddlThread, accessorThreads;
  
INITTASK taskClass = sql.sqlTx.SQLDistTxTest taskMethod = HydraTask_createGfxdLocatorTask
         threadGroups = locator;
         
INITTASK taskClass = sql.sqlTx.SQLDistTxTest taskMethod = HydraTask_startGfxdLocatorTask
         runMode = always
         threadGroups = locator;                                

INITTASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_startFabricServer
    runMode = always
    threadGroups = accessorThreads, dataStoreThreads;

INITTASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_createGFESchemas
  threadGroups = ddlThread;

INITTASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_createGFETables
  threadGroups = ddlThread;
  
INITTASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_setTableCols
  threadGroups = ddlThread;  
  
INITTASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_populateTxTables
  threadGroups = accessorThreads, ddlThread;   

INITTASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_setInitialData
  threadGroups = ddlThread; 

TASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_doDMLOp
  threadGroups = accessorThreads, ddlThread; 

TASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_concUpdateTx
  threadGroups = accessorThreads, ddlThread;   
  
CLOSETASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_verifyConcUpdateTx
  threadGroups = ddlThread;    
  
CLOSETASK     taskClass   = sql.sqlTx.SQLDistTxTest taskMethod  = HydraTask_checkConstraints
	 threadGroups = ddlThread;  

sql.SQLPrms-hasNetworth = true;    //will create networth table
sql.SQLPrms-dmlOperations = ONEOF update update update update update update update query query query delete FOENO;
sql.SQLPrms-dmlTables = "trade.securities" "trade.customers" "trade.networth" "trade.portfolio" "trade.sellorders" "trade.buyorders" "trade.txhistory" ;   
sql.SQLPrms-createSchemas = "create schema trade" "create schema default1" "create schema emp" ;

sql.SQLPrms-createTablesStatements =
  "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 1), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))"
  "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))"
  "create table trade.networth (cid int not null, cash decimal (30, 1), securities decimal (30, 1), loanlimit int, availloan decimal (30, 1),  tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))"
  "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30, 1), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))" 
  "create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 1), order_time timestamp, status varchar(10), tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, constraint status_ch check (status in ('cancelled', 'open', 'filled')))"
  "create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 1), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict, constraint bo_qty_ck check (qty>=0))"
  "create table trade.txhistory(cid int, oid int, sid int, qty int, price decimal (30, 1), ordertime timestamp, type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))"
  "create table emp.employees (eid int not null constraint employees_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9))"
  "create table trade.trades (tid int, cid int, eid int, tradedate date, primary Key (tid), foreign key (cid) references trade.customers (cid), constraint emp_fk foreign key (eid) references emp.employees (eid))";

sql.SQLPrms-numOfStores = fcn "(${${A}Hosts} * ${${A}VMsPerHost})" ncf;
sql.SQLPrms-numOfWorkers = fcn "(${${B}Hosts} * ${${B}VMsPerHost} *  ${${B}ThreadsPerVM})  " ncf;
sql.SQLPrms-dropIndex = true;
sql.SQLPrms-createIndex = true;
sql.SQLPrms-testUniqueKeys = false;
sql.sqlTx.SQLTxPrms-doOpByOne = false;
sql.SQLPrms-hasTx = true;
sql.SQLPrms-isConcUpdateTx = true;

sql.SQLPrms-testPartitionBy = true;
sql.SQLPrms-withReplicatedTables = true;

sql.SQLPrms-gfeDDLExtension =
	"trade.securities:random" 
    "trade.customers:random"
	"trade.networth:random"
	"trade.portfolio:random"
	"trade.sellorders:random"
    "trade.buyorders:random" 
    "trade.txhistory:random"
	"emp.employees:random"
	"trade.trades:random" ;

hydra.Prms-clientShutdownHook = sql.sqlTx.SQLDistTxTest dumpResults;
hydra.gemfirexd.FabricServerPrms-hostData = false true false;
