//------------------------------------------------------------------------------
// INCLUDE FILES
//------------------------------------------------------------------------------

include $JTESTS/hydraconfig/hydraparams1.inc;
include $JTESTS/hydraconfig/gemfirexd/topology_wan_client_locator.inc;
//------------------------------------------------------------------------------
// TEST DESCRIPTION
//------------------------------------------------------------------------------

hydra.Prms-testDescription=" TBD ";

hydra.VmPrms-extraClassPaths        += $GEMFIRE/../product-gfxd/lib/gemfirexd.jar;
hydra.VmPrms-extraClassPaths        += $GEMFIRE/../product-gfxd/lib/gemfirexd-client.jar;
hydra.VmPrms-extraClassPaths        += $JTESTS;
hydra.VmPrms-extraVMArgs += "-Xss256k -Xmx512m -Xms256m";

hydra.Prms-manageDerbyServer = true;  
hydra.Prms-totalTaskTimeSec           = 2000;
hydra.Prms-maxResultWaitSec           = 1800;
hydra.Prms-maxCloseTaskResultWaitSec  = 1500;
hydra.Prms-serialExecution            = false;	

hydra.gemfirexd.FabricServerPrms-remoteDistributedSystems =
	  fcn "sql.wan.WanTestConfigFcns.generateRemoteSiteDS
          (\"ds_\", ${wanSites})"
      ncf
  ;
  
hydra.gemfirexd.GatewayReceiverPrms-names =
  fcn "hydra.TestConfigFcns.generateNames
      (\"receiver\", ${wanSites})" 
  ncf
  ;
  
hydra.gemfirexd.GatewayReceiverPrms-distributedSystem =
  fcn "hydra.TestConfigFcns.generateNames
      (\"ds_\", ${wanSites})" 
  ncf
  ;

/*  
hydra.gemfirexd.ThinClientPrms-clientNames =
  fcn "hydra.TestConfigFcns.generateDoubleSuffixedNames(\"${B}\", ${wanSites}, ${${B}HostsPerSite}, false)" ncf;
*/

THREADGROUP locator
           	totalThreads = fcn ${wanSites} * ${locatorHostsPerSite}
               					* ${locatorVMsPerHost} * ${locatorThreadsPerVM} ncf
  			clientNames  = fcn "hydra.TestConfigFcns.generateDoubleSuffixedNames
           						(\"locator\", ${wanSites}, ${locatorHostsPerSite}, false, true)" ncf;
           
THREADGROUP serverThreads
            totalThreads = fcn "${wanSites}  * ${${A}HostsPerSite} * ${${A}VMsPerHost} 
              *  ${${A}ThreadsPerVM} " ncf
            totalVMs     = fcn "${wanSites} * (${${A}HostsPerSite} * ${${A}VMsPerHost} ) " ncf
            clientNames  = fcn "hydra.TestConfigFcns.generateDoubleSuffixedNames(\"${A}\",
                                ${wanSites}, ${${A}HostsPerSite}, false, true)" ncf;                                                                                    

THREADGROUP clientSiteOne
           totalThreads = fcn ${${B}HostsPerSite}  * ${${B}VMsPerHost} * ${${B}ThreadsPerVM}  ncf
           totalVMs     = fcn ${${B}HostsPerSite} * ${${B}VMsPerHost} ncf
           clientNames  = fcn "sql.wan.WanTestConfigFcns.generateLastDoubleSuffixedNames
                          (\"${B}\", ${wanSites}, ${${B}HostsPerSite}, true)" ncf; 
                          
THREADGROUP clientSiteOther
            totalThreads = fcn "(${wanSites}-1) * (${${B}HostsPerSite} * ${${B}VMsPerHost} *  ${${B}ThreadsPerVM}) " ncf
            totalVMs     = fcn "(${wanSites}-1) * ${${B}HostsPerSite} * ${${B}VMsPerHost}" ncf
            clientNames  = fcn "hydra.TestConfigFcns.generateDoubleSuffixedNames(\"${B}\",
                                ${wanSites}-1, ${${B}HostsPerSite}, false, true)" ncf;                                   

                            
INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = createLocatorTask
         threadGroups = locator;
         
INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = startAndConnectLocatorTask
         threadGroups = locator;
                                                              
INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = HydraTask_initialize
         runMode = always
	     threadGroups = serverThreads, clientSiteOther, clientSiteOne;

INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = HydraTask_initEdges
         runMode = always
	     threadGroups = clientSiteOther, clientSiteOne;	     
	     	     	          
INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = HydraTask_initWanClientTest
         runMode = always
         threadGroups = serverThreads, clientSiteOther, clientSiteOne; 

INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = HydraTask_initBBForWanConfig
	     threadGroups = clientSiteOther, clientSiteOne; //need only one thread -- derbyDDLThread

INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_startFabricServerTask
	runMode = always
	threadGroups = serverThreads;       
		
INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_startNetworkServer
		runMode = always
		threadGroups =  serverThreads;  
		      	
INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_createDiscDB
    runMode = once
	threadGroups = clientSiteOther, clientSiteOne; //need only one thread -- derbyDDLThread


INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_createDiscSchemas
    runMode = once
	threadGroups = clientSiteOther, clientSiteOne; //need only one thread -- derbyDDLThread

INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_createDiscTables
    runMode = once
	threadGroups = clientSiteOther, clientSiteOne; //need only one thread -- derbyDDLThread	

INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_createGFESchemas
	threadGroups = clientSiteOther, clientSiteOne; //need only one thread in each site -- gfeDDLThread

INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_createDiskStores
	threadGroups = clientSiteOther, clientSiteOne; /* one thread in each site to do the op */

INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = HydraTask_createGatewaySenders
         threadGroups = clientSiteOther, clientSiteOne; //gfeDDL only

INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_createGFETables
	threadGroups = clientSiteOther, clientSiteOne; //need only one thread in each site -- gfeDDLThread    	
         
INITTASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = HydraTask_createGatewayReceivers
         threadGroups = clientSiteOther, clientSiteOne; //gfeDDL only     
         
INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_populateTables
	threadGroups = clientSiteOther, clientSiteOne;

INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_putLastKey
	threadGroups = clientSiteOther, clientSiteOne; /*gfeDDLThread*/
			
INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_checkQueueEmpty
	threadGroups = serverThreads;  

INITTASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_verifyResultSets
	threadGroups = clientSiteOther, clientSiteOne;	//gfeDDLThread
		
TASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_doDMLOp
	 threadGroups = clientSiteOther, clientSiteOne;

CLOSETASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_putLastKey
	threadGroups = clientSiteOther, clientSiteOne; /*gfeDDLThread*/
 
CLOSETASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_checkQueueEmpty
	threadGroups = serverThreads;  	

CLOSETASK     taskClass   = sql.wan.thinClient.WanClientTest taskMethod  = HydraTask_verifyResultSets
	threadGroups = clientSiteOther, clientSiteOne;	//gfeDDLThread	

CLOSETASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = stopServerTask
         threadGroups = serverThreads;

CLOSETASK taskClass = sql.wan.thinClient.WanClientTest taskMethod = stopLocatorTask
         threadGroups = locator;

//sql.wan.SQLWanPrms-numOfPeersPerSite = fcn ${${A}HostsPerSite} * ${${A}VMsPerHost} ncf;		
//sql.wan.SQLWanPrms-numOfDataStoresPerSite = fcn ${${A}HostsPerSite} * ${${A}VMsPerHost} ncf;	 		
sql.wan.SQLWanPrms-numOfServersPerSite = fcn ${${A}HostsPerSite} * ${${A}VMsPerHost} ncf;
sql.wan.SQLWanPrms-numOfLocators = fcn ${wanSites} * ${locatorHostsPerSite} * ${locatorVMsPerHost} ncf;
sql.wan.SQLWanPrms-numOfClientNodes = fcn ${wanSites} * ${${B}HostsPerSite} * ${${B}VMsPerHost} ncf;
sql.wan.SQLWanPrms-numOfWanSites = ${wanSites};
sql.wan.SQLWanPrms-numOfThreadsPerSite = fcn ${${A}HostsPerSite} * ${${A}VMsPerHost} * ${${A}ThreadsPerVM}
				 + ${${B}HostsPerSite} * ${${B}VMsPerHost} * ${${B}ThreadsPerVM} ncf;
sql.wan.SQLWanPrms-numOfClientThreadsPerSite = fcn ${${B}HostsPerSite} * ${${B}VMsPerHost} * ${${B}ThreadsPerVM} ncf;
sql.wan.SQLWanPrms-enableQueueConflation = ${enableQueueConflation};
sql.wan.SQLWanPrms-enableQueuePersistence = ONEOF true false FOENO;

sql.wan.SQLWanPrms-isWanTest = true;
sql.wan.SQLWanPrms-isSingleSitePublisher = false;

sql.SQLPrms-hasNetworth = true;		//will create networth table
sql.SQLPrms-dmlOperations = ONEOF insert update update update query query query delete FOENO;
sql.SQLPrms-dmlTables = "trade.securities" "trade.customers" "trade.networth" "trade.portfolio" "trade.sellorders" "trade.buyorders" "trade.txhistory"; 	
sql.SQLPrms-createSchemas = "create schema trade" "create schema default1" "create schema emp" ;


sql.SQLPrms-maxSymbolLength = 8;
sql.SQLPrms-minSymbolLength = 5;


//without cascade delete
sql.SQLPrms-createTablesStatements =
	"create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))"
	"create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))"
	"create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))"
	"create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references trade.securities (sec_id), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))" 
	"create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10) default 'open', tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, constraint status_ch check (status in ('cancelled', 'open', 'filled')))"
	"create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id), constraint bo_qty_ck check (qty>=0))"
	"create table trade.txhistory(cid int, oid int, sid int, qty int, price decimal (30, 20), ordertime timestamp, type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))"
	"create table emp.employees (eid int not null constraint employees_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9))"
	"create table trade.trades (tid int, cid int, eid int, tradedate date, primary Key (tid), foreign key (cid) references trade.customers (cid), constraint emp_fk foreign key (eid) references emp.employees (eid))"
	"create table default1.employees (eid int not null constraint employees_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9))";

sql.SQLPrms-gfeDDLExtension =
	" " //" replicate"
	" "//" replicate"
	" "
	" partition by column (cid, sid) "
	" " 
	" " 
	" "
	" "	 //emp.employees
	" "  //trade.trades
	" "; //default1.employees
	
sql.SQLPrms-createDiskStore = "create diskstore WanDiskStore 'wanPersist'" ;
sql.SQLPrms-useGfxdConfig = true;

sql.wan.SQLWanPrms-mineToRemoteId = 
	"random"
	"random"
	"random"
	"random"
	"random";

hydra.gemfirexd.NetworkServerPrms-names = server;
hydra.gemfirexd.GfxdConfigPrms-networkServerConfig = server;

