/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.impl;

import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.internal.cache.ExternalTableMetaData;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.spark.sql.collection.Utils;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry;
import org.apache.spark.sql.hive.ExternalTableType;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.sources.JdbcExtendedUtils;
import org.apache.spark.sql.store.StoreUtils;
import org.apache.spark.sql.types.StructType;
import org.apache.thrift.TException;

public class SnappyHiveCatalog
implements ExternalCatalog {
    private static final String THREAD_GROUP_NAME = "HiveMetaStore Client Group";
    private ThreadLocal<HiveMetaStoreClient> hmClients = new ThreadLocal();
    private final ThreadLocal<HMSQuery> queries = new ThreadLocal();
    private final ExecutorService hmsQueriesExecutorService;
    private final ArrayList<HiveMetaStoreClient> allHMclients = new ArrayList();

    public SnappyHiveCatalog() {
        LogWriterImpl.LoggingThreadGroup hmsThreadGroup = LogWriterImpl.createThreadGroup((String)THREAD_GROUP_NAME, (LogWriterI18n)Misc.getI18NLogWriter());
        ThreadFactory hmsClientThreadFactory = new ThreadFactory((ThreadGroup)hmsThreadGroup){
            private int next = 0;
            final /* synthetic */ ThreadGroup val$hmsThreadGroup;
            {
                this.val$hmsThreadGroup = threadGroup;
            }

            @Override
            public Thread newThread(Runnable command) {
                Thread t = new Thread(this.val$hmsThreadGroup, command, "HiveMetaStore Client-" + this.next++);
                t.setDaemon(true);
                return t;
            }
        };
        this.hmsQueriesExecutorService = Executors.newFixedThreadPool(1, hmsClientThreadFactory);
        HMSQuery q = this.getHMSQuery();
        q.resetValues(0, null, null, true);
        Future<Object> ret = this.hmsQueriesExecutorService.submit(q);
        try {
            ret.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isColumnTable(String schema, String tableName, boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(2, tableName, schema, skipLocks);
        Future<Object> f = this.hmsQueriesExecutorService.submit(q);
        return (Boolean)this.handleFutureResult(f);
    }

    public boolean isRowTable(String schema, String tableName, boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(1, tableName, schema, skipLocks);
        Future<Object> f = this.hmsQueriesExecutorService.submit(q);
        return (Boolean)this.handleFutureResult(f);
    }

    public String getColumnTableSchemaAsJson(String schema, String tableName, boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(3, tableName, schema, skipLocks);
        Future<Object> f = this.hmsQueriesExecutorService.submit(q);
        return (String)this.handleFutureResult(f);
    }

    public ExternalTableMetaData getHiveTableMetaData(String schema, String tableName, boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(6, tableName, schema, skipLocks);
        Future<Object> f = this.hmsQueriesExecutorService.submit(q);
        return (ExternalTableMetaData)this.handleFutureResult(f);
    }

    public HashMap<String, List<String>> getAllStoreTablesInCatalog(boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(4, null, null, skipLocks);
        Future<Object> f = this.hmsQueriesExecutorService.submit(q);
        return (HashMap)this.handleFutureResult(f);
    }

    public boolean removeTable(String schema, String table, boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(5, table, schema, skipLocks);
        Future<Object> f = this.hmsQueriesExecutorService.submit(q);
        return (Boolean)this.handleFutureResult(f);
    }

    public String catalogSchemaName() {
        return SnappyStoreHiveCatalog.HIVE_METASTORE();
    }

    public void stop() {
        for (HiveMetaStoreClient cl : this.allHMclients) {
            cl.close();
        }
        this.hmClients = null;
        this.allHMclients.clear();
        this.hmsQueriesExecutorService.shutdown();
    }

    private HMSQuery getHMSQuery() {
        HMSQuery q = this.queries.get();
        if (q == null) {
            q = new HMSQuery();
            this.queries.set(q);
        }
        return q;
    }

    private <T> T handleFutureResult(Future<T> f) {
        try {
            return f.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class HMSQuery
    implements Callable<Object> {
        private int qType;
        private String tableName;
        private String dbName;
        private boolean skipLock;
        private static final int INIT = 0;
        private static final int ISROWTABLE_QUERY = 1;
        private static final int ISCOLUMNTABLE_QUERY = 2;
        private static final int COLUMNTABLE_SCHEMA = 3;
        private static final int GET_ALL_TABLES_MANAGED_IN_DD = 4;
        private static final int REMOVE_TABLE = 5;
        private static final int GET_COL_TABLE = 6;

        HMSQuery() {
        }

        public void resetValues(int queryType, String tableName, String dbName, boolean skipLocks) {
            this.qType = queryType;
            this.tableName = tableName;
            this.dbName = dbName;
            this.skipLock = skipLocks;
        }

        @Override
        public Object call() throws Exception {
            try {
                if (this.skipLock) {
                    GfxdDataDictionary.SKIP_LOCKS.set(true);
                }
                switch (this.qType) {
                    case 0: {
                        this.initHMC();
                        Boolean bl = true;
                        return bl;
                    }
                    case 1: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        String type = this.getType(hmc);
                        Boolean bl = type.equalsIgnoreCase(ExternalTableType.Row().toString());
                        return bl;
                    }
                    case 2: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        String type = this.getType(hmc);
                        Boolean bl = !type.equalsIgnoreCase(ExternalTableType.Row().toString());
                        return bl;
                    }
                    case 3: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        String string = this.getSchema(hmc);
                        return string;
                    }
                    case 4: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        List dbList = hmc.getAllDatabases();
                        HashMap dbTablesMap = new HashMap();
                        for (String db : dbList) {
                            List tables = hmc.getAllTables(db);
                            LinkedList<String> upperCaseTableNames = new LinkedList<String>();
                            for (String t : tables) {
                                Table hiveTab = hmc.getTable(db, t);
                                if (!this.isTableInStoreDD(hiveTab)) continue;
                                upperCaseTableNames.add(t.toUpperCase());
                            }
                            dbTablesMap.put(db.toUpperCase(), upperCaseTableNames);
                        }
                        HashMap hashMap = dbTablesMap;
                        return hashMap;
                    }
                    case 5: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        hmc.dropTable(this.dbName, this.tableName);
                        Boolean bl = true;
                        return bl;
                    }
                    case 6: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        Table table = this.getTableWithRetry(hmc);
                        String fullyQualifiedName = table.getDbName().toUpperCase() + "." + table.getTableName().toUpperCase();
                        StructType schema = ExternalStoreUtils.convertSchemaMap(table.getParameters());
                        CaseInsensitiveMap parameters = new CaseInsensitiveMap(table.getSd().getSerdeInfo().getParameters());
                        int partitions = ExternalStoreUtils.getAndSetTotalPartitions((Map<String, String>)parameters, true);
                        Object value = parameters.get((Object)StoreUtils.GEM_INDEXED_TABLE());
                        String baseTable = value != null ? value.toString() : "";
                        String dmls = JdbcExtendedUtils.getInsertOrPutString(fullyQualifiedName, schema, false);
                        value = parameters.get((Object)ExternalStoreUtils.DEPENDENT_RELATIONS());
                        String[] dependentRelations = value != null ? value.toString().split(",") : null;
                        int columnBatchSize = Integer.parseInt(parameters.get((Object)ExternalStoreUtils.COLUMN_BATCH_SIZE()).toString());
                        int columnMaxDeltaRows = Integer.parseInt(parameters.get((Object)ExternalStoreUtils.COLUMN_MAX_DELTA_ROWS()).toString());
                        value = parameters.get((Object)ExternalStoreUtils.COMPRESSION_CODEC());
                        String compressionCodec = value == null ? null : value.toString();
                        String tableType = (String)table.getParameters().get(JdbcExtendedUtils.TABLETYPE_PROPERTY());
                        ExternalTableMetaData externalTableMetaData = new ExternalTableMetaData(fullyQualifiedName, (Object)schema, tableType, (Object)ExternalStoreUtils.getExternalStoreOnExecutor((Map<String, String>)parameters, partitions, fullyQualifiedName, schema), columnBatchSize, columnMaxDeltaRows, compressionCodec, baseTable, dmls, dependentRelations);
                        return externalTableMetaData;
                    }
                }
                throw new IllegalStateException("HiveMetaStoreClient:unknown query option");
            }
            finally {
                GfxdDataDictionary.SKIP_LOCKS.set(false);
            }
        }

        public String toString() {
            return "HiveMetaStoreQuery:query type = " + this.qType + " tname = " + this.tableName + " db = " + this.dbName;
        }

        private void initHMC() {
            DriverRegistry.register((String)"io.snappydata.jdbc.EmbeddedDriver");
            DriverRegistry.register((String)"io.snappydata.jdbc.ClientDriver");
            String url = "jdbc:snappydata:;user=" + SnappyStoreHiveCatalog.HIVE_METASTORE() + ";disable-streaming=true;default-persistent=true";
            HiveConf metadataConf = new HiveConf();
            metadataConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, url);
            metadataConf.setVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER, "io.snappydata.jdbc.EmbeddedDriver");
            try {
                HiveMetaStoreClient hmc = new HiveMetaStoreClient(metadataConf);
                SnappyHiveCatalog.this.hmClients.set(hmc);
                SnappyHiveCatalog.this.allHMclients.add(hmc);
            }
            catch (MetaException me) {
                throw new IllegalStateException(me);
            }
        }

        private Table getTable(HiveMetaStoreClient hmc, String dbName, String tableName) throws SQLException {
            try {
                return hmc.getTable(dbName, tableName);
            }
            catch (NoSuchObjectException ignored) {
                return null;
            }
            catch (TException te) {
                throw Util.generateCsSQLException((String)"XIE0M.S", (Object)tableName, (Object)((Object)te));
            }
        }

        private String getType(HiveMetaStoreClient hmc) throws SQLException {
            Table t = this.getTable(hmc, this.dbName, this.tableName);
            if (t != null) {
                return (String)t.getParameters().get(JdbcExtendedUtils.TABLETYPE_PROPERTY());
            }
            return ExternalTableType.Row().toString();
        }

        private boolean isTableInStoreDD(Table t) {
            String type = (String)t.getParameters().get(JdbcExtendedUtils.TABLETYPE_PROPERTY());
            return type.equalsIgnoreCase(ExternalTableType.Row().toString()) || type.equalsIgnoreCase(ExternalTableType.Column().toString()) || type.equalsIgnoreCase(ExternalTableType.Sample().toString());
        }

        private Table getTableWithRetry(HiveMetaStoreClient hmc) throws SQLException {
            Table table = null;
            try {
                table = this.getTable(hmc, this.dbName, this.tableName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (table == null) {
                table = this.getTable(hmc, this.dbName, Utils.toUpperCase(this.tableName));
            }
            return table;
        }

        private String getSchema(HiveMetaStoreClient hmc) throws SQLException {
            Table table = this.getTableWithRetry(hmc);
            if (table != null) {
                return SnappyStoreHiveCatalog.getSchemaStringFromHiveTable(table);
            }
            return null;
        }
    }
}

