/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.impl;

import io.snappydata.impl.ArrayValidatingConverter;
import io.snappydata.impl.GenericValidatingConverter;
import io.snappydata.impl.IdentityValidatingConverter;
import io.snappydata.impl.MapValidatingConverter;
import io.snappydata.impl.NullValidatingConverter;
import io.snappydata.impl.StructValidatingConverter;
import io.snappydata.impl.ValidatingConverter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;

public final class ValidatingConverter$ {
    public static final ValidatingConverter$ MODULE$;
    private final Map<Class<?>, Seq<Class<?>>> objectCompatibilityMap;

    static {
        new ValidatingConverter$();
    }

    public Map<Class<?>, Seq<Class<?>>> objectCompatibilityMap() {
        return this.objectCompatibilityMap;
    }

    public ValidatingConverter apply(DataType dataType, String table, String column) {
        ValidatingConverter validatingConverter;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            validatingConverter = new ArrayValidatingConverter(arrayType, table, column);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            validatingConverter = new MapValidatingConverter(mapType, table, column);
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            validatingConverter = new StructValidatingConverter(structType, table, column);
        } else {
            boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (DoubleType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (ByteType$.MODULE$.equals(dataType2) ? true : (CalendarIntervalType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2))))))));
            validatingConverter = bl ? new IdentityValidatingConverter(dataType, table, column) : (NullType$.MODULE$.equals(dataType2) ? new NullValidatingConverter(table, column) : new GenericValidatingConverter(dataType, table, column));
        }
        return validatingConverter;
    }

    private ValidatingConverter$() {
        MODULE$ = this;
        this.objectCompatibilityMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(StringType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{String.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(IntegerType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Integer.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LongType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Long.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ShortType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Short.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DoubleType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Double.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(FloatType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Float.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BooleanType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Boolean.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ByteType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Byte.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DateType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Date.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimestampType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Timestamp.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(CalendarIntervalType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{CalendarInterval.class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BinaryType$.MODULE$.getClass()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{byte[].class}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DecimalType.class), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{BigDecimal.class, Decimal.class, scala.math.BigDecimal.class})))}));
    }
}

