/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.util.com.clearspring.analytics.stream;

import com.clearspring.analytics.util.DoublyLinkedList;
import com.clearspring.analytics.util.ListNode2;
import com.clearspring.analytics.util.Pair;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.snappydata.util.com.clearspring.analytics.stream.Counter;
import io.snappydata.util.com.clearspring.analytics.stream.ITopK;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StreamSummary<T>
implements ITopK<T> {
    protected final int capacity;
    private final HashMap<T, ListNode2<Counter<T>>> counterMap;
    protected final DoublyLinkedList<Bucket> bucketList;

    public StreamSummary(int capacity) {
        this.capacity = capacity;
        this.counterMap = new HashMap();
        this.bucketList = new DoublyLinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean offer(T item) {
        return this.offer(item, 1);
    }

    @Override
    public boolean offer(T item, int incrementCount) {
        return (Boolean)this.offerReturnAll(item, (int)incrementCount).left;
    }

    public T offerReturnDropped(T item, int incrementCount) {
        return (T)this.offerReturnAll(item, (int)incrementCount).right;
    }

    public Pair<Boolean, T> offerReturnAll(T item, int incrementCount) {
        ListNode2 counterNode = this.counterMap.get(item);
        boolean isNewItem = counterNode == null;
        Object droppedItem = null;
        if (isNewItem) {
            if (this.size() < this.capacity) {
                counterNode = ((Bucket)this.bucketList.enqueue((Object)(StreamSummary)this.new Bucket((long)0L)).getValue()).counterList.add(new Counter<T>((ListNode2<Bucket>)this.bucketList.tail(), item));
            } else {
                Bucket min = (Bucket)this.bucketList.first();
                counterNode = min.counterList.tail();
                Counter counter = (Counter)counterNode.getValue();
                droppedItem = counter.item;
                this.counterMap.remove(droppedItem);
                counter.item = item;
                counter.error = min.count;
            }
            this.counterMap.put(item, counterNode);
        }
        this.incrementCounter(counterNode, incrementCount);
        return new Pair((Object)isNewItem, droppedItem);
    }

    protected void incrementCounter(ListNode2<Counter<T>> counterNode, int incrementCount) {
        Bucket bucketNext;
        Counter counter = (Counter)counterNode.getValue();
        ListNode2 oldNode = counter.bucketNode;
        Bucket bucket = (Bucket)oldNode.getValue();
        bucket.counterList.remove(counterNode);
        counter.count += (long)incrementCount;
        ListNode2 bucketNodePrev = oldNode;
        ListNode2 bucketNodeNext = bucketNodePrev.getNext();
        while (bucketNodeNext != null) {
            bucketNext = (Bucket)bucketNodeNext.getValue();
            if (counter.count == bucketNext.count) {
                bucketNext.counterList.add(counterNode);
                break;
            }
            if (counter.count > bucketNext.count) {
                bucketNodePrev = bucketNodeNext;
                bucketNodeNext = bucketNodePrev.getNext();
                continue;
            }
            bucketNodeNext = null;
        }
        if (bucketNodeNext == null) {
            bucketNext = new Bucket(counter.count);
            bucketNext.counterList.add(counterNode);
            bucketNodeNext = this.bucketList.addAfter(bucketNodePrev, (Object)bucketNext);
        }
        counter.bucketNode = bucketNodeNext;
        if (bucket.counterList.isEmpty()) {
            this.bucketList.remove(oldNode);
        }
    }

    @Override
    public List<T> peek(int k) {
        ArrayList topK = new ArrayList(k);
        for (ListNode2 bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = (Bucket)bNode.getValue();
            for (Counter c : b.counterList) {
                if (topK.size() == k) {
                    return topK;
                }
                topK.add(c.item);
            }
        }
        return topK;
    }

    public List<Counter<T>> topK(int k) {
        ArrayList<Counter<T>> topK = new ArrayList<Counter<T>>(k);
        for (ListNode2 bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = (Bucket)bNode.getValue();
            for (Counter c : b.counterList) {
                if (topK.size() == k) {
                    return topK;
                }
                topK.add(c);
            }
        }
        return topK;
    }

    public int size() {
        return this.counterMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (ListNode2 bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = (Bucket)bNode.getValue();
            sb.append('{');
            sb.append(b.count);
            sb.append(":[");
            for (Counter c : b.counterList) {
                sb.append('{');
                sb.append(c.item);
                sb.append(':');
                sb.append(c.error);
                sb.append("},");
            }
            if (b.counterList.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]},");
        }
        if (this.bucketList.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public static <T> void write(Kryo kryo, Output output2, StreamSummary<T> obj) {
        output2.writeInt(obj.capacity);
        output2.writeInt(obj.size());
        for (ListNode2 bNode = obj.bucketList.tail(); bNode != null; bNode = bNode.getNext()) {
            Bucket b = (Bucket)bNode.getValue();
            for (Counter c : b.counterList) {
                kryo.writeObject(output2, (Object)c);
            }
        }
    }

    public static <T> StreamSummary<T> read(Kryo kryo, Input input) {
        int capacity = input.readInt();
        int size = input.readInt();
        StreamSummary<T> deser = new StreamSummary<T>(capacity);
        Bucket currentBucket = null;
        ListNode2 currentBucketNode = null;
        for (int i = 0; i < size; ++i) {
            Counter c = (Counter)kryo.readObject(input, Counter.class);
            if (currentBucket == null || c.count != currentBucket.count) {
                StreamSummary<T> streamSummary = deser;
                streamSummary.getClass();
                currentBucket = streamSummary.new Bucket(c.count);
                currentBucketNode = deser.bucketList.add((Object)currentBucket);
            }
            c.bucketNode = currentBucketNode;
            deser.counterMap.put(c.item, currentBucket.counterList.add((Object)c));
        }
        return deser;
    }

    protected class Bucket {
        protected final DoublyLinkedList<Counter<T>> counterList;
        private final long count;

        public Bucket(long count2) {
            this.count = count2;
            this.counterList = new DoublyLinkedList();
        }
    }
}

