/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Properties;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.row.GemFireXDBaseDialect;
import org.apache.spark.sql.row.GemFireXDClientDialect$;
import org.apache.spark.sql.row.GemFireXDDialect$;
import org.apache.spark.sql.sources.ConnectionProperties;
import org.apache.spark.sql.types.TypeUtilities$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConnectionPropertiesSerializer$
extends Serializer<ConnectionProperties> {
    public static final ConnectionPropertiesSerializer$ MODULE$;

    static {
        new ConnectionPropertiesSerializer$();
    }

    public void write(Kryo kryo, Output output2, ConnectionProperties connProps) {
        Integer n;
        output2.writeString(connProps.url());
        output2.writeString(connProps.driver());
        JdbcDialect jdbcDialect = connProps.dialect();
        if (((Object)((Object)GemFireXDDialect$.MODULE$)).equals(jdbcDialect)) {
            output2.writeByte(0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)GemFireXDClientDialect$.MODULE$)).equals(jdbcDialect)) {
            output2.writeByte(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            output2.writeByte(2);
            kryo.writeClassAndObject(output2, (Object)jdbcDialect);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Map<String, String> poolProps = connProps.poolProps();
        if (poolProps != null) {
            int numProps = poolProps.size();
            output2.writeVarInt(numProps, true);
            if (numProps > 0) {
                poolProps.withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                        Tuple2<String, String> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(output2){
                    public static final long serialVersionUID = 0L;
                    private final Output output$1;

                    public final void apply(Tuple2<String, String> x$1) {
                        Tuple2<String, String> tuple2 = x$1;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            this.output$1.writeString(key);
                            this.output$1.writeString(value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.output$1 = output$1;
                    }
                });
            }
            n = BoxedUnit.UNIT;
        } else {
            n = BoxesRunTime.boxToInteger((int)output2.writeVarInt(0, true));
        }
        if (connProps.executorConnProps().isEmpty()) {
            TypeUtilities$.MODULE$.writeProperties(connProps.connProps(), output2);
        } else {
            TypeUtilities$.MODULE$.writeProperties(connProps.executorConnProps(), output2);
        }
        output2.writeBoolean(connProps.hikariCP());
    }

    public ConnectionProperties read(Kryo kryo, Input input, Class<ConnectionProperties> c) {
        return this.read(kryo, input);
    }

    public ConnectionProperties read(Kryo kryo, Input input) {
        int numProps;
        GemFireXDBaseDialect gemFireXDBaseDialect;
        String url = input.readString();
        String driver = input.readString();
        byte by = input.readByte();
        switch (by) {
            default: {
                gemFireXDBaseDialect = (JdbcDialect)kryo.readClassAndObject(input);
                break;
            }
            case 1: {
                gemFireXDBaseDialect = GemFireXDClientDialect$.MODULE$;
                break;
            }
            case 0: {
                gemFireXDBaseDialect = GemFireXDDialect$.MODULE$;
            }
        }
        GemFireXDBaseDialect dialect = gemFireXDBaseDialect;
        Map poolProps = Predef$.MODULE$.Map().empty();
        if (numProps > 0) {
            Builder propsBuilder = Predef$.MODULE$.Map().newBuilder();
            for (numProps = input.readVarInt(true); numProps > 0; --numProps) {
                String key = input.readString();
                propsBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)input.readString()));
            }
            poolProps = (Map)propsBuilder.result();
        }
        Properties connProps = TypeUtilities$.MODULE$.readProperties(input);
        boolean hikariCP = input.readBoolean();
        return new ConnectionProperties(url, driver, dialect, (Map<String, String>)poolProps, connProps, connProps, hikariCP);
    }

    private ConnectionPropertiesSerializer$() {
        MODULE$ = this;
    }
}

