/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.serializer.PooledKryoSerializer;
import org.apache.spark.serializer.PooledObject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class KryoSerializerPool$ {
    public static final KryoSerializerPool$ MODULE$;
    private final Field autoResetField;
    private final byte[] zeroBytes;
    private final /* synthetic */ Tuple2 x$2;
    private final PooledKryoSerializer serializer;
    private final int bufferSize;
    private final ArrayDeque<SoftReference<PooledObject>> pool;

    static {
        new KryoSerializerPool$();
    }

    public Field autoResetField() {
        return this.autoResetField;
    }

    public byte[] zeroBytes() {
        return this.zeroBytes;
    }

    public PooledKryoSerializer serializer() {
        return this.serializer;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PooledObject borrow() {
        SoftReference<PooledObject> ref = null;
        ArrayDeque<SoftReference<PooledObject>> arrayDeque = this.pool;
        synchronized (arrayDeque) {
            ref = this.pool.pollFirst();
        }
        while (ref != null) {
            SoftReference<PooledObject> softReference;
            PooledObject poolObject = (PooledObject)softReference.get();
            if (poolObject != null) {
                return poolObject;
            }
            ArrayDeque<SoftReference<PooledObject>> arrayDeque2 = this.pool;
            synchronized (arrayDeque2) {
                softReference = this.pool.pollFirst();
            }
        }
        return new PooledObject(this.serializer(), this.bufferSize());
    }

    public void release(PooledObject poolObject, boolean clearInputBuffer) {
        poolObject.kryo().reset();
        if (clearInputBuffer) {
            poolObject.input().setBuffer(this.zeroBytes());
        }
        SoftReference<PooledObject> ref = new SoftReference<PooledObject>(poolObject);
        ArrayDeque<SoftReference<PooledObject>> arrayDeque = this.pool;
        synchronized (arrayDeque) {
            this.pool.addFirst(ref);
            return;
        }
    }

    public boolean release$default$2() {
        return false;
    }

    public void clear() {
        ArrayDeque<SoftReference<PooledObject>> arrayDeque = this.pool;
        synchronized (arrayDeque) {
            this.pool.clear();
            return;
        }
    }

    private KryoSerializerPool$() {
        MODULE$ = this;
        this.autoResetField = Kryo.class.getDeclaredField("autoReset");
        this.autoResetField().setAccessible(true);
        this.zeroBytes = new byte[0];
        SparkConf conf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkConf apply(SparkEnv x$1) {
                return x$1.conf();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkConf apply() {
                return new SparkConf();
            }
        });
        long bufferSizeKb = conf.getSizeAsKb("spark.kryoserializer.buffer", "4k");
        int bufferSize = (int)ByteUnit.KiB.toBytes(bufferSizeKb);
        Tuple2 tuple2 = new Tuple2((Object)new PooledKryoSerializer(conf), (Object)BoxesRunTime.boxToInteger((int)bufferSize));
        if (tuple2 != null) {
            Tuple2 tuple22;
            PooledKryoSerializer serializer = (PooledKryoSerializer)((Object)tuple2._1());
            int bufferSize2 = tuple2._2$mcI$sp();
            this.x$2 = tuple22 = new Tuple2((Object)serializer, (Object)BoxesRunTime.boxToInteger((int)bufferSize2));
            this.serializer = (PooledKryoSerializer)((Object)this.x$2._1());
            this.bufferSize = this.x$2._2$mcI$sp();
            this.pool = new ArrayDeque();
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

