/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.KryoSerializerPool$;
import org.apache.spark.serializer.KryoStringFixDeserializationStream;
import org.apache.spark.serializer.KryoStringFixSerializationStream;
import org.apache.spark.serializer.PooledKryoSerializer;
import org.apache.spark.serializer.PooledObject;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0005\u0011Q!\u0001\b)p_2,Gm\u0013:z_N+'/[1mSj,'/\u00138ti\u0006t7-\u001a\u0006\u0003\u0007\u0011\t!b]3sS\u0006d\u0017N_3s\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7c\u0001\u0001\f\u001fA\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u0013'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\u0005\u0002\u0011#5\tA!\u0003\u0002\u0013\t\t9Aj\\4hS:<\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002!A|w\u000e\\3e'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u0001\u0001\t\u0003\u0019]I!\u0001\u0007\u0002\u0003)A{w\u000e\\3e\u0017JLxnU3sS\u0006d\u0017N_3s\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011A$\b\t\u0003\u0019\u0001AQ\u0001F\rA\u0002YAQa\b\u0001\u0005\n\u0001\nQC]3bI\nKH/\u001a\"vM\u001a,'/Q:J]B,H\u000fF\u0002\"OE\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012A!\u00168ji\")\u0001F\ba\u0001S\u0005\u0011!M\u0019\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\n1A\\5p\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u00033=\u0001\u00071'A\u0003j]B,H\u000f\u0005\u00025{5\tQG\u0003\u00027o\u0005\u0011\u0011n\u001c\u0006\u0003qe\nAa\u001b:z_*\u0011!hO\u0001\u0011KN|G/\u001a:jGN|g\r^<be\u0016T\u0011\u0001P\u0001\u0004G>l\u0017B\u0001 6\u0005\u0015Ie\u000e];u\u0011\u0015\u0001\u0005\u0001\"\u0011B\u0003%\u0019XM]5bY&TX-\u0006\u0002C\u001dR\u00111i\u0016\u000b\u0003S\u0011Cq!R \u0002\u0002\u0003\u000fa)\u0001\u0006fm&$WM\\2fIE\u00022a\u0012&M\u001b\u0005A%BA%$\u0003\u001d\u0011XM\u001a7fGRL!a\u0013%\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"!\u0014(\r\u0001\u0011)qj\u0010b\u0001!\n\tA+\u0005\u0002R)B\u0011!EU\u0005\u0003'\u000e\u0012qAT8uQ&tw\r\u0005\u0002#+&\u0011ak\t\u0002\u0004\u0003:L\b\"\u0002-@\u0001\u0004a\u0015!\u0001;\t\u000bi\u0003A\u0011I.\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u00039~#\"!X2\u0015\u0005y\u0003\u0007CA'`\t\u0015y\u0015L1\u0001Q\u0011\u001d\t\u0017,!AA\u0004\t\f!\"\u001a<jI\u0016t7-\u001a\u00133!\r9%J\u0018\u0005\u0006If\u0003\r!K\u0001\u0007EV4g-\u001a:\t\u000bi\u0003A\u0011\t4\u0016\u0005\u001dTGc\u00015o_R\u0011\u0011n\u001b\t\u0003\u001b*$QaT3C\u0002ACq\u0001\\3\u0002\u0002\u0003\u000fQ.\u0001\u0006fm&$WM\\2fIM\u00022a\u0012&j\u0011\u0015!W\r1\u0001*\u0011\u0015\u0001X\r1\u0001r\u0003\u0019aw.\u00193feB\u0011!/^\u0007\u0002g*\u0011A/L\u0001\u0005Y\u0006tw-\u0003\u0002wg\nY1\t\\1tg2{\u0017\rZ3s\u0011\u0015A\b\u0001\"\u0011z\u0003=\u0019XM]5bY&TXm\u0015;sK\u0006lGC\u0001>~!\ta10\u0003\u0002}\u0005\t\u00192+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[\")ap\u001ea\u0001\u007f\u000611\u000f\u001e:fC6\u0004B!!\u0001\u0002\u00065\u0011\u00111\u0001\u0006\u0003m5JA!a\u0002\u0002\u0004\taq*\u001e;qkR\u001cFO]3b[\"9\u00111\u0002\u0001\u0005B\u00055\u0011!\u00053fg\u0016\u0014\u0018.\u00197ju\u0016\u001cFO]3b[R!\u0011qBA\u000b!\ra\u0011\u0011C\u0005\u0004\u0003'\u0011!!\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TiJ,\u0017-\u001c\u0005\b}\u0006%\u0001\u0019AA\f!\u0011\t\t!!\u0007\n\t\u0005m\u00111\u0001\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002 \u0001!\t!!\t\u0002\u0019\u001d,G/Q;u_J+7/\u001a;\u0016\u0005\u0005\r\u0002c\u0001\u0012\u0002&%\u0019\u0011qE\u0012\u0003\u000f\t{w\u000e\\3b]\u0002")
public final class PooledKryoSerializerInstance
extends SerializerInstance
implements Logging {
    private transient Logger org$apache$spark$Logging$$log_;
    private transient int org$apache$spark$Logging$$levelFlags;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$Logging$$levelFlags() {
        return this.org$apache$spark$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private void readByteBufferAsInput(ByteBuffer bb, Input input) {
        if (bb.hasArray()) {
            input.setBuffer(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int numBytes = bb.remaining();
            byte[] bytes = new byte[numBytes];
            bb.get(bytes, 0, numBytes);
            input.setBuffer(bytes, 0, numBytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> ByteBuffer serialize(T t, ClassTag<T> evidence$1) {
        ByteBuffer byteBuffer;
        PooledObject poolObject = KryoSerializerPool$.MODULE$.borrow();
        Output output2 = poolObject.newOutput();
        try {
            ByteBuffer result;
            poolObject.kryo().writeClassAndObject(output2, t);
            byteBuffer = result = ByteBuffer.wrap(output2.toBytes());
            KryoSerializerPool$.MODULE$.release(poolObject, KryoSerializerPool$.MODULE$.release$default$2());
        }
        catch (Throwable throwable) {
            void var3_3;
            KryoSerializerPool$.MODULE$.release((PooledObject)var3_3, KryoSerializerPool$.MODULE$.release$default$2());
            throw throwable;
        }
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T deserialize(ByteBuffer buffer, ClassTag<T> evidence$2) {
        Object object;
        PooledObject poolObject = KryoSerializerPool$.MODULE$.borrow();
        Input input = poolObject.input();
        try {
            Object result;
            this.readByteBufferAsInput(buffer, input);
            object = result = poolObject.kryo().readClassAndObject(input);
            KryoSerializerPool$.MODULE$.release(poolObject, true);
        }
        catch (Throwable throwable) {
            void var3_3;
            KryoSerializerPool$.MODULE$.release((PooledObject)var3_3, true);
            throw throwable;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T deserialize(ByteBuffer buffer, ClassLoader loader, ClassTag<T> evidence$3) {
        Object object;
        PooledObject poolObject = KryoSerializerPool$.MODULE$.borrow();
        Kryo kryo = poolObject.kryo();
        Input input = poolObject.input();
        ClassLoader oldClassLoader = kryo.getClassLoader();
        try {
            Object result;
            kryo.setClassLoader(loader);
            this.readByteBufferAsInput(buffer, input);
            object = result = kryo.readClassAndObject(input);
        }
        catch (Throwable throwable) {
            void var4_4;
            void var7_7;
            void var5_5;
            var5_5.setClassLoader((ClassLoader)var7_7);
            KryoSerializerPool$.MODULE$.release((PooledObject)var4_4, true);
            throw throwable;
        }
        kryo.setClassLoader(oldClassLoader);
        KryoSerializerPool$.MODULE$.release(poolObject, true);
        return (T)object;
    }

    public SerializationStream serializeStream(OutputStream stream) {
        return new KryoStringFixSerializationStream(stream);
    }

    public DeserializationStream deserializeStream(InputStream stream) {
        return new KryoStringFixDeserializationStream(stream);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getAutoReset() {
        PooledObject poolObject = KryoSerializerPool$.MODULE$.borrow();
        try {
            void var3_2;
            boolean result = BoxesRunTime.unboxToBoolean((Object)KryoSerializerPool$.MODULE$.autoResetField().get(poolObject.kryo()));
            KryoSerializerPool$.MODULE$.release(poolObject, KryoSerializerPool$.MODULE$.release$default$2());
            return (boolean)var3_2;
        }
        catch (Throwable throwable) {
            void var1_1;
            KryoSerializerPool$.MODULE$.release((PooledObject)var1_1, KryoSerializerPool$.MODULE$.release$default$2());
            throw throwable;
        }
    }

    public PooledKryoSerializerInstance(PooledKryoSerializer pooledSerializer) {
        Logging$class.$init$(this);
    }
}

