/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeUtilities$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StructTypeSerializer$
extends Serializer<StructType> {
    public static final StructTypeSerializer$ MODULE$;

    static {
        new StructTypeSerializer$();
    }

    public void writeType(Kryo kryo, Output output2, DataType dataType) {
        DataType dataType2 = dataType;
        if (IntegerType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(4, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LongType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(-5, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (StringType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(2005, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(8, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(6, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(5, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(-6, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(16, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(2004, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(93, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateType$.MODULE$.equals(dataType2)) {
            output2.writeVarInt(91, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            output2.writeVarInt(3, false);
            output2.writeVarInt(decimalType.precision(), true);
            output2.writeVarInt(decimalType.scale(), true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            output2.writeVarInt(2003, false);
            this.writeType(kryo, output2, arrayType.elementType());
            output2.writeBoolean(arrayType.containsNull());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            output2.writeVarInt(2000, false);
            this.writeType(kryo, output2, mapType.keyType());
            this.writeType(kryo, output2, mapType.valueType());
            output2.writeBoolean(mapType.valueContainsNull());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            output2.writeVarInt(2002, false);
            this.write(kryo, output2, structType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            output2.writeVarInt(1111, false);
            kryo.writeClassAndObject(output2, (Object)dataType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public DataType readType(Kryo kryo, Input input) {
        DateType$ dateType$;
        int n = input.readVarInt(false);
        switch (n) {
            default: {
                throw new KryoException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Serialization error: unexpected DataType ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
            }
            case 1111: {
                dateType$ = (DataType)kryo.readClassAndObject(input);
                break;
            }
            case 2002: {
                dateType$ = this.read(kryo, input, StructType.class);
                break;
            }
            case 2000: {
                DataType keyType = this.readType(kryo, input);
                DataType valueType = this.readType(kryo, input);
                dateType$ = new MapType(keyType, valueType, input.readBoolean());
                break;
            }
            case 2003: {
                DataType elementType = this.readType(kryo, input);
                dateType$ = new ArrayType(elementType, input.readBoolean());
                break;
            }
            case 3: {
                int precision = input.readVarInt(true);
                int scale = input.readVarInt(true);
                dateType$ = new DecimalType(precision, scale);
                break;
            }
            case 91: {
                dateType$ = DateType$.MODULE$;
                break;
            }
            case 93: {
                dateType$ = TimestampType$.MODULE$;
                break;
            }
            case 2004: {
                dateType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                dateType$ = BooleanType$.MODULE$;
                break;
            }
            case -6: {
                dateType$ = ByteType$.MODULE$;
                break;
            }
            case 5: {
                dateType$ = ShortType$.MODULE$;
                break;
            }
            case 6: {
                dateType$ = FloatType$.MODULE$;
                break;
            }
            case 8: {
                dateType$ = DoubleType$.MODULE$;
                break;
            }
            case 2005: {
                dateType$ = StringType$.MODULE$;
                break;
            }
            case -5: {
                dateType$ = LongType$.MODULE$;
                break;
            }
            case 4: {
                dateType$ = IntegerType$.MODULE$;
            }
        }
        return dateType$;
    }

    public void write(Kryo kryo, Output output2, StructType struct) {
        StructField[] fields = struct.fields();
        int numFields = fields.length;
        output2.writeVarInt(numFields, true);
        for (int i = 0; i < numFields; ++i) {
            StructField field = fields[i];
            output2.writeString(field.name());
            this.writeType(kryo, output2, field.dataType());
            output2.writeBoolean(field.nullable());
            TypeUtilities$.MODULE$.writeMetadata(field.metadata(), kryo, output2);
        }
    }

    public StructType read(Kryo kryo, Input input, Class<StructType> c) {
        int numFields = input.readVarInt(true);
        StructField[] fields = new StructField[numFields];
        for (int i = 0; i < numFields; ++i) {
            String name = input.readString();
            DataType dataType = this.readType(kryo, input);
            boolean nullable = input.readBoolean();
            Metadata metadata = TypeUtilities$.MODULE$.readMetadata(kryo, input);
            fields[i] = new StructField(name, dataType, nullable, metadata);
        }
        return new StructType(fields);
    }

    private StructTypeSerializer$() {
        MODULE$ = this;
    }
}

