/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import io.snappydata.Property$;
import org.apache.spark.sql.catalyst.planning.ExtractEquiJoinKeys$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.ExistenceJoin;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.PartitionedDataSourceScan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import scala.Option;
import scala.Tuple3;
import scala.Tuple6;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;

public final class JoinStrategy$ {
    public static final JoinStrategy$ MODULE$;

    static {
        new JoinStrategy$();
    }

    public boolean skipBroadcastRight(JoinType joinType, LogicalPlan left, LogicalPlan right, SQLConf conf) {
        return this.canBuildLeft(joinType) && this.canBroadcast(left, conf) && left.statistics().sizeInBytes().$less(right.statistics().sizeInBytes());
    }

    public boolean canBroadcast(LogicalPlan plan, SQLConf conf) {
        return plan.statistics().isBroadcastable() || plan.statistics().sizeInBytes().$less$eq(BigInt$.MODULE$.long2bigInt(conf.autoBroadcastJoinThreshold()));
    }

    public boolean canBuildLocalHashMap(LogicalPlan plan, SQLConf conf) {
        return plan.statistics().sizeInBytes().$less$eq(BigInt$.MODULE$.long2bigInt(BoxesRunTime.unboxToLong((Object)Property$.MODULE$.HashJoinSize().get(conf))));
    }

    public boolean isLocalJoin(LogicalPlan plan) {
        boolean bl;
        LogicalPlan logicalPlan = plan;
        Option option = ExtractEquiJoinKeys$.MODULE$.unapply(logicalPlan);
        if (option.isEmpty()) {
            bl = false;
        } else {
            JoinType joinType = (JoinType)((Tuple6)option.get())._1();
            LogicalPlan left = (LogicalPlan)((Tuple6)option.get())._5();
            LogicalPlan right = (LogicalPlan)((Tuple6)option.get())._6();
            bl = this.canBuildRight(joinType) && this.canLocalJoin(right) || this.canBuildLeft(joinType) && this.canLocalJoin(left);
        }
        return bl;
    }

    public boolean canLocalJoin(LogicalPlan plan) {
        boolean bl;
        block4: {
            while (true) {
                LogicalPlan node;
                LogicalPlan logicalPlan;
                LogicalRelation logicalRelation;
                BaseRelation t;
                LogicalPlan logicalPlan2;
                LogicalPlan logicalPlan3;
                Option option;
                if (!(option = PhysicalOperation$.MODULE$.unapply(logicalPlan3 = plan)).isEmpty() && (logicalPlan2 = (LogicalPlan)((Tuple3)option.get())._3()) instanceof LogicalRelation && (t = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) instanceof PartitionedDataSourceScan) {
                    BaseRelation baseRelation = t;
                    bl = ((PartitionedDataSourceScan)baseRelation).numBuckets() == 1;
                    break block4;
                }
                Option option2 = PhysicalOperation$.MODULE$.unapply(logicalPlan3);
                if (!option2.isEmpty() && (logicalPlan = (LogicalPlan)((Tuple3)option2.get())._3()) instanceof Join) {
                    Join join = (Join)logicalPlan;
                    LogicalPlan left = join.left();
                    LogicalPlan right = join.right();
                    if (this.canLocalJoin(left)) {
                        plan = right;
                        continue;
                    }
                    bl = false;
                    break block4;
                }
                Option option3 = PhysicalOperation$.MODULE$.unapply(logicalPlan3);
                if (option3.isEmpty() || (node = (LogicalPlan)((Tuple3)option3.get())._3()).children().size() != 1) break;
                plan = (LogicalPlan)node.children().head();
            }
            bl = false;
        }
        return bl;
    }

    public boolean canBuildRight(JoinType joinType) {
        JoinType joinType2 = joinType;
        boolean bl = Inner$.MODULE$.equals(joinType2) ? true : (LeftOuter$.MODULE$.equals(joinType2) ? true : (LeftSemi$.MODULE$.equals(joinType2) ? true : LeftAnti$.MODULE$.equals(joinType2)));
        boolean bl2 = bl ? true : joinType2 instanceof ExistenceJoin;
        return bl2;
    }

    public boolean canBuildLeft(JoinType joinType) {
        JoinType joinType2 = joinType;
        boolean bl = Inner$.MODULE$.equals(joinType2) ? true : RightOuter$.MODULE$.equals(joinType2);
        boolean bl2 = bl;
        return bl2;
    }

    private JoinStrategy$() {
        MODULE$ = this;
    }
}

