/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.SerializedArray;
import org.apache.spark.sql.catalyst.util.SerializedArray$;
import org.apache.spark.sql.catalyst.util.SerializedMap;
import org.apache.spark.sql.catalyst.util.SerializedRow;
import org.apache.spark.sql.catalyst.util.SerializedRowData;
import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoding$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class SerializedRowData$class {
    public static final long getFieldCursor(SerializedRowData $this, int ordinal) {
        return $this.baseOffset() + (long)$this.bitSetWidthInBytes() + ((long)ordinal << (int)3L);
    }

    public static final void assertIndexIsValid(SerializedRowData $this, int index) {
        if (index < 0 || index >= $this.nFields()) {
            throw new AssertionError((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"index ", " should be >= 0 and < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToInteger((int)$this.nFields())})));
        }
    }

    private static final int readInt(SerializedRowData $this, int ordinal) {
        return ColumnEncoding$.MODULE$.readInt($this.baseObject(), $this.getFieldCursor(ordinal));
    }

    public static final long org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong(SerializedRowData $this, int ordinal) {
        return ColumnEncoding$.MODULE$.readLong($this.baseObject(), $this.getFieldCursor(ordinal));
    }

    private static final byte[] readBinary(SerializedRowData $this, int ordinal) {
        long offsetAndSize = SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        byte[] bytes = new byte[size];
        Platform.copyMemory((Object)$this.baseObject(), (long)($this.baseOffset() + (long)offset), (Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)size);
        return bytes;
    }

    public static final int calculateBitSetWidthInBytes(SerializedRowData $this, int numFields) {
        return UnsafeRow.calculateBitSetWidthInBytes((int)(numFields + ($this.skipBytes() << 3)));
    }

    public static final Object getBaseObject(SerializedRowData $this) {
        return $this.baseObject();
    }

    public static final long getBaseOffset(SerializedRowData $this) {
        return $this.baseOffset();
    }

    public static final int getSkipBytes(SerializedRowData $this) {
        return $this.skipBytes();
    }

    public static final int getSizeInBytes(SerializedRowData $this) {
        return $this.sizeInBytes();
    }

    public static final int numFields(SerializedRowData $this) {
        return $this.nFields();
    }

    public static void pointTo(SerializedRowData $this, Object baseObject, long baseOffset, int sizeInBytes) {
        Predef$.MODULE$.assert($this.nFields() >= 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SerializedRowData $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numColumns (", ") should >= 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.nFields())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.baseObject_$eq(baseObject);
        $this.baseOffset_$eq(baseOffset);
        $this.sizeInBytes_$eq(sizeInBytes);
    }

    public static final Object get(SerializedRowData $this, int ordinal, DataType dataType) {
        while (true) {
            DataType dataType2;
            block19: {
                Object object;
                block4: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block11: {
                                                    block10: {
                                                        block9: {
                                                            block8: {
                                                                block7: {
                                                                    block6: {
                                                                        block5: {
                                                                            block3: {
                                                                                if (!NullType$.MODULE$.equals(dataType2 = dataType)) break block3;
                                                                                object = null;
                                                                                break block4;
                                                                            }
                                                                            if (!$this.isNullAt(ordinal)) break block5;
                                                                            object = null;
                                                                            break block4;
                                                                        }
                                                                        boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : DateType$.MODULE$.equals(dataType2);
                                                                        if (!bl) break block6;
                                                                        object = BoxesRunTime.boxToInteger((int)$this.getInt(ordinal));
                                                                        break block4;
                                                                    }
                                                                    boolean bl = LongType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2);
                                                                    if (!bl) break block7;
                                                                    object = BoxesRunTime.boxToLong((long)$this.getLong(ordinal));
                                                                    break block4;
                                                                }
                                                                if (!StringType$.MODULE$.equals(dataType2)) break block8;
                                                                object = $this.getUTF8String(ordinal);
                                                                break block4;
                                                            }
                                                            if (!DoubleType$.MODULE$.equals(dataType2)) break block9;
                                                            object = BoxesRunTime.boxToDouble((double)$this.getDouble(ordinal));
                                                            break block4;
                                                        }
                                                        if (!(dataType2 instanceof DecimalType)) break block10;
                                                        DecimalType decimalType = (DecimalType)dataType2;
                                                        object = $this.getDecimal(ordinal, decimalType.precision(), decimalType.scale());
                                                        break block4;
                                                    }
                                                    if (!FloatType$.MODULE$.equals(dataType2)) break block11;
                                                    object = BoxesRunTime.boxToFloat((float)$this.getFloat(ordinal));
                                                    break block4;
                                                }
                                                if (!BooleanType$.MODULE$.equals(dataType2)) break block12;
                                                object = BoxesRunTime.boxToBoolean((boolean)$this.getBoolean(ordinal));
                                                break block4;
                                            }
                                            if (!ByteType$.MODULE$.equals(dataType2)) break block13;
                                            object = BoxesRunTime.boxToByte((byte)$this.getByte(ordinal));
                                            break block4;
                                        }
                                        if (!ShortType$.MODULE$.equals(dataType2)) break block14;
                                        object = BoxesRunTime.boxToShort((short)$this.getShort(ordinal));
                                        break block4;
                                    }
                                    if (!BinaryType$.MODULE$.equals(dataType2)) break block15;
                                    object = $this.getBinary(ordinal);
                                    break block4;
                                }
                                if (!CalendarIntervalType$.MODULE$.equals(dataType2)) break block16;
                                object = $this.getInterval(ordinal);
                                break block4;
                            }
                            if (!(dataType2 instanceof ArrayType)) break block17;
                            object = $this.getArray(ordinal);
                            break block4;
                        }
                        if (!(dataType2 instanceof MapType)) break block18;
                        object = $this.getMap(ordinal);
                        break block4;
                    }
                    if (!(dataType2 instanceof StructType)) break block19;
                    StructType structType = (StructType)dataType2;
                    object = $this.getStruct(ordinal, structType.size());
                }
                return object;
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.simpleString()})));
    }

    public static final boolean isNullAt(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return BitSetMethods.isSet((Object)$this.baseObject(), (long)$this.baseOffset(), (int)(ordinal + ($this.skipBytes() << 3)));
    }

    public static final boolean getBoolean(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return Platform.getBoolean((Object)$this.baseObject(), (long)$this.getFieldCursor(ordinal));
    }

    public static final byte getByte(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return Platform.getByte((Object)$this.baseObject(), (long)$this.getFieldCursor(ordinal));
    }

    public static final short getShort(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return ColumnEncoding$.MODULE$.readShort($this.baseObject(), $this.getFieldCursor(ordinal));
    }

    public static final int getInt(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return SerializedRowData$class.readInt($this, ordinal);
    }

    public static final long getLong(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal);
    }

    public static final float getFloat(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return ColumnEncoding$.MODULE$.readFloat($this.baseObject(), $this.getFieldCursor(ordinal));
    }

    public static final double getDouble(SerializedRowData $this, int ordinal) {
        $this.assertIndexIsValid(ordinal);
        return ColumnEncoding$.MODULE$.readDouble($this.baseObject(), $this.getFieldCursor(ordinal));
    }

    public static final Decimal getDecimal(SerializedRowData $this, int ordinal, int precision, int scale) {
        Decimal decimal;
        if ($this.isNullAt(ordinal)) {
            decimal = null;
        } else if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            decimal = Decimal$.MODULE$.createUnsafe(SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal), precision, scale);
        } else {
            byte[] bytes = SerializedRowData$class.readBinary($this, ordinal);
            BigInteger bigInteger = new BigInteger(bytes);
            BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
            decimal = Decimal$.MODULE$.apply(javaDecimal, precision, scale);
        }
        return decimal;
    }

    public static final UTF8String getUTF8String(SerializedRowData $this, int ordinal) {
        UTF8String uTF8String;
        if ($this.isNullAt(ordinal)) {
            uTF8String = null;
        } else {
            long offsetAndSize = SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal);
            int offset = (int)(offsetAndSize >> 32);
            int size = (int)offsetAndSize;
            uTF8String = UTF8String.fromAddress((Object)$this.baseObject(), (long)($this.baseOffset() + (long)offset), (int)size);
        }
        return uTF8String;
    }

    public static final byte[] getBinary(SerializedRowData $this, int ordinal) {
        return $this.isNullAt(ordinal) ? null : SerializedRowData$class.readBinary($this, ordinal);
    }

    public static final CalendarInterval getInterval(SerializedRowData $this, int ordinal) {
        CalendarInterval calendarInterval;
        if ($this.isNullAt(ordinal)) {
            calendarInterval = null;
        } else {
            long offsetAndSize = SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal);
            int offset = (int)(offsetAndSize >> 32);
            int months = (int)offsetAndSize;
            long micros = ColumnEncoding$.MODULE$.readLong($this.baseObject(), $this.baseOffset() + (long)offset);
            calendarInterval = new CalendarInterval(months, micros);
        }
        return calendarInterval;
    }

    public static final SerializedRow getStruct(SerializedRowData $this, int ordinal, int numFields) {
        SerializedRow serializedRow;
        if ($this.isNullAt(ordinal)) {
            serializedRow = null;
        } else {
            long offsetAndSize = SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal);
            int offset = (int)(offsetAndSize >> 32);
            int size = (int)offsetAndSize;
            SerializedRow row = new SerializedRow(0, numFields);
            row.pointTo($this.baseObject(), $this.baseOffset() + (long)offset, size);
            serializedRow = row;
        }
        return serializedRow;
    }

    public static final SerializedArray getArray(SerializedRowData $this, int ordinal) {
        SerializedArray serializedArray;
        if ($this.isNullAt(ordinal)) {
            serializedArray = null;
        } else {
            long offsetAndSize = SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal);
            int offset = (int)(offsetAndSize >> 32);
            int size = (int)offsetAndSize;
            SerializedArray array = new SerializedArray(SerializedArray$.MODULE$.$lessinit$greater$default$1());
            array.pointTo($this.baseObject(), $this.baseOffset() + (long)offset, size);
            serializedArray = array;
        }
        return serializedArray;
    }

    public static final SerializedMap getMap(SerializedRowData $this, int ordinal) {
        SerializedMap serializedMap;
        if ($this.isNullAt(ordinal)) {
            serializedMap = null;
        } else {
            long offsetAndSize = SerializedRowData$class.org$apache$spark$sql$catalyst$util$SerializedRowData$$readLong($this, ordinal);
            int offset = (int)(offsetAndSize >> 32);
            SerializedMap map = new SerializedMap();
            map.pointTo($this.baseObject(), $this.baseOffset() + (long)offset);
            serializedMap = map;
        }
        return serializedMap;
    }

    public static final boolean anyNull(SerializedRowData $this) {
        boolean bl;
        if ($this.skipBytes() == 0) {
            bl = BitSetMethods.anySet((Object)$this.baseObject(), (long)$this.baseOffset(), (long)($this.bitSetWidthInBytes() >>> 3));
        } else {
            long offset;
            long endSkip = $this.baseOffset() + (long)($this.skipBytes() + 7 >>> 3) << 3;
            long endOffset = offset + (long)$this.bitSetWidthInBytes();
            for (offset = $this.baseOffset() + (long)$this.skipBytes(); offset < endSkip; ++offset) {
                if (Platform.getByte((Object)$this.baseObject(), (long)offset) == 0) continue;
                return true;
            }
            while (offset < endOffset) {
                if (Platform.getLong((Object)$this.baseObject(), (long)offset) != 0L) {
                    return true;
                }
                offset += 8L;
            }
            bl = false;
        }
        return bl;
    }

    public static final int hashCode(SerializedRowData $this) {
        return Murmur3_x86_32.hashUnsafeWords((Object)$this.baseObject(), (long)$this.baseOffset(), (int)$this.sizeInBytes(), (int)42);
    }

    public static final boolean equals(SerializedRowData $this, Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof SerializedRowData) {
            SerializedRowData serializedRowData = (SerializedRowData)object;
            bl = $this.sizeInBytes() == serializedRowData.sizeInBytes() && ByteArrayMethods.arrayEquals((Object)$this.baseObject(), (long)$this.baseOffset(), (Object)serializedRowData.baseObject(), (long)serializedRowData.baseOffset(), (long)$this.sizeInBytes());
        } else {
            if (object instanceof InternalRow) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot compare SerializedRow to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{other.getClass().getName()})));
            }
            bl = false;
        }
        return bl;
    }

    public static final byte[] getBytes(SerializedRowData $this) {
        if ($this.baseOffset() == (long)Platform.BYTE_ARRAY_OFFSET) {
            byte[] byArray;
            Object object = $this.baseObject();
            if (object instanceof byte[] && (byArray = (byte[])object).length == $this.sizeInBytes()) {
                return byArray;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        byte[] bytes = new byte[$this.sizeInBytes()];
        Platform.copyMemory((Object)$this.baseObject(), (long)$this.baseOffset(), (Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)$this.sizeInBytes());
        return bytes;
    }

    public static final String toString(SerializedRowData $this) {
        StringBuilder sb = new StringBuilder("[");
        long baseOffset = $this.baseOffset();
        for (int i = 0; i < $this.sizeInBytes(); i += 8) {
            Object object = i != 0 ? sb.append(',') : BoxedUnit.UNIT;
            sb.append(Long.toHexString(Platform.getLong((Object)$this.baseObject(), (long)(baseOffset + (long)i))));
        }
        sb.append(']');
        return sb.toString();
    }

    public static final void writeExternal(SerializedRowData $this, ObjectOutput out) throws IOException {
        byte[] bytes = $this.getBytes();
        out.writeInt(bytes.length);
        out.writeInt($this.skipBytes());
        out.writeInt($this.nFields());
        out.write(bytes);
    }

    public static final void readExternal(SerializedRowData $this, ObjectInput in) throws IOException, ClassNotFoundException {
        $this.sizeInBytes_$eq(in.readInt());
        $this.skipBytes_$eq(in.readInt());
        $this.nFields_$eq(in.readInt());
        $this.bitSetWidthInBytes_$eq($this.calculateBitSetWidthInBytes($this.nFields()));
        $this.baseOffset_$eq(Platform.BYTE_ARRAY_OFFSET);
        byte[] bytes = new byte[$this.sizeInBytes()];
        in.readFully(bytes);
        $this.baseObject_$eq(bytes);
    }

    public static final void write(SerializedRowData $this, Kryo kryo, Output out) {
        byte[] bytes = $this.getBytes();
        out.writeInt(bytes.length);
        out.writeVarInt($this.skipBytes(), true);
        out.writeVarInt($this.nFields(), true);
        out.write(bytes);
    }

    public static final void read(SerializedRowData $this, Kryo kryo, Input in) {
        $this.sizeInBytes_$eq(in.readInt());
        $this.skipBytes_$eq(in.readVarInt(true));
        $this.nFields_$eq(in.readVarInt(true));
        $this.bitSetWidthInBytes_$eq($this.calculateBitSetWidthInBytes($this.nFields()));
        $this.baseOffset_$eq(Platform.BYTE_ARRAY_OFFSET);
        byte[] bytes = new byte[$this.sizeInBytes()];
        in.read(bytes);
        $this.baseObject_$eq(bytes);
    }

    public static void $init$(SerializedRowData $this) {
    }
}

