/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.collection;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import scala.Tuple2;

public class BoundedSortedSet<K, V extends Comparable<V>>
extends TreeSet<Tuple2<K, V>> {
    private final int bound;
    private final Map<K, V> map;
    private static final float tolerance = 0.0f;
    private final boolean isRelaxedBound;

    public BoundedSortedSet(int bound, boolean isRelaxedBound) {
        super(new Comparator<Tuple2<K, V>>(){

            @Override
            public int compare(Tuple2<K, V> o1, Tuple2<K, V> o2) {
                if (o1._1.equals(o2._1)) {
                    return 0;
                }
                if (((Comparable)o1._2).compareTo(o2._2) > 0) {
                    return -1;
                }
                return 1;
            }
        });
        this.bound = bound;
        this.map = new HashMap();
        this.isRelaxedBound = isRelaxedBound;
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    private void addBypassCheck(K key, V value) {
        this.map.put(key, value);
        super.add(new Tuple2(key, value));
    }

    @Override
    public boolean add(Tuple2<K, V> data) {
        Comparable prevCount = (Comparable)this.map.get(data._1);
        if (prevCount != null) {
            this.remove(new Tuple2(data._1, (Object)prevCount));
        }
        boolean added = false;
        super.add(data);
        if (this.size() > this.bound) {
            boolean remove = false;
            if (this.isRelaxedBound) {
                Iterator iter = this.descendingIterator();
                Tuple2 last = (Tuple2)iter.next();
                if (iter.hasNext()) {
                    Tuple2 last_1 = (Tuple2)iter.next();
                    if ((float)Math.abs((Long)last._2 - (Long)last_1._2) * 100.0f / (float)((Long)last_1._2).longValue() > 0.0f) {
                        remove = true;
                    }
                }
            } else {
                remove = true;
            }
            if (remove) {
                Tuple2 prev = (Tuple2)this.pollLast();
                if (!prev._1.equals(data._1)) {
                    this.map.put(data._1, data._2);
                    this.map.remove(prev._1);
                    added = true;
                } else if (prevCount != null) {
                    this.map.remove(data._1);
                }
            } else {
                this.map.put(data._1, data._2);
                added = true;
            }
        } else {
            this.map.put(data._1, data._2);
            added = true;
        }
        return added;
    }

    public V get(K key) {
        return (V)((Comparable)this.map.get(key));
    }

    public int getBound() {
        return this.bound;
    }

    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.bound);
        dos.writeBoolean(this.isRelaxedBound);
        dos.writeInt(this.map.size());
        ObjectOutputStream oos = null;
        boolean firstCall = true;
        boolean isString = false;
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            if (firstCall) {
                if (entry.getKey() instanceof String) {
                    isString = true;
                } else {
                    oos = new ObjectOutputStream(dos);
                }
                dos.writeBoolean(isString);
                firstCall = false;
            }
            if (isString) {
                dos.writeUTF((String)entry.getKey());
                dos.writeLong((Long)entry.getValue());
                continue;
            }
            oos.writeObject(entry.getKey());
            oos.writeLong((Long)entry.getValue());
        }
        if (oos != null) {
            oos.flush();
        }
    }

    public static <K, V extends Comparable<V>> BoundedSortedSet<K, V> deserialize(DataInputStream dis) throws Exception {
        int bound = dis.readInt();
        boolean relaxedBound = dis.readBoolean();
        BoundedSortedSet<K, V> bs = new BoundedSortedSet<K, V>(bound, relaxedBound);
        int mapSize = dis.readInt();
        if (mapSize > 0) {
            boolean isString = dis.readBoolean();
            ObjectInputStream ois = null;
            if (!isString) {
                ois = new ObjectInputStream(dis);
            }
            for (int i = 0; i < mapSize; ++i) {
                Long value;
                Object key;
                if (isString) {
                    key = dis.readUTF();
                    value = dis.readLong();
                    super.addBypassCheck(key, value);
                    continue;
                }
                key = ois.readObject();
                value = ois.readLong();
                super.addBypassCheck(key, value);
            }
        }
        return bs;
    }
}

