/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.columnar.DefaultSource;
import org.apache.spark.sql.execution.columnar.ExternalStore;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.execution.columnar.JDBCAppendableRelation;
import org.apache.spark.sql.execution.columnar.JDBCSourceAsStore;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.row.GemFireXDBaseDialect;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.ConnectionProperties;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001f\tA2i\u001c7v[:\f'OU3mCRLwN\u001c)s_ZLG-\u001a:\u000b\u0005\r!\u0011\u0001C2pYVlg.\u0019:\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001C\u0006\u000f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\"$D\u0001\u0019\u0015\tIb!A\u0004t_V\u00148-Z:\n\u0005mA\"AF*dQ\u0016l\u0017MU3mCRLwN\u001c)s_ZLG-\u001a:\u0011\u0005]i\u0012B\u0001\u0010\u0019\u0005e\u0019%/Z1uC\ndWMU3mCRLwN\u001c)s_ZLG-\u001a:\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"B\u0013\u0001\t\u00031\u0013AD2sK\u0006$XMU3mCRLwN\u001c\u000b\u0006O)\u0002T'\u0011\t\u0003G!J!!\u000b\u0002\u0003-)#%iQ!qa\u0016tG-\u00192mKJ+G.\u0019;j_:DQa\u000b\u0013A\u00021\n!b]9m\u0007>tG/\u001a=u!\tic&D\u0001\u0007\u0013\tycA\u0001\u0006T#2\u001buN\u001c;fqRDQ!\r\u0013A\u0002I\nA!\\8eKB\u0011QfM\u0005\u0003i\u0019\u0011\u0001bU1wK6{G-\u001a\u0005\u0006m\u0011\u0002\raN\u0001\b_B$\u0018n\u001c8t!\u0011A4H\u0010 \u000f\u0005EI\u0014B\u0001\u001e\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0004\u001b\u0006\u0004(B\u0001\u001e\u0013!\tAt(\u0003\u0002A{\t11\u000b\u001e:j]\u001eDQA\u0011\u0013A\u0002\r\u000baa]2iK6\f\u0007C\u0001#H\u001b\u0005)%B\u0001$\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tAUI\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\n\u0001\u0005B)#BaJ&M\u001b\")1&\u0013a\u0001Y!)a'\u0013a\u0001o!)!)\u0013a\u0001\u0007\")Q\u0005\u0001C!\u001fR)q\u0005U)S'\")1F\u0014a\u0001Y!)\u0011G\u0014a\u0001e!)aG\u0014a\u0001o!)AK\u0014a\u0001+\u0006!A-\u0019;b!\t1FM\u0004\u0002XE:\u0011\u0001,\u0019\b\u00033\u0002t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005us\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003G\u001a\tq\u0001]1dW\u0006<W-\u0003\u0002fM\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003G\u001aAQ\u0001\u001b\u0001\u0005\u0002%\f1bZ3u%\u0016d\u0017\r^5p]R\u0019!E[6\t\u000b-:\u0007\u0019\u0001\u0017\t\u000bY:\u0007\u0019A\u001c\t\u000b5\u0004A\u0011\u00018\u0002#\u001d,G/\u0012=uKJt\u0017\r\\*pkJ\u001cW\r\u0006\u0003peND\bCA\u0012q\u0013\t\t(AA\u0007FqR,'O\\1m'R|'/\u001a\u0005\u0006W1\u0004\r\u0001\f\u0005\u0006i2\u0004\r!^\u0001\u000fG>tg\u000e\u0015:pa\u0016\u0014H/[3t!\t9b/\u0003\u0002x1\t!2i\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKNDQ!\u001f7A\u0002i\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bCA\t|\u0013\ta(CA\u0002J]R\u0004")
public class ColumnarRelationProvider
implements SchemaRelationProvider,
CreatableRelationProvider {
    public JDBCAppendableRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, StructType schema) {
        HashMap parameters = new HashMap();
        parameters.$plus$plus$eq(options);
        String table = ExternalStoreUtils$.MODULE$.removeInternalProps((scala.collection.mutable.Map<String, String>)parameters);
        SparkContext sc = sqlContext.sparkContext();
        ConnectionProperties connectionProperties = ExternalStoreUtils$.MODULE$.validateAndGetAllProps((Option<SparkSession>)new Some((Object)sqlContext.sparkSession()), (scala.collection.mutable.Map<String, String>)parameters);
        int partitions = ExternalStoreUtils$.MODULE$.getAndSetTotalPartitions((Option<SparkContext>)new Some((Object)sc), (scala.collection.mutable.Map<String, String>)parameters, false, ExternalStoreUtils$.MODULE$.getAndSetTotalPartitions$default$4(), ExternalStoreUtils$.MODULE$.getAndSetTotalPartitions$default$5());
        ExternalStore externalStore = this.getExternalSource(sqlContext, connectionProperties, partitions);
        String tableName = SnappyStoreHiveCatalog$.MODULE$.processTableIdentifier(table, sqlContext.conf());
        boolean success = false;
        JDBCAppendableRelation relation = new JDBCAppendableRelation(tableName, this.getClass().getCanonicalName(), mode, schema, options, externalStore, sqlContext);
        try {
            relation.createTable(mode);
            SnappyStoreHiveCatalog catalog = ((SnappySession)sqlContext.sparkSession()).sessionCatalog();
            catalog.registerDataSourceTable(catalog.newQualifiedTableName(tableName), (Option<StructType>)new Some((Object)relation.schema()), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), DefaultSource.class.getCanonicalName(), options, relation);
            success = true;
            return relation;
        }
        finally {
            if (!success && !relation.tableExists()) {
                relation.destroy(true);
            }
        }
    }

    public JDBCAppendableRelation createRelation(SQLContext sqlContext, Map<String, String> options, StructType schema) {
        boolean allowExisting = options.get((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
            }
        });
        SaveMode mode = allowExisting ? SaveMode.Ignore : SaveMode.ErrorIfExists;
        ColumnarRelationProvider rel = this.getRelation(sqlContext, options);
        return rel.createRelation(sqlContext, mode, options, schema);
    }

    public JDBCAppendableRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, Dataset<Row> data) {
        ColumnarRelationProvider rel = this.getRelation(sqlContext, options);
        SnappyStoreHiveCatalog catalog = ((SnappySession)sqlContext.sparkSession()).sessionCatalog();
        JDBCAppendableRelation relation = rel.createRelation(sqlContext, mode, options, catalog.normalizeSchema(data.schema()));
        boolean success = false;
        try {
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            relation.insert(data, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
            success = true;
            return relation;
        }
        finally {
            if (!success && !relation.tableExists()) {
                SnappyStoreHiveCatalog catalog2 = ((SnappySession)sqlContext.sparkSession()).sessionCatalog();
                catalog2.unregisterDataSourceTable(catalog2.newQualifiedTableName(relation.table()), (Option<BaseRelation>)new Some((Object)relation));
                relation.destroy(true);
            }
        }
    }

    public ColumnarRelationProvider getRelation(SQLContext sqlContext, Map<String, String> options) {
        String url = (String)options.getOrElse((Object)"url", (Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final String apply() {
                return ExternalStoreUtils$.MODULE$.defaultStoreURL((Option<SparkContext>)new Some((Object)this.sqlContext$1.sparkContext()));
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        });
        JdbcDialect jdbcDialect = JdbcDialects$.MODULE$.get(url);
        Class clazz = jdbcDialect instanceof GemFireXDBaseDialect ? new DataSource(sqlContext.sparkSession(), org.apache.spark.sql.execution.columnar.impl.DefaultSource.class.getCanonicalName(), DataSource$.MODULE$.apply$default$3(), DataSource$.MODULE$.apply$default$4(), DataSource$.MODULE$.apply$default$5(), DataSource$.MODULE$.apply$default$6(), DataSource$.MODULE$.apply$default$7()).providingClass() : DefaultSource.class;
        Class clazz2 = clazz;
        return (ColumnarRelationProvider)clazz2.newInstance();
    }

    public ExternalStore getExternalSource(SQLContext sqlContext, ConnectionProperties connProperties, int numPartitions) {
        return new JDBCSourceAsStore(connProperties, numPartitions);
    }
}

