/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import com.gemstone.gemfire.internal.cache.ExternalTableMetaData;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import io.snappydata.Constant$;
import io.snappydata.Property$;
import io.snappydata.util.ServiceUtils$;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.ClusterMode;
import org.apache.spark.sql.ExternalClusterMode;
import org.apache.spark.sql.ExternalEmbeddedMode;
import org.apache.spark.sql.LocalMode;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SnappyContext$;
import org.apache.spark.sql.SnappyEmbeddedMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SplitClusterMode;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.execution.BufferedRowIterator;
import org.apache.spark.sql.execution.CodegenSupport;
import org.apache.spark.sql.execution.CodegenSupportOnExecutor;
import org.apache.spark.sql.execution.ConnectionPool$;
import org.apache.spark.sql.execution.columnar.ColumnType$;
import org.apache.spark.sql.execution.columnar.ConnectionType$;
import org.apache.spark.sql.execution.columnar.ExternalStore;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$$anonfun$pruneSchema$1$;
import org.apache.spark.sql.execution.columnar.impl.JDBCSourceAsColumnarStore;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.row.GemFireXDClientDialect$;
import org.apache.spark.sql.row.GemFireXDDialect$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.ConnectionProperties;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.JdbcExtendedDialect;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.store.CodeGeneration$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

public final class ExternalStoreUtils$
implements Logging {
    public static final ExternalStoreUtils$ MODULE$;
    private final String DEFAULT_TABLE_BUCKETS;
    private final String DEFAULT_SAMPLE_TABLE_BUCKETS;
    private final String DEFAULT_TABLE_BUCKETS_LOCAL_MODE;
    private final String DEFAULT_SAMPLE_TABLE_BUCKETS_LOCAL_MODE;
    private final String INDEX_TYPE;
    private final String INDEX_NAME;
    private final String DEPENDENT_RELATIONS;
    private final String COLUMN_BATCH_SIZE;
    private final String COLUMN_MAX_DELTA_ROWS;
    private final String COMPRESSION_CODEC;
    private final String RELATION_FOR_SAMPLE;
    private final String EXTERNAL_DATASOURCE;
    private final Some<Object> SOME_TRUE;
    private final Some<Object> SOME_FALSE;
    private final String PARTITION_BY;
    private final String REPLICATE;
    private final String BUCKETS;
    private transient Logger org$apache$spark$Logging$$log_;
    private transient int org$apache$spark$Logging$$levelFlags;

    static {
        new ExternalStoreUtils$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$Logging$$levelFlags() {
        return this.org$apache$spark$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public final String DEFAULT_TABLE_BUCKETS() {
        return "113";
    }

    public final String DEFAULT_SAMPLE_TABLE_BUCKETS() {
        return "79";
    }

    public final String DEFAULT_TABLE_BUCKETS_LOCAL_MODE() {
        return "19";
    }

    public final String DEFAULT_SAMPLE_TABLE_BUCKETS_LOCAL_MODE() {
        return "11";
    }

    public final String INDEX_TYPE() {
        return "INDEX_TYPE";
    }

    public final String INDEX_NAME() {
        return "INDEX_NAME";
    }

    public final String DEPENDENT_RELATIONS() {
        return "DEPENDENT_RELATIONS";
    }

    public final String COLUMN_BATCH_SIZE() {
        return "COLUMN_BATCH_SIZE";
    }

    public final String COLUMN_MAX_DELTA_ROWS() {
        return "COLUMN_MAX_DELTA_ROWS";
    }

    public final String COMPRESSION_CODEC() {
        return "COMPRESSION_CODEC";
    }

    public final String RELATION_FOR_SAMPLE() {
        return "RELATION_FOR_SAMPLE";
    }

    public final String EXTERNAL_DATASOURCE() {
        return "EXTERNAL_DATASOURCE";
    }

    public String lookupName(String tableName, String schema) {
        return tableName.indexOf(46) <= 0 ? new StringBuilder().append((Object)schema).append((Object)BoxesRunTime.boxToCharacter((char)'.')).append((Object)tableName).toString() : tableName;
    }

    private scala.collection.immutable.Map<String, String> addProperty(scala.collection.immutable.Map<String, String> props, String key, String string) {
        return props.contains((Object)key) ? props : props.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)string));
    }

    private String defaultMaxExternalPoolSize() {
        return String.valueOf(package$.MODULE$.max(64, Runtime.getRuntime().availableProcessors() * 4));
    }

    private String defaultMaxEmbeddedPoolSize() {
        return String.valueOf(package$.MODULE$.max(256, Runtime.getRuntime().availableProcessors() * 16));
    }

    public scala.collection.immutable.Map<String, String> getAllPoolProperties(String url, String driver, scala.collection.immutable.Map<String, String> poolProps, boolean hikariCP, boolean isEmbedded) {
        String defaultMaxPoolSize;
        scala.collection.immutable.Map<String, String> props = poolProps;
        if (driver != null && !driver.isEmpty()) {
            props = this.addProperty(props, "driverClassName", driver);
        }
        String string = defaultMaxPoolSize = isEmbedded ? this.defaultMaxEmbeddedPoolSize() : this.defaultMaxExternalPoolSize();
        if (hikariCP) {
            props = props.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcUrl"), (Object)url));
            props = this.addProperty(props, "maximumPoolSize", defaultMaxPoolSize);
            props = this.addProperty(props, "minimumIdle", "4");
        } else {
            props = props.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url));
            props = this.addProperty(props, "maxActive", defaultMaxPoolSize);
            props = this.addProperty(props, "maxIdle", defaultMaxPoolSize);
            props = this.addProperty(props, "initialSize", "4");
        }
        return props;
    }

    public String getDriver(String url, JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        String string = ((Object)((Object)GemFireXDDialect$.MODULE$)).equals(jdbcDialect) ? "io.snappydata.jdbc.EmbeddedDriver" : (((Object)((Object)GemFireXDClientDialect$.MODULE$)).equals(jdbcDialect) ? "io.snappydata.jdbc.ClientDriver" : Utils$.MODULE$.getDriverClassName(url));
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String removeInternalProps(scala.collection.mutable.Map<String, String> parameters) {
        void var3_3;
        String dbtableProp = JdbcExtendedUtils$.MODULE$.DBTABLE_PROPERTY();
        String table = (String)parameters.remove((Object)dbtableProp).getOrElse((Function0)new Serializable(dbtableProp){
            public static final long serialVersionUID = 0L;
            private final String dbtableProp$1;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option '", "' not specified"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbtableProp$1})));
            }
            {
                this.dbtableProp$1 = dbtableProp$1;
            }
        });
        parameters.remove((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY());
        parameters.remove((Object)JdbcExtendedUtils$.MODULE$.SCHEMA_PROPERTY());
        parameters.remove((Object)"serialization.format");
        return var3_3;
    }

    public scala.collection.immutable.Map<String, String> removeSamplingOptions(scala.collection.mutable.Map<String, String> parameters) {
        Seq optSequence = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"qcs", "fraction", "strataReservoirSize", "errorLimitColumn", "errorLimitPercent", "timeSeriesColumn", "timeInterval", "aqp.debug.byPassSampleOperator"}));
        HashMap optMap = new HashMap();
        optSequence.map((Function1)new Serializable(parameters, optMap){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map parameters$2;
            private final HashMap optMap$1;

            public final Object apply(String key) {
                Option option;
                block4: {
                    BoxedUnit boxedUnit;
                    block3: {
                        block2: {
                            Option value = this.parameters$2.remove((Object)key);
                            option = value;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String v = (String)some.x();
                            boxedUnit = this.optMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Utils$.MODULE$.toLowerCase(key)), (Object)v));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)option);
            }
            {
                this.parameters$2 = parameters$2;
                this.optMap$1 = optMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return optMap.toMap(Predef$.MODULE$.$conforms());
    }

    public String defaultStoreURL(Option<SparkContext> sparkContext) {
        Option<SparkContext> option;
        block6: {
            ClusterMode clusterMode;
            block11: {
                String string;
                block5: {
                    String string2;
                    block8: {
                        block10: {
                            block9: {
                                SparkContext sc;
                                block7: {
                                    block4: {
                                        option = sparkContext;
                                        if (!None$.MODULE$.equals(option)) break block4;
                                        string = new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_EMBEDDED_URL()).append((Object)";host-data=false;mcast-port=0").toString();
                                        break block5;
                                    }
                                    if (!(option instanceof Some)) break block6;
                                    Some some = (Some)option;
                                    sc = (SparkContext)some.x();
                                    clusterMode = SnappyContext$.MODULE$.getClusterMode(sc);
                                    if (!(clusterMode instanceof SnappyEmbeddedMode)) break block7;
                                    string2 = new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_EMBEDDED_URL()).append((Object)";host-data=false;mcast-port=0").toString();
                                    break block8;
                                }
                                if (!(clusterMode instanceof SplitClusterMode)) break block9;
                                string2 = new StringBuilder().append((Object)ServiceUtils$.MODULE$.getLocatorJDBCURL(sc)).append((Object)";route-query=false").toString();
                                break block8;
                            }
                            if (!(clusterMode instanceof ExternalEmbeddedMode)) break block10;
                            ExternalEmbeddedMode externalEmbeddedMode = (ExternalEmbeddedMode)clusterMode;
                            String url = externalEmbeddedMode.url();
                            string2 = new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_EMBEDDED_URL()).append((Object)";host-data=false;").append((Object)url).toString();
                            break block8;
                        }
                        if (!(clusterMode instanceof LocalMode)) break block11;
                        LocalMode localMode = (LocalMode)clusterMode;
                        String url = localMode.url();
                        string2 = new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_EMBEDDED_URL()).append((Object)BoxesRunTime.boxToCharacter((char)';')).append((Object)url).toString();
                    }
                    string = string2;
                }
                return string;
            }
            if (clusterMode instanceof ExternalClusterMode) {
                ExternalClusterMode externalClusterMode = (ExternalClusterMode)clusterMode;
                String url = externalClusterMode.url();
                throw new AnalysisException(new StringBuilder().append((Object)"Option 'url' not specified for cluster ").append((Object)url).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new MatchError((Object)clusterMode);
        }
        throw new MatchError(option);
    }

    public boolean isSplitOrLocalMode(SparkContext sparkContext) {
        ClusterMode clusterMode = SnappyContext$.MODULE$.getClusterMode(sparkContext);
        boolean bl = clusterMode instanceof SplitClusterMode ? true : clusterMode instanceof LocalMode;
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    public ConnectionProperties validateAndGetAllProps(Option<SparkSession> session, scala.collection.mutable.Map<String, String> parameters) {
        block8: {
            block11: {
                block13: {
                    block14: {
                        block12: {
                            block10: {
                                block9: {
                                    block6: {
                                        block7: {
                                            block5: {
                                                url = (String)parameters.remove((Object)"url").getOrElse((Function0)new Serializable(session){
                                                    public static final long serialVersionUID = 0L;
                                                    private final Option session$1;

                                                    public final String apply() {
                                                        return ExternalStoreUtils$.MODULE$.defaultStoreURL((Option<SparkContext>)this.session$1.map((Function1)new Serializable(this){
                                                            public static final long serialVersionUID = 0L;

                                                            public final SparkContext apply(SparkSession x$1) {
                                                                return x$1.sparkContext();
                                                            }
                                                        }));
                                                    }
                                                    {
                                                        this.session$1 = session$1;
                                                    }
                                                });
                                                dialect = JdbcDialects$.MODULE$.get(url);
                                                driver = (String)parameters.remove((Object)"driver").getOrElse((Function0)new Serializable(url, dialect){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String url$1;
                                                    private final JdbcDialect dialect$1;

                                                    public final String apply() {
                                                        return ExternalStoreUtils$.MODULE$.getDriver(this.url$1, this.dialect$1);
                                                    }
                                                    {
                                                        this.url$1 = url$1;
                                                        this.dialect$1 = dialect$1;
                                                    }
                                                });
                                                DriverRegistry$.MODULE$.register(driver);
                                                poolImpl = parameters.remove((Object)"poolimpl");
                                                poolProperties = parameters.remove((Object)"poolproperties");
                                                var9_8 = false;
                                                var10_9 = null;
                                                var11_10 = poolImpl.map((Function1)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply(String k) {
                                                        return Utils$.MODULE$.toLowerCase(k);
                                                    }
                                                });
                                                if (!(var11_10 instanceof Some)) break block5;
                                                var9_8 = true;
                                                var10_9 = (Some)var11_10;
                                                var12_11 = (String)var10_9.x();
                                                if (!"hikari".equals(var12_11)) break block5;
                                                var13_12 = true;
                                                break block6;
                                            }
                                            if (!var9_8 || !"tomcat".equals(var14_13 = (String)var10_9.x())) break block7;
                                            var13_12 = false;
                                            break block6;
                                        }
                                        if (var9_8) {
                                            p = (String)var10_9.x();
                                            throw new IllegalArgumentException(new StringBuilder().append((Object)"ExternalStoreUtils: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported pool implementation '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(supported values: tomcat, hikari)"})).s((Seq)Nil$.MODULE$)).toString());
                                        }
                                        if (!None$.MODULE$.equals(var11_10)) break block8;
                                        var13_12 = Constant$.MODULE$.DEFAULT_USE_HIKARICP();
                                    }
                                    hikariCP = var13_12;
                                    poolProps = (scala.collection.immutable.Map)poolProperties.map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final scala.collection.immutable.Map<String, String> apply(String p) {
                                            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])p.split(",")).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final Tuple2<String, String> apply(String s) {
                                                    int eqIndex = s.indexOf(61);
                                                    return eqIndex >= 0 ? new Tuple2((Object)s.substring(0, eqIndex).trim(), (Object)s.substring(eqIndex + 1).trim()) : new Tuple2((Object)s.trim(), (Object)"true");
                                                }
                                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final scala.collection.immutable.Map<String, Nothing$> apply() {
                                            return Predef$.MODULE$.Map().empty();
                                        }
                                    });
                                    var18_17 = session;
                                    if (!None$.MODULE$.equals(var18_17)) break block9;
                                    var19_18 = false;
                                    break block10;
                                }
                                if (!(var18_17 instanceof Some)) break block11;
                                var20_19 = (Some)var18_17;
                                ss = (SparkSession)var20_19.x();
                                var19_18 = Utils$.MODULE$.isLoner(ss.sparkContext());
                            }
                            isLoner = var19_18;
                            connProps = new Properties();
                            executorConnProps = new Properties();
                            parameters.foreach((Function1)new Serializable(connProps, executorConnProps){
                                public static final long serialVersionUID = 0L;
                                private final Properties connProps$1;
                                private final Properties executorConnProps$1;

                                public final Object apply(Tuple2<String, String> kv) {
                                    this.connProps$1.setProperty((String)kv._1(), (String)kv._2());
                                    return this.executorConnProps$1.setProperty((String)kv._1(), (String)kv._2());
                                }
                                {
                                    this.connProps$1 = connProps$1;
                                    this.executorConnProps$1 = executorConnProps$1;
                                }
                            });
                            connProps.remove("poolProperties");
                            executorConnProps.remove("poolProperties");
                            connProps.setProperty("driver", driver);
                            executorConnProps.setProperty("driver", driver);
                            var25_24 = dialect;
                            if (!GemFireXDDialect$.MODULE$.equals(var25_24)) break block12;
                            GemFireXDDialect$.MODULE$.addExtraDriverProperties(isLoner, connProps);
                            var26_25 = true;
                            break block13;
                        }
                        if (!GemFireXDClientDialect$.MODULE$.equals(var25_24)) ** GOTO lbl80
                        GemFireXDClientDialect$.MODULE$.addExtraDriverProperties(isLoner, connProps);
                        connProps.setProperty("route-query", "false");
                        executorConnProps.setProperty("route-query", "false");
                        var28_26 = parameters.get((Object)"COLUMN_BATCH_SIZE".toLowerCase());
                        if (!(var28_26 instanceof Some)) break block14;
                        var29_27 = (Some)var28_26;
                        s = (String)var29_27.x();
                        var31_29 = Integer.parseInt(s);
                        ** GOTO lbl73
                    }
                    if (None$.MODULE$.equals(var28_26)) {
                        var31_29 = BoxesRunTime.unboxToInt((Object)session.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(SparkSession session) {
                                return ExternalStoreUtils$.MODULE$.defaultColumnBatchSize(session);
                            }
                        }).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return BoxesRunTime.unboxToInt((Object)Property$.MODULE$.ColumnBatchSize().defaultValue().get());
                            }
                        }));
lbl73:
                        // 2 sources

                        batchSize = var31_29;
                        columnBatchSize = package$.MODULE$.max((batchSize << 2) / 3, 0x200000);
                        executorConnProps.setProperty("lob-chunk-size", Integer.toString(columnBatchSize));
                        var26_25 = false;
                    } else {
                        throw new MatchError((Object)var28_26);
lbl80:
                        // 1 sources

                        if (var25_24 instanceof JdbcExtendedDialect) {
                            var33_32 = (JdbcExtendedDialect)var25_24;
                            var33_32.addExtraDriverProperties(isLoner, connProps);
                            var26_25 = false;
                        } else {
                            var26_25 = false;
                        }
                    }
                }
                isEmbedded = var26_25;
                allPoolProps = this.getAllPoolProperties(url, driver, (scala.collection.immutable.Map<String, String>)poolProps, hikariCP, isEmbedded);
                return new ConnectionProperties(url, driver, dialect, allPoolProps, connProps, executorConnProps, hikariCP);
            }
            throw new MatchError(var18_17);
        }
        throw new MatchError((Object)var11_10);
    }

    public Connection getConnection(String id, ConnectionProperties connProperties, boolean forExecutor) {
        Utils$.MODULE$.registerDriver(connProperties.driver());
        Properties connProps = forExecutor ? connProperties.executorConnProps() : connProperties.connProps();
        return ConnectionPool$.MODULE$.getPoolConnection(id, connProperties.dialect(), connProperties.poolProps(), connProps, connProperties.hikariCP());
    }

    public Enumeration.Value getConnectionType(JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        Enumeration.Value value = ((Object)((Object)GemFireXDDialect$.MODULE$)).equals(jdbcDialect) ? ConnectionType$.MODULE$.Embedded() : (((Object)((Object)GemFireXDClientDialect$.MODULE$)).equals(jdbcDialect) ? ConnectionType$.MODULE$.Net() : ConnectionType$.MODULE$.Unknown());
        return value;
    }

    public int getJDBCType(JdbcDialect dialect, DataType dataType) {
        return BoxesRunTime.unboxToInt((Object)dialect.getJDBCType(dataType).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(JdbcType x$2) {
                return x$2.jdbcNullType();
            }
        }).getOrElse((Function0)new Serializable(dataType){
            public static final long serialVersionUID = 0L;
            private final DataType dataType$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                block15: {
                    int n;
                    block3: {
                        DataType dataType;
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block5: {
                                                                block4: {
                                                                    block2: {
                                                                        dataType = this.dataType$1;
                                                                        if (!IntegerType$.MODULE$.equals(dataType)) break block2;
                                                                        n = 4;
                                                                        break block3;
                                                                    }
                                                                    if (!LongType$.MODULE$.equals(dataType)) break block4;
                                                                    n = -5;
                                                                    break block3;
                                                                }
                                                                if (!DoubleType$.MODULE$.equals(dataType)) break block5;
                                                                n = 8;
                                                                break block3;
                                                            }
                                                            if (!FloatType$.MODULE$.equals(dataType)) break block6;
                                                            n = 7;
                                                            break block3;
                                                        }
                                                        if (!ShortType$.MODULE$.equals(dataType)) break block7;
                                                        n = 4;
                                                        break block3;
                                                    }
                                                    if (!ByteType$.MODULE$.equals(dataType)) break block8;
                                                    n = 4;
                                                    break block3;
                                                }
                                                if (!BooleanType$.MODULE$.equals(dataType)) break block9;
                                                n = -7;
                                                break block3;
                                            }
                                            if (!StringType$.MODULE$.equals(dataType)) break block10;
                                            n = 2005;
                                            break block3;
                                        }
                                        if (!BinaryType$.MODULE$.equals(dataType)) break block11;
                                        n = 2004;
                                        break block3;
                                    }
                                    if (!TimestampType$.MODULE$.equals(dataType)) break block12;
                                    n = 93;
                                    break block3;
                                }
                                if (!DateType$.MODULE$.equals(dataType)) break block13;
                                n = 91;
                                break block3;
                            }
                            if (!(dataType instanceof DecimalType)) break block14;
                            n = 3;
                            break block3;
                        }
                        if (!NullType$.MODULE$.equals(dataType)) break block15;
                        n = 0;
                    }
                    return n;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't translate to JDBC value for type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataType$1})));
            }
            {
                this.dataType$1 = dataType$1;
            }
        }));
    }

    public boolean unhandledFilter(Filter f) {
        Filter filter = f;
        boolean bl = filter instanceof EqualTo ? false : (filter instanceof LessThan ? false : (filter instanceof GreaterThan ? false : (filter instanceof LessThanOrEqual ? false : !(filter instanceof GreaterThanOrEqual))));
        return bl;
    }

    public Some<Object> SOME_TRUE() {
        return this.SOME_TRUE;
    }

    public Some<Object> SOME_FALSE() {
        return this.SOME_FALSE;
    }

    private Option<Object> checkIndexedColumn(String col, Set<String> indexedCols) {
        return indexedCols.contains((Object)col) ? this.SOME_TRUE() : None$.MODULE$;
    }

    public Option<Object> handledFilter(Filter f, Set<String> indexedCols) {
        Option<Object> option;
        block11: {
            Filter filter;
            while (true) {
                if ((filter = f) instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)filter;
                    String col = equalTo.attribute();
                    option = this.checkIndexedColumn(col, indexedCols);
                    break block11;
                }
                if (filter instanceof LessThan) {
                    LessThan lessThan = (LessThan)filter;
                    String col = lessThan.attribute();
                    option = this.checkIndexedColumn(col, indexedCols);
                    break block11;
                }
                if (filter instanceof GreaterThan) {
                    GreaterThan greaterThan = (GreaterThan)filter;
                    String col = greaterThan.attribute();
                    option = this.checkIndexedColumn(col, indexedCols);
                    break block11;
                }
                if (filter instanceof LessThanOrEqual) {
                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
                    String col = lessThanOrEqual.attribute();
                    option = this.checkIndexedColumn(col, indexedCols);
                    break block11;
                }
                if (filter instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
                    String col = greaterThanOrEqual.attribute();
                    option = this.checkIndexedColumn(col, indexedCols);
                    break block11;
                }
                if (filter instanceof StringStartsWith) {
                    StringStartsWith stringStartsWith = (StringStartsWith)filter;
                    String col = stringStartsWith.attribute();
                    option = this.checkIndexedColumn(col, indexedCols);
                    break block11;
                }
                if (filter instanceof In) {
                    In in = (In)filter;
                    String col = in.attribute();
                    option = this.checkIndexedColumn(col, indexedCols);
                    break block11;
                }
                if (!(filter instanceof And)) break;
                And and = (And)filter;
                Filter left = and.left();
                Filter right = and.right();
                Option<Object> v = this.handledFilter(left, indexedCols);
                if (v != None$.MODULE$) {
                    option = v;
                    break block11;
                }
                f = right;
            }
            if (filter instanceof Or) {
                Or or = (Or)filter;
                Filter left = or.left();
                Filter right = or.right();
                option = this.handledFilter(left, indexedCols) == this.SOME_TRUE() && this.handledFilter(right, indexedCols) == this.SOME_TRUE() ? this.SOME_TRUE() : this.SOME_FALSE();
            } else {
                option = this.SOME_FALSE();
            }
        }
        return option;
    }

    public boolean unhandledFilter(Filter f, Set<String> indexedCols) {
        return this.handledFilter(f, indexedCols) != this.SOME_TRUE();
    }

    public StructType pruneSchema(scala.collection.immutable.Map<String, StructField> fieldMap, String[] columns2) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])columns2).map((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map fieldMap$1;

            public final StructField apply(String col) {
                return (StructField)this.fieldMap$1.getOrElse((Object)col, (Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.pruneSchema.1 $outer;
                    public final String col$1;

                    public final StructField apply() {
                        return (StructField)this.$outer.fieldMap$1.getOrElse((Object)this.col$1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$pruneSchema$1$$anonfun$apply$3 $outer;

                            public final Nothing$ apply() {
                                throw new AnalysisException(new StringBuilder().append((Object)"Cannot resolve ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"column name \"", "\" among (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.col$1, this.$outer.org$apache$spark$sql$execution$columnar$ExternalStoreUtils$$anonfun$$anonfun$$$outer().fieldMap$1.keys().mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.pruneSchema.1 org$apache$spark$sql$execution$columnar$ExternalStoreUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                });
            }
            {
                this.fieldMap$1 = fieldMap$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Tuple2<Object, StructField>> columnIndicesAndDataTypes(StructType requestedSchema, StructType schema) {
        Seq seq;
        if (requestedSchema.isEmpty()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, StructField> apply(Tuple2<StructField, Object> f) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)f._2$mcI$sp())), f._1());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).minBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, StructField> f) {
                    return ColumnType$.MODULE$.apply(((StructField)f._2()).dataType()).defaultSize();
                }
            }, (Ordering)Ordering.Int$.MODULE$);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            int narrowestOrdinal = tuple22._1$mcI$sp();
            StructField narrowestField = (StructField)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)narrowestOrdinal), (Object)narrowestField);
            int narrowestOrdinal2 = tuple23._1$mcI$sp();
            StructField narrowestField2 = (StructField)tuple23._2();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)narrowestOrdinal2)), (Object)narrowestField2)}));
            return seq;
        } else {
            seq = (Seq)requestedSchema.map((Function1)new Serializable(schema){
                public static final long serialVersionUID = 0L;
                private final StructType schema$1;

                public final Tuple2<Object, StructField> apply(StructField a) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.schema$1.fieldIndex(Utils$.MODULE$.fieldName(a)))), (Object)a);
                }
                {
                    this.schema$1 = schema$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public void setStatementParameters(PreparedStatement stmt, ArrayBuffer<Object> row) {
        int len = row.length();
        for (int col = 1; col <= len; ++col) {
            BoxedUnit boxedUnit;
            Object colVal = row.apply(col - 1);
            if (colVal == null) {
                stmt.setNull(col, 0);
                continue;
            }
            Object object = colVal;
            if (object instanceof String) {
                String string = (String)object;
                stmt.setString(col, string);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                stmt.setInt(col, n);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                stmt.setLong(col, l);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                stmt.setDouble(col, d);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                stmt.setFloat(col, f);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                stmt.setInt(col, s);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                stmt.setInt(col, by);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                stmt.setBoolean(col, bl);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                stmt.setBytes(col, byArray);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                stmt.setTimestamp(col, timestamp);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                stmt.setDate(col, date);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Time) {
                Time time = (Time)object;
                stmt.setTime(col, time);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Decimal) {
                Decimal decimal = (Decimal)object;
                stmt.setBigDecimal(col, decimal.toJavaBigDecimal());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                stmt.setBigDecimal(col, bigDecimal);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            stmt.setObject(col, colVal);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final String PARTITION_BY() {
        return "PARTITION_BY";
    }

    public final String REPLICATE() {
        return "REPLICATE";
    }

    public final String BUCKETS() {
        return "BUCKETS";
    }

    public int getAndSetTotalPartitions(Map<String, String> parameters, boolean forManagedTable) {
        return this.getAndSetTotalPartitions((Option<SparkContext>)None$.MODULE$, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(parameters).asScala()), forManagedTable, true, false);
    }

    public int getAndSetTotalPartitions(Option<SparkContext> sparkContext, scala.collection.mutable.Map<String, String> parameters, boolean forManagedTable, boolean forColumnTable, boolean forSampleTable) {
        return new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"BUCKETS", (Function0)new Serializable(sparkContext, parameters, forManagedTable, forColumnTable, forSampleTable){
            public static final long serialVersionUID = 0L;
            private final Option sparkContext$1;
            private final scala.collection.mutable.Map parameters$1;
            private final boolean forManagedTable$1;
            private final boolean forColumnTable$1;
            private final boolean forSampleTable$1;

            /*
             * WARNING - void declaration
             */
            public final String apply() {
                Option option;
                block5: {
                    void var1_7;
                    String string;
                    block4: {
                        block3: {
                            option = this.sparkContext$1;
                            if (!(option instanceof Some)) break block3;
                            Some some = (Some)option;
                            SparkContext sc = (SparkContext)some.x();
                            ClusterMode clusterMode = SnappyContext$.MODULE$.getClusterMode(sc);
                            String string2 = clusterMode instanceof LocalMode ? (this.forSampleTable$1 ? "11" : "19") : (this.forSampleTable$1 ? "79" : "113");
                            string = string2;
                            break block4;
                        }
                        if (!None$.MODULE$.equals(option)) break block5;
                        string = "113";
                    }
                    String partitions = string;
                    Object object = this.forManagedTable$1 ? (this.forColumnTable$1 ? this.parameters$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BUCKETS"), (Object)partitions)) : (this.parameters$1.contains((Object)"PARTITION_BY") && !this.parameters$1.contains((Object)"REPLICATE") ? this.parameters$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BUCKETS"), (Object)partitions)) : BoxedUnit.UNIT)) : BoxedUnit.UNIT;
                    return var1_7;
                }
                throw new MatchError((Object)option);
            }
            {
                this.sparkContext$1 = sparkContext$1;
                this.parameters$1 = parameters$1;
                this.forManagedTable$1 = forManagedTable$1;
                this.forColumnTable$1 = forColumnTable$1;
                this.forSampleTable$1 = forSampleTable$1;
            }
        }))).toInt();
    }

    public boolean getAndSetTotalPartitions$default$4() {
        return true;
    }

    public boolean getAndSetTotalPartitions$default$5() {
        return false;
    }

    public void removeCachedObjects(SQLContext sqlContext, String table, boolean registerDestroy) {
        Utils$.MODULE$.mapExecutors(sqlContext, this.removeCachedObjects(table), ClassTag$.MODULE$.Unit()).count();
        this.removeCachedObjects(table).apply();
        if (registerDestroy) {
            SnappyStoreHiveCatalog$.MODULE$.registerRelationDestroy();
        }
    }

    public Function0<Iterator<BoxedUnit>> removeCachedObjects(String table) {
        return new Serializable(table){
            public static final long serialVersionUID = 0L;
            private final String table$1;

            public final Iterator<Nothing$> apply() {
                ConnectionPool$.MODULE$.removePoolReference(this.table$1);
                CodeGeneration$.MODULE$.removeCache(this.table$1);
                return scala.package$.MODULE$.Iterator().empty();
            }
            {
                this.table$1 = table$1;
            }
        };
    }

    public boolean removeCachedObjects$default$3() {
        return false;
    }

    public Tuple2<CodegenContext, CodeAndComment> codeGenOnExecutor(CodegenSupport plan, CodegenSupportOnExecutor child) {
        CodegenContext ctx = new CodegenContext();
        String code = child.produceOnExecutor(ctx, plan);
        String source = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      public Object generate(Object[] references) {\n        return new GeneratedIterator(references);\n      }\n\n      ", "\n      final class GeneratedIterator extends ", " {\n\n        private Object[] references;\n        ", "\n\n        public GeneratedIterator(Object[] references) {\n          this.references = references;\n        }\n\n        public void init(int index, scala.collection.Iterator inputs[]) {\n          partitionIndex = index;\n          ", "\n        }\n\n        ", "\n\n        protected void processNext() throws java.io.IOException {\n          ", "\n        }\n      }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.registerComment((Function0)new Serializable(child){
            public static final long serialVersionUID = 0L;
            private final CodegenSupportOnExecutor child$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Codegend pipeline for\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TreeNode)this.child$1).treeString().trim()}));
            }
            {
                this.child$1 = child$1;
            }
        }), BufferedRowIterator.class.getName(), ctx.declareMutableStates(), ctx.initMutableStates(), ctx.declareAddedFunctions(), code.trim()})).trim();
        CodeAndComment cleanedSource = CodeFormatter$.MODULE$.stripOverlappingComments(new CodeAndComment(CodeFormatter$.MODULE$.stripExtraNewLines(source), ctx.getPlaceHolderToComments()));
        this.logDebug((Function0<String>)new Serializable(cleanedSource){
            public static final long serialVersionUID = 0L;
            private final CodeAndComment cleanedSource$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeFormatter$.MODULE$.format(this.cleanedSource$1)}));
            }
            {
                this.cleanedSource$1 = cleanedSource$1;
            }
        });
        return new Tuple2((Object)ctx, (Object)cleanedSource);
    }

    public ExternalStore getExternalStoreOnExecutor(Map<String, String> parameters, int partitions, String tableName, StructType schema) {
        ConnectionProperties connProperties = this.validateAndGetAllProps((Option<SparkSession>)None$.MODULE$, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(parameters).asScala()));
        return new JDBCSourceAsColumnarStore(connProperties, partitions, tableName, schema);
    }

    public StructType convertSchemaMap(Map<String, String> tableProps) {
        Option jsonString = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(tableProps).asScala()).get((Object)SnappyStoreHiveCatalog$.MODULE$.HIVE_SCHEMA_NUMPARTS()).map((Function1)new Serializable(tableProps){
            public static final long serialVersionUID = 0L;
            public final Map tableProps$1;

            public final String apply(String numParts) {
                return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(numParts)).toInt()).map((Function1)new Serializable(this, numParts){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.13 $outer;
                    private final String numParts$1;

                    public final String apply(int index) {
                        String partProp = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnappyStoreHiveCatalog$.MODULE$.HIVE_SCHEMA_PART(), BoxesRunTime.boxToInteger((int)index)}));
                        Option option = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.$outer.tableProps$1).asScala()).get((Object)partProp);
                        if (option instanceof Some) {
                            String part;
                            Some some = (Some)option;
                            String string = part = (String)some.x();
                            return string;
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw new AnalysisException(new StringBuilder().append((Object)"Could not read schema from metastore because it is corrupted (missing ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part ", " of the schema, ", " parts expected)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), this.numParts$1}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numParts$1 = numParts$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).mkString();
            }
            {
                this.tableProps$1 = tableProps$1;
            }
        });
        return StructType$.MODULE$.fromString((String)jsonString.get());
    }

    public ExternalTableMetaData getExternalTableMetaData(String schema, String table) {
        Option container = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Misc.getMemStore().getAllContainers()).asScala()).find((Function1)new Serializable(schema, table){
            public static final long serialVersionUID = 0L;
            private final String schema$2;
            private final String table$2;

            public final boolean apply(GemFireContainer c) {
                return c.getTableName().equalsIgnoreCase(this.table$2) && c.getSchemaName().equalsIgnoreCase(this.schema$2);
            }
            {
                this.schema$2 = schema$2;
                this.table$2 = table$2;
            }
        });
        Option option = container;
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", ".", " not found in containers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema, table})));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            GemFireContainer c = (GemFireContainer)some.x();
            ExternalTableMetaData externalTableMetaData = c.fetchHiveMetaData(false);
            return externalTableMetaData;
        }
        throw new MatchError((Object)option);
    }

    public int defaultColumnBatchSize(SparkSession session) {
        return BoxesRunTime.unboxToInt((Object)Property$.MODULE$.ColumnBatchSize().get(session.sessionState().conf()));
    }

    public int defaultColumnMaxDeltaRows(SparkSession session) {
        return BoxesRunTime.unboxToInt((Object)Property$.MODULE$.ColumnMaxDeltaRows().get(session.sessionState().conf()));
    }

    public String defaultCompressionCodec(SparkSession session) {
        return Property$.MODULE$.CompressionCodec().get(session.sessionState().conf());
    }

    private ExternalStoreUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.SOME_TRUE = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.SOME_FALSE = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }
}

