/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.encoding;

import io.snappydata.util.StringUtils$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.execution.columnar.encoding.ColumnAllocator;
import org.apache.spark.sql.execution.columnar.encoding.ColumnData;
import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoder;
import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoding$;
import org.apache.spark.sql.execution.columnar.encoding.HeapAllocator$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Double$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class ColumnEncoder$class {
    public static long sizeInBytes(ColumnEncoder $this, long cursor) {
        return cursor - $this.columnData().baseOffset();
    }

    public static int defaultSize(ColumnEncoder $this, DataType dataType) {
        DataType dataType2 = dataType;
        int n = CalendarIntervalType$.MODULE$.equals(dataType2) ? 12 : dataType.defaultSize();
        return n;
    }

    public static final long initialize(ColumnEncoder $this, StructField field, int initSize, boolean withHeader) {
        return $this.initialize(field, initSize, withHeader, HeapAllocator$.MODULE$);
    }

    public static void initializeLimits(ColumnEncoder $this) {
        if ($this.forComplexType()) {
            $this._lowerLong_$eq(Long.MIN_VALUE);
            $this._upperLong_$eq(Long.MAX_VALUE);
            $this._lowerDouble_$eq(Double$.MODULE$.MinValue());
            $this._upperDouble_$eq(Double.MAX_VALUE);
        } else {
            $this._lowerLong_$eq(Long.MAX_VALUE);
            $this._upperLong_$eq(Long.MIN_VALUE);
            $this._lowerDouble_$eq(Double.MAX_VALUE);
            $this._upperDouble_$eq(Double$.MODULE$.MinValue());
        }
        $this._lowerStr_$eq(null);
        $this._upperStr_$eq(null);
        $this._lowerDecimal_$eq(null);
        $this._upperDecimal_$eq(null);
    }

    public static long initialize(ColumnEncoder $this, StructField field, int initSize, boolean withHeader, ColumnAllocator allocator) {
        long l;
        $this.allocator_$eq(allocator);
        DataType dataType = Utils$.MODULE$.getSQLDataType(field.dataType());
        int defSize = $this.defaultSize(dataType);
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof ArrayType ? true : (dataType2 instanceof MapType ? true : dataType2 instanceof StructType);
        boolean bl2 = bl;
        $this.forComplexType_$eq(bl2);
        if (withHeader) {
            $this.initializeLimits();
        }
        int numNullWords = $this.initializeNulls(initSize);
        if (withHeader) {
            $this.initializeLimits();
        } else if (numNullWords != 0) {
            Predef$.MODULE$.assert(false, (Function0)new Serializable($this, numNullWords){
                public static final long serialVersionUID = 0L;
                private final int numNullWords$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected nulls=", " for withHeader=false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numNullWords$1)}));
                }
                {
                    this.numNullWords$1 = numNullWords$1;
                }
            });
        }
        if ($this.reuseColumnData() == null) {
            long initByteSize = (long)defSize * (long)initSize;
            if (withHeader) {
                initByteSize += 8L;
            }
            $this.columnData_$eq(allocator.allocate(initByteSize));
            $this.columnBytes_$eq($this.columnData().bytes());
            $this.columnEndPosition_$eq($this.columnData().endPosition());
        } else {
            DataType dataType3 = dataType;
            boolean bl3 = BooleanType$.MODULE$.equals(dataType3) ? true : (ByteType$.MODULE$.equals(dataType3) ? true : (ShortType$.MODULE$.equals(dataType3) ? true : (IntegerType$.MODULE$.equals(dataType3) ? true : (LongType$.MODULE$.equals(dataType3) ? true : (DateType$.MODULE$.equals(dataType3) ? true : (TimestampType$.MODULE$.equals(dataType3) ? true : (FloatType$.MODULE$.equals(dataType3) ? true : DoubleType$.MODULE$.equals(dataType3))))))));
            if (bl3 && (long)$this.reuseUsedSize() != $this.reuseColumnData().sizeInBytes()) {
                $this.columnData_$eq(allocator.allocate($this.reuseUsedSize()));
                $this.columnBytes_$eq($this.columnData().bytes());
                $this.columnEndPosition_$eq($this.columnData().endPosition());
                allocator.release($this.reuseColumnData());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.columnData_$eq($this.reuseColumnData());
                $this.columnBytes_$eq($this.reuseColumnData().bytes());
                $this.columnEndPosition_$eq($this.reuseColumnData().endPosition());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            $this.reuseColumnData_$eq(null);
            $this.reuseUsedSize_$eq(0);
        }
        if (withHeader) {
            long cursor = $this.columnData().baseOffset();
            ColumnEncoding$.MODULE$.writeInt($this.columnBytes(), cursor, $this.typeId());
            ColumnEncoding$.MODULE$.writeInt($this.columnBytes(), cursor += 4L, numNullWords);
            l = cursor + 4L + ((long)numNullWords << (int)3L);
        } else {
            l = $this.columnData().baseOffset();
        }
        return l;
    }

    public static final long baseOffset(ColumnEncoder $this) {
        return $this.columnData().baseOffset();
    }

    public static final long offset(ColumnEncoder $this, long cursor) {
        return cursor - $this.columnData().baseOffset();
    }

    public static final Object buffer(ColumnEncoder $this) {
        return $this.columnBytes();
    }

    public static final boolean isOffHeap(ColumnEncoder $this) {
        return $this.allocator().isOffHeap();
    }

    public static final long expand(ColumnEncoder $this, long cursor, long required) {
        long numWritten = cursor - $this.columnData().baseOffset();
        $this.columnData_$eq($this.allocator().expand($this.columnData(), cursor, required));
        $this.columnBytes_$eq($this.columnData().bytes());
        $this.columnEndPosition_$eq($this.columnData().endPosition());
        return $this.columnData().baseOffset() + numWritten;
    }

    public static final long ensureCapacity(ColumnEncoder $this, long cursor, long required) {
        return cursor + required <= $this.columnEndPosition() ? cursor : $this.expand(cursor, required);
    }

    public static final long lowerLong(ColumnEncoder $this) {
        return $this._lowerLong();
    }

    public static final long upperLong(ColumnEncoder $this) {
        return $this._upperLong();
    }

    public static final double lowerDouble(ColumnEncoder $this) {
        return $this._lowerDouble();
    }

    public static final double upperDouble(ColumnEncoder $this) {
        return $this._upperDouble();
    }

    public static final Decimal lowerDecimal(ColumnEncoder $this) {
        return $this._lowerDecimal();
    }

    public static final Decimal upperDecimal(ColumnEncoder $this) {
        return $this._upperDecimal();
    }

    public static final UTF8String lowerString(ColumnEncoder $this) {
        return $this._lowerStr();
    }

    public static final UTF8String upperString(ColumnEncoder $this) {
        return $this._upperStr();
    }

    public static final void updateLongStats(ColumnEncoder $this, long value) {
        long lower = $this._lowerLong();
        if (value < lower) {
            $this._lowerLong_$eq(value);
            if (lower == Long.MAX_VALUE) {
                $this._upperLong_$eq(value);
            }
        } else if (value > $this._upperLong()) {
            $this._upperLong_$eq(value);
        }
    }

    public static final void updateDoubleStats(ColumnEncoder $this, double value) {
        double lower = $this._lowerDouble();
        if (value < lower) {
            if (lower == Double.MAX_VALUE) {
                $this._upperDouble_$eq(value);
            }
            $this._lowerDouble_$eq(value);
        } else if (value > $this._upperDouble()) {
            $this._upperDouble_$eq(value);
        }
    }

    public static final void updateStringStats(ColumnEncoder $this, UTF8String value) {
        if (value != null) {
            UTF8String lower = $this._lowerStr();
            if (lower == null) {
                if (!$this.forComplexType()) {
                    $this._lowerStr_$eq(value);
                    $this._upperStr_$eq(value);
                }
            } else if (value.compare(lower) < 0) {
                $this._lowerStr_$eq(value);
            } else if (value.compare($this._upperStr()) > 0) {
                $this._upperStr_$eq(value);
            }
        }
    }

    public static final void updateStringStatsClone(ColumnEncoder $this, UTF8String value) {
        if (value != null) {
            UTF8String lower = $this._lowerStr();
            if (lower == null) {
                if (!$this.forComplexType()) {
                    UTF8String valueClone = StringUtils$.MODULE$.cloneIfRequired(value);
                    $this._lowerStr_$eq(valueClone);
                    $this._upperStr_$eq(valueClone);
                }
            } else if (value.compare(lower) < 0) {
                $this._lowerStr_$eq(StringUtils$.MODULE$.cloneIfRequired(value));
            } else if (value.compare($this._upperStr()) > 0) {
                $this._upperStr_$eq(StringUtils$.MODULE$.cloneIfRequired(value));
            }
        }
    }

    public static final void updateDecimalStats(ColumnEncoder $this, Decimal value) {
        if (value != null) {
            Decimal lower = $this._lowerDecimal();
            if (lower == null) {
                if (!$this.forComplexType()) {
                    $this._lowerDecimal_$eq(value);
                    $this._upperDecimal_$eq(value);
                }
            } else if (value.compare(lower) < 0) {
                $this._lowerDecimal_$eq(value);
            } else if (value.compare($this._upperDecimal()) > 0) {
                $this._upperDecimal_$eq(value);
            }
        }
    }

    public static long writeBoolean(ColumnEncoder $this, long cursor, boolean value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeBoolean for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeByte(ColumnEncoder $this, long cursor, byte value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeByte for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeShort(ColumnEncoder $this, long cursor, short value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeShort for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeInt(ColumnEncoder $this, long cursor, int value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeInt for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeLong(ColumnEncoder $this, long cursor, long value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeLong for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeFloat(ColumnEncoder $this, long cursor, float value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeFloat for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeDouble(ColumnEncoder $this, long cursor, double value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeDouble for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeLongDecimal(ColumnEncoder $this, long cursor, Decimal value, int ordinal, int precision, int scale) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeLongDecimal for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeDecimal(ColumnEncoder $this, long cursor, Decimal value, int ordinal, int precision, int scale) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeDecimal for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeDate(ColumnEncoder $this, long cursor, int value) {
        return $this.writeInt(cursor, value);
    }

    public static long writeTimestamp(ColumnEncoder $this, long cursor, long value) {
        return $this.writeLong(cursor, value);
    }

    public static long writeInterval(ColumnEncoder $this, long cursor, CalendarInterval value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeInterval for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeUTF8String(ColumnEncoder $this, long cursor, UTF8String value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeUTF8String for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeBinary(ColumnEncoder $this, long cursor, byte[] value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeBinary for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeBooleanUnchecked(ColumnEncoder $this, long cursor, boolean value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeBooleanUnchecked for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeByteUnchecked(ColumnEncoder $this, long cursor, byte value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeByteUnchecked for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeShortUnchecked(ColumnEncoder $this, long cursor, short value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeShortUnchecked for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeIntUnchecked(ColumnEncoder $this, long cursor, int value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeIntUnchecked for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeLongUnchecked(ColumnEncoder $this, long cursor, long value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeLongUnchecked for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeFloatUnchecked(ColumnEncoder $this, long cursor, float value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeFloatUnchecked for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeDoubleUnchecked(ColumnEncoder $this, long cursor, double value) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeDoubleUnchecked for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static long writeUnsafeData(ColumnEncoder $this, long cursor, Object baseObject, long baseOffset, int numBytes) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeUnsafeData for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()})));
    }

    public static final void setOffsetAndSize(ColumnEncoder $this, long cursor, long fieldCursor, long baseOffset, int size) {
        long relativeOffset = cursor - $this.columnData().baseOffset() - baseOffset;
        long offsetAndSize = relativeOffset << (int)32L | (long)size;
        Platform.putLong((Object)$this.columnBytes(), (long)fieldCursor, (long)offsetAndSize);
    }

    public static final long getBaseTypeOffset(ColumnEncoder $this) {
        return $this.baseTypeOffset();
    }

    public static final long getBaseDataOffset(ColumnEncoder $this) {
        return $this.baseDataOffset();
    }

    public static final long initializeComplexType(ColumnEncoder $this, long cursor, int numElements, int skipBytes, boolean writeNumElements) {
        long position = cursor;
        int numNullBytes = UnsafeRow.calculateBitSetWidthInBytes((int)(numElements + (skipBytes << 3)));
        int fixedWidth = numNullBytes + (numElements << 3);
        if (position + (long)fixedWidth > $this.columnEndPosition()) {
            position = $this.expand(position, fixedWidth);
        }
        if ($this.isOffHeap()) {
            for (int i = 0; i < numNullBytes; i += 8) {
                $this.writeLongUnchecked(position + (long)i, 0L);
            }
        }
        $this.baseTypeOffset_$eq($this.offset(position));
        $this.baseDataOffset_$eq($this.baseTypeOffset() + (long)numNullBytes);
        Object object = writeNumElements ? BoxesRunTime.boxToLong((long)$this.writeIntUnchecked(position + (long)skipBytes - 4L, numElements)) : BoxedUnit.UNIT;
        return position + (long)fixedWidth;
    }

    private static final long writeStructData(ColumnEncoder $this, long cursor, Object value, int size, long valueOffset, long fieldCursor, long baseOffset) {
        long position = cursor;
        int alignedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)size);
        if (position + (long)alignedSize > $this.columnEndPosition()) {
            position = $this.expand(position, alignedSize);
        }
        Platform.copyMemory((Object)value, (long)valueOffset, (Object)$this.columnBytes(), (long)position, (long)size);
        $this.setOffsetAndSize(position, fieldCursor, baseOffset, size);
        return position + (long)alignedSize;
    }

    public static final long writeStructUTF8String(ColumnEncoder $this, long cursor, UTF8String value, long fieldCursor, long baseOffset) {
        return ColumnEncoder$class.writeStructData($this, cursor, value.getBaseObject(), value.numBytes(), value.getBaseOffset(), fieldCursor, baseOffset);
    }

    public static final long writeStructBinary(ColumnEncoder $this, long cursor, byte[] value, long fieldCursor, long baseOffset) {
        return ColumnEncoder$class.writeStructData($this, cursor, value, value.length, Platform.BYTE_ARRAY_OFFSET, fieldCursor, baseOffset);
    }

    public static final long writeStructDecimal(ColumnEncoder $this, long cursor, Decimal value, long fieldCursor, long baseOffset) {
        byte[] bytes = value.toJavaBigDecimal().unscaledValue().toByteArray();
        return ColumnEncoder$class.writeStructData($this, cursor, bytes, bytes.length, Platform.BYTE_ARRAY_OFFSET, fieldCursor, baseOffset);
    }

    public static final long writeStructInterval(ColumnEncoder $this, long cursor, CalendarInterval value, long fieldCursor, long baseOffset) {
        long position = cursor;
        if (position + 8L > $this.columnEndPosition()) {
            position = $this.expand(position, 8L);
        }
        Platform.putLong((Object)$this.columnBytes(), (long)position, (long)value.microseconds);
        $this.setOffsetAndSize(position, fieldCursor, baseOffset, value.months);
        return position + 8L;
    }

    public static final void releaseForReuse(ColumnEncoder $this, ColumnData columnData, long newSize) {
        if ($this.reuseColumnData() != null) {
            $this.allocator().release($this.reuseColumnData());
        }
        if (newSize < Integer.MAX_VALUE) {
            $this.reuseColumnData_$eq(columnData);
            $this.reuseUsedSize_$eq((int)newSize);
        } else {
            $this.reuseColumnData_$eq(null);
            $this.reuseUsedSize_$eq(0);
        }
    }

    public static void $init$(ColumnEncoder $this) {
    }
}

