/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.encoding;

import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.execution.columnar.encoding.BigDictionaryDecoder;
import org.apache.spark.sql.execution.columnar.encoding.BigDictionaryDecoderBase;
import org.apache.spark.sql.execution.columnar.encoding.BigDictionaryDecoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.BooleanBitSetDecoder;
import org.apache.spark.sql.execution.columnar.encoding.BooleanBitSetDecoderBase;
import org.apache.spark.sql.execution.columnar.encoding.BooleanBitSetDecoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.ColumnDecoder;
import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoder;
import org.apache.spark.sql.execution.columnar.encoding.DictionaryDecoder;
import org.apache.spark.sql.execution.columnar.encoding.DictionaryDecoderBase;
import org.apache.spark.sql.execution.columnar.encoding.DictionaryDecoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.DictionaryEncoder;
import org.apache.spark.sql.execution.columnar.encoding.DictionaryEncoderBase;
import org.apache.spark.sql.execution.columnar.encoding.DictionaryEncoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.IntDeltaDecoder;
import org.apache.spark.sql.execution.columnar.encoding.IntDeltaDecoderBase;
import org.apache.spark.sql.execution.columnar.encoding.IntDeltaDecoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.LongDeltaDecoder;
import org.apache.spark.sql.execution.columnar.encoding.LongDeltaDecoderBase;
import org.apache.spark.sql.execution.columnar.encoding.LongDeltaDecoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.RunLengthDecoder;
import org.apache.spark.sql.execution.columnar.encoding.RunLengthDecoderBase;
import org.apache.spark.sql.execution.columnar.encoding.RunLengthDecoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.UncompressedDecoder;
import org.apache.spark.sql.execution.columnar.encoding.UncompressedDecoderNullable;
import org.apache.spark.sql.execution.columnar.encoding.UncompressedEncoder;
import org.apache.spark.sql.execution.columnar.encoding.UncompressedEncoderNullable;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.collection.BitSet;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ColumnEncoding$ {
    public static final ColumnEncoding$ MODULE$;
    private final Field bitSetWords;
    private final int BITS_PER_LONG;
    private final boolean littleEndian;
    private final Function2<DataType, Object, ColumnDecoder>[] allDecoders;

    static {
        new ColumnEncoding$();
    }

    public Field bitSetWords() {
        return this.bitSetWords;
    }

    public int BITS_PER_LONG() {
        return this.BITS_PER_LONG;
    }

    public boolean littleEndian() {
        return this.littleEndian;
    }

    public Function2<DataType, Object, ColumnDecoder>[] allDecoders() {
        return this.allDecoders;
    }

    public ColumnDecoder getColumnDecoder(ByteBuffer buffer, StructField field) {
        return buffer.isDirect() ? this.getColumnDecoder(null, UnsafeHolder.getDirectBufferAddress((Buffer)buffer), field) : this.getColumnDecoder(buffer.array(), buffer.arrayOffset() + buffer.position() + Platform.BYTE_ARRAY_OFFSET, field);
    }

    /*
     * WARNING - void declaration
     */
    public ColumnDecoder getColumnDecoder(Object columnBytes, long offset, StructField field) {
        void var14_12;
        void var8_6;
        long cursor = offset;
        int typeId = this.readInt(columnBytes, cursor);
        cursor += 4L;
        DataType dataType = Utils$.MODULE$.getSQLDataType(field.dataType());
        if (typeId >= this.allDecoders().length) {
            String string;
            Object object = columnBytes;
            if (object == null) {
                string = "";
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" bytes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.byteArrayOps(byArray).toSeq()}));
            } else {
                string = "";
            }
            String bytesStr = string;
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown encoding typeId = ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)typeId)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for ", "(", ")", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType, field, bytesStr}))).toString());
        }
        int numNullWords = this.readInt(columnBytes, cursor);
        ColumnDecoder decoder = (ColumnDecoder)this.allDecoders()[typeId].apply((Object)dataType, (Object)BoxesRunTime.boxToBoolean((field.nullable() && numNullWords > 0 ? 1 : 0) != 0));
        if (decoder.typeId() != typeId) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"typeId for ", " = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decoder}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not match ", " in global registration"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decoder.typeId()), BoxesRunTime.boxToInteger((int)typeId)}))).toString());
        }
        if (decoder.supports(dataType)) {
            return decoder;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Encoder bug? Unsupported type ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_6, var14_12}))).toString());
    }

    public ColumnEncoder getColumnEncoder(StructField field) {
        DataType dataType = Utils$.MODULE$.getSQLDataType(field.dataType());
        ColumnEncoder columnEncoder = StringType$.MODULE$.equals(dataType) ? this.createDictionaryEncoder((DataType)StringType$.MODULE$, field.nullable()) : this.createUncompressedEncoder(dataType, field.nullable());
        return columnEncoder;
    }

    public ColumnDecoder createUncompressedDecoder(DataType dataType, boolean nullable) {
        return nullable ? new UncompressedDecoderNullable() : new UncompressedDecoder();
    }

    public ColumnDecoder createRunLengthDecoder(DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        boolean bl = BooleanType$.MODULE$.equals(dataType2) ? true : (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : StringType$.MODULE$.equals(dataType2)))))));
        if (bl) {
            RunLengthDecoderBase runLengthDecoderBase = nullable ? new RunLengthDecoderNullable() : new RunLengthDecoder();
            return runLengthDecoderBase;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RunLengthDecoder not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public ColumnDecoder createDictionaryDecoder(DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        boolean bl = StringType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))));
        if (bl) {
            DictionaryDecoderBase dictionaryDecoderBase = nullable ? new DictionaryDecoderNullable() : new DictionaryDecoder();
            return dictionaryDecoderBase;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DictionaryDecoder not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public ColumnDecoder createBigDictionaryDecoder(DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        boolean bl = StringType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))));
        if (bl) {
            BigDictionaryDecoderBase bigDictionaryDecoderBase = nullable ? new BigDictionaryDecoderNullable() : new BigDictionaryDecoder();
            return bigDictionaryDecoderBase;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BigDictionaryDecoder not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public ColumnDecoder createBooleanBitSetDecoder(DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            BooleanBitSetDecoderBase booleanBitSetDecoderBase = nullable ? new BooleanBitSetDecoderNullable() : new BooleanBitSetDecoder();
            return booleanBitSetDecoderBase;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BooleanBitSetDecoder not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public ColumnDecoder createIntDeltaDecoder(DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : DateType$.MODULE$.equals(dataType2);
        if (bl) {
            IntDeltaDecoderBase intDeltaDecoderBase = nullable ? new IntDeltaDecoderNullable() : new IntDeltaDecoder();
            return intDeltaDecoderBase;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IntDeltaDecoder not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public ColumnDecoder createLongDeltaDecoder(DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        boolean bl = LongType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2);
        if (bl) {
            LongDeltaDecoderBase longDeltaDecoderBase = nullable ? new LongDeltaDecoderNullable() : new LongDeltaDecoder();
            return longDeltaDecoderBase;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LongDeltaDecoder not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public ColumnEncoder createUncompressedEncoder(DataType dataType, boolean nullable) {
        return nullable ? new UncompressedEncoderNullable() : new UncompressedEncoder();
    }

    public ColumnEncoder createDictionaryEncoder(DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        boolean bl = StringType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))));
        if (bl) {
            DictionaryEncoderBase dictionaryEncoderBase = nullable ? new DictionaryEncoderNullable() : new DictionaryEncoder();
            return dictionaryEncoderBase;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DictionaryEncoder not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public final short readShort(Object columnBytes, long cursor) {
        return this.littleEndian() ? Platform.getShort((Object)columnBytes, (long)cursor) : Short.reverseBytes(Platform.getShort((Object)columnBytes, (long)cursor));
    }

    public final int readInt(Object columnBytes, long cursor) {
        return this.littleEndian() ? Platform.getInt((Object)columnBytes, (long)cursor) : Integer.reverseBytes(Platform.getInt((Object)columnBytes, (long)cursor));
    }

    public final long readLong(Object columnBytes, long cursor) {
        return this.littleEndian() ? Platform.getLong((Object)columnBytes, (long)cursor) : Long.reverseBytes(Platform.getLong((Object)columnBytes, (long)cursor));
    }

    public final float readFloat(Object columnBytes, long cursor) {
        return this.littleEndian() ? Platform.getFloat((Object)columnBytes, (long)cursor) : Float.intBitsToFloat(Integer.reverseBytes(Platform.getInt((Object)columnBytes, (long)cursor)));
    }

    public final double readDouble(Object columnBytes, long cursor) {
        return this.littleEndian() ? Platform.getDouble((Object)columnBytes, (long)cursor) : Double.longBitsToDouble(Long.reverseBytes(Platform.getLong((Object)columnBytes, (long)cursor)));
    }

    public final UTF8String readUTF8String(Object columnBytes, long cursor) {
        int size = this.readInt(columnBytes, cursor);
        return UTF8String.fromAddress((Object)columnBytes, (long)(cursor + 4L), (int)size);
    }

    public final void writeShort(Object columnBytes, long cursor, short value) {
        if (this.littleEndian()) {
            Platform.putShort((Object)columnBytes, (long)cursor, (short)value);
        } else {
            Platform.putShort((Object)columnBytes, (long)cursor, (short)Short.reverseBytes(value));
        }
    }

    public final void writeInt(Object columnBytes, long cursor, int value) {
        if (this.littleEndian()) {
            Platform.putInt((Object)columnBytes, (long)cursor, (int)value);
        } else {
            Platform.putInt((Object)columnBytes, (long)cursor, (int)Integer.reverseBytes(value));
        }
    }

    public final void writeLong(Object columnBytes, long cursor, long value) {
        if (this.littleEndian()) {
            Platform.putLong((Object)columnBytes, (long)cursor, (long)value);
        } else {
            Platform.putLong((Object)columnBytes, (long)cursor, (long)Long.reverseBytes(value));
        }
    }

    public final long writeUTF8String(Object columnBytes, long cursor, UTF8String value, int size) {
        this.writeInt(columnBytes, cursor, size);
        long position = cursor + 4L;
        Platform.copyMemory((Object)value.getBaseObject(), (long)value.getBaseOffset(), (Object)columnBytes, (long)position, (long)size);
        return position + (long)size;
    }

    /*
     * WARNING - void declaration
     */
    private ColumnEncoding$() {
        void var1_1;
        MODULE$ = this;
        Field f = BitSet.class.getDeclaredField("words");
        f.setAccessible(true);
        this.bitSetWords = var1_1;
        this.BITS_PER_LONG = 64;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
        this.littleEndian = !(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null);
        this.allDecoders = (Function2[])((Object[])new Function2[]{new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDecoder apply(DataType dataType, boolean nullable) {
                return ColumnEncoding$.MODULE$.createUncompressedDecoder(dataType, nullable);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDecoder apply(DataType dataType, boolean nullable) {
                return ColumnEncoding$.MODULE$.createRunLengthDecoder(dataType, nullable);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDecoder apply(DataType dataType, boolean nullable) {
                return ColumnEncoding$.MODULE$.createDictionaryDecoder(dataType, nullable);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDecoder apply(DataType dataType, boolean nullable) {
                return ColumnEncoding$.MODULE$.createBigDictionaryDecoder(dataType, nullable);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDecoder apply(DataType dataType, boolean nullable) {
                return ColumnEncoding$.MODULE$.createBooleanBitSetDecoder(dataType, nullable);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDecoder apply(DataType dataType, boolean nullable) {
                return ColumnEncoding$.MODULE$.createIntDeltaDecoder(dataType, nullable);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDecoder apply(DataType dataType, boolean nullable) {
                return ColumnEncoding$.MODULE$.createLongDeltaDecoder(dataType, nullable);
            }
        }});
    }
}

