/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.encoding;

import com.gemstone.gnu.trove.TLongArrayList;
import java.nio.ByteBuffer;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.execution.ObjectHashSet;
import org.apache.spark.sql.execution.columnar.encoding.ColumnAllocator;
import org.apache.spark.sql.execution.columnar.encoding.ColumnData;
import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoding$;
import org.apache.spark.sql.execution.columnar.encoding.DictionaryEncoderBase;
import org.apache.spark.sql.execution.columnar.encoding.LongIndexKey;
import org.apache.spark.sql.execution.columnar.encoding.LongInit$;
import org.apache.spark.sql.execution.columnar.encoding.StringIndexKey;
import org.apache.spark.sql.execution.columnar.encoding.StringInit$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public abstract class DictionaryEncoderBase$class {
    public static int typeId(DictionaryEncoderBase $this) {
        return $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isShortDictionary() ? 2 : $this.BIG_DICTIONARY_TYPE_ID();
    }

    public static long sizeInBytes(DictionaryEncoderBase $this, long cursor) {
        return $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize() > 0L || $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringMap() != null ? cursor - $this.columnData().baseOffset() + $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize() : ($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isIntMap() ? cursor - $this.columnData().baseOffset() + (long)($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray().size() << 2) : cursor - $this.columnData().baseOffset() + (long)($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray().size() << 4));
    }

    public static int defaultSize(DictionaryEncoderBase $this, DataType dataType) {
        DataType dataType2 = dataType;
        int n = StringType$.MODULE$.equals(dataType2) ? dataType.defaultSize() >>> 1 : dataType.defaultSize();
        return n;
    }

    public static void initializeIndexBytes(DictionaryEncoderBase $this, int initSize, int minSize) {
        int numBytes;
        int n = numBytes = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isShortDictionary() ? (int)((long)initSize << (int)1L) : (int)((long)initSize << (int)2L);
        if ($this.reuseColumnData() == null || $this.reuseColumnData().sizeInBytes() < (long)minSize) {
            $this.columnData_$eq($this.allocator().allocate(numBytes));
            $this.columnBytes_$eq($this.columnData().bytes());
            $this.columnEndPosition_$eq($this.columnData().endPosition());
            if ($this.reuseColumnData() != null) {
                $this.allocator().release($this.reuseColumnData());
                $this.reuseColumnData_$eq(null);
            }
        } else {
            $this.columnData_$eq($this.reuseColumnData());
            $this.columnBytes_$eq($this.reuseColumnData().bytes());
            $this.columnEndPosition_$eq($this.columnData().endPosition());
            $this.reuseColumnData_$eq(null);
        }
    }

    public static long initialize(DictionaryEncoderBase $this, StructField field, int initSize, boolean withHeader, ColumnAllocator allocator) {
        Predef$.MODULE$.assert(withHeader, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DictionaryEncoding not supported without header";
            }
        });
        DataType dataType = Utils$.MODULE$.getSQLDataType(field.dataType());
        if (StringType$.MODULE$.equals(dataType)) {
            BoxedUnit boxedUnit;
            if ($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringMap() == null || $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringMap().size() > Short.MAX_VALUE) {
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringMap_$eq(new ObjectHashSet(128, 0.6, 1, ClassTag$.MODULE$.apply(StringIndexKey.class)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longMap_$eq(new ObjectHashSet(128, 0.6, 1, ClassTag$.MODULE$.apply(LongIndexKey.class)));
            $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray_$eq(new TLongArrayList(128));
            $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isIntMap_$eq(dataType instanceof IntegerType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize_$eq(0L);
        $this.allocator_$eq(allocator);
        $this.initializeLimits();
        $this.initializeNulls(initSize);
        $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isShortDictionary_$eq(true);
        $this.initializeIndexBytes(initSize, 0);
        return $this.columnData().baseOffset();
    }

    public static final long switchToBigDictionary(DictionaryEncoderBase $this, int numUsedIndexes, int newNumIndexes) {
        $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isShortDictionary_$eq(false);
        ColumnData oldIndexData = $this.columnData();
        Object oldIndexBytes = $this.columnBytes();
        long oldCursor = $this.columnData().baseOffset();
        $this.initializeIndexBytes(newNumIndexes, newNumIndexes << 2);
        long cursor = $this.columnData().baseOffset();
        for (int i = 0; i < numUsedIndexes; ++i) {
            ColumnEncoding$.MODULE$.writeInt($this.columnBytes(), cursor, ColumnEncoding$.MODULE$.readShort(oldIndexBytes, oldCursor));
            oldCursor += 2L;
            cursor += 4L;
        }
        $this.allocator().release(oldIndexData);
        return cursor;
    }

    public static final long writeIndex(DictionaryEncoderBase $this, long cursor, int index) {
        long l;
        if ($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isShortDictionary()) {
            long position = cursor;
            if (position + 2L > $this.columnEndPosition()) {
                position = $this.expand(position, 2L);
            }
            ColumnEncoding$.MODULE$.writeShort($this.columnBytes(), position, (short)index);
            l = position + 2L;
        } else {
            long position = cursor;
            if (position + 4L > $this.columnEndPosition()) {
                position = $this.expand(position, 4L);
            }
            ColumnEncoding$.MODULE$.writeInt($this.columnBytes(), position, index);
            l = position + 4L;
        }
        return l;
    }

    public static final long writeUTF8String(DictionaryEncoderBase $this, long cursor, UTF8String value) {
        long position = cursor;
        StringIndexKey key = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringMap().addString(value, StringInit$.MODULE$);
        int index = key.index();
        if (index == -1) {
            StringIndexKey stringTail;
            UTF8String s = key.s();
            $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize_$eq($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize() + (long)(4 + s.numBytes()));
            $this.updateStringStats(s);
            index = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$numStrings();
            $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$numStrings_$eq($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$numStrings() + 1);
            key.index_$eq(index);
            if (index == Short.MAX_VALUE && $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isShortDictionary()) {
                int numUsedIndexes = (int)(position - $this.columnData().baseOffset() >> 1);
                position = $this.switchToBigDictionary(numUsedIndexes, (numUsedIndexes << 2) / 3);
            }
            if ((stringTail = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringTail()) != null) {
                stringTail.next_$eq(key);
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringTail_$eq(key);
            } else {
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringHead_$eq(key);
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringTail_$eq(key);
            }
        }
        return $this.writeIndex(position, index);
    }

    public static final long writeInt(DictionaryEncoderBase $this, long cursor, int value) {
        return $this.writeLong(cursor, value);
    }

    public static final long writeLong(DictionaryEncoderBase $this, long cursor, long value) {
        long position = cursor;
        LongIndexKey key = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longMap().addLong(value, LongInit$.MODULE$);
        int index = key.index();
        if (index == -1) {
            index = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray().size();
            key.index_$eq(index);
            if (index == Short.MAX_VALUE && $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isShortDictionary()) {
                int numUsedIndexes = (int)(position - $this.columnData().baseOffset() >> 1);
                position = $this.switchToBigDictionary(numUsedIndexes, (numUsedIndexes << 2) / 3);
            }
            $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray().add(key.l());
            $this.updateLongStats(value);
        }
        return $this.writeIndex(position, index);
    }

    public static ByteBuffer finish(DictionaryEncoderBase $this, long indexCursor) {
        long numIndexBytes = indexCursor - $this.columnData().baseOffset();
        int numElements = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$numStrings();
        if ($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringMap() == null) {
            numElements = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray().size();
            if ($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isIntMap()) {
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize_$eq(numElements << 2);
            } else {
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize_$eq(numElements << 4);
            }
        }
        int numNullWords = $this.getNumNullWords();
        long dataSize = 4L + $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$dictionarySize() + numIndexBytes;
        ColumnData columnData = $this.allocator().allocate(8L + ((long)numNullWords << (int)3L) + dataSize);
        Object columnBytes = columnData.bytes();
        long cursor = columnData.baseOffset();
        ColumnEncoding$.MODULE$.writeInt(columnBytes, cursor, $this.typeId());
        ColumnEncoding$.MODULE$.writeInt(columnBytes, cursor += 4L, numNullWords);
        cursor += 4L;
        cursor = $this.writeNulls(columnBytes, cursor, numNullWords);
        ColumnEncoding$.MODULE$.writeInt(columnBytes, cursor, numElements);
        cursor += 4L;
        if ($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringMap() != null) {
            if (numElements > 0) {
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringTail().next_$eq(null);
                StringIndexKey current = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringHead();
                do {
                    UTF8String s = current.s();
                    current.index_$eq(-1);
                    cursor = ColumnEncoding$.MODULE$.writeUTF8String(columnBytes, cursor, s, s.numBytes());
                } while ((current = current.next()) != null);
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringHead_$eq(null);
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$stringTail_$eq(null);
                $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$numStrings_$eq(0);
            }
        } else if ($this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$isIntMap()) {
            for (int index = 0; index < numElements; ++index) {
                long l = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray().getQuick(index);
                ColumnEncoding$.MODULE$.writeInt(columnBytes, cursor, (int)l);
                cursor += 4L;
            }
        } else {
            for (int index = 0; index < numElements; ++index) {
                long l = $this.org$apache$spark$sql$execution$columnar$encoding$DictionaryEncoderBase$$longArray().getQuick(index);
                ColumnEncoding$.MODULE$.writeLong(columnBytes, cursor, l);
                cursor += 8L;
            }
        }
        $this.allocator().copy($this.columnBytes(), $this.columnData().baseOffset(), columnBytes, cursor, numIndexBytes);
        $this.releaseForReuse($this.columnData(), numIndexBytes);
        return $this.allocator().toBuffer(columnData);
    }

    public static void $init$(DictionaryEncoderBase $this) {
    }
}

