/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.encoding;

import java.nio.ByteBuffer;
import org.apache.spark.sql.execution.columnar.encoding.ColumnAllocator;
import org.apache.spark.sql.execution.columnar.encoding.ColumnData;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class HeapAllocator$
implements ColumnAllocator {
    public static final HeapAllocator$ MODULE$;

    static {
        new HeapAllocator$();
    }

    private long baseOffset() {
        return Platform.BYTE_ARRAY_OFFSET;
    }

    private int checkSize(long size) {
        if (size < Integer.MAX_VALUE) {
            return (int)size;
        }
        throw new ArrayIndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid size/index = ", ". Max allowed = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)size), BoxesRunTime.boxToInteger((int)0x7FFFFFFE)})));
    }

    @Override
    public ColumnData allocate(long size) {
        return new ColumnData(new byte[ByteArrayMethods.roundNumberOfBytesToNearestWord((int)this.checkSize(size))], this.baseOffset(), this.baseOffset() + size);
    }

    @Override
    public ColumnData expand(ColumnData columnData, long cursor, long required) {
        long currentUsed;
        long minRequired;
        byte[] columnBytes = (byte[])columnData.bytes();
        int newLength = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)((int)package$.MODULE$.min(package$.MODULE$.max((long)((int)((long)columnBytes.length << (int)1L)), minRequired = (currentUsed = cursor - this.baseOffset()) + required), 0x3FFFFFFFL)));
        if ((long)newLength < minRequired) {
            throw new ArrayIndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot allocate more than ", " bytes but required ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)newLength), BoxesRunTime.boxToLong((long)minRequired)})));
        }
        byte[] newBytes = new byte[newLength];
        System.arraycopy(columnBytes, 0, newBytes, 0, (int)currentUsed);
        return new ColumnData(newBytes, this.baseOffset(), (long)newLength + this.baseOffset());
    }

    @Override
    public void copy(Object source, long sourcePos, Object dest, long destPos, long size) {
        System.arraycopy(source, this.checkSize(sourcePos - this.baseOffset()), dest, this.checkSize(destPos - this.baseOffset()), this.checkSize(size));
    }

    @Override
    public void release(ColumnData columnData) {
    }

    @Override
    public ByteBuffer toBuffer(ColumnData data) {
        return ByteBuffer.wrap((byte[])data.bytes());
    }

    @Override
    public boolean isOffHeap() {
        return false;
    }

    private HeapAllocator$() {
        MODULE$ = this;
    }
}

