/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.encoding;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.columnar.encoding.ColumnData;
import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoding$;
import org.apache.spark.sql.execution.columnar.encoding.NullableEncoder;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import scala.math.package$;

public abstract class NullableEncoder$class {
    /*
     * WARNING - void declaration
     */
    public static int getNumNullWords(NullableEncoder $this) {
        void var2_2;
        long[] nullWords = $this.nullWords();
        for (int numWords = nullWords.length; numWords > 0 && nullWords[numWords - 1] == 0L; --numWords) {
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int initializeNulls(NullableEncoder $this, int initSize) {
        void v0;
        if ($this.nullWords() == null) {
            void var2_2;
            int numWords = UnsafeRow.calculateBitSetWidthInBytes((int)initSize) >>> 3;
            $this.maxNulls_$eq((long)numWords << (int)6L);
            $this.nullWords_$eq(new long[numWords]);
            $this.initialNumWords_$eq(numWords);
            v0 = var2_2;
        } else {
            void var3_3;
            int numWords = $this.getNumNullWords();
            $this.initialNumWords_$eq(numWords);
            for (int i = 0; i < numWords; ++i) {
                if ($this.nullWords()[i] == 0L) continue;
                $this.nullWords()[i] = 0L;
            }
            v0 = var3_3;
        }
        return (int)v0;
    }

    /*
     * WARNING - void declaration
     */
    public static int nullCount(NullableEncoder $this) {
        void var1_1;
        int sum = 0;
        int numWords = $this.nullWords().length;
        for (int i = 0; i < numWords; ++i) {
            sum += Long.bitCount($this.nullWords()[i]);
        }
        return (int)var1_1;
    }

    public static void writeIsNull(NullableEncoder $this, int ordinal) {
        if ((long)ordinal < $this.maxNulls()) {
            BitSetMethods.set((Object)$this.nullWords(), (long)Platform.LONG_ARRAY_OFFSET, (int)ordinal);
        } else {
            long[] oldNulls = $this.nullWords();
            int oldLen = oldNulls.length;
            int newLen = oldLen << 1;
            $this.nullWords_$eq(new long[newLen]);
            $this.maxNulls_$eq((int)((long)newLen << (int)6L));
            System.arraycopy(oldNulls, 0, $this.nullWords(), 0, oldLen);
            BitSetMethods.set((Object)$this.nullWords(), (long)Platform.LONG_ARRAY_OFFSET, (int)ordinal);
        }
    }

    public static long writeNulls(NullableEncoder $this, Object columnBytes, long cursor, int numWords) {
        long position = cursor;
        for (int index = 0; index < numWords; ++index) {
            ColumnEncoding$.MODULE$.writeLong(columnBytes, position, $this.nullWords()[index]);
            position += 8L;
        }
        return position;
    }

    public static ByteBuffer finish(NullableEncoder $this, long cursor) {
        ByteBuffer byteBuffer;
        int numWords = $this.getNumNullWords();
        int maxWastedWords = 50;
        long baseOffset = $this.columnData().baseOffset();
        if ($this.initialNumWords() == numWords) {
            $this.writeNulls($this.columnBytes(), baseOffset + 8L, numWords);
            byteBuffer = $this.org$apache$spark$sql$execution$columnar$encoding$NullableEncoder$$super$finish(cursor);
        } else if ($this.initialNumWords() > numWords && numWords > 0 && $this.initialNumWords() - numWords < maxWastedWords && cursor == $this.columnEndPosition()) {
            $this.writeNulls($this.columnBytes(), baseOffset + 8L, $this.initialNumWords());
            byteBuffer = $this.allocator().toBuffer($this.columnData());
        } else {
            int numNullBytes = numWords << 3;
            int initialNullBytes = $this.initialNumWords() << 3;
            long oldSize = cursor - baseOffset;
            long newSize = oldSize + (long)numNullBytes - (long)initialNullBytes;
            ColumnData newColumnData = $this.allocator().allocate(newSize);
            Object newColumnBytes = newColumnData.bytes();
            long position = newColumnData.baseOffset();
            ColumnEncoding$.MODULE$.writeInt(newColumnBytes, position, $this.typeId());
            ColumnEncoding$.MODULE$.writeInt(newColumnBytes, position += 4L, numWords);
            $this.allocator().copy($this.columnBytes(), baseOffset + 8L + (long)initialNullBytes, newColumnBytes, (position += 4L) + (long)numNullBytes, oldSize - 8L - (long)initialNullBytes);
            if (package$.MODULE$.abs($this.initialNumWords() - numWords) < maxWastedWords) {
                $this.releaseForReuse($this.columnData(), newSize);
            }
            $this.columnData_$eq(newColumnData);
            $this.columnBytes_$eq(newColumnBytes);
            $this.columnEndPosition_$eq(newColumnData.endPosition());
            $this.writeNulls(newColumnBytes, position, numWords);
            byteBuffer = $this.allocator().toBuffer(newColumnData);
        }
        return byteBuffer;
    }

    public static void $init$(NullableEncoder $this) {
    }
}

