/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.encoding;

import org.apache.spark.sql.execution.columnar.encoding.ColumnDecoder;
import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoding$;
import org.apache.spark.sql.execution.columnar.encoding.RunLengthEncoding;
import org.apache.spark.sql.execution.columnar.encoding.RunLengthEncoding$class;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0003\u0003\t\"\u0001\u0006*v]2+gn\u001a;i\t\u0016\u001cw\u000eZ3s\u0005\u0006\u001cXM\u0003\u0002\u0004\t\u0005AQM\\2pI&twM\u0003\u0002\u0006\r\u0005A1m\u001c7v[:\f'O\u0003\u0002\b\u0011\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0019u\u000e\\;n]\u0012+7m\u001c3feB\u00111cF\u0005\u00031\t\u0011\u0011CU;o\u0019\u0016tw\r\u001e5F]\u000e|G-\u001b8h\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u0014\u0001!1a\u0004\u0001Q!\n}\t\u0011B];o\u0019\u0016tw\r\u001e5\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u0007%sG\u000f\u0003\u0004'\u0001\u0001\u0006KaJ\u0001\nGV\u00148o\u001c:Q_N\u0004\"\u0001\t\u0015\n\u0005%\n#\u0001\u0002'p]\u001eD\u0011b\u000b\u0001A\u0002\u0003\u0005\u000b\u0015B\u0014\u0002!\r,(O]3oiZ\u000bG.^3M_:<\u0007\"C\u0017\u0001\u0001\u0004\u0005\t\u0015)\u0003/\u0003I\u0019WO\u001d:f]R4\u0016\r\\;f'R\u0014\u0018N\\4\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014!\u0002;za\u0016\u001c(BA\u001a\u000b\u0003\u0019)hn]1gK&\u0011Q\u0007\r\u0002\u000b+R3\u0005h\u0015;sS:<\u0007\"B\u001c\u0001\t#B\u0014\u0001E5oSRL\u0017\r\\5{K\u000e+(o]8s)\u00119\u0013H\u0010!\t\u000bi2\u0004\u0019A\u001e\u0002\u0017\r|G.^7o\u0005f$Xm\u001d\t\u0003AqJ!!P\u0011\u0003\r\u0005s\u0017PU3g\u0011\u0015yd\u00071\u0001(\u0003\u0019\u0019WO]:pe\")\u0011I\u000ea\u0001\u0005\u0006)a-[3mIB\u00111)R\u0007\u0002\t*\u0011\u0011\u0007C\u0005\u0003\r\u0012\u00131b\u0015;sk\u000e$h)[3mI\")\u0001\n\u0001C#\u0013\u0006Aa.\u001a=u\u0005f$X\rF\u0002(\u0015.CQAO$A\u0002mBQ\u0001T$A\u0002\u001d\n!bY8v]R4\u0016\r\\;f\u0011\u0015q\u0005\u0001\"\u0012P\u0003!\u0011X-\u00193CsR,Gc\u0001)T)B\u0011\u0001%U\u0005\u0003%\u0006\u0012AAQ=uK\")!(\u0014a\u0001w!)A*\u0014a\u0001O!)a\u000b\u0001C#/\u0006Ya.\u001a=u\u0005>|G.Z1o)\r9\u0003,\u0017\u0005\u0006uU\u0003\ra\u000f\u0005\u0006\u0019V\u0003\ra\n\u0005\u00067\u0002!)\u0005X\u0001\fe\u0016\fGMQ8pY\u0016\fg\u000eF\u0002^A\u0006\u0004\"\u0001\t0\n\u0005}\u000b#a\u0002\"p_2,\u0017M\u001c\u0005\u0006ui\u0003\ra\u000f\u0005\u0006\u0019j\u0003\ra\n\u0005\u0006G\u0002!)\u0005Z\u0001\n]\u0016DHo\u00155peR$2aJ3g\u0011\u0015Q$\r1\u0001<\u0011\u0015a%\r1\u0001(\u0011\u0015A\u0007\u0001\"\u0012j\u0003%\u0011X-\u00193TQ>\u0014H\u000fF\u0002k[:\u0004\"\u0001I6\n\u00051\f#!B*i_J$\b\"\u0002\u001eh\u0001\u0004Y\u0004\"\u0002'h\u0001\u00049\u0003\"\u00029\u0001\t\u000b\n\u0018a\u00028fqRLe\u000e\u001e\u000b\u0004OI\u001c\b\"\u0002\u001ep\u0001\u0004Y\u0004\"\u0002'p\u0001\u00049\u0003\"B;\u0001\t\u000b2\u0018a\u0002:fC\u0012Le\u000e\u001e\u000b\u0004?]D\b\"\u0002\u001eu\u0001\u0004Y\u0004\"\u0002'u\u0001\u00049\u0003\"\u0002>\u0001\t\u000bZ\u0018\u0001\u0003:fC\u0012$\u0015\r^3\u0015\u0007}aX\u0010C\u0003;s\u0002\u00071\bC\u0003Ms\u0002\u0007q\u0005\u0003\u0004\u0000\u0001\u0011\u0015\u0013\u0011A\u0001\t]\u0016DH\u000fT8oOR)q%a\u0001\u0002\u0006!)!H a\u0001w!1\u0011q\u0001@A\u0002\u001d\nQaY8v]RDq!a\u0003\u0001\t\u000b\ni!\u0001\u0005sK\u0006$Gj\u001c8h)\u00159\u0013qBA\t\u0011\u0019Q\u0014\u0011\u0002a\u0001w!9\u0011qAA\u0005\u0001\u00049\u0003bBA\u000b\u0001\u0011\u0015\u0013qC\u0001\u000ee\u0016\fG\rV5nKN$\u0018-\u001c9\u0015\u000b\u001d\nI\"a\u0007\t\ri\n\u0019\u00021\u0001<\u0011\u001d\t9!a\u0005A\u0002\u001dBq!a\b\u0001\t\u000b\n\t#\u0001\boKb$X\u000b\u0016$9'R\u0014\u0018N\\4\u0015\u000b\u001d\n\u0019#!\n\t\ri\ni\u00021\u0001<\u0011\u001d\t9!!\bA\u0002\u001dBq!!\u000b\u0001\t\u000b\nY#\u0001\bsK\u0006$W\u000b\u0016$9'R\u0014\u0018N\\4\u0015\u000b9\ni#a\f\t\ri\n9\u00031\u0001<\u0011\u001d\t9!a\nA\u0002\u001d\u0002")
public abstract class RunLengthDecoderBase
extends ColumnDecoder
implements RunLengthEncoding {
    private int runLength;
    private long cursorPos;
    private long currentValueLong;
    private UTF8String currentValueString;

    @Override
    public final int typeId() {
        return RunLengthEncoding$class.typeId(this);
    }

    @Override
    public final boolean supports(DataType dataType) {
        return RunLengthEncoding$class.supports(this, dataType);
    }

    @Override
    public long initializeCursor(Object columnBytes, long cursor, StructField field) {
        this.cursorPos = cursor;
        return 0L;
    }

    @Override
    public final long nextByte(Object columnBytes, long countValue) {
        long l;
        int count2 = (int)countValue;
        if (count2 != this.runLength) {
            l = countValue + 1L;
        } else {
            long cursor = this.cursorPos;
            long currentValue = Platform.getByte((Object)columnBytes, (long)cursor);
            this.runLength = ColumnEncoding$.MODULE$.readInt(columnBytes, cursor + 1L);
            this.cursorPos = cursor + 5L;
            l = currentValue << 32 | 1L;
        }
        return l;
    }

    @Override
    public final byte readByte(Object columnBytes, long countValue) {
        return (byte)(countValue >> 32);
    }

    @Override
    public final long nextBoolean(Object columnBytes, long countValue) {
        return this.nextByte(columnBytes, countValue);
    }

    @Override
    public final boolean readBoolean(Object columnBytes, long countValue) {
        return countValue >> 32 == 1L;
    }

    @Override
    public final long nextShort(Object columnBytes, long countValue) {
        long l;
        int count2 = (int)countValue;
        if (count2 != this.runLength) {
            l = countValue + 1L;
        } else {
            long cursor = this.cursorPos;
            long currentValue = ColumnEncoding$.MODULE$.readShort(columnBytes, cursor);
            this.runLength = ColumnEncoding$.MODULE$.readInt(columnBytes, cursor + 2L);
            this.cursorPos = cursor + 6L;
            l = currentValue << 32 | 1L;
        }
        return l;
    }

    @Override
    public final short readShort(Object columnBytes, long countValue) {
        return (short)(countValue >> 32);
    }

    @Override
    public final long nextInt(Object columnBytes, long countValue) {
        long l;
        int count2 = (int)countValue;
        if (count2 != this.runLength) {
            l = countValue + 1L;
        } else {
            long cursor = this.cursorPos;
            long currentValue = ColumnEncoding$.MODULE$.readInt(columnBytes, cursor);
            this.runLength = ColumnEncoding$.MODULE$.readInt(columnBytes, cursor + 4L);
            this.cursorPos = cursor + 8L;
            l = currentValue << 32 | 1L;
        }
        return l;
    }

    @Override
    public final int readInt(Object columnBytes, long countValue) {
        return (int)(countValue >> 32);
    }

    @Override
    public final int readDate(Object columnBytes, long countValue) {
        return (int)(countValue >> 32);
    }

    @Override
    public final long nextLong(Object columnBytes, long count2) {
        long l;
        if (count2 != (long)this.runLength) {
            l = count2 + 1L;
        } else {
            long cursor = this.cursorPos;
            this.currentValueLong = ColumnEncoding$.MODULE$.readLong(columnBytes, cursor);
            this.runLength = ColumnEncoding$.MODULE$.readInt(columnBytes, cursor + 8L);
            this.cursorPos = cursor + 12L;
            l = 1L;
        }
        return l;
    }

    @Override
    public final long readLong(Object columnBytes, long count2) {
        return this.currentValueLong;
    }

    @Override
    public final long readTimestamp(Object columnBytes, long count2) {
        return this.currentValueLong;
    }

    @Override
    public final long nextUTF8String(Object columnBytes, long count2) {
        long l;
        if (count2 != (long)this.runLength) {
            l = count2 + 1L;
        } else {
            long cursor = this.cursorPos;
            UTF8String currentValue = ColumnEncoding$.MODULE$.readUTF8String(columnBytes, cursor);
            this.runLength = ColumnEncoding$.MODULE$.readInt(columnBytes, cursor += (long)(4 + currentValue.numBytes()));
            this.cursorPos = cursor + 4L;
            this.currentValueString = currentValue;
            l = 1L;
        }
        return l;
    }

    @Override
    public final UTF8String readUTF8String(Object columnBytes, long count2) {
        return this.currentValueString;
    }

    public RunLengthDecoderBase() {
        RunLengthEncoding$class.$init$(this);
        this.runLength = 0;
        this.cursorPos = 0L;
    }
}

