/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.encoding;

import org.apache.spark.sql.execution.columnar.encoding.ColumnEncoding$;
import org.apache.spark.sql.execution.columnar.encoding.UncompressedEncoderBase;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public abstract class UncompressedEncoderBase$class {
    public static long writeBoolean(UncompressedEncoderBase $this, long cursor, boolean value) {
        byte b;
        long position = cursor;
        byte by = b = value ? (byte)1 : 0;
        if (position + 1L > $this.columnEndPosition()) {
            position = $this.expand(position, 1L);
        }
        Platform.putByte((Object)$this.columnBytes(), (long)position, (byte)b);
        $this.updateLongStats(b);
        return position + 1L;
    }

    public static long writeByte(UncompressedEncoderBase $this, long cursor, byte value) {
        long position = cursor;
        if (position + 1L > $this.columnEndPosition()) {
            position = $this.expand(position, 1L);
        }
        Platform.putByte((Object)$this.columnBytes(), (long)position, (byte)value);
        $this.updateLongStats(value);
        return position + 1L;
    }

    public static long writeShort(UncompressedEncoderBase $this, long cursor, short value) {
        long position = cursor;
        if (position + 2L > $this.columnEndPosition()) {
            position = $this.expand(position, 2L);
        }
        ColumnEncoding$.MODULE$.writeShort($this.columnBytes(), position, value);
        $this.updateLongStats(value);
        return position + 2L;
    }

    public static long writeInt(UncompressedEncoderBase $this, long cursor, int value) {
        long position = cursor;
        if (position + 4L > $this.columnEndPosition()) {
            position = $this.expand(position, 4L);
        }
        ColumnEncoding$.MODULE$.writeInt($this.columnBytes(), position, value);
        $this.updateLongStats(value);
        return position + 4L;
    }

    public static long writeLong(UncompressedEncoderBase $this, long cursor, long value) {
        long position = cursor;
        if (position + 8L > $this.columnEndPosition()) {
            position = $this.expand(position, 8L);
        }
        ColumnEncoding$.MODULE$.writeLong($this.columnBytes(), position, value);
        $this.updateLongStats(value);
        return position + 8L;
    }

    public static long writeFloat(UncompressedEncoderBase $this, long cursor, float value) {
        long position = cursor;
        if (position + 4L > $this.columnEndPosition()) {
            position = $this.expand(position, 4L);
        }
        if (Float.isNaN(value)) {
            if (ColumnEncoding$.MODULE$.littleEndian()) {
                Platform.putFloat((Object)$this.columnBytes(), (long)position, (float)Float.NaN);
            } else {
                Platform.putInt((Object)$this.columnBytes(), (long)position, (int)Integer.reverseBytes(Float.floatToIntBits(Float.NaN)));
            }
        } else {
            if (ColumnEncoding$.MODULE$.littleEndian()) {
                Platform.putFloat((Object)$this.columnBytes(), (long)position, (float)value);
            } else {
                Platform.putInt((Object)$this.columnBytes(), (long)position, (int)Integer.reverseBytes(Float.floatToIntBits(value)));
            }
            $this.updateDoubleStats(value);
        }
        return position + 4L;
    }

    public static long writeDouble(UncompressedEncoderBase $this, long cursor, double value) {
        long position = cursor;
        if (position + 8L > $this.columnEndPosition()) {
            position = $this.expand(position, 8L);
        }
        if (Double.isNaN(value)) {
            if (ColumnEncoding$.MODULE$.littleEndian()) {
                Platform.putDouble((Object)$this.columnBytes(), (long)position, (double)Double.NaN);
            } else {
                Platform.putLong((Object)$this.columnBytes(), (long)position, (long)Long.reverseBytes(Double.doubleToLongBits(Double.NaN)));
            }
        } else {
            if (ColumnEncoding$.MODULE$.littleEndian()) {
                Platform.putDouble((Object)$this.columnBytes(), (long)position, (double)value);
            } else {
                Platform.putLong((Object)$this.columnBytes(), (long)position, (long)Long.reverseBytes(Double.doubleToLongBits(value)));
            }
            $this.updateDoubleStats(value);
        }
        return position + 8L;
    }

    public static long writeLongDecimal(UncompressedEncoderBase $this, long cursor, Decimal value, int ordinal, int precision, int scale) {
        long l;
        if (!(value.precision() == precision && value.scale() == scale || value.changePrecision(precision, scale))) {
            $this.writeIsNull(ordinal);
            l = cursor;
        } else {
            l = $this.writeLong(cursor, value.toUnscaledLong());
        }
        return l;
    }

    public static long writeDecimal(UncompressedEncoderBase $this, long cursor, Decimal value, int ordinal, int precision, int scale) {
        long l;
        if (!(value.precision() == precision && value.scale() == scale || value.changePrecision(precision, scale))) {
            $this.writeIsNull(ordinal);
            l = cursor;
        } else {
            byte[] b = value.toJavaBigDecimal().unscaledValue().toByteArray();
            $this.updateDecimalStats(value);
            l = $this.writeBinary(cursor, b);
        }
        return l;
    }

    public static long writeInterval(UncompressedEncoderBase $this, long cursor, CalendarInterval value) {
        long position = $this.writeInt(cursor, value.months);
        return $this.writeLong(position, value.microseconds);
    }

    public static long writeUTF8String(UncompressedEncoderBase $this, long cursor, UTF8String value) {
        long position = cursor;
        int size = value.numBytes();
        if (position + (long)size + 4L > $this.columnEndPosition()) {
            position = $this.expand(position, size + 4);
        }
        $this.updateStringStatsClone(value);
        return ColumnEncoding$.MODULE$.writeUTF8String($this.columnBytes(), position, value, size);
    }

    public static long writeBinary(UncompressedEncoderBase $this, long cursor, byte[] value) {
        long position = cursor;
        int size = value.length;
        if (position + (long)size + 4L > $this.columnEndPosition()) {
            position = $this.expand(position, size + 4);
        }
        Object columnBytes = $this.columnBytes();
        ColumnEncoding$.MODULE$.writeInt(columnBytes, position, size);
        Platform.copyMemory((Object)value, (long)Platform.BYTE_ARRAY_OFFSET, (Object)columnBytes, (long)(position += 4L), (long)size);
        return position + (long)size;
    }

    public static long writeBooleanUnchecked(UncompressedEncoderBase $this, long cursor, boolean value) {
        byte b = value ? (byte)1 : 0;
        Platform.putByte((Object)$this.columnBytes(), (long)cursor, (byte)b);
        return cursor + 1L;
    }

    public static long writeByteUnchecked(UncompressedEncoderBase $this, long cursor, byte value) {
        Platform.putByte((Object)$this.columnBytes(), (long)cursor, (byte)value);
        return cursor + 1L;
    }

    public static long writeShortUnchecked(UncompressedEncoderBase $this, long cursor, short value) {
        ColumnEncoding$.MODULE$.writeShort($this.columnBytes(), cursor, value);
        return cursor + 2L;
    }

    public static long writeIntUnchecked(UncompressedEncoderBase $this, long cursor, int value) {
        ColumnEncoding$.MODULE$.writeInt($this.columnBytes(), cursor, value);
        return cursor + 4L;
    }

    public static long writeLongUnchecked(UncompressedEncoderBase $this, long cursor, long value) {
        ColumnEncoding$.MODULE$.writeLong($this.columnBytes(), cursor, value);
        return cursor + 8L;
    }

    public static long writeFloatUnchecked(UncompressedEncoderBase $this, long cursor, float value) {
        if (Float.isNaN(value)) {
            if (ColumnEncoding$.MODULE$.littleEndian()) {
                Platform.putFloat((Object)$this.columnBytes(), (long)cursor, (float)Float.NaN);
            } else {
                Platform.putInt((Object)$this.columnBytes(), (long)cursor, (int)Integer.reverseBytes(Float.floatToIntBits(Float.NaN)));
            }
        } else if (ColumnEncoding$.MODULE$.littleEndian()) {
            Platform.putFloat((Object)$this.columnBytes(), (long)cursor, (float)value);
        } else {
            Platform.putInt((Object)$this.columnBytes(), (long)cursor, (int)Integer.reverseBytes(Float.floatToIntBits(value)));
        }
        return cursor + 4L;
    }

    public static long writeDoubleUnchecked(UncompressedEncoderBase $this, long cursor, double value) {
        if (Double.isNaN(value)) {
            if (ColumnEncoding$.MODULE$.littleEndian()) {
                Platform.putDouble((Object)$this.columnBytes(), (long)cursor, (double)Double.NaN);
            } else {
                Platform.putLong((Object)$this.columnBytes(), (long)cursor, (long)Long.reverseBytes(Double.doubleToLongBits(Double.NaN)));
            }
        } else if (ColumnEncoding$.MODULE$.littleEndian()) {
            Platform.putDouble((Object)$this.columnBytes(), (long)cursor, (double)value);
        } else {
            Platform.putLong((Object)$this.columnBytes(), (long)cursor, (long)Long.reverseBytes(Double.doubleToLongBits(value)));
        }
        return cursor + 8L;
    }

    public static long writeUnsafeData(UncompressedEncoderBase $this, long cursor, Object baseObject, long baseOffset, int numBytes) {
        long position = cursor;
        if (position + (long)numBytes > $this.columnEndPosition()) {
            position = $this.expand(position, numBytes);
        }
        Platform.copyMemory((Object)baseObject, (long)baseOffset, (Object)$this.columnBytes(), (long)position, (long)numBytes);
        return position + (long)numBytes;
    }

    public static void $init$(UncompressedEncoderBase $this) {
    }
}

