/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.hive.QualifiedTableName;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$$anonfun$org$apache$spark$sql$hive$SnappyStoreHiveCatalog$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SnappyStoreHiveCatalog$ {
    public static final SnappyStoreHiveCatalog$ MODULE$;
    private final String HIVE_PROVIDER;
    private final String HIVE_SCHEMA_NUMPARTS;
    private final String HIVE_SCHEMA_PART;
    private final String HIVE_METASTORE;
    private final LoadingCache<QualifiedTableName, Seq<Tuple2<LogicalPlan, String>>> cachedSampleTables;
    private int relationDestroyVersion;
    private final ReentrantReadWriteLock org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$relationDestroyLock;
    private final Object org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$alterTableLock;

    static {
        new SnappyStoreHiveCatalog$();
    }

    public String HIVE_PROVIDER() {
        return this.HIVE_PROVIDER;
    }

    public String HIVE_SCHEMA_NUMPARTS() {
        return this.HIVE_SCHEMA_NUMPARTS;
    }

    public String HIVE_SCHEMA_PART() {
        return this.HIVE_SCHEMA_PART;
    }

    public String HIVE_METASTORE() {
        return this.HIVE_METASTORE;
    }

    public LoadingCache<QualifiedTableName, Seq<Tuple2<LogicalPlan, String>>> cachedSampleTables() {
        return this.cachedSampleTables;
    }

    public String processTableIdentifier(String tableIdentifier, SQLConf conf) {
        return conf.caseSensitiveAnalysis() ? tableIdentifier : Utils$.MODULE$.toUpperCase(tableIdentifier);
    }

    public ReentrantReadWriteLock org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$relationDestroyLock() {
        return this.org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$relationDestroyLock;
    }

    public Object org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$alterTableLock() {
        return this.org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$alterTableLock;
    }

    public int getRelationDestroyVersion() {
        return this.relationDestroyVersion;
    }

    /*
     * WARNING - void declaration
     */
    public int registerRelationDestroy() {
        ReentrantReadWriteLock.WriteLock sync = this.org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$relationDestroyLock().writeLock();
        sync.lock();
        try {
            void var3_2;
            int globalVersion = this.relationDestroyVersion++;
            sync.unlock();
            return (int)var3_2;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    public Option<String> org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$getSchemaString(Map<String, String> tableProps) {
        return tableProps.get((Object)this.HIVE_SCHEMA_NUMPARTS()).map((Function1)new Serializable(tableProps){
            public static final long serialVersionUID = 0L;
            public final Map tableProps$1;

            public final String apply(String numParts) {
                return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(numParts)).toInt()).map((Function1)new Serializable(this, numParts){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$getSchemaString$1 $outer;
                    private final String numParts$1;

                    public final String apply(int index) {
                        String partProp = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnappyStoreHiveCatalog$.MODULE$.HIVE_SCHEMA_PART(), BoxesRunTime.boxToInteger((int)index)}));
                        Option option = this.$outer.tableProps$1.get((Object)partProp);
                        if (option instanceof Some) {
                            String part;
                            Some some = (Some)option;
                            String string = part = (String)some.x();
                            return string;
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw new AnalysisException(new StringBuilder().append((Object)"Could not read schema from metastore because it is corrupted (missing ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part ", " of the schema, ", " parts expected)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), this.numParts$1}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numParts$1 = numParts$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).mkString();
            }
            {
                this.tableProps$1 = tableProps$1;
            }
        });
    }

    public String getSchemaStringFromHiveTable(Table table) {
        return (String)this.org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$getSchemaString((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.getParameters()).asScala())).orNull(Predef$.MODULE$.$conforms());
    }

    public void closeCurrent() {
        Hive.closeCurrent();
    }

    private SnappyStoreHiveCatalog$() {
        MODULE$ = this;
        this.HIVE_PROVIDER = "spark.sql.sources.provider";
        this.HIVE_SCHEMA_NUMPARTS = "spark.sql.sources.schema.numParts";
        this.HIVE_SCHEMA_PART = "spark.sql.sources.schema.part";
        this.HIVE_METASTORE = "SNAPPY_HIVE_METASTORE";
        this.cachedSampleTables = CacheBuilder.newBuilder().maximumSize(1L).build((CacheLoader)new CacheLoader<QualifiedTableName, Seq<Tuple2<LogicalPlan, String>>>(){

            public Seq<Tuple2<LogicalPlan, String>> load(QualifiedTableName in) {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        this.relationDestroyVersion = 0;
        this.org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$relationDestroyLock = new ReentrantReadWriteLock();
        this.org$apache$spark$sql$hive$SnappyStoreHiveCatalog$$alterTableLock = new Object();
    }
}

